#include "config.h"
#ifndef HAVE_LIBZ
/*
 * NEVER EVER edit this manually, fix the mkhelp.pl script instead!
 * Generation time: Wed Jan 21 18:04:58 2004
 */
#include <stdio.h>
void hugehelp(void)
{
   fputs(
"                                  _   _ ____  _     \n"
"  Project                     ___| | | |  _ \\| |    \n"
"                             / __| | | | |_) | |    \n"
"                            | (__| |_| |  _ <| |___ \n"
"                             \\___|\\___/|_| \\_\\_____|\n"
"\n"
"NAME\n"
"       curl - transfer a URL\n"
"\n"
"SYNOPSIS\n"
"       curl [options] [URL...]\n"
"\n"
"DESCRIPTION\n"
"       curl is a tool to transfer data from or to a server, using\n"
"       one of the supported protocols (HTTP,  HTTPS,  FTP,  FTPS,\n"
, stdout);
 fputs(
"       GOPHER,  DICT,  TELNET,  LDAP  or  FILE).  The  command is\n"
"       designed to work without user interaction.\n"
"\n"
"       curl offers a busload of useful tricks like proxy support,\n"
"       user  authentication,  ftp upload, HTTP post, SSL (https:)\n"
"       connections, cookies, file transfer resume  and  more.  As\n"
"       you  will see below, the amount of features will make your\n"
"       head spin!\n"
"\n"
"       curl is powered by libcurl for all  transfer-related  fea-\n"
, stdout);
 fputs(
"       tures. See libcurl(3) for details.\n"
"\n"
"URL\n"
"       The  URL  syntax  is  protocol  dependent.  You'll  find a\n"
"       detailed description in RFC 2396.\n"
"\n"
"       You can specify multiple URLs or parts of URLs by  writing\n"
"       part sets within braces as in:\n"
"\n"
"        http://site.{one,two,three}.com\n"
"\n"
"       or  you  can get sequences of alphanumeric series by using\n"
"       [] as in:\n"
"\n"
"        ftp://ftp.numericals.com/file[1-100].txt\n"
"        ftp://ftp.numericals.com/file[001-100].txt    (with lead-\n"
, stdout);
 fputs(
"       ing zeros)\n"
"        ftp://ftp.letters.com/file[a-z].txt\n"
"\n"
"       No nesting of the sequences is supported at the moment:\n"
"\n"
"        http://www.any.org/archive[1996-1999]/vol-\n"
"       ume[1-4]part{a,b,c,index}.html\n"
"\n"
"       You can specify any amount of URLs on  the  command  line.\n"
"       They  will be fetched in a sequential manner in the speci-\n"
"       fied order.\n"
"\n"
"       Curl will attempt to re-use connections for multiple  file\n"
, stdout);
 fputs(
"       transfers, so that getting many files from the same server\n"
"       will not do multiple connects / handshakes. This  improves\n"
"       speed. Of course this is only done on files specified on a\n"
"       single command line and cannot be  used  between  separate\n"
"       curl invokes.\n"
"\n"
"OPTIONS\n"
"       -a/--append\n"
"              (FTP)  When  used  in an FTP upload, this will tell\n"
"              curl to append to the target file instead of  over-\n"
, stdout);
 fputs(
"              writing  it.  If the file doesn't exist, it will be\n"
"              created.\n"
"\n"
"              If this option is used twice, the second  one  will\n"
"              disable append mode again.\n"
"\n"
"       -A/--user-agent <agent string>\n"
"              (HTTP) Specify the User-Agent string to send to the\n"
"              HTTP server. Some badly done CGIs fail if  its  not\n"
"              set  to  \"Mozilla/4.0\".   To  encode  blanks in the\n"
"              string,  surround  the  string  with  single  quote\n"
, stdout);
 fputs(
"              marks.   This  can also be set with the -H/--header\n"
"              option of course.\n"
"\n"
"              If this option is set more than once, the last  one\n"
"              will be the one that's used.\n"
"\n"
"       --anyauth\n"
"              (HTTP)  Tells  curl  to  figure  out authentication\n"
"              method by itself, and use the most secure  one  the\n"
"              remote  site  claims  it  supports. This is done by\n"
"              first doing a request and  checking  the  response-\n"
, stdout);
 fputs(
"              headers, thus inducing an extra network round-trip.\n"
"              This is used instead of setting a specific  authen-\n"
"              tication  method,  which  you  can do with --basic,\n"
"              --digest,  --ntlm,  and  --negotiate.   (Added   in\n"
"              7.10.6)\n"
"\n"
"              If this option is used several times, the following\n"
"              occurrences make no difference.\n"
"\n"
"       -b/--cookie <name=data>\n"
"              (HTTP) Pass the  data  to  the  HTTP  server  as  a\n"
, stdout);
 fputs(
"              cookie.   It  is  supposedly  the  data  previously\n"
"              received from the server in a  \"Set-Cookie:\"  line.\n"
"              The  data  should  be  in the format \"NAME1=VALUE1;\n"
"              NAME2=VALUE2\".\n"
"\n"
"              If no '=' letter is used in the line, it is treated\n"
"              as  a  filename  to  use  to read previously stored\n"
"              cookie lines from, which should  be  used  in  this\n"
"              session if they match. Using this method also acti-\n"
, stdout);
 fputs(
"              vates the \"cookie  parser\"  which  will  make  curl\n"
"              record  incoming cookies too, which may be handy if\n"
"              you're  using  this   in   combination   with   the\n"
"              -L/--location  option.  The file format of the file\n"
"              to read cookies from should be plain  HTTP  headers\n"
"              or the Netscape/Mozilla cookie file format.\n"
"\n"
"              NOTE  that  the  file specified with -b/--cookie is\n"
, stdout);
 fputs(
"              only used as input. No cookies will  be  stored  in\n"
"              the file. To store cookies, use the -c/--cookie-jar\n"
"              option or you could even save the HTTP headers to a\n"
"              file using -D/--dump-header!\n"
"\n"
"              If  this option is set more than once, the last one\n"
"              will be the one that's used.\n"
"\n"
"       -B/--use-ascii\n"
"              Use ASCII transfer when getting an FTP file or LDAP\n"
, stdout);
 fputs(
"              info.  For  FTP, this can also be enforced by using\n"
"              an URL that ends with \";type=A\". This option causes\n"
"              data  sent  to  stdout to be in text mode for win32\n"
"              systems.\n"
"\n"
"              If this option is used twice, the second  one  will\n"
"              disable ASCII usage.\n"
"\n"
"       --basic\n"
"              (HTTP) Tells curl to use HTTP Basic authentication.\n"
"              This is the default  and  this  option  is  usually\n"
, stdout);
 fputs(
"              pointless,  unless  you use it to override a previ-\n"
"              ously set option that sets a different  authentica-\n"
"              tion method (such as --ntlm, --digest and --negoti-\n"
"              ate). (Added in 7.10.6)\n"
"\n"
"              If this option is used several times, the following\n"
"              occurrences make no difference.\n"
"\n"
"       --ciphers <list of ciphers>\n"
"              (SSL) Specifies which ciphers to use in the connec-\n"
, stdout);
 fputs(
"              tion. The list  of  ciphers  must  be  using  valid\n"
"              ciphers. Read up on SSL cipher list details on this\n"
"              URL: http://www.openssl.org/docs/apps/ciphers.html\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will override the others.\n"
"\n"
"       --compressed\n"
"              (HTTP)  Request  a compressed response using one of\n"
"              the algorithms libcurl  supports,  and  return  the\n"
, stdout);
 fputs(
"              uncompressed  document.  If this option is used and\n"
"              the server sends an unsupported encoding, Curl will\n"
"              report an error.\n"
"\n"
"              If  this  option is used several times, each occur-\n"
"              rence will toggle it on/off.\n"
"\n"
"       --connect-timeout <seconds>\n"
"              Maximum time in seconds that you allow the  connec-\n"
"              tion  to  the server to take.  This only limits the\n"
, stdout);
 fputs(
"              connection phase,  once  curl  has  connected  this\n"
"              option  is  of no more use. See also the --max-time\n"
"              option.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       -c/--cookie-jar <file name>\n"
"              Specify  to  which  file you want curl to write all\n"
"              cookies after a completed  operation.  Curl  writes\n"
"              all  cookies  previously read from a specified file\n"
, stdout);
 fputs(
"              as  well  as  all  cookies  received  from   remote\n"
"              server(s). If no cookies are known, no file will be\n"
"              written.  The  file  will  be  written  using   the\n"
"              Netscape  cookie  file  format. If you set the file\n"
"              name to a single dash, \"-\",  the  cookies  will  be\n"
"              written to stdout.\n"
"\n"
"              NOTE  If the cookie jar can't be created or written\n"
"              to, the whole curl operation  won't  fail  or  even\n"
, stdout);
 fputs(
"              report  an error clearly. Using -v will get a warn-\n"
"              ing displayed, but that is the only  visible  feed-\n"
"              back  you get about this possibly lethal situation.\n"
"              If this option is  used  several  times,  the  last\n"
"              specfied file name will be used.\n"
"\n"
"       -C/--continue-at <offset>\n"
"              Continue/Resume  a  previous  file  transfer at the\n"
"              given offset. The given offset is the exact  number\n"
, stdout);
 fputs(
"              of  bytes  that  will  be  skipped counted from the\n"
"              beginning of the source file before  it  is  trans-\n"
"              fered  to  the  destination.  If used with uploads,\n"
"              the ftp server command SIZE will  not  be  used  by\n"
"              curl.\n"
"\n"
"              Use  \"-C  -\" to tell curl to automatically find out\n"
"              where/how to resume the transfer. It then uses  the\n"
"              given output/input files to figure that out.\n"
"\n"
, stdout);
 fputs(
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"       --create-dirs\n"
"              When used in conjunction with the -o  option,  curl\n"
"              will create the necessary local directory hierarchy\n"
"              as needed.\n"
"\n"
"       --crlf (FTP) Convert LF to CRLF in upload. Useful for  MVS\n"
"              (OS/390).\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable crlf converting.\n"
"\n"
"       -d/--data <data>\n"
, stdout);
 fputs(
"              (HTTP) Sends the specified data in a  POST  request\n"
"              to the HTTP server, in a way that can emulate as if\n"
"              a user has filled in a HTML form  and  pressed  the\n"
"              submit  button.  Note that the data is sent exactly\n"
"              as specified with no  extra  processing  (with  all\n"
"              newlines  cut  off).   The  data  is expected to be\n"
"              \"url-encoded\". This will cause  curl  to  pass  the\n"
, stdout);
 fputs(
"              data  to the server using the content-type applica-\n"
"              tion/x-www-form-urlencoded. Compare to -F. If  this\n"
"              option  is  used more than once on the same command\n"
"              line, the data  pieces  specified  will  be  merged\n"
"              together  with  a  separating &-letter. Thus, using\n"
"              '-d name=daniel -d skill=lousy'  would  generate  a\n"
"              post        chunk       that       looks       like\n"
, stdout);
 fputs(
"              'name=daniel&skill=lousy'.\n"
"\n"
"              If you start the data with the letter @,  the  rest\n"
"              should  be  a file name to read the data from, or -\n"
"              if you want curl to read the data from stdin.   The\n"
"              contents  of  the file must already be url-encoded.\n"
"              Multiple files can also be specified. Posting  data\n"
"              from  a file named 'foobar' would thus be done with\n"
"              --data @foobar\".\n"
"\n"
, stdout);
 fputs(
"              To post data purely binary, you should instead  use\n"
"              the --data-binary option.\n"
"\n"
"              -d/--data is the same as --data-ascii.\n"
"\n"
"              If this option is used several times, the ones fol-\n"
"              lowing the first will append data.\n"
"\n"
"       --data-ascii <data>\n"
"              (HTTP) This is an alias for the -d/--data option.\n"
"\n"
"              If this option is used several times, the ones fol-\n"
"              lowing the first will append data.\n"
"\n"
, stdout);
 fputs(
"       --data-binary <data>\n"
"              (HTTP)  This  posts  data  in  a  similar manner as\n"
"              --data-ascii does, although when using this  option\n"
"              the  entire  context of the posted data is kept as-\n"
"              is. If you want to post a binary file  without  the\n"
"              strip-newlines  feature of the --data-ascii option,\n"
"              this is for you.\n"
"\n"
"              If this option is used several times, the ones fol-\n"
, stdout);
 fputs(
"              lowing the first will append data.\n"
"\n"
"       --digest\n"
"              (HTTP)  Enables HTTP Digest authentication. This is\n"
"              a authentication that prevents  the  password  from\n"
"              being sent over the wire in clear text. Use this in\n"
"              combination with the normal -u/--user option to set\n"
"              user  name and password. See also --ntlm, --negoti-\n"
"              ate and --anyauth for related  options.  (Added  in\n"
"              curl 7.10.6)\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the following\n"
"              occurrences make no difference.\n"
"\n"
"       --disable-eprt\n"
"              (FTP) Tell curl to disable the use of the EPRT  and\n"
"              LPRT commands when doing active FTP transfers. Curl\n"
"              will normally always first  attempt  to  use  EPRT,\n"
"              then  LPRT before using PORT, but with this option,\n"
"              it will use PORT right  away.  EPRT  and  LPRT  are\n"
, stdout);
 fputs(
"              extensions  to  the  original FTP protocol, may not\n"
"              work on all servers but enable  more  functionality\n"
"              in  a better way than the traditional PORT command.\n"
"              (Aded in 7.10.5)\n"
"\n"
"              If this option is used several times,  each  occur-\n"
"              rence will toggle this on/off.\n"
"\n"
"       --disable-epsv\n"
"              (FTP) Tell curl to disable the use of the EPSV com-\n"
"              mand when doing passive FTP  transfers.  Curl  will\n"
, stdout);
 fputs(
"              normally  always  first  attempt to use EPSV before\n"
"              PASV, but with this option, it will not  try  using\n"
"              EPSV.\n"
"\n"
"              If  this  option is used several times, each occur-\n"
"              rence will toggle this on/off.\n"
"\n"
"       -D/--dump-header <file>\n"
"              Write the protocol headers to the specified file.\n"
"\n"
"              This option is handy to use when you want to  store\n"
"              the  headers that a HTTP site sends to you. Cookies\n"
, stdout);
 fputs(
"              from the headers could then be  read  in  a  second\n"
"              curl  invoke  by  using the -b/--cookie option! The\n"
"              -c/--cookie-jar option is however a better  way  to\n"
"              store cookies.\n"
"\n"
"              When used on FTP, the ftp server response lines are\n"
"              considered  being  \"headers\"  and  thus  are  saved\n"
"              there.\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
, stdout);
 fputs(
"       -e/--referer <URL>\n"
"              (HTTP) Sends the \"Referer Page\" information to  the\n"
"              HTTP   server.  This  can  also  be  set  with  the\n"
"              -H/--header  flag  of  course.   When   used   with\n"
"              -L/--location you can append \";auto\" to the referer\n"
"              URL to make curl automatically set the previous URL\n"
"              when  it  follows  a  Location: header. The \";auto\"\n"
"              string can be used alone, even if you don't set  an\n"
, stdout);
 fputs(
"              initial referer.\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"       --environment\n"
"              (RISC OS ONLY) Sets a range  of  environment  vari-\n"
"              ables,  using  the names the -w option supports, to\n"
"              easier allow extraction of useful information after\n"
"              having run curl.\n"
"\n"
"              If  this  option is used several times, each occur-\n"
"              rence will toggle this on/off.\n"
"\n"
, stdout);
 fputs(
"       --egd-file <file>\n"
"              (HTTPS) Specify the path name to the Entropy  Gath-\n"
"              ering Daemon socket. The socket is used to seed the\n"
"              random engine for SSL  connections.  See  also  the\n"
"              --random-file option.\n"
"\n"
"       -E/--cert <certificate[:password]>\n"
"              (HTTPS) Tells curl to use the specified certificate\n"
"              file when getting a file with HTTPS.  The  certifi-\n"
"              cate  must be in PEM format.  If the optional pass-\n"
, stdout);
 fputs(
"              word isn't specified, it will be queried for on the\n"
"              terminal. Note that this certificate is the private\n"
"              key and the private certificate concatenated!\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       --cacert <CA certificate>\n"
"              (HTTPS) Tells curl to use the specified certificate\n"
"              file to verify the peer. The file may contain  mul-\n"
, stdout);
 fputs(
"              tiple  CA  certificates. The certificate(s) must be\n"
"              in PEM format.\n"
"\n"
"              curl  recognizes  the  environment  variable  named\n"
"              'CURL_CA_BUNDLE' if that is set, and uses the given\n"
"              path as a path to a CA  cert  bundle.  This  option\n"
"              overrides that variable.\n"
"\n"
"              The windows version of curl will automatically look\n"
"              for a CA  certs  file  named  'curl-ca-bundle.crt',\n"
, stdout);
 fputs(
"              either in the same directory as curl.exe, or in the\n"
"              Current Working Directory, or in any  folder  along\n"
"              your PATH.\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
"       --capath <CA certificate directory>\n"
"              (HTTPS) Tells curl to use the specified certificate\n"
"              directory to verify the peer. The certificates must\n"
"              be in PEM format, and the directory must have  been\n"
, stdout);
 fputs(
"              processed  using the c_rehash utility supplied with\n"
"              openssl. Using --capath  can  allow  curl  to  make\n"
"              https  connections much more efficiently than using\n"
"              --cacert if the --cacert file contains many CA cer-\n"
"              tificates.\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
"       -f/--fail\n"
"              (HTTP) Fail silently (no output at all)  on  server\n"
, stdout);
 fputs(
"              errors.  This  is  mostly  done like this to better\n"
"              enable scripts  etc  to  better  deal  with  failed\n"
"              attempts.  In normal cases when a HTTP server fails\n"
"              to deliver a document, it returns a  HTML  document\n"
"              stating  so  (which  often  also  describes why and\n"
"              more). This flag will prevent curl from  outputting\n"
"              that and fail silently instead.\n"
"\n"
, stdout);
 fputs(
"              If this option is used twice, the second will again\n"
"              disable silent failure.\n"
"\n"
"       --ftp-create-dirs\n"
"              (FTP) When an FTP URL/operation uses  a  path  that\n"
"              doesn't currently exist on the server, the standard\n"
"              behavior of curl is to  fail.  Using  this  option,\n"
"              curl  will instead attempt to create missing direc-\n"
"              tories. (Added in 7.10.7)\n"
"\n"
, stdout);
 fputs(
"              If this option is used twice, the second will again\n"
"              disable silent failure.\n"
"\n"
"       --ftp-pasv\n"
"              (FTP) Use PASV when transfering. PASV is the inter-\n"
"              nal default behavior, but using this option can  be\n"
"              used  to  override  a  previos  --ftp-port  option.\n"
"              (Added in 7.11.0)\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable silent failure.\n"
"\n"
"       --ftp-ssl\n"
, stdout);
 fputs(
"              (FTP)   Make  the  FTP  connection  switch  to  use\n"
"              SSL/TLS. (Added in 7.11.0)\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable silent failure.\n"
"\n"
"       -F/--form <name=content>\n"
"              (HTTP)  This  lets curl emulate a filled in form in\n"
"              which a user has pressed the  submit  button.  This\n"
"              causes  curl  to  POST  data using the content-type\n"
, stdout);
 fputs(
"              multipart/form-data  according  to  RFC1867.   This\n"
"              enables uploading of binary files etc. To force the\n"
"              'content' part to be be a  file,  prefix  the  file\n"
"              name  with  an @ sign. To just get the content part\n"
"              from a file, prefix the file name with  the  letter\n"
"              <.  The  difference  between @ and < is then that @\n"
"              makes a file get attached in the  post  as  a  file\n"
, stdout);
 fputs(
"              upload, while the < makes a text field and just get\n"
"              the contents for that text field from a file.\n"
"\n"
"              Example, to send your password file to the  server,\n"
"              where  'password'  is the name of the form-field to\n"
"              which /etc/passwd will be the input:\n"
"\n"
"              curl -F password=@/etc/passwd www.mypasswords.com\n"
"\n"
"              To read the file's content from stdin insted  of  a\n"
, stdout);
 fputs(
"              file,  use  -  where  the file name should've been.\n"
"              This goes for both @ and < constructs.\n"
"\n"
"              You can also tell curl what Content-Type to use for\n"
"              the file upload part, by using 'type=', in a manner\n"
"              similar to:\n"
"\n"
"              curl -F \"web=@index.html;type=text/html\" url.com\n"
"\n"
"              See further examples and details in the MANUAL.\n"
"\n"
"              This option can be used multiple times.\n"
"\n"
"       -g/--globoff\n"
, stdout);
 fputs(
"              This option switches off the \"URL globbing parser\".\n"
"              When you set this option, you can specify URLs that\n"
"              contain the letters {}[] without having them  being\n"
"              interpreted by curl itself. Note that these letters\n"
"              are not normal legal URL contents but  they  should\n"
"              be encoded according to the URI standard.\n"
"\n"
"       -G/--get\n"
"              When used, this option will make all data specified\n"
, stdout);
 fputs(
"              with -d/--data or --data-binary to  be  used  in  a\n"
"              HTTP  GET  request instead of the POST request that\n"
"              otherwise would be used. The data will be  appended\n"
"              to the URL with a '?'  separator.\n"
"\n"
"              If  used in combination with -I, the POST data will\n"
"              instead be appended to the URL with a HEAD request.\n"
"\n"
"              If used multiple times, nothing special happens.\n"
"\n"
"       -h/--help\n"
"              Usage help.\n"
"\n"
, stdout);
 fputs(
"       -H/--header <header>\n"
"              (HTTP) Extra header to use when getting a web page.\n"
"              You may specify any number of extra  headers.  Note\n"
"              that if you should add a custom header that has the\n"
"              same name as one of the internal  ones  curl  would\n"
"              use,  your  externally  set  header  will  be  used\n"
"              instead of the internal one.  This  allows  you  to\n"
"              make  even  trickier stuff than curl would normally\n"
, stdout);
 fputs(
"              do. You should not replace internally  set  headers\n"
"              without  knowing  perfectly well what you're doing.\n"
"              Replacing an internal header with one without  con-\n"
"              tent  on  the  right side of the colon will prevent\n"
"              that header from appearing.\n"
"\n"
"              See  also  the  -A/--user-agent  and   -e/--referer\n"
"              options.\n"
"\n"
"              This   option   can   be  used  multiple  times  to\n"
, stdout);
 fputs(
"              add/replace/remove multiple headers.\n"
"\n"
"       -i/--include\n"
"              (HTTP) Include the HTTP-header in the  output.  The\n"
"              HTTP-header  includes things like server-name, date\n"
"              of the document, HTTP-version and more...\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable header include.\n"
"\n"
"       --interface <name>\n"
"              Perform  an  operation using a specified interface.\n"
, stdout);
 fputs(
"              You can enter interface name, IP  address  or  host\n"
"              name. An example could look like:\n"
"\n"
"               curl --interface eth0:1 http://www.netscape.com/\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
"       -I/--head\n"
"              (HTTP/FTP/FILE) Fetch the HTTP-header  only!  HTTP-\n"
"              servers feature the command HEAD which this uses to\n"
"              get nothing but the header of a document. When used\n"
, stdout);
 fputs(
"              on  a FTP or FILE file, curl displays the file size\n"
"              and last modification time only.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable header only.\n"
"\n"
"       -j/--junk-session-cookies\n"
"              (HTTP)  When  curl  is  told to read cookies from a\n"
"              given file, this option will make  it  discard  all\n"
"              \"session  cookies\". This will basicly have the same\n"
, stdout);
 fputs(
"              effect as if a  new  session  is  started.  Typical\n"
"              browsers   always   discard  session  cookies  when\n"
"              they're closed down. (Added in 7.9.7)\n"
"\n"
"              If this option is used several times,  each  occur-\n"
"              rence will toggle this on/off.\n"
"\n"
"       -k/--insecure\n"
"              (SSL) This option explicitly allows curl to perform\n"
"              \"insecure\" SSL connections and transfers.  Starting\n"
, stdout);
 fputs(
"              with   curl  7.10,  all  SSL  connections  will  be\n"
"              attempted to be made secure by using  the  CA  cer-\n"
"              tificate  bundle  installed  by default. This makes\n"
"              all  connections  considered  \"insecure\"  to   fail\n"
"              unless -k/--insecure is used.\n"
"\n"
"              If  this option is used twice, the second time will\n"
"              again disable it.\n"
"\n"
"       --krb4 <level>\n"
"              (FTP) Enable kerberos4 authentication and use.  The\n"
, stdout);
 fputs(
"              level must be entered and should be one of 'clear',\n"
"              'safe', 'confidential' or 'private'. Should you use\n"
"              a  level  that  is not one of these, 'private' will\n"
"              instead be used.\n"
"\n"
"              This option requiures that the  library  was  built\n"
"              with  kerberos4  support.  This is not very common.\n"
"              Use --version to see if your version supports it.\n"
"\n"
"              If this option is used several times, the last  one\n"
, stdout);
 fputs(
"              will be used.\n"
"\n"
"       -K/--config <config file>\n"
"              Specify  which  config  file to read curl arguments\n"
"              from. The config file is a text file in which  com-\n"
"              mand  line arguments can be written which then will\n"
"              be used as if they were written on the actual  com-\n"
"              mand  line.  Options  and  their parameters must be\n"
"              specified on the same  config  file  line.  If  the\n"
, stdout);
 fputs(
"              parameter is to contain white spaces, the parameter\n"
"              must be inclosed within quotes.  If the first  col-\n"
"              umn  of  a config line is a '#' character, the rest\n"
"              of the line will be treated as a comment.\n"
"\n"
"              Specify the filename as '-' to make curl  read  the\n"
"              file from stdin.\n"
"\n"
"              Note that to be able to specify a URL in the config\n"
"              file, you  need  to  specify  it  using  the  --url\n"
, stdout);
 fputs(
"              option,  and  not  by simply writing the URL on its\n"
"              own line. So, it could look similar to this:\n"
"\n"
"              url = \"http://curl.haxx.se/docs/\"\n"
"\n"
"              This option can be used multiple times.\n"
"\n"
"       --limit-rate <speed>\n"
"              Specify the maximum transfer rate you want curl  to\n"
"              use.  This  feature is useful if you have a limited\n"
"              pipe and you'd like  your  transfer  not  use  your\n"
"\n"
"              entire bandwidth.\n"
"\n"
, stdout);
 fputs(
"              The given speed is measured in bytes/second, unless\n"
"              a suffix is appended. Appending  'k'  or  'K'  will\n"
"              count  the  number as kilobytes, 'm' or M' makes it\n"
"              megabytes while 'g'  or  'G'  makes  it  gigabytes.\n"
"              Examples: 200K, 3m and 1G.\n"
"\n"
"              This option was introduced in curl 7.10.\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
"       -l/--list-only\n"
, stdout);
 fputs(
"              (FTP) When listing an FTP  directory,  this  switch\n"
"              forces  a name-only view.  Especially useful if you\n"
"              want to machine-parse the contents of an FTP direc-\n"
"              tory  since the normal directory view doesn't use a\n"
"              standard look or format.\n"
"\n"
"              This option causes an FTP NLST command to be  sent.\n"
"              Some  FTP servers list only files in their response\n"
, stdout);
 fputs(
"              to NLST; they do  not  include  subdirectories  and\n"
"              symbolic links.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable list only.\n"
"\n"
"       -L/--location\n"
"              (HTTP/HTTPS)  If  the  server  reports   that   the\n"
"              requested  page has a different location (indicated\n"
"              with the header line Location:) this flag will  let\n"
"              curl attempt to reattempt the get on the new place.\n"
, stdout);
 fputs(
"              If used together with -i or -I,  headers  from  all\n"
"              requested pages will be shown. If authentication is\n"
"              used, curl will only send its  credentials  to  the\n"
"              initial host, so if a redirect takes curl to a dif-\n"
"              ferent host, it won't intercept the  user+password.\n"
"              See  also --location-trusted on how to change this.\n"
"              If this option is used twice, the second will again\n"
, stdout);
 fputs(
"              disable location following.\n"
"\n"
"       --location-trusted\n"
"              (HTTP/HTTPS)  Like  -L/--location,  but  will allow\n"
"              sending the name + password to all hosts  that  the\n"
"              site may redirect to. This may or may not introduce\n"
"              a security breach if the site redirects  you  do  a\n"
"              site  to which you'll send your authentication info\n"
"              (which is plaintext  in  the  case  of  HTTP  Basic\n"
"              authentication).\n"
"\n"
, stdout);
 fputs(
"              If this option is used twice, the second will again\n"
"              disable location following.\n"
"\n"
"       --max-filesize <bytes>\n"
"              Specify the maximum size (in bytes) of  a  file  to\n"
"              download. If the file requested is larger than this\n"
"              value, the transfer will not start  and  curl  will\n"
"              return with exit code 63.\n"
"\n"
"              NOTE:  The  file  size is not always known prior to\n"
, stdout);
 fputs(
"              download, and for such files  this  option  has  no\n"
"              effect  even  if  the  file  transfer ends up being\n"
"              larger than this given limit.  This  concerns  both\n"
"              FTP and HTTP transfers.\n"
"       -m/--max-time <seconds>\n"
"              Maximum  time  in  seconds that you allow the whole\n"
"              operation to take.  This is useful  for  preventing\n"
"              your  batch jobs from hanging for hours due to slow\n"
, stdout);
 fputs(
"              networks or links going down.   This  doesn't  work\n"
"              fully  in  win32  systems.  See also the --connect-\n"
"              timeout option.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       -M/--manual\n"
"              Manual. Display the huge help text.\n"
"\n"
"       -n/--netrc\n"
"              Makes  curl scan the .netrc file in the user's home\n"
"              directory for login name and password. This is typ-\n"
, stdout);
 fputs(
"              ically  used  for  ftp  on unix. If used with http,\n"
"              curl will enable user authentication. See  netrc(4)\n"
"              or ftp(1) for details on the file format. Curl will\n"
"              not complain if that file hasn't the right  permis-\n"
"              sions  (it should not be world nor group readable).\n"
"              The environment variable \"HOME\" is used to find the\n"
"              home directory.\n"
"\n"
"              A  quick  and very simple example of how to setup a\n"
, stdout);
 fputs(
"              .netrc  to  allow  curl  to  ftp  to  the   machine\n"
"              host.domain.com  with  user name 'myself' and pass-\n"
"              word\n"
"\n"
"              machine  host.domain.com  login   myself   password\n"
"              secret\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable netrc usage.\n"
"\n"
"       --negotiate\n"
"              (HTTP) Enables  GSS-Negotiate  authentication.  The\n"
"              GSS-Negotiate  method was designed by Microsoft and\n"
, stdout);
 fputs(
"              is used in their web aplications. It  is  primarily\n"
"              meant as a support for Kerberos5 authentication but\n"
"              may be also used along with another  authentication\n"
"              methods. For more information see IETF draft draft-\n"
"              brezak-spnego-http-04.txt. (Added in 7.10.6)\n"
"\n"
"              This option requiures that the  library  was  built\n"
"              with  GSSAPI  support. This is not very common. Use\n"
, stdout);
 fputs(
"              --version to see if your version supports GSS-Nego-\n"
"              tiate.\n"
"\n"
"              If this option is used several times, the following\n"
"              occurrences make no difference.\n"
"\n"
"       -N/--no-buffer\n"
"              Disables the buffering of  the  output  stream.  In\n"
"              normal  work  situations,  curl will use a standard\n"
"              buffered output stream that will  have  the  effect\n"
"              that  it will output the data in chunks, not neces-\n"
, stdout);
 fputs(
"              sarily exactly when the data arrives.   Using  this\n"
"              option will disable that buffering.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              switch on buffering.\n"
"\n"
"       --ntlm (HTTP)  Enables  NTLM  authentication.   The   NTLM\n"
"              authentication method was designed by Microsoft and\n"
"              is used by IIS web servers.  It  is  a  proprietary\n"
"              protocol,  reversed engineered by clever people and\n"
, stdout);
 fputs(
"              implemented in curl based on  their  efforts.  This\n"
"              kind of behavior should not be endorsed, you should\n"
"              encourage everyone who uses NTLM  to  switch  to  a\n"
"              public   and   documented   authentication   method\n"
"              instead. Such as Digest. (Added in 7.10.6)\n"
"\n"
"              This option requiures that the  library  was  built\n"
"              with SSL support. Use curl --version to see if your\n"
"              version supports NTLM.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the following\n"
"              occurrences make no difference.\n"
"\n"
"       -o/--output <file>\n"
"              Write  output  to  <file> instead of stdout. If you\n"
"              are using {} or [] to fetch multiple documents, you\n"
"              can  use  '#'  followed  by  a number in the <file>\n"
"              specifier. That variable will be replaced with  the\n"
"              current string for the URL being fetched. Like in:\n"
"\n"
, stdout);
 fputs(
"                curl http://{one,two}.site.com -o \"file_#1.txt\"\n"
"\n"
"              or use several variables like:\n"
"\n"
"                curl http://{site,host}.host[1-5].com -o \"#1_#2\"\n"
"\n"
"              You  may  use this option as many times as you have\n"
"              number of URLs.\n"
"\n"
"              See also the --create-dirs  option  to  create  the\n"
"              local directories dynamically.\n"
"\n"
"       -O/--remote-name\n"
"              Write  output to a local file named like the remote\n"
, stdout);
 fputs(
"              file we get. (Only the file part of the remote file\n"
"              is used, the path is cut off.)\n"
"\n"
"              You  may  use this option as many times as you have\n"
"              number of URLs.\n"
"\n"
"       -p/--proxytunnel\n"
"              When an HTTP proxy is used, this option will  cause\n"
"              non-HTTP protocols to attempt to tunnel through the\n"
"              proxy instead of merely using it  to  do  HTTP-like\n"
"              operations.  The  tunnel  approach is made with the\n"
, stdout);
 fputs(
"              HTTP proxy CONNECT request and  requires  that  the\n"
"              proxy allows direct connect to the remote port num-\n"
"              ber curl wants to tunnel through to.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable proxy tunnel.\n"
"\n"
"       -P/--ftp-port <address>\n"
"              (FTP)  Reverses  the  initiator/listener roles when\n"
"              connecting with ftp. This switch makes Curl use the\n"
, stdout);
 fputs(
"              PORT  command  instead  of  PASV. In practice, PORT\n"
"              tells the server to connect to the client's  speci-\n"
"              fied  address  and port, while PASV asks the server\n"
"              for an ip address and port to connect to. <address>\n"
"              should be one of:\n"
"\n"
"              interface\n"
"                     i.e  \"eth0\"  to specify which interface's IP\n"
"                     address you want to use  (Unix only)\n"
"\n"
"              IP address\n"
, stdout);
 fputs(
"                     i.e \"192.168.10.1\" to specify exact IP  num-\n"
"                     ber\n"
"\n"
"              host name\n"
"                     i.e \"my.host.domain\" to specify machine\n"
"\n"
"              -      (any  single-letter  string) to make it pick\n"
"                     the machine's default\n"
"\n"
"       If this option is used several times, the last one will be\n"
"       used. Disable the use of PORT with --ftp-pasv.\n"
"\n"
"       -q     If used as the first parameter on the command line,\n"
, stdout);
 fputs(
"              the $HOME/.curlrc file will not be read and used as\n"
"              a config file.\n"
"\n"
"       -Q/--quote <comand>\n"
"              (FTP)  Send  an arbitrary command to the remote FTP\n"
"              server, by using the QUOTE command of  the  server.\n"
"              Not  all  servers support this command, and the set\n"
"              of QUOTE commands are server specific!  Quote  com-\n"
"              mands are sent BEFORE the transfer is taking place.\n"
, stdout);
 fputs(
"              To make commands  take  place  after  a  successful\n"
"              transfer,  prefix  them  with  a  dash '-'. You may\n"
"              specify any amount of commands to be run before and\n"
"              after  the  transfer. If the server returns failure\n"
"              for one of the commands, the entire operation  will\n"
"              be aborted.\n"
"\n"
"              This option can be used multiple times.\n"
"\n"
"       --random-file <file>\n"
, stdout);
 fputs(
"              (HTTPS)  Specify  the  path name to file containing\n"
"              what will be considered as random data. The data is\n"
"              used to seed the random engine for SSL connections.\n"
"              See also the --egd-file option.\n"
"\n"
"       -r/--range <range>\n"
"              (HTTP/FTP) Retrieve a byte  range  (i.e  a  partial\n"
"              document) from a HTTP/1.1 or FTP server. Ranges can\n"
"              be specified in a number of ways.\n"
"\n"
, stdout);
 fputs(
"              0-499     specifies the first 500 bytes\n"
"\n"
"              500-999   specifies the second 500 bytes\n"
"\n"
"              -500      specifies the last 500 bytes\n"
"\n"
"              9500      specifies the bytes from offset 9500  and\n"
"                        forward\n"
"\n"
"              0-0,-1    specifies   the   first   and  last  byte\n"
"                        only(*)(H)\n"
"\n"
"              500-700,600-799\n"
"                        specifies 300 bytes from offset 500(H)\n"
"\n"
"              100-199,500-599\n"
, stdout);
 fputs(
"                        specifies   two   separate   100    bytes\n"
"                        ranges(*)(H)\n"
"\n"
"       (*) = NOTE that this will cause the server to reply with a\n"
"       multipart response!\n"
"\n"
"       You should also be aware that many HTTP/1.1 servers do not\n"
"       have this feature enabled, so that when you attempt to get\n"
"       a range, you'll instead get the whole document.\n"
"\n"
"       FTP range downloads only support the simple syntax 'start-\n"
, stdout);
 fputs(
"       stop'  (optionally  with  one  of the numbers omitted). It\n"
"\n"
"       depends on the non-RFC command SIZE.\n"
"\n"
"       If this option is used several times, the last one will be\n"
"       used.\n"
"\n"
"       -R/--remote-time\n"
"              When used, this will make libcurl attempt to figure\n"
"              out the timestamp of the remote file, and  if  that\n"
"              is  available  make  the  local  file get that same\n"
"              timestamp.\n"
"\n"
, stdout);
 fputs(
"              If this option is used twice, the second time  dis-\n"
"              ables this again.\n"
"\n"
"       -s/--silent\n"
"              Silent  mode.  Don't  show  progress meter or error\n"
"              messages.  Makes Curl mute.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable mute.\n"
"\n"
"       -S/--show-error\n"
"              When  used with -s it makes curl show error message\n"
"              if it fails.\n"
"\n"
, stdout);
 fputs(
"              If this option is used twice, the second will again\n"
"              disable show error.\n"
"\n"
"       --stderr <file>\n"
"              Redirect all writes to stderr to the specified file\n"
"              instead. If the file name is a  plain  '-',  it  is\n"
"              instead written to stdout. This option has no point\n"
"              when you're using a shell with  decent  redirecting\n"
"              capabilities.\n"
"\n"
"              If  this option is used several times, the last one\n"
, stdout);
 fputs(
"              will be used.\n"
"\n"
"       -t/--telnet-option <OPT=val>\n"
"              Pass options  to  the  telnet  protocol.  Supported\n"
"              options are:\n"
"\n"
"              TTYPE=<term> Sets the terminal type.\n"
"\n"
"              XDISPLOC=<X display> Sets the X display location.\n"
"\n"
"              NEW_ENV=<var,val> Sets an environment variable.\n"
"\n"
"       -T/--upload-file <file>\n"
"              This  transfers  the  specified  local  file to the\n"
, stdout);
 fputs(
"              remote URL. If there is no file part in the  speci-\n"
"              fied  URL,  Curl  will  append the local file name.\n"
"              NOTE that you must use a trailing  /  on  the  last\n"
"              directory  to really prove to Curl that there is no\n"
"              file name or curl will think that your last  direc-\n"
"              tory name is the remote file name to use. That will\n"
"              most likely cause the upload operation to fail.  If\n"
, stdout);
 fputs(
"              this  is  used on a http(s) server, the PUT command\n"
"              will be used.\n"
"\n"
"              Use the file name \"-\" (a single dash) to use  stdin\n"
"              instead of a given file.\n"
"\n"
"              Before  7.10.8,  when  this option was used several\n"
"              times, the last one was used.\n"
"\n"
"              In curl 7.10.8 and later, you can  specify  one  -T\n"
"              for  each  URL  on  the command line. Each -T + URL\n"
, stdout);
 fputs(
"              pair specifies what to upload and  to  where.  curl\n"
"              also  supports \"globbing\" of the -T argument, mean-\n"
"              ing that you can upload multiple files to a  single\n"
"              URL  by using the same URL globbing style supported\n"
"              in the URL, like this:\n"
"\n"
"              curl    -T    \"{file1,file2}\"    http://www.upload-\n"
"              tothissite.com\n"
"\n"
"              or even\n"
"\n"
"              curl   -T   \"img[1-1000].png\"  ftp://ftp.picturema-\n"
, stdout);
 fputs(
"              nia.com/upload/\n"
"\n"
"       --trace <file>\n"
"              Enables a full trace dump of all incoming and  out-\n"
"              going  data,  including descriptive information, to\n"
"              the given output file. Use \"-\" as filename to  have\n"
"              the output sent to stdout.\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used. (Added in 7.9.7)\n"
"\n"
"       --trace-ascii <file>\n"
"              Enables a full trace dump of all incoming and  out-\n"
, stdout);
 fputs(
"              going  data,  including descriptive information, to\n"
"              the given output file. Use \"-\" as filename to  have\n"
"              the output sent to stdout.\n"
"\n"
"              This is very similar to --trace, but leaves out the\n"
"              hex part and only shows the ASCII part of the dump.\n"
"              It  makes  smaller  output  that might be easier to\n"
"              read for untrained humans.\n"
"\n"
"              If this option is used several times, the last  one\n"
, stdout);
 fputs(
"              will be used. (Added in 7.9.7)\n"
"\n"
"       -u/--user <user:password>\n"
"              Specify  user  and  password  to use when fetching.\n"
"              Read the MANUAL for detailed examples of how to use\n"
"              this.  If  no  password is specified, curl will ask\n"
"              for it interactively.\n"
"\n"
"              You can also use  the  --digest  option  to  enable\n"
"              Digest  authentication when communicating with HTTP\n"
"              1.1 servers.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       -U/--proxy-user <user:password>\n"
"              Specify  user and password to use for Proxy authen-\n"
"              tication. If no password is  specified,  curl  will\n"
"              ask for it interactively.\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
"       --url <URL>\n"
"              Specify a URL to fetch. This option is mostly handy\n"
, stdout);
 fputs(
"              when you want to specify URL(s) in a config file.\n"
"\n"
"              This  option  may  be  used any number of times. To\n"
"              control where this URL is written, use  the  -o  or\n"
"              the -O options.\n"
"\n"
"       -v/--verbose\n"
"              Makes  the  fetching more verbose/talkative. Mostly\n"
"              usable for debugging. Lines starting with '>' means\n"
"              data  sent by curl, '<' means data received by curl\n"
, stdout);
 fputs(
"              that is hidden in normal cases and  lines  starting\n"
"              with '*' means additional info provided by curl.\n"
"\n"
"              Note  that  if  you want to see HTTP headers in the\n"
"              output, -i/--include might be option you're looking\n"
"              for.\n"
"\n"
"              If  you  think  this  option still doesn't give you\n"
"              enough details, consider using --trace or  --trace-\n"
"              ascii instead.\n"
"\n"
, stdout);
 fputs(
"              If this option is used twice, the second will again\n"
"              disable verbose.\n"
"\n"
"       -V/--version\n"
"              Displays information about  curl  and  the  libcurl\n"
"              version it uses.\n"
"\n"
"              The  first  line includes the full version of curl,\n"
"              libcurl and other 3rd party libraries  linked  with\n"
"              the executable.\n"
"\n"
"              The  second  line  (starts with \"Protocols:\") shows\n"
, stdout);
 fputs(
"              all protocols that libcurl reports to support.\n"
"\n"
"              The third line (starts with \"Features:\") shows spe-\n"
"              cific features libcurl reports to offer.\n"
"\n"
"       -w/--write-out <format>\n"
"              Defines  what to display after a completed and suc-\n"
"              cessful operation. The format is a string that  may\n"
"              contain  plain  text mixed with any number of vari-\n"
"              ables. The string can be specified as \"string\",  to\n"
, stdout);
 fputs(
"              get  read  from  a  particular  file you specify it\n"
"              \"@filename\" and to tell curl  to  read  the  format\n"
"              from stdin you write \"@-\".\n"
"\n"
"              The  variables present in the output format will be\n"
"              substituted by the value or text that  curl  thinks\n"
"              fit,  as  described below. All variables are speci-\n"
"              fied like %{variable_name} and to output a normal %\n"
, stdout);
 fputs(
"              you  just write them like %%. You can output a new-\n"
"              line by using \\n, a carriage return with \\r  and  a\n"
"              tab space with \\t.\n"
"\n"
"              NOTE:  The  %-letter  is  a  special  letter in the\n"
"              win32-environment, where all occurrences of %  must\n"
"              be doubled when using this option.\n"
"\n"
"              Available variables are at this point:\n"
"\n"
"              url_effective  The  URL that was fetched last. This\n"
, stdout);
 fputs(
"                             is mostly meaningful if you've  told\n"
"                             curl to follow location: headers.\n"
"\n"
"              http_code      The numerical code that was found in\n"
"                             the last retrieved HTTP(S) page.\n"
"\n"
"              time_total     The total time, in seconds, that the\n"
"                             full operation lasted. The time will\n"
"                             be displayed with millisecond  reso-\n"
"                             lution.\n"
"\n"
, stdout);
 fputs(
"              time_namelookup\n"
"                             The  time,  in seconds, it took from\n"
"                             the start until the  name  resolving\n"
"                             was completed.\n"
"\n"
"              time_connect   The  time,  in seconds, it took from\n"
"                             the start until the connect  to  the\n"
"                             remote  host  (or  proxy)  was  com-\n"
"                             pleted.\n"
"\n"
"              time_pretransfer\n"
, stdout);
 fputs(
"                             The time, in seconds, it  took  from\n"
"                             the start until the file transfer is\n"
"                             just about to begin.  This  includes\n"
"                             all    pre-transfer   commands   and\n"
"                             negotiations that  are  specific  to\n"
"                             the particular protocol(s) involved.\n"
"\n"
"              time_starttransfer\n"
"                             The time, in seconds, it  took  from\n"
, stdout);
 fputs(
"                             the  start  until  the first byte is\n"
"                             just about to  be  transfered.  This\n"
"                             includes  time_pretransfer  and also\n"
"                             the time the server needs to  calcu-\n"
"                             late the result.\n"
"\n"
"              size_download  The  total amount of bytes that were\n"
"                             downloaded.\n"
"\n"
"              size_upload    The total amount of bytes that  were\n"
, stdout);
 fputs(
"                             uploaded.\n"
"\n"
"              size_header    The  total  amount  of  bytes of the\n"
"                             downloaded headers.\n"
"\n"
"              size_request   The total amount of bytes that  were\n"
"                             sent in the HTTP request.\n"
"\n"
"              speed_download The average download speed that curl\n"
"                             measured for the complete  download.\n"
"\n"
"              speed_upload   The  average  upload speed that curl\n"
, stdout);
 fputs(
"                             measured for the complete upload.\n"
"\n"
"              content_type   The Content-Type  of  the  requested\n"
"                             document,  if  there was any. (Added\n"
"                             in 7.9.5)\n"
"\n"
"       If this option is used several times, the last one will be\n"
"       used.\n"
"\n"
"       -x/--proxy <proxyhost[:port]>\n"
"              Use specified HTTP proxy. If the port number is not\n"
"              specified, it is assumed at port 1080.\n"
"\n"
, stdout);
 fputs(
"              This option overrides  existing  environment  vari-\n"
"              ables  that  sets proxy to use. If there's an envi-\n"
"              ronment variable setting a proxy, you can set proxy\n"
"              to \"\" to override it.\n"
"\n"
"              Note  that all operations that are performed over a\n"
"              HTTP proxy will transparantly be converted to HTTP.\n"
"              It  means that certain protocol specific operations\n"
"              might not be available. This is not the case if you\n"
, stdout);
 fputs(
"              can  tunnel  through  the  proxy,  as done with the\n"
"              -p/--proxytunnel option.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       -X/--request <command>\n"
"              (HTTP)  Specifies a custom request to use when com-\n"
"              municating with the  HTTP  server.   The  specified\n"
"              request  will  be used instead of the standard GET.\n"
"              Read the HTTP 1.1  specification  for  details  and\n"
, stdout);
 fputs(
"              explanations.\n"
"\n"
"              (FTP) Specifies a custom FTP command to use instead\n"
"              of LIST when doing file lists with ftp.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       -y/--speed-time <time>\n"
"              If  a download is slower than speed-limit bytes per\n"
"              second during a  speed-time  period,  the  download\n"
"              gets  aborted.  If  speed-time is used, the default\n"
, stdout);
 fputs(
"              speed-limit will be 1 unless set with -y.\n"
"\n"
"              This option controls transfers and  thus  will  not\n"
"              affect  slow connects etc. If this is a concern for\n"
"              you, try the --connect-timeout option.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       -Y/--speed-limit <speed>\n"
"              If  a  download is slower than this given speed, in\n"
, stdout);
 fputs(
"              bytes per second, for speed-time  seconds  it  gets\n"
"              aborted. speed-time is set with -Y and is 30 if not\n"
"              set.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       -z/--time-cond <date expression>\n"
"              (HTTP) Request to get a file that has been modified\n"
"              later than the given time and date, or one that has\n"
"              been modified before that time. The date expression\n"
, stdout);
 fputs(
"              can be all sorts of date strings or if  it  doesn't\n"
"              match  any  internal ones, it tries to get the time\n"
"              from a given file name instead! See the GNU date(1)\n"
"              or  curl_getdate(3)  man  pages for date expression\n"
"              details.\n"
"\n"
"              Start the date expression with a dash (-)  to  make\n"
"              it  request  for  a document that is older than the\n"
"              given date/time, default  is  a  document  that  is\n"
, stdout);
 fputs(
"              newer than the specified date/time.\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
"       -Z/--max-redirs <num>\n"
"              Set  maximum   number   of   redirection-followings\n"
"              allowed.  If -L/--location is used, this option can\n"
"              be used to prevent curl from following redirections\n"
"              \"in absurdum\".\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
, stdout);
 fputs(
"       -0/--http1.0\n"
"              (HTTP) Forces curl to issue its requests using HTTP\n"
"              1.0 instead of using its internally preferred: HTTP\n"
"              1.1.\n"
"\n"
"       -1/--tlsv1\n"
"              (HTTPS) Forces curl to use TSL version 1 when nego-\n"
"              tiating with a remote TLS server.\n"
"\n"
"       -2/--sslv2\n"
"              (HTTPS) Forces curl to use SSL version 2 when nego-\n"
"              tiating with a remote SSL server.\n"
"\n"
"       -3/--sslv3\n"
, stdout);
 fputs(
"              (HTTPS) Forces curl to use SSL version 3 when nego-\n"
"              tiating with a remote SSL server.\n"
"\n"
"       -4/--ipv4\n"
"              If  libcurl  is  capable of resolving an address to\n"
"              multiple  IP  versions  (which  it  is  if  it   is\n"
"              ipv6-capable), this option tells libcurl to resolve\n"
"              names to IPv4 addresses only. (Added in 7.10.8)\n"
"\n"
"       -6/--ipv6\n"
"              If libcurl is capable of resolving  an  address  to\n"
, stdout);
 fputs(
"              multiple   IP  versions  (which  it  is  if  it  is\n"
"              ipv6-capable), this option tells libcurl to resolve\n"
"              names to IPv6 addresses only. (Added in 7.10.8)\n"
"\n"
"       -#/--progress-bar\n"
"              Make   curl   display  progress  information  as  a\n"
"              progress bar instead of the default statistics.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable the progress bar.\n"
"\n"
"FILES\n"
"       ~/.curlrc\n"
, stdout);
 fputs(
"              Default config file.\n"
"\n"
"ENVIRONMENT\n"
"       http_proxy [protocol://]<host>[:port]\n"
"              Sets proxy server to use for HTTP.\n"
"\n"
"       HTTPS_PROXY [protocol://]<host>[:port]\n"
"              Sets proxy server to use for HTTPS.\n"
"\n"
"       FTP_PROXY [protocol://]<host>[:port]\n"
"              Sets proxy server to use for FTP.\n"
"\n"
"       GOPHER_PROXY [protocol://]<host>[:port]\n"
"              Sets proxy server to use for GOPHER.\n"
"       ALL_PROXY [protocol://]<host>[:port]\n"
, stdout);
 fputs(
"              Sets  proxy  server  to use if no protocol-specific\n"
"              proxy is set.\n"
"\n"
"       NO_PROXY <comma-separated list of hosts>\n"
"              list of host names that shouldn't  go  through  any\n"
"              proxy. If set to a asterisk\n"
"\n"
"EXIT CODES\n"
"       There  exists  a  bunch of different error codes and their\n"
"       corresponding error messages that may  appear  during  bad\n"
"       conditions.  At  the  time of this writing, the exit codes\n"
"       are:\n"
"\n"
, stdout);
 fputs(
"       1      Unsupported protocol. This build  of  curl  has  no\n"
"              support for this protocol.\n"
"\n"
"       2      Failed to initialize.\n"
"\n"
"       3      URL malformat. The syntax was not correct.\n"
"\n"
"       4      URL  user  malformatted.  The  user-part of the URL\n"
"              syntax was not correct.\n"
"\n"
"       5      Couldn't resolve proxy. The given proxy host  could\n"
"              not be resolved.\n"
"\n"
"       6      Couldn't  resolve  host.  The given remote host was\n"
"              not resolved.\n"
, stdout);
 fputs(
"\n"
"       7      Failed to connect to host.\n"
"\n"
"       8      FTP weird server reply. The server sent  data  curl\n"
"              couldn't parse.\n"
"\n"
"       9      FTP access denied. The server denied login.\n"
"\n"
"       10     FTP  user/password  incorrect.  Either  one or both\n"
"              were not accepted by the server.\n"
"\n"
"       11     FTP weird PASS reply. Curl couldn't parse the reply\n"
"              sent to the PASS request.\n"
"\n"
"       12     FTP weird USER reply. Curl couldn't parse the reply\n"
, stdout);
 fputs(
"              sent to the USER request.\n"
"\n"
"       13     FTP weird PASV reply, Curl couldn't parse the reply\n"
"              sent to the PASV request.\n"
"\n"
"       14     FTP  weird  227  format.  Curl  couldn't  parse the\n"
"              227-line the server sent.\n"
"\n"
"       15     FTP can't get host. Couldn't resolve the host IP we\n"
"              got in the 227-line.\n"
"\n"
"       16     FTP  can't  reconnect. Couldn't connect to the host\n"
"              we got in the 227-line.\n"
"\n"
, stdout);
 fputs(
"       17     FTP couldn't set binary. Couldn't  change  transfer\n"
"              method to binary.\n"
"\n"
"       18     Partial  file.  Only  a part of the file was trans-\n"
"              fered.\n"
"\n"
"       19     FTP couldn't download/access the  given  file,  the\n"
"              RETR (or similar) command failed.\n"
"\n"
"       20     FTP  write  error. The transfer was reported bad by\n"
"              the server.\n"
"\n"
"       21     FTP quote error. A  quote  command  returned  error\n"
"              from the server.\n"
"\n"
, stdout);
 fputs(
"       22     HTTP  page not retrieved. The requested url was not\n"
"              found or returned another error with the HTTP error\n"
"              code  being  400  or  above.  This return code only\n"
"              appears if --fail is used.\n"
"\n"
"       23     Write error. Curl couldn't write data  to  a  local\n"
"              filesystem or similar.\n"
"\n"
"       24     Malformed user. User name badly specified.\n"
"\n"
"       25     FTP  couldn't STOR file. The server denied the STOR\n"
, stdout);
 fputs(
"              operation, used for FTP uploading.\n"
"\n"
"       26     Read error. Various reading problems.\n"
"\n"
"       27     Out of memory. A memory allocation request  failed.\n"
"       28     Operation  timeout.  The  specified time-out period\n"
"              was reached according to the conditions.\n"
"\n"
"       29     FTP couldn't set  ASCII.  The  server  returned  an\n"
"              unknown reply.\n"
"\n"
"       30     FTP  PORT  failed. The PORT command failed. Not all\n"
, stdout);
 fputs(
"              FTP servers support the PORT command, try  doing  a\n"
"              transfer using PASV instead!\n"
"\n"
"       31     FTP  couldn't  use  REST.  The REST command failed.\n"
"              This command is used for resumed FTP transfers.\n"
"\n"
"       32     FTP couldn't use SIZE. The SIZE command failed. The\n"
"              command  is  an  extension to the original FTP spec\n"
"              RFC 959.\n"
"\n"
"       33     HTTP range error. The range \"command\" didn't  work.\n"
, stdout);
 fputs(
"       34     HTTP  post  error. Internal post-request generation\n"
"              error.\n"
"\n"
"       35     SSL connect error. The SSL handshaking failed.\n"
"\n"
"       36     FTP bad download resume. Couldn't continue an  ear-\n"
"              lier aborted download.\n"
"\n"
"       37     FILE  couldn't  read file. Failed to open the file.\n"
"              Permissions?\n"
"\n"
"       38     LDAP cannot bind. LDAP bind operation failed.\n"
"\n"
"       39     LDAP search failed.\n"
"\n"
, stdout);
 fputs(
"       40     Library not found. The LDAP library was not  found.\n"
"       41     Function  not  found.  A required LDAP function was\n"
"              not found.\n"
"\n"
"       42     Aborted by callback. An application  told  curl  to\n"
"              abort the operation.\n"
"\n"
"       43     Internal  error.  A  function was called with a bad\n"
"              parameter.\n"
"\n"
"       44     Internal error. A function  was  called  in  a  bad\n"
"              order.\n"
"\n"
, stdout);
 fputs(
"       45     Interface  error.  A  specified  outgoing interface\n"
"              could not be used.\n"
"\n"
"       46     Bad password entered. An error  was  signaled  when\n"
"              the password was entered.\n"
"\n"
"       47     Too  many redirects. When following redirects, curl\n"
"              hit the maximum amount.\n"
"\n"
"       48     Unknown TELNET option specified.\n"
"\n"
"       49     Malformed telnet option.\n"
"\n"
"       51     The remote peer's SSL certificate wasn't ok\n"
"\n"
, stdout);
 fputs(
"       52     The server didn't reply  anything,  which  here  is\n"
"\n"
"              considered an error.\n"
"\n"
"       53     SSL crypto engine not found\n"
"\n"
"       54     Cannot set SSL crypto engine as default\n"
"\n"
"       55     Failed sending network data\n"
"\n"
"       56     Failure in receiving network data\n"
"\n"
"       57     Share is in use (internal error)\n"
"\n"
"       58     Problem with the local certificate\n"
"\n"
"       59     Couldn't use specified SSL cipher\n"
"\n"
"       60     Problem with the CA cert (path? permission?)\n"
"\n"
, stdout);
 fputs(
"       61     Unrecognized transfer encoding\n"
"\n"
"       62     Invalid LDAP URL\n"
"\n"
"       63     Maximum file size exceeded\n"
"\n"
"       XX     There  will  appear more error codes here in future\n"
"              releases. The existing  ones  are  meant  to  never\n"
"              change.\n"
"\n"
"AUTHORS / CONTRIBUTORS\n"
"       Daniel  Stenberg is the main author, but the whole list of\n"
"       contributors is found in the separate THANKS file.\n"
"\n"
"WWW\n"
"       http://curl.haxx.se\n"
"\n"
"FTP\n"
, stdout);
 fputs(
"       ftp://ftp.sunet.se/pub/www/utilities/curl/\n"
"\n"
"SEE ALSO\n"
"       ftp(1), wget(1), snarf(1)\n"
"\n"
"LATEST VERSION\n"
"\n"
"  You always find news about what's going on as well as the latest versions\n"
"  from the curl web pages, located at:\n"
"\n"
"        http://curl.haxx.se\n"
"\n"
"SIMPLE USAGE\n"
"\n"
"  Get the main page from netscape's web-server:\n"
"\n"
"        curl http://www.netscape.com/\n"
"\n"
"  Get the README file the user's home directory at funet's ftp-server:\n"
"\n"
"        curl ftp://ftp.funet.fi/README\n"
"\n"
, stdout);
 fputs(
"  Get a web page from a server using port 8000:\n"
"\n"
"        curl http://www.weirdserver.com:8000/\n"
"\n"
"  Get a list of a directory of an FTP site:\n"
"\n"
"        curl ftp://cool.haxx.se/\n"
"\n"
"  Get a gopher document from funet's gopher server:\n"
"\n"
"        curl gopher://gopher.funet.fi\n"
"\n"
"  Get the definition of curl from a dictionary:\n"
"\n"
"        curl dict://dict.org/m:curl\n"
"\n"
"  Fetch two documents at once:\n"
"\n"
"        curl ftp://cool.haxx.se/ http://www.weirdserver.com:8000/\n"
"\n"
"DOWNLOAD TO A FILE\n"
"\n"
, stdout);
 fputs(
"  Get a web page and store in a local file:\n"
"\n"
"        curl -o thatpage.html http://www.netscape.com/\n"
"\n"
"  Get a web page and store in a local file, make the local file get the name\n"
"  of the remote document (if no file name part is specified in the URL, this\n"
"  will fail):\n"
"\n"
"        curl -O http://www.netscape.com/index.html\n"
"\n"
"  Fetch two files and store them with their remote names:\n"
"\n"
"        curl -O www.haxx.se/index.html -O curl.haxx.se/download.html\n"
"\n"
"USING PASSWORDS\n"
"\n"
" FTP\n"
"\n"
, stdout);
 fputs(
"   To ftp files using name+passwd, include them in the URL like:\n"
"\n"
"        curl ftp://name:passwd@machine.domain:port/full/path/to/file\n"
"\n"
"   or specify them with the -u flag like\n"
"\n"
"        curl -u name:passwd ftp://machine.domain:port/full/path/to/file\n"
"\n"
" HTTP\n"
"\n"
"   The HTTP URL doesn't support user and password in the URL string. Curl\n"
"   does support that anyway to provide a ftp-style interface and thus you can\n"
"   pick a file like:\n"
"\n"
"        curl http://name:passwd@machine.domain/full/path/to/file\n"
"\n"
, stdout);
 fputs(
"   or specify user and password separately like in\n"
"\n"
"        curl -u name:passwd http://machine.domain/full/path/to/file\n"
"\n"
"   NOTE! Since HTTP URLs don't support user and password, you can't use that\n"
"   style when using Curl via a proxy. You _must_ use the -u style fetch\n"
"   during such circumstances.\n"
"\n"
" HTTPS\n"
"\n"
"   Probably most commonly used with private certificates, as explained below.\n"
"\n"
" GOPHER\n"
"\n"
"   Curl features no password support for gopher.\n"
"\n"
"PROXY\n"
"\n"
, stdout);
 fputs(
" Get an ftp file using a proxy named my-proxy that uses port 888:\n"
"\n"
"        curl -x my-proxy:888 ftp://ftp.leachsite.com/README\n"
"\n"
" Get a file from a HTTP server that requires user and password, using the\n"
" same proxy as above:\n"
"\n"
"        curl -u user:passwd -x my-proxy:888 http://www.get.this/\n"
"\n"
" Some proxies require special authentication. Specify by using -U as above:\n"
"\n"
"        curl -U user:passwd -x my-proxy:888 http://www.get.this/\n"
"\n"
, stdout);
 fputs(
" See also the environment variables Curl support that offer further proxy\n"
" control.\n"
"\n"
"RANGES\n"
"\n"
"  With HTTP 1.1 byte-ranges were introduced. Using this, a client can request\n"
"  to get only one or more subparts of a specified document. Curl supports\n"
"  this with the -r flag.\n"
"\n"
"  Get the first 100 bytes of a document:\n"
"\n"
"        curl -r 0-99 http://www.get.this/\n"
"\n"
"  Get the last 500 bytes of a document:\n"
"\n"
"        curl -r -500 http://www.get.this/\n"
"\n"
, stdout);
 fputs(
"  Curl also supports simple ranges for FTP files as well. Then you can only\n"
"  specify start and stop position.\n"
"\n"
"  Get the first 100 bytes of a document using FTP:\n"
"\n"
"        curl -r 0-99 ftp://www.get.this/README  \n"
"\n"
"UPLOADING\n"
"\n"
" FTP\n"
"\n"
"  Upload all data on stdin to a specified ftp site:\n"
"\n"
"        curl -T - ftp://ftp.upload.com/myfile\n"
"\n"
"  Upload data from a specified file, login with user and password:\n"
"\n"
"        curl -T uploadfile -u user:passwd ftp://ftp.upload.com/myfile\n"
"\n"
, stdout);
 fputs(
"  Upload a local file to the remote site, and use the local file name remote\n"
"  too:\n"
" \n"
"        curl -T uploadfile -u user:passwd ftp://ftp.upload.com/\n"
"\n"
"  Upload a local file to get appended to the remote file using ftp:\n"
"\n"
"        curl -T localfile -a ftp://ftp.upload.com/remotefile\n"
"\n"
"  Curl also supports ftp upload through a proxy, but only if the proxy is\n"
"  configured to allow that kind of tunneling. If it does, you can run curl in\n"
"  a fashion similar to:\n"
"\n"
, stdout);
 fputs(
"        curl --proxytunnel -x proxy:port -T localfile ftp.upload.com\n"
"\n"
" HTTP\n"
"\n"
"  Upload all data on stdin to a specified http site:\n"
"\n"
"        curl -T - http://www.upload.com/myfile\n"
"\n"
"  Note that the http server must've been configured to accept PUT before this\n"
"  can be done successfully.\n"
"\n"
"  For other ways to do http data upload, see the POST section below.\n"
"\n"
"VERBOSE / DEBUG\n"
"\n"
"  If curl fails where it isn't supposed to, if the servers don't let you in,\n"
, stdout);
 fputs(
"  if you can't understand the responses: use the -v flag to get verbose\n"
"  fetching. Curl will output lots of info and what it sends and receives in\n"
"  order to let the user see all client-server interaction (but it won't show\n"
"  you the actual data).\n"
"\n"
"        curl -v ftp://ftp.upload.com/\n"
"\n"
"  To get even more details and information on what curl does, try using the\n"
"  --trace or --trace-ascii options with a given file name to log to, like\n"
"  this:\n"
"\n"
"        curl --trace trace.txt www.haxx.se\n"
" \n"
"\n"
, stdout);
 fputs(
"DETAILED INFORMATION\n"
"\n"
"  Different protocols provide different ways of getting detailed information\n"
"  about specific files/documents. To get curl to show detailed information\n"
"  about a single file, you should use -I/--head option. It displays all\n"
"  available info on a single file for HTTP and FTP. The HTTP information is a\n"
"  lot more extensive.\n"
"\n"
"  For HTTP, you can get the header information (the same as -I would show)\n"
"  shown before the data by using -i/--include. Curl understands the\n"
, stdout);
 fputs(
"  -D/--dump-header option when getting files from both FTP and HTTP, and it\n"
"  will then store the headers in the specified file.\n"
"\n"
"  Store the HTTP headers in a separate file (headers.txt in the example):\n"
"\n"
"        curl --dump-header headers.txt curl.haxx.se\n"
"\n"
"  Note that headers stored in a separate file can be very useful at a later\n"
"  time if you want curl to use cookies sent by the server. More about that in\n"
"  the cookies section.\n"
"\n"
"POST (HTTP)\n"
"\n"
, stdout);
 fputs(
"  It's easy to post data using curl. This is done using the -d <data>\n"
"  option.  The post data must be urlencoded.\n"
"\n"
"  Post a simple \"name\" and \"phone\" guestbook.\n"
"\n"
"        curl -d \"name=Rafael%20Sagula&phone=3320780\" \\\n"
"                http://www.where.com/guest.cgi\n"
"\n"
"  How to post a form with curl, lesson #1:\n"
"\n"
"  Dig out all the <input> tags in the form that you want to fill in. (There's\n"
"  a perl program called formfind.pl on the curl site that helps with this).\n"
"\n"
, stdout);
 fputs(
"  If there's a \"normal\" post, you use -d to post. -d takes a full \"post\n"
"  string\", which is in the format\n"
"\n"
"        <variable1>=<data1>&<variable2>=<data2>&...\n"
"\n"
"  The 'variable' names are the names set with \"name=\" in the <input> tags, and\n"
"  the data is the contents you want to fill in for the inputs. The data *must*\n"
"  be properly URL encoded. That means you replace space with + and that you\n"
"  write weird letters with %XX where XX is the hexadecimal representation of\n"
, stdout);
 fputs(
"  the letter's ASCII code.\n"
"\n"
"  Example:\n"
"\n"
"  (page located at http://www.formpost.com/getthis/\n"
"\n"
"        <form action=\"post.cgi\" method=\"post\">\n"
"        <input name=user size=10>\n"
"        <input name=pass type=password size=10>\n"
"        <input name=id type=hidden value=\"blablabla\">\n"
"        <input name=ding value=\"submit\">\n"
"        </form>\n"
"\n"
"  We want to enter user 'foobar' with password '12345'.\n"
"\n"
"  To post to this, you enter a curl command line like:\n"
"\n"
, stdout);
 fputs(
"        curl -d \"user=foobar&pass=12345&id=blablabla&ding=submit\"  (continues)\n"
"          http://www.formpost.com/getthis/post.cgi\n"
"\n"
"\n"
"  While -d uses the application/x-www-form-urlencoded mime-type, generally\n"
"  understood by CGI's and similar, curl also supports the more capable\n"
"  multipart/form-data type. This latter type supports things like file upload.\n"
"\n"
"  -F accepts parameters like -F \"name=contents\". If you want the contents to\n"
, stdout);
 fputs(
"  be read from a file, use <@filename> as contents. When specifying a file,\n"
"  you can also specify the file content type by appending ';type=<mime type>'\n"
"  to the file name. You can also post the contents of several files in one\n"
"  field.  For example, the field name 'coolfiles' is used to send three files,\n"
"  with different content types using the following syntax:\n"
"\n"
"        curl -F \"coolfiles=@fil1.gif;type=image/gif,fil2.txt,fil3.html\" \\\n"
"        http://www.post.com/postit.cgi\n"
"\n"
, stdout);
 fputs(
"  If the content-type is not specified, curl will try to guess from the file\n"
"  extension (it only knows a few), or use the previously specified type (from\n"
"  an earlier file if several files are specified in a list) or else it will\n"
"  using the default type 'text/plain'.\n"
"\n"
"  Emulate a fill-in form with -F. Let's say you fill in three fields in a\n"
"  form. One field is a file name which to post, one field is your name and one\n"
, stdout);
 fputs(
"  field is a file description. We want to post the file we have written named\n"
"  \"cooltext.txt\". To let curl do the posting of this data instead of your\n"
"  favourite browser, you have to read the HTML source of the form page and\n"
"  find the names of the input fields. In our example, the input field names\n"
"  are 'file', 'yourname' and 'filedescription'.\n"
"\n"
"        curl -F \"file=@cooltext.txt\" -F \"yourname=Daniel\" \\\n"
"             -F \"filedescription=Cool text file with cool text inside\" \\\n"
, stdout);
 fputs(
"             http://www.post.com/postit.cgi\n"
"\n"
"  To send two files in one post you can do it in two ways:\n"
"\n"
"  1. Send multiple files in a single \"field\" with a single field name:\n"
" \n"
"        curl -F \"pictures=@dog.gif,cat.gif\" \n"
" \n"
"  2. Send two fields with two field names: \n"
"\n"
"        curl -F \"docpicture=@dog.gif\" -F \"catpicture=@cat.gif\" \n"
"\n"
"REFERRER\n"
"\n"
"  A HTTP request has the option to include information about which address\n"
"  that referred to actual page.  Curl allows you to specify the\n"
, stdout);
 fputs(
"  referrer to be used on the command line. It is especially useful to\n"
"  fool or trick stupid servers or CGI scripts that rely on that information\n"
"  being available or contain certain data.\n"
"\n"
"        curl -e www.coolsite.com http://www.showme.com/\n"
"\n"
"  NOTE: The referer field is defined in the HTTP spec to be a full URL.\n"
"\n"
"USER AGENT\n"
"\n"
"  A HTTP request has the option to include information about the browser\n"
"  that generated the request. Curl allows it to be specified on the command\n"
, stdout);
 fputs(
"  line. It is especially useful to fool or trick stupid servers or CGI\n"
"  scripts that only accept certain browsers.\n"
"\n"
"  Example:\n"
"\n"
"  curl -A 'Mozilla/3.0 (Win95; I)' http://www.nationsbank.com/\n"
"\n"
"  Other common strings:\n"
"    'Mozilla/3.0 (Win95; I)'     Netscape Version 3 for Windows 95\n"
"    'Mozilla/3.04 (Win95; U)'    Netscape Version 3 for Windows 95\n"
"    'Mozilla/2.02 (OS/2; U)'     Netscape Version 2 for OS/2\n"
"    'Mozilla/4.04 [en] (X11; U; AIX 4.2; Nav)'           NS for AIX\n"
, stdout);
 fputs(
"    'Mozilla/4.05 [en] (X11; U; Linux 2.0.32 i586)'      NS for Linux\n"
"\n"
"  Note that Internet Explorer tries hard to be compatible in every way:\n"
"    'Mozilla/4.0 (compatible; MSIE 4.01; Windows 95)'    MSIE for W95\n"
"\n"
"  Mozilla is not the only possible User-Agent name:\n"
"    'Konqueror/1.0'             KDE File Manager desktop client\n"
"    'Lynx/2.7.1 libwww-FM/2.14' Lynx command line browser\n"
"\n"
"COOKIES\n"
"\n"
"  Cookies are generally used by web servers to keep state information at the\n"
, stdout);
 fputs(
"  client's side. The server sets cookies by sending a response line in the\n"
"  headers that looks like 'Set-Cookie: <data>' where the data part then\n"
"  typically contains a set of NAME=VALUE pairs (separated by semicolons ';'\n"
"  like \"NAME1=VALUE1; NAME2=VALUE2;\"). The server can also specify for what\n"
"  path the \"cookie\" should be used for (by specifying \"path=value\"), when the\n"
"  cookie should expire (\"expire=DATE\"), for what domain to use it\n"
, stdout);
 fputs(
"  (\"domain=NAME\") and if it should be used on secure connections only\n"
"  (\"secure\").\n"
"\n"
"  If you've received a page from a server that contains a header like:\n"
"        Set-Cookie: sessionid=boo123; path=\"/foo\";\n"
"\n"
"  it means the server wants that first pair passed on when we get anything in\n"
"  a path beginning with \"/foo\".\n"
"\n"
"  Example, get a page that wants my name passed in a cookie:\n"
"\n"
"        curl -b \"name=Daniel\" www.sillypage.com\n"
"\n"
, stdout);
 fputs(
"  Curl also has the ability to use previously received cookies in following\n"
"  sessions. If you get cookies from a server and store them in a file in a\n"
"  manner similar to:\n"
"\n"
"        curl --dump-header headers www.example.com\n"
"\n"
"  ... you can then in a second connect to that (or another) site, use the\n"
"  cookies from the 'headers' file like:\n"
"\n"
"        curl -b headers www.example.com\n"
"\n"
"  While saving headers to a file is a working way to store cookies, it is\n"
, stdout);
 fputs(
"  however error-prone and not the prefered way to do this. Instead, make curl\n"
"  save the incoming cookies using the well-known netscape cookie format like\n"
"  this:\n"
"\n"
"        curl -c cookies.txt www.example.com\n"
"\n"
"  Note that by specifying -b you enable the \"cookie awareness\" and with -L\n"
"  you can make curl follow a location: (which often is used in combination\n"
"  with cookies). So that if a site sends cookies and a location, you can\n"
"  use a non-existing file to trigger the cookie awareness like:\n"
"\n"
, stdout);
 fputs(
"        curl -L -b empty.txt www.example.com\n"
"\n"
"  The file to read cookies from must be formatted using plain HTTP headers OR\n"
"  as netscape's cookie file. Curl will determine what kind it is based on the\n"
"  file contents.  In the above command, curl will parse the header and store\n"
"  the cookies received from www.example.com.  curl will send to the server the\n"
"  stored cookies which match the request as it follows the location.  The\n"
"  file \"empty.txt\" may be a non-existant file.\n"
"\n"
, stdout);
 fputs(
"  Alas, to both read and write cookies from a netscape cookie file, you can\n"
"  set both -b and -c to use the same file:\n"
"\n"
"        curl -b cookies.txt -c cookies.txt www.example.com\n"
"\n"
"PROGRESS METER\n"
"\n"
"  The progress meter exists to show a user that something actually is\n"
"  happening. The different fields in the output have the following meaning:\n"
"\n"
"  % Total    % Received % Xferd  Average Speed          Time             Curr.\n"
, stdout);
 fputs(
"                                 Dload  Upload Total    Current  Left    Speed\n"
"  0  151M    0 38608    0     0   9406      0  4:41:43  0:00:04  4:41:39  9287\n"
"\n"
"  From left-to-right:\n"
"   %             - percentage completed of the whole transfer\n"
"   Total         - total size of the whole expected transfer\n"
"   %             - percentage completed of the download\n"
"   Received      - currently downloaded amount of bytes\n"
"   %             - percentage completed of the upload\n"
, stdout);
 fputs(
"   Xferd         - currently uploaded amount of bytes\n"
"   Average Speed\n"
"   Dload         - the average transfer speed of the download\n"
"   Average Speed\n"
"   Upload        - the average transfer speed of the upload\n"
"   Time Total    - expected time to complete the operation\n"
"   Time Current  - time passed since the invoke\n"
"   Time Left     - expected time left to completetion\n"
"   Curr.Speed    - the average transfer speed the last 5 seconds (the first\n"
, stdout);
 fputs(
"                   5 seconds of a transfer is based on less time of course.)\n"
"\n"
"  The -# option will display a totally different progress bar that doesn't\n"
"  need much explanation!\n"
"\n"
"SPEED LIMIT\n"
"\n"
"  Curl allows the user to set the transfer speed conditions that must be met\n"
"  to let the transfer keep going. By using the switch -y and -Y you\n"
"  can make curl abort transfers if the transfer speed is below the specified\n"
"  lowest limit for a specified time.\n"
"\n"
, stdout);
 fputs(
"  To have curl abort the download if the speed is slower than 3000 bytes per\n"
"  second for 1 minute, run:\n"
"\n"
"        curl -Y 3000 -y 60 www.far-away-site.com\n"
"\n"
"  This can very well be used in combination with the overall time limit, so\n"
"  that the above operatioin must be completed in whole within 30 minutes:\n"
"\n"
"        curl -m 1800 -Y 3000 -y 60 www.far-away-site.com\n"
"\n"
"  Forcing curl not to transfer data faster than a given rate is also possible,\n"
, stdout);
 fputs(
"  which might be useful if you're using a limited bandwidth connection and you\n"
"  don't want your transfer to use all of it (sometimes referred to as\n"
"  \"bandwith throttle\").\n"
"\n"
"  Make curl transfer data no faster than 10 kilobytes per second:\n"
"\n"
"        curl --limit-rate 10K www.far-away-site.com\n"
"\n"
"    or\n"
"\n"
"        curl --limit-rate 10240 www.far-away-site.com\n"
"\n"
"  Or prevent curl from uploading data faster than 1 megabyte per second:\n"
"\n"
"        curl -T upload --limit-rate 1M ftp://uploadshereplease.com\n"
"\n"
, stdout);
 fputs(
"  When using the --limit-rate option, the transfer rate is regulated on a\n"
"  per-second basis, which will cause the total transfer speed to become lower\n"
"  than the given number. Sometimes of course substantially lower, if your\n"
"  transfer stalls during periods.\n"
"\n"
"CONFIG FILE\n"
"\n"
"  Curl automatically tries to read the .curlrc file (or _curlrc file on win32\n"
"  systems) from the user's home dir on startup.\n"
"\n"
"  The config file could be made up with normal command line switches, but you\n"
, stdout);
 fputs(
"  can also specify the long options without the dashes to make it more\n"
"  readable. You can separate the options and the parameter with spaces, or\n"
"  with = or :. Comments can be used within the file. If the first letter on a\n"
"  line is a '#'-letter the rest of the line is treated as a comment.\n"
"\n"
"  If you want the parameter to contain spaces, you must inclose the entire\n"
"  parameter within double quotes (\"). Within those quotes, you specify a\n"
"  quote as \\\".\n"
"\n"
, stdout);
 fputs(
"  NOTE: You must specify options and their arguments on the same line.\n"
"\n"
"  Example, set default time out and proxy in a config file:\n"
"\n"
"        # We want a 30 minute timeout:\n"
"        -m 1800\n"
"        # ... and we use a proxy for all accesses:\n"
"        proxy = proxy.our.domain.com:8080\n"
"\n"
"  White spaces ARE significant at the end of lines, but all white spaces\n"
"  leading up to the first characters of each line are ignored.\n"
"\n"
"  Prevent curl from reading the default file by using -q as the first command\n"
, stdout);
 fputs(
"  line parameter, like:\n"
"\n"
"        curl -q www.thatsite.com\n"
"\n"
"  Force curl to get and display a local help page in case it is invoked\n"
"  without URL by making a config file similar to:\n"
"\n"
"        # default url to get\n"
"        url = \"http://help.with.curl.com/curlhelp.html\"\n"
"\n"
"  You can specify another config file to be read by using the -K/--config\n"
"  flag. If you set config file name to \"-\" it'll read the config from stdin,\n"
"  which can be handy if you want to hide options from being visible in process\n"
, stdout);
 fputs(
"  tables etc:\n"
"\n"
"        echo \"user = user:passwd\" | curl -K - http://that.secret.site.com\n"
"\n"
"EXTRA HEADERS\n"
"\n"
"  When using curl in your own very special programs, you may end up needing\n"
"  to pass on your own custom headers when getting a web page. You can do\n"
"  this by using the -H flag.\n"
"\n"
"  Example, send the header \"X-you-and-me: yes\" to the server when getting a\n"
"  page:\n"
"\n"
"        curl -H \"X-you-and-me: yes\" www.love.com\n"
"\n"
"  This can also be useful in case you want curl to send a different text in a\n"
, stdout);
 fputs(
"  header than it normally does. The -H header you specify then replaces the\n"
"  header curl would normally send. If you replace an internal header with an\n"
"  empty one, you prevent that header from being sent. To prevent the Host:\n"
"  header from being used:\n"
"\n"
"        curl -H \"Host:\" www.server.com\n"
"\n"
"FTP and PATH NAMES\n"
"\n"
"  Do note that when getting files with the ftp:// URL, the given path is\n"
"  relative the directory you enter. To get the file 'README' from your home\n"
"  directory at your ftp site, do:\n"
"\n"
, stdout);
 fputs(
"        curl ftp://user:passwd@my.site.com/README\n"
"\n"
"  But if you want the README file from the root directory of that very same\n"
"  site, you need to specify the absolute file name:\n"
"\n"
"        curl ftp://user:passwd@my.site.com//README\n"
"\n"
"  (I.e with an extra slash in front of the file name.)\n"
"\n"
"FTP and firewalls\n"
"\n"
"  The FTP protocol requires one of the involved parties to open a second\n"
"  connction as soon as data is about to get transfered. There are two ways to\n"
"  do this.\n"
"\n"
, stdout);
 fputs(
"  The default way for curl is to issue the PASV command which causes the\n"
"  server to open another port and await another connection performed by the\n"
"  client. This is good if the client is behind a firewall that don't allow\n"
"  incoming connections.\n"
"\n"
"        curl ftp.download.com\n"
"\n"
"  If the server for example, is behind a firewall that don't allow connections\n"
"  on other ports than 21 (or if it just doesn't support the PASV command), the\n"
, stdout);
 fputs(
"  other way to do it is to use the PORT command and instruct the server to\n"
"  connect to the client on the given (as parameters to the PORT command) IP\n"
"  number and port.\n"
"\n"
"  The -P flag to curl supports a few different options. Your machine may have\n"
"  several IP-addresses and/or network interfaces and curl allows you to select\n"
"  which of them to use. Default address can also be used:\n"
"\n"
"        curl -P - ftp.download.com\n"
"\n"
, stdout);
 fputs(
"  Download with PORT but use the IP address of our 'le0' interface (this does\n"
"  not work on windows):\n"
"\n"
"        curl -P le0 ftp.download.com\n"
"\n"
"  Download with PORT but use 192.168.0.10 as our IP address to use:\n"
"\n"
"        curl -P 192.168.0.10 ftp.download.com\n"
"\n"
"NETWORK INTERFACE\n"
"\n"
"  Get a web page from a server using a specified port for the interface:\n"
"\n"
"	curl --interface eth0:1 http://www.netscape.com/\n"
"\n"
"  or\n"
"\n"
"	curl --interface 192.168.1.10 http://www.netscape.com/\n"
"\n"
"HTTPS\n"
"\n"
, stdout);
 fputs(
"  Secure HTTP requires SSL libraries to be installed and used when curl is\n"
"  built. If that is done, curl is capable of retrieving and posting documents\n"
"  using the HTTPS procotol.\n"
"\n"
"  Example:\n"
"\n"
"        curl https://www.secure-site.com\n"
"\n"
"  Curl is also capable of using your personal certificates to get/post files\n"
"  from sites that require valid certificates. The only drawback is that the\n"
"  certificate needs to be in PEM-format. PEM is a standard and open format to\n"
, stdout);
 fputs(
"  store certificates with, but it is not used by the most commonly used\n"
"  browsers (Netscape and MSIE both use the so called PKCS#12 format). If you\n"
"  want curl to use the certificates you use with your (favourite) browser, you\n"
"  may need to download/compile a converter that can convert your browser's\n"
"  formatted certificates to PEM formatted ones. This kind of converter is\n"
"  included in recent versions of OpenSSL, and for older versions Dr Stephen\n"
, stdout);
 fputs(
"  N. Henson has written a patch for SSLeay that adds this functionality. You\n"
"  can get his patch (that requires an SSLeay installation) from his site at:\n"
"  http://www.drh-consultancy.demon.co.uk/\n"
"\n"
"  Example on how to automatically retrieve a document using a certificate with\n"
"  a personal password:\n"
"\n"
"        curl -E /path/to/cert.pem:password https://secure.site.com/\n"
"\n"
"  If you neglect to specify the password on the command line, you will be\n"
, stdout);
 fputs(
"  prompted for the correct password before any data can be received.\n"
"\n"
"  Many older SSL-servers have problems with SSLv3 or TLS, that newer versions\n"
"  of OpenSSL etc is using, therefore it is sometimes useful to specify what\n"
"  SSL-version curl should use. Use -3, -2 or -1 to specify that exact SSL\n"
"  version to use (for SSLv3, SSLv2 or TLSv1 respectively):\n"
"\n"
"        curl -2 https://secure.site.com/\n"
"\n"
"  Otherwise, curl will first attempt to use v3 and then v2.\n"
"\n"
, stdout);
 fputs(
"  To use OpenSSL to convert your favourite browser's certificate into a PEM\n"
"  formatted one that curl can use, do something like this (assuming netscape,\n"
"  but IE is likely to work similarly):\n"
"\n"
"    You start with hitting the 'security' menu button in netscape. \n"
"\n"
"    Select 'certificates->yours' and then pick a certificate in the list \n"
"\n"
"    Press the 'export' button \n"
"\n"
"    enter your PIN code for the certs \n"
"\n"
"    select a proper place to save it \n"
"\n"
, stdout);
 fputs(
"    Run the 'openssl' application to convert the certificate. If you cd to the\n"
"    openssl installation, you can do it like:\n"
"\n"
"     # ./apps/openssl pkcs12 -in [file you saved] -clcerts -out [PEMfile]\n"
"\n"
"\n"
"RESUMING FILE TRANSFERS\n"
"\n"
" To continue a file transfer where it was previously aborted, curl supports\n"
" resume on http(s) downloads as well as ftp uploads and downloads.\n"
"\n"
" Continue downloading a document:\n"
"\n"
"        curl -C - -o file ftp://ftp.server.com/path/file\n"
"\n"
" Continue uploading a document(*1):\n"
, stdout);
 fputs(
"\n"
"        curl -C - -T file ftp://ftp.server.com/path/file\n"
"\n"
" Continue downloading a document from a web server(*2):\n"
"\n"
"        curl -C - -o file http://www.server.com/\n"
"\n"
" (*1) = This requires that the ftp server supports the non-standard command\n"
"        SIZE. If it doesn't, curl will say so.\n"
"\n"
" (*2) = This requires that the web server supports at least HTTP/1.1. If it\n"
"        doesn't, curl will say so.\n"
"\n"
"TIME CONDITIONS\n"
"\n"
" HTTP allows a client to specify a time condition for the document it\n"
, stdout);
 fputs(
" requests. It is If-Modified-Since or If-Unmodified-Since. Curl allow you to\n"
" specify them with the -z/--time-cond flag.\n"
"\n"
" For example, you can easily make a download that only gets performed if the\n"
" remote file is newer than a local copy. It would be made like:\n"
"\n"
"        curl -z local.html http://remote.server.com/remote.html\n"
"\n"
" Or you can download a file only if the local file is newer than the remote\n"
" one. Do this by prepending the date string with a '-', as in:\n"
"\n"
, stdout);
 fputs(
"        curl -z -local.html http://remote.server.com/remote.html\n"
"\n"
" You can specify a \"free text\" date as condition. Tell curl to only download\n"
" the file if it was updated since yesterday:\n"
"\n"
"        curl -z yesterday http://remote.server.com/remote.html\n"
"\n"
" Curl will then accept a wide range of date formats. You always make the date\n"
" check the other way around by prepending it with a dash '-'.\n"
"\n"
"DICT\n"
"\n"
"  For fun try\n"
"\n"
"        curl dict://dict.org/m:curl\n"
"        curl dict://dict.org/d:heisenbug:jargon\n"
, stdout);
 fputs(
"        curl dict://dict.org/d:daniel:web1913\n"
"\n"
"  Aliases for 'm' are 'match' and 'find', and aliases for 'd' are 'define'\n"
"  and 'lookup'. For example,\n"
"\n"
"        curl dict://dict.org/find:curl\n"
"\n"
"  Commands that break the URL description of the RFC (but not the DICT\n"
"  protocol) are\n"
"\n"
"        curl dict://dict.org/show:db\n"
"        curl dict://dict.org/show:strat\n"
"\n"
"  Authentication is still missing (but this is not required by the RFC)\n"
"\n"
"LDAP\n"
"\n"
, stdout);
 fputs(
"  If you have installed the OpenLDAP library, curl can take advantage of it\n"
"  and offer ldap:// support.\n"
"\n"
"  LDAP is a complex thing and writing an LDAP query is not an easy task. I do\n"
"  advice you to dig up the syntax description for that elsewhere. Two places\n"
"  that might suit you are:\n"
"\n"
"  Netscape's \"Netscape Directory SDK 3.0 for C Programmer's Guide Chapter 10:\n"
"  Working with LDAP URLs\":\n"
"  http://developer.netscape.com/docs/manuals/dirsdk/csdk30/url.htm\n"
"\n"
, stdout);
 fputs(
"  RFC 2255, \"The LDAP URL Format\" http://www.rfc-editor.org/rfc/rfc2255.txt\n"
"\n"
"  To show you an example, this is now I can get all people from my local LDAP\n"
"  server that has a certain sub-domain in their email address:\n"
"\n"
"        curl -B \"ldap://ldap.frontec.se/o=frontec??sub?mail=*sth.frontec.se\"\n"
"\n"
"  If I want the same info in HTML format, I can get it by not using the -B\n"
"  (enforce ASCII) flag.\n"
"\n"
"ENVIRONMENT VARIABLES\n"
"\n"
"  Curl reads and understands the following environment variables:\n"
"\n"
, stdout);
 fputs(
"        http_proxy, HTTPS_PROXY, FTP_PROXY, GOPHER_PROXY\n"
"\n"
"  They should be set for protocol-specific proxies. General proxy should be\n"
"  set with\n"
"        \n"
"        ALL_PROXY\n"
"\n"
"  A comma-separated list of host names that shouldn't go through any proxy is\n"
"  set in (only an asterisk, '*' matches all hosts)\n"
"\n"
"        NO_PROXY\n"
"\n"
"  If a tail substring of the domain-path for a host matches one of these\n"
"  strings, transactions with that node will not be proxied.\n"
"\n"
"\n"
, stdout);
 fputs(
"  The usage of the -x/--proxy flag overrides the environment variables.\n"
"\n"
"NETRC\n"
"\n"
"  Unix introduced the .netrc concept a long time ago. It is a way for a user\n"
"  to specify name and password for commonly visited ftp sites in a file so\n"
"  that you don't have to type them in each time you visit those sites. You\n"
"  realize this is a big security risk if someone else gets hold of your\n"
"  passwords, so therefor most unix programs won't read this file unless it is\n"
, stdout);
 fputs(
"  only readable by yourself (curl doesn't care though).\n"
"\n"
"  Curl supports .netrc files if told so (using the -n/--netrc and\n"
"  --netrc-optional options). This is not restricted to only ftp,\n"
"  but curl can use it for all protocols where authentication is used.\n"
"\n"
"  A very simple .netrc file could look something like:\n"
"\n"
"        machine curl.haxx.se login iamdaniel password mysecret\n"
"\n"
"CUSTOM OUTPUT\n"
"\n"
"  To better allow script programmers to get to know about the progress of\n"
, stdout);
 fputs(
"  curl, the -w/--write-out option was introduced. Using this, you can specify\n"
"  what information from the previous transfer you want to extract.\n"
"\n"
"  To display the amount of bytes downloaded together with some text and an\n"
"  ending newline:\n"
"\n"
"        curl -w 'We downloaded %{size_download} bytes\\n' www.download.com\n"
"\n"
"KERBEROS4 FTP TRANSFER\n"
"\n"
"  Curl supports kerberos4 for FTP transfers. You need the kerberos package\n"
"  installed and used at curl build time for it to be used.\n"
"\n"
, stdout);
 fputs(
"  First, get the krb-ticket the normal way, like with the kauth tool. Then use\n"
"  curl in way similar to:\n"
"\n"
"        curl --krb4 private ftp://krb4site.com -u username:fakepwd\n"
"\n"
"  There's no use for a password on the -u switch, but a blank one will make\n"
"  curl ask for one and you already entered the real password to kauth.\n"
"\n"
"TELNET\n"
"\n"
"  The curl telnet support is basic and very easy to use. Curl passes all data\n"
"  passed to it on stdin to the remote server. Connect to a remote telnet\n"
, stdout);
 fputs(
"  server using a command line similar to:\n"
"\n"
"        curl telnet://remote.server.com\n"
"\n"
"  And enter the data to pass to the server on stdin. The result will be sent\n"
"  to stdout or to the file you specify with -o.\n"
"\n"
"  You might want the -N/--no-buffer option to switch off the buffered output\n"
"  for slow connections or similar.\n"
"\n"
"  Pass options to the telnet protocol negotiation, by using the -t option. To\n"
"  tell the server we use a vt100 terminal, try something like:\n"
"\n"
, stdout);
 fputs(
"        curl -tTTYPE=vt100 telnet://remote.server.com\n"
"\n"
"  Other interesting options for it -t include:\n"
"\n"
"   - XDISPLOC=<X display> Sets the X display location.\n"
"\n"
"   - NEW_ENV=<var,val> Sets an environment variable.\n"
"\n"
"  NOTE: the telnet protocol does not specify any way to login with a specified\n"
"  user and password so curl can't do that automatically. To do that, you need\n"
"  to track when the login prompt is received and send the username and\n"
"  password accordingly.\n"
"\n"
"PERSISTANT CONNECTIONS\n"
"\n"
, stdout);
 fputs(
"  Specifying multiple files on a single command line will make curl transfer\n"
"  all of them, one after the other in the specified order.\n"
"\n"
"  libcurl will attempt to use persistant connections for the transfers so that\n"
"  the second transfer to the same host can use the same connection that was\n"
"  already initiated and was left open in the previous transfer. This greatly\n"
"  decreases connection time for all but the first transfer and it makes a far\n"
"  better use of the network.\n"
"\n"
, stdout);
 fputs(
"  Note that curl cannot use persistant connections for transfers that are used\n"
"  in subsequence curl invokes. Try to stuff as many URLs as possible on the\n"
"  same command line if they are using the same host, as that'll make the\n"
"  transfers faster. If you use a http proxy for file transfers, practicly\n"
"  all transfers will be persistant.\n"
"\n"
"  Persistant connections were introduced in curl 7.7.\n"
"\n"
"MAILING LISTS\n"
"\n"
"  For your convenience, we have several open mailing lists to discuss curl,\n"
, stdout);
 fputs(
"  its development and things relevant to this. Get all info at\n"
"  http://curl.haxx.se/mail/. The lists available are:\n"
"\n"
"  curl-users\n"
"\n"
"    Users of the command line tool. How to use it, what doesn't work, new\n"
"    features, related tools, questions, news, installations, compilations,\n"
"    running, porting etc.\n"
"\n"
"  curl-library\n"
"\n"
"    Developers using or developing libcurl. Bugs, extensions, improvements.\n"
"\n"
"  curl-announce\n"
"\n"
"    Low-traffic. Only announcements of new public versions.\n"
"\n"
"  curl-and-PHP\n"
"\n"
, stdout);
 fputs(
"    Using the curl functions in PHP. Everything curl with a PHP angle. Or PHP\n"
"    with a curl angle.\n"
"\n"
"  curl-commits\n"
"\n"
"    Receives notifications on all CVS commits done to the curl source module.\n"
"    This can become quite a large amount of mails during intense development,\n"
"    be aware. This is for us who like email...\n"
"\n"
"  curl-www-commits\n"
"\n"
"    Receives notifications on all CVS commits done to the curl www module\n"
"    (basicly the web site).  This can become quite a large amount of mails\n"
, stdout);
 fputs(
"    during intense changing, be aware. This is for us who like email...\n"
"\n"
"  Please direct curl questions, feature requests and trouble reports to one of\n"
"  these mailing lists instead of mailing any individual.\n"
, stdout) ;
}
#else
/*
 * NEVER EVER edit this manually, fix the mkhelp.pl script instead!
 * Generation time: Wed Jan 21 18:04:59 2004
 */
#include <stdio.h>
#include <zlib.h>
static const unsigned char hugehelpgz[] = {
  /* This mumbo-jumbo is the huge help text compressed with gzip.
     Thanks to this operation, the size of this data shrunk from 92821
     to 28565 bytes. You can disable the use of compressed help
     texts by NOT passing -c to the mkhelp.pl tool. */
  0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03, 0xed, 0xbd, 
  0x6b, 0x77, 0x1b, 0xc7, 0xb1, 0x2e, 0xfc, 0xf9, 0xe5, 0xaf, 0x98, 0xc0, 
  0xaf, 0x03, 0x32, 0x1b, 0x00, 0x2f, 0x92, 0x1d, 0x4b, 0x91, 0x1c, 0xd3, 
  0x14, 0x65, 0x73, 0x99, 0x12, 0xb9, 0x49, 0xca, 0x97, 0xe3, 0x78, 0x69, 
  0x0d, 0x80, 0x01, 0x39, 0x21, 0x30, 0x83, 0xcc, 0x0c, 0x48, 0xc1, 0xd9, 
  0x39, 0xbf, 0xfd, 0x54, 0x3d, 0x55, 0xd5, 0xdd, 0x73, 0x01, 0x25, 0x27, 
  0xb1, 0x73, 0x3e, 0x1c, 0xef, 0x1d, 0x91, 0x04, 0x66, 0xfa, 0x5a, 0x5d, 
  0x5d, 0xd7, 0xa7, 0xa2, 0xe8, 0x7d, 0xff, 0xbd, 0xc5, 0xff, 0xde, 0xd2, 
  0x7f, 0xf2, 0x7b, 0x14, 0x6d, 0x45, 0xd1, 0x79, 0x91, 0xff, 0x35, 0x99, 
  0x54, 0xdd, 0x2f, 0xbc, 0x7d, 0xfb, 0x3f, 0x91, 0xfc, 0x1f, 0xbd, 0xf0, 
  0x17, 0xfc, 0xc4, 0x4b, 0x0f, 0xfc, 0xb7, 0x1b, 0xf9, 0x97, 0xfe, 0xe7, 
  0xed, 0x4e, 0xf4, 0x21, 0x2f, 0xfd, 0x4f, 0xb4, 0x8d, 0x97, 0xde, 0x6a, 
  0x4f, 0xcf, 0xf8, 0x77, 0x1a, 0xe5, 0xc3, 0x3d, 0xfd, 0x85, 0x87, 0xc7, 
  0xff, 0xec, 0xf2, 0x8b, 0x7f, 0x79, 0xcb, 0xbf, 0xd2, 0x27, 0x5b, 0x5b, 
  0xaf, 0x0f, 0x5f, 0x1d, 0xdb, 0xab, 0x93, 0x55, 0x31, 0x8f, 0x86, 0x51, 
  0x55, 0xc4, 0x59, 0x39, 0x4b, 0x8a, 0x28, 0x8e, 0xde, 0x5c, 0x9c, 0x6e, 
  0x6d, 0x5d, 0xfe, 0xf0, 0xfa, 0xec, 0xfc, 0xf2, 0xe4, 0xb2, 0xf6, 0xd8, 
  0x8f, 0xf9, 0xb2, 0x4a, 0xf3, 0xac, 0xfc, 0x29, 0xfa, 0x91, 0x1e, 0x1a, 
  0x8d, 0x46, 0x3f, 0x6d, 0x6d, 0xbd, 0x38, 0xbe, 0x3c, 0xba, 0x38, 0x39, 
  0xbf, 0x3a, 0x39, 0x7b, 0x5d, 0x7b, 0x36, 0x2d, 0xa9, 0xa9, 0x2a, 0xcf, 
  0xe7, 0xf4, 0x8f, 0x6f, 0x7d, 0x1a, 0x57, 0x71, 0x34, 0x2b, 0xf2, 0x45, 
  0x94, 0x17, 0xfc, 0x45, 0x1c, 0x95, 0x49, 0x71, 0x97, 0x14, 0x83, 0x68, 
  0x55, 0xa6, 0xd9, 0xb5, 0xb5, 0x90, 0x67, 0x49, 0x94, 0xcf, 0xa2, 0xea, 
  0x26, 0x89, 0xca, 0xd5, 0x72, 0x99, 0x17, 0x55, 0x32, 0x8d, 0x96, 0x45, 
  0x5e, 0xe5, 0x93, 0x7c, 0x5e, 0x46, 0xdb, 0x5f, 0x5f, 0x5d, 0x9d, 0x0f, 
  0xa2, 0x88, 0x7f, 0x5c, 0xd2, 0xcf, 0x97, 0xf8, 0xeb, 0x25, 0xff, 0x61, 
  0x2d, 0x7c, 0x75, 0x76, 0xfe, 0xf5, 0xf1, 0x05, 0x7d, 0xfa, 0xe2, 0xe4, 
  0xe8, 0x8a, 0x7e, 0x5c, 0x1d, 0x9f, 0xbe, 0x3e, 0xe6, 0x5f, 0x4e, 0x5f, 
  0x1c, 0x9e, 0x47, 0xdc, 0x7b, 0xf4, 0xf2, 0xe4, 0xf4, 0x78, 0x67, 0x44, 
  0x5f, 0x51, 0x2f, 0xd1, 0x24, 0x5f, 0x2c, 0xe2, 0x6c, 0x4a, 0xc3, 0xb6, 
  0x16, 0xa6, 0x49, 0x99, 0x5e, 0x67, 0xd4, 0x2f, 0x0d, 0xf3, 0x3e, 0x2f, 
  0x6e, 0xa3, 0xfb, 0xb4, 0xba, 0xc9, 0x57, 0x15, 0x8d, 0x94, 0x26, 0x92, 
  0x66, 0x55, 0x52, 0xc4, 0x13, 0x5e, 0x8e, 0xd1, 0x56, 0x6d, 0xe2, 0xf9, 
  0x8c, 0x26, 0xca, 0x93, 0x1f, 0xaf, 0xca, 0x79, 0x1e, 0x4f, 0x79, 0x22, 
  0xf4, 0xca, 0x6c, 0x45, 0x2b, 0x51, 0xa4, 0x93, 0xdb, 0x32, 0x9a, 0xa7, 
  0xb7, 0x09, 0xcf, 0xe6, 0xdd, 0xda, 0x66, 0xe7, 0x86, 0x8d, 0xb6, 0xa3, 
  0x78, 0x45, 0x33, 0xcf, 0xaa, 0x74, 0x12, 0x73, 0xfb, 0x34, 0xe8, 0x59, 
  0xb5, 0x8c, 0x56, 0x4b, 0x6e, 0x6d, 0x80, 0x49, 0x47, 0xcb, 0xbc, 0xac, 
  0x06, 0xd1, 0xe5, 0xe5, 0x69, 0xb4, 0x7d, 0x53, 0x55, 0xcb, 0xf2, 0xe9, 
  0x8e, 0x1b, 0x43, 0x9e, 0x65, 0x09, 0xc6, 0x55, 0x0e, 0xe8, 0x8f, 0xfc, 
  0x36, 0x4d, 0xe8, 0x97, 0x59, 0x3a, 0x4f, 0xfc, 0x2e, 0x14, 0x49, 0xb9, 
  0x5a, 0xd0, 0xa4, 0x79, 0xc2, 0xd1, 0x22, 0x2f, 0x12, 0x5a, 0x85, 0x43, 
  0x37, 0xf1, 0x75, 0xbe, 0x8a, 0x68, 0xb2, 0xf3, 0x39, 0xed, 0x4d, 0x12, 
  0x8d, 0x93, 0x79, 0x7e, 0x3f, 0xc0, 0x56, 0xc4, 0x8b, 0x7c, 0x95, 0x55, 
  0x3c, 0x9f, 0x59, 0x12, 0x57, 0x2b, 0x6a, 0x45, 0x1e, 0x5b, 0xc4, 0x34, 
  0x1f, 0x7a, 0xab, 0xb0, 0x16, 0x6e, 0x12, 0x9a, 0x76, 0xb9, 0x4c, 0xb3, 
  0xdf, 0x6d, 0x35, 0x69, 0x62, 0x99, 0xdf, 0x27, 0x05, 0x2d, 0xea, 0x78, 
  0x4d, 0xcb, 0x30, 0xc6, 0xa7, 0x33, 0xda, 0x8c, 0x98, 0x9a, 0x71, 0xe3, 
  0x1b, 0x16, 0xc9, 0x3c, 0xe6, 0x1d, 0xe7, 0x7e, 0x86, 0xd6, 0x02, 0x3a, 
  0x1c, 0x45, 0x97, 0x34, 0x26, 0x7d, 0x73, 0xfb, 0xd1, 0x0e, 0x5e, 0x9e, 
  0x26, 0x55, 0x9c, 0xce, 0x4b, 0xda, 0x07, 0x26, 0x5d, 0x7d, 0x1c, 0xbb, 
  0x4a, 0x7f, 0x47, 0x51, 0xb9, 0xce, 0xaa, 0xf8, 0x5d, 0xc4, 0xbd, 0x3b, 
  0x1a, 0xe2, 0xed, 0x5d, 0x26, 0xd9, 0x94, 0x56, 0x99, 0xe6, 0xfe, 0x43, 
  0xbe, 0xea, 0xf3, 0x00, 0x66, 0x29, 0x2d, 0x48, 0xec, 0x09, 0x80, 0x9b, 
  0xa5, 0x61, 0x10, 0x25, 0x4c, 0x8a, 0x14, 0xa4, 0x4f, 0xfb, 0x1e, 0x5d, 
  0xbc, 0x3c, 0x8a, 0x0e, 0x1e, 0x3d, 0xf9, 0xd4, 0xef, 0x3b, 0xbd, 0x1f, 
  0x4d, 0xe2, 0x8c, 0xa6, 0x9c, 0x4c, 0xd2, 0xd9, 0x3a, 0x5a, 0xac, 0xe6, 
  0x55, 0xba, 0xa4, 0x15, 0xa7, 0xfe, 0x4b, 0xa6, 0xb5, 0x65, 0x5c, 0x54, 
  0x25, 0x2f, 0x1c, 0x3e, 0xa0, 0xb9, 0x47, 0xf7, 0x45, 0x5a, 0x05, 0x04, 
  0xcf, 0x0f, 0xd0, 0x72, 0x57, 0x25, 0xa8, 0x8c, 0x3a, 0x19, 0x13, 0x71, 
  0xd1, 0xfa, 0xc6, 0x25, 0xf5, 0xf8, 0xd4, 0x75, 0x14, 0xf1, 0x66, 0x3f, 
  0xdd, 0xdd, 0x2d, 0xd3, 0x2a, 0x19, 0xfd, 0x9d, 0x4e, 0xc9, 0xa0, 0xba, 
  0xcf, 0x07, 0xd5, 0x4d, 0x91, 0x24, 0xff, 0x18, 0x11, 0x09, 0xbb, 0x07, 
  0x99, 0xbe, 0xb1, 0x8f, 0x3c, 0xac, 0xeb, 0x84, 0xdb, 0xfe, 0xdb, 0x2a, 
  0xc9, 0xb8, 0x49, 0x1a, 0x45, 0x3c, 0x5f, 0xde, 0xc4, 0x19, 0x91, 0x00, 
  0xd1, 0x23, 0x1f, 0x40, 0x22, 0x11, 0x1e, 0x54, 0xed, 0x08, 0xfe, 0xf8, 
  0x53, 0xab, 0xf3, 0x19, 0xfa, 0xa6, 0x7f, 0x47, 0xfa, 0x6e, 0x4c, 0x8b, 
  0x4e, 0xbd, 0xee, 0x32, 0x75, 0xfd, 0xb8, 0x3f, 0xdc, 0xdf, 0xdb, 0xfb, 
  0x69, 0x54, 0xbd, 0xab, 0x3e, 0xf0, 0x85, 0xbd, 0x3d, 0xff, 0x0a, 0x3f, 
  0xbd, 0xcd, 0x53, 0x8f, 0xe6, 0x44, 0x3b, 0x6e, 0xcf, 0x69, 0x3c, 0xd1, 
  0xcf, 0x49, 0x91, 0x97, 0x3b, 0x1d, 0x6d, 0xce, 0x93, 0x8a, 0xce, 0x60, 
  0xd0, 0x60, 0x3c, 0xfc, 0x59, 0xfa, 0xb7, 0x87, 0x5f, 0xe7, 0x51, 0x96, 
  0x94, 0xbc, 0xce, 0x8e, 0x9b, 0xb8, 0x65, 0x20, 0x6a, 0xf0, 0xac, 0x25, 
  0xae, 0xf0, 0xed, 0x22, 0x5f, 0x10, 0x41, 0xb4, 0x97, 0xfb, 0xfe, 0xfe, 
  0x7e, 0x14, 0x67, 0xeb, 0x51, 0x5e, 0x5c, 0xef, 0xc6, 0xc5, 0xe4, 0x26, 
  0xbd, 0xa3, 0xe9, 0x3e, 0x79, 0xf2, 0xe9, 0x90, 0xfe, 0x79, 0xf2, 0xd3, 
  0xee, 0x5d, 0x3e, 0x77, 0x23, 0xa6, 0x79, 0xd2, 0x4a, 0x3c, 0xfe, 0x89, 
  0x37, 0xf4, 0xef, 0xf1, 0x60, 0x3c, 0x98, 0x0c, 0x88, 0xa8, 0x92, 0x77, 
  0xff, 0x18, 0xdd, 0x54, 0x8b, 0xf9, 0x46, 0x8a, 0xa1, 0xd6, 0x83, 0xe3, 
  0x25, 0x64, 0x93, 0x45, 0x18, 0x94, 0x63, 0x4d, 0x44, 0xf6, 0x59, 0x32, 
  0x0a, 0xe8, 0x7b, 0xad, 0xc7, 0x74, 0x9c, 0xd0, 0x41, 0xa9, 0x26, 0x37, 
  0x34, 0x11, 0xa2, 0x9c, 0x58, 0x27, 0x59, 0xa5, 0x31, 0x1f, 0x4d, 0xe2, 
  0x06, 0xcc, 0xad, 0x64, 0xf6, 0xdc, 0x9b, 0x1b, 0xea, 0x2c, 0xa5, 0x17, 
  0xf2, 0x62, 0x9a, 0x14, 0x9e, 0x92, 0x8f, 0xf8, 0x40, 0xa2, 0xd1, 0x98, 
  0x16, 0x77, 0xb1, 0xac, 0x98, 0xfb, 0x15, 0xc9, 0x90, 0xf8, 0x52, 0xc8, 
  0x59, 0x70, 0xec, 0x1c, 0x95, 0x83, 0xbb, 0xb8, 0x63, 0xaa, 0x87, 0x98, 
  0x98, 0x4e, 0x49, 0x8c, 0xff, 0x86, 0x96, 0x96, 0xe8, 0x0f, 0x7b, 0xb0, 
  0xe0, 0x59, 0xf2, 0xb3, 0xa5, 0x5c, 0x01, 0x18, 0x52, 0xbc, 0x48, 0xf4, 
  0x0e, 0xb0, 0x16, 0xd0, 0x7d, 0x96, 0x57, 0xd1, 0x34, 0xf7, 0x7d, 0x68, 
  0xe7, 0x25, 0x5d, 0x9f, 0x44, 0xba, 0xd3, 0xf2, 0x86, 0x78, 0x0e, 0x71, 
  0x83, 0xab, 0x1b, 0x3e, 0xd5, 0xe9, 0x82, 0xce, 0xf5, 0x5d, 0xe2, 0x38, 
  0x18, 0xcd, 0x33, 0x99, 0x8e, 0xa2, 0xb3, 0x19, 0xbd, 0xb6, 0x2a, 0x68, 
  0xe8, 0x15, 0x3f, 0x96, 0xf2, 0x9a, 0xce, 0xd7, 0xd4, 0x2c, 0xdf, 0x2e, 
  0x99, 0x8e, 0x44, 0x76, 0x00, 0x4b, 0x91, 0xf9, 0xb3, 0xcf, 0x27, 0x01, 
  0xbd, 0xca, 0xd2, 0xf3, 0xca, 0x83, 0x5b, 0xd2, 0x9e, 0xf1, 0xc8, 0x68, 
  0xc5, 0x99, 0x55, 0xd3, 0x9e, 0x8c, 0x93, 0xea, 0x3e, 0x49, 0x68, 0xab, 
  0xca, 0x84, 0xb6, 0x9c, 0xb8, 0x56, 0x9d, 0xe1, 0x65, 0x77, 0x39, 0x8f, 
  0x73, 0x6b, 0xeb, 0x0c, 0x37, 0xa4, 0xbb, 0x4e, 0x87, 0xf1, 0xee, 0x70, 
  0x18, 0x2f, 0x99, 0x05, 0x35, 0xee, 0xf0, 0x6d, 0xba, 0xc6, 0x76, 0xa2, 
  0xe8, 0xbb, 0x1b, 0x6e, 0x54, 0xfa, 0xe0, 0x4d, 0xcd, 0xf8, 0x7a, 0x73, 
  0x77, 0x00, 0xe6, 0x83, 0x75, 0xaa, 0x92, 0xf9, 0xbc, 0xd1, 0x02, 0x7a, 
  0xe6, 0xbb, 0x15, 0xcd, 0xe3, 0xfa, 0xa5, 0x85, 0xae, 0xe2, 0x82, 0xf9, 
  0x00, 0x2e, 0x82, 0x34, 0x2b, 0xab, 0x44, 0x6e, 0xa6, 0x88, 0xd6, 0xad, 
  0x18, 0x36, 0x5a, 0x50, 0xe6, 0x44, 0x3d, 0x33, 0x77, 0x3c, 0x91, 0xa3, 
  0x83, 0x37, 0xa7, 0x79, 0x52, 0x66, 0xfd, 0x2a, 0x4a, 0xde, 0xa5, 0x7c, 
  0x01, 0xa5, 0x95, 0x51, 0x60, 0x73, 0x0c, 0x45, 0xc2, 0x1c, 0xdc, 0x13, 
  0x96, 0xfe, 0x87, 0xb6, 0x78, 0x23, 0x94, 0x9b, 0x96, 0x32, 0xc5, 0xea, 
  0x3e, 0x9d, 0x24, 0x03, 0x3d, 0xa1, 0xb4, 0xd5, 0x53, 0x11, 0x01, 0xd0, 
  0x78, 0xa3, 0x85, 0x69, 0x5a, 0xc6, 0x63, 0x1a, 0x89, 0xce, 0x6e, 0x91, 
  0x4f, 0xe9, 0xf7, 0xeb, 0x38, 0x0d, 0xae, 0xe1, 0xe1, 0x21, 0x2d, 0x2e, 
  0xdf, 0xa4, 0xc3, 0xf8, 0x9a, 0xce, 0x41, 0xf4, 0x4c, 0x7e, 0x94, 0x74, 
  0xfd, 0x66, 0xd7, 0x9f, 0x37, 0xd7, 0x9b, 0xef, 0xd3, 0x9d, 0xe8, 0x52, 
  0x0f, 0x22, 0x0f, 0xe1, 0x0d, 0xbf, 0x7a, 0x18, 0xbc, 0xc3, 0x6b, 0x58, 
  0xfa, 0xb5, 0x6c, 0xb4, 0x80, 0x0b, 0x59, 0x48, 0x98, 0xae, 0x27, 0x62, 
  0x21, 0xd1, 0x38, 0x9e, 0x1a, 0x9d, 0x1d, 0x7d, 0x75, 0x42, 0xd4, 0x4e, 
  0xf7, 0x48, 0x94, 0xce, 0x78, 0x3d, 0x89, 0x5a, 0x89, 0x80, 0x1a, 0x2d, 
  0x10, 0xe3, 0x8f, 0xb8, 0xed, 0xa8, 0xf7, 0x2a, 0xff, 0x99, 0xa6, 0x1c, 
  0xef, 0x3e, 0x1e, 0xed, 0xf5, 0x46, 0x7c, 0xca, 0xe9, 0x43, 0xe2, 0x57, 
  0x3c, 0xc9, 0x68, 0x3c, 0x8f, 0xb3, 0xdb, 0x52, 0xcf, 0x72, 0xb3, 0x05, 
  0x8c, 0x93, 0x24, 0x85, 0x72, 0x55, 0x14, 0xc4, 0x46, 0xa6, 0xca, 0x3b, 
  0x74, 0xfc, 0xb8, 0x55, 0x1c, 0x55, 0x47, 0x7f, 0x5b, 0xe5, 0x55, 0xb3, 
  0x85, 0x45, 0x5c, 0xdc, 0x96, 0xe8, 0x12, 0x47, 0x8a, 0x99, 0x13, 0x71, 
  0xeb, 0x9c, 0x49, 0x9d, 0x87, 0x87, 0x06, 0xb8, 0xc9, 0xe1, 0xd7, 0xb4, 
  0xb8, 0x7c, 0xc1, 0xfb, 0x03, 0x6b, 0x77, 0x8e, 0xec, 0x69, 0x6e, 0xa7, 
  0xee, 0x03, 0x36, 0x9f, 0x5b, 0x66, 0xf9, 0x83, 0xf9, 0x04, 0xbd, 0x99, 
  0x19, 0x11, 0xcc, 0xe3, 0xb2, 0x02, 0x09, 0x34, 0x09, 0x53, 0xd9, 0x1d, 
  0x3f, 0xc3, 0xab, 0xcb, 0xec, 0xa5, 0x2f, 0x34, 0x14, 0x6c, 0xff, 0x90, 
  0xf8, 0x0c, 0x8b, 0x50, 0xdd, 0x3b, 0x1d, 0x5d, 0xd1, 0x91, 0x29, 0xf5, 
  0x98, 0x60, 0xd5, 0x67, 0xe9, 0x35, 0xc9, 0x16, 0xd4, 0x1f, 0x09, 0x77, 
  0x75, 0xd1, 0xab, 0xb9, 0x46, 0x09, 0x49, 0x80, 0x90, 0x5d, 0x68, 0x23, 
  0x93, 0xf9, 0x6c, 0x00, 0x9e, 0xb0, 0x2a, 0x13, 0xbd, 0x3d, 0x4a, 0xbe, 
  0x67, 0x27, 0xd2, 0x16, 0x93, 0x6f, 0x7b, 0x9f, 0x8a, 0x64, 0x41, 0x4b, 
  0xcf, 0x3b, 0xc1, 0xff, 0x4e, 0xe6, 0x71, 0xba, 0x60, 0xfe, 0x55, 0x45, 
  0x76, 0x19, 0x19, 0x4f, 0xa3, 0xff, 0x07, 0xfd, 0x8c, 0xd7, 0x8d, 0x16, 
  0x66, 0x69, 0x51, 0x32, 0x6b, 0xe4, 0x6d, 0x8d, 0xa9, 0x3d, 0x62, 0xf5, 
  0xf4, 0x37, 0xee, 0x07, 0xba, 0x01, 0x26, 0xb7, 0xd8, 0x6e, 0xec, 0x3d, 
  0x89, 0x4b, 0x4b, 0xe2, 0xd5, 0x49, 0xf3, 0x74, 0xcb, 0xe6, 0x95, 0xbc, 
  0xd2, 0x2b, 0x26, 0xa7, 0xe9, 0x6a, 0x82, 0xc6, 0x32, 0x3a, 0xd5, 0xc4, 
  0xbd, 0xe9, 0xca, 0xac, 0x20, 0xef, 0x82, 0x8e, 0x86, 0x44, 0x40, 0xcb, 
  0x51, 0xa3, 0x05, 0x1b, 0x21, 0xce, 0x6e, 0xc0, 0x4c, 0x4a, 0x65, 0xf4, 
  0xb1, 0x71, 0xd5, 0x89, 0xc9, 0xb2, 0xcd, 0x31, 0xd8, 0x02, 0xdb, 0x9a, 
  0x12, 0xe5, 0xde, 0xdf, 0xa4, 0x93, 0x9b, 0x40, 0x6a, 0x21, 0xee, 0x0f, 
  0xa2, 0x1b, 0x0e, 0xc7, 0x71, 0x99, 0x4e, 0x06, 0x8d, 0x16, 0x86, 0xc3, 
  0x69, 0x7a, 0x9d, 0x30, 0x13, 0xa2, 0x5f, 0xb3, 0x6a, 0xbe, 0x18, 0xa8, 
  0x3c, 0x4b, 0x7f, 0x25, 0xd7, 0x39, 0xdd, 0x7e, 0x15, 0x8b, 0xb5, 0xd1, 
  0xf6, 0xe1, 0x74, 0xca, 0x4c, 0x94, 0xc6, 0xd9, 0x68, 0xe1, 0x8f, 0xa3, 
  0xfd, 0xbd, 0xd1, 0xa7, 0x3b, 0x1f, 0xc8, 0xa2, 0xca, 0x84, 0xce, 0x37, 
  0xdd, 0xa8, 0x55, 0xba, 0x48, 0x4a, 0xa1, 0xd2, 0x59, 0x3e, 0x27, 0xd9, 
  0x38, 0x90, 0x99, 0xec, 0x20, 0x4c, 0x88, 0x06, 0x0a, 0x11, 0x33, 0x20, 
  0x1b, 0x67, 0x39, 0xb1, 0x2d, 0x56, 0x0b, 0xf8, 0xb3, 0x80, 0x50, 0xc7, 
  0x74, 0x94, 0x44, 0x44, 0x8f, 0x9e, 0x65, 0x74, 0x11, 0x3e, 0x67, 0xf5, 
  0x68, 0x03, 0x83, 0x3a, 0x8f, 0xcb, 0x52, 0xf6, 0x15, 0x3a, 0x14, 0x08, 
  0x17, 0x7f, 0x82, 0xfd, 0x28, 0xff, 0x89, 0x58, 0x66, 0xf3, 0xb7, 0x98, 
  0x53, 0x09, 0xb8, 0x0b, 0x5e, 0x8c, 0x93, 0x4a, 0xc4, 0x60, 0x10, 0x1b, 
  0xcd, 0x8a, 0xb8, 0x54, 0xd8, 0xe6, 0xb2, 0x48, 0xee, 0xd2, 0x9c, 0xd4, 
  0x96, 0x75, 0x8b, 0x6c, 0x27, 0x09, 0x09, 0x3d, 0xd3, 0xe0, 0xde, 0x96, 
  0xfe, 0x20, 0x6f, 0x44, 0xbd, 0xcb, 0xa4, 0x1a, 0x1e, 0xa1, 0x97, 0xa7, 
  0xbd, 0x86, 0x9c, 0x12, 0x8a, 0xe3, 0xd2, 0x4b, 0x49, 0x5a, 0xd4, 0x1c, 
  0x57, 0x67, 0x64, 0x82, 0x09, 0x89, 0x13, 0x0b, 0x12, 0x14, 0x7a, 0xac, 
  0x98, 0xee, 0x3f, 0xff, 0xf6, 0xf0, 0xf4, 0xcd, 0xf1, 0xfe, 0x9f, 0x1a, 
  0x2d, 0xf0, 0x77, 0x07, 0xf2, 0xdd, 0x41, 0xaf, 0x8b, 0xb7, 0xd0, 0x2a, 
  0xf7, 0x9f, 0xf7, 0x23, 0x11, 0x0b, 0x03, 0xf2, 0x14, 0x8e, 0x42, 0x63, 
  0xc2, 0x7d, 0x45, 0x9f, 0x57, 0x72, 0x39, 0x35, 0x5a, 0xc0, 0xca, 0x89, 
  0x2c, 0xc3, 0x7b, 0x21, 0x2b, 0xcc, 0x67, 0x5b, 0x44, 0xa0, 0x78, 0x1a, 
  0x2c, 0x0f, 0xf1, 0x55, 0xe2, 0x5a, 0xd3, 0xce, 0x75, 0x46, 0x57, 0x22, 
  0xe1, 0x0c, 0x94, 0xa8, 0xc3, 0x19, 0xbb, 0x2b, 0x1d, 0x54, 0xd6, 0xba, 
  0x08, 0xca, 0x12, 0x44, 0x87, 0x2b, 0x97, 0x14, 0x89, 0x98, 0xc4, 0xba, 
  0x11, 0x5d, 0x48, 0xb8, 0x84, 0x98, 0x2a, 0x95, 0x05, 0x81, 0x35, 0xb3, 
  0xfa, 0xd9, 0x3c, 0x58, 0x77, 0x34, 0x33, 0xa1, 0x93, 0x9e, 0x0e, 0x87, 
  0x75, 0x0b, 0xda, 0xad, 0x9e, 0x3b, 0x61, 0x60, 0xa2, 0x42, 0x98, 0x60, 
  0x82, 0xed, 0xbd, 0x26, 0xa1, 0x90, 0x87, 0x48, 0xd2, 0x0f, 0xf7, 0xab, 
  0x4a, 0x24, 0x2b, 0xf3, 0x36, 0xa1, 0x45, 0xbc, 0xe6, 0xc9, 0xb0, 0x24, 
  0x46, 0xbc, 0x70, 0xd6, 0x68, 0x81, 0x8e, 0x70, 0xbf, 0xc0, 0x54, 0x95, 
  0x19, 0x31, 0xc9, 0x61, 0xca, 0x2c, 0x50, 0x8d, 0xd3, 0x4c, 0x8f, 0xbe, 
  0xde, 0x4a, 0x1d, 0x6c, 0x72, 0x78, 0x4a, 0x27, 0x63, 0x9e, 0x1b, 0x8f, 
  0x90, 0xa3, 0xa8, 0xaa, 0x3a, 0xe4, 0x10, 0x25, 0x98, 0xdc, 0x8b, 0x26, 
  0x4d, 0x06, 0xa3, 0x7b, 0x66, 0x83, 0x07, 0xe1, 0xea, 0x3e, 0xd0, 0xc8, 
  0x97, 0xc4, 0x79, 0x33, 0x3b, 0x3b, 0xca, 0x10, 0x9b, 0xa7, 0xb8, 0x40, 
  0xdb, 0xaf, 0x49, 0x29, 0x9b, 0xc4, 0xcb, 0x64, 0x57, 0xaf, 0x66, 0xdb, 
  0xe5, 0x60, 0x18, 0x2d, 0x62, 0x7c, 0x7d, 0x76, 0x75, 0x1c, 0x89, 0xec, 
  0x2b, 0xc7, 0x0b, 0x0f, 0x7b, 0x49, 0x53, 0xf8, 0x5a, 0x70, 0xfa, 0x5b, 
  0x84, 0x00, 0x41, 0x15, 0xa4, 0x02, 0x25, 0x6c, 0xb9, 0x22, 0x41, 0x8c, 
  0xb4, 0x19, 0x9b, 0x8d, 0x6c, 0xe1, 0x18, 0x17, 0x3c, 0x13, 0x62, 0x07, 
  0x77, 0xb3, 0x75, 0x19, 0xb1, 0x0c, 0x81, 0xa7, 0xbc, 0x35, 0xc0, 0x6e, 
  0xac, 0xe1, 0xc4, 0x0d, 0x61, 0xf8, 0xd7, 0x78, 0xd3, 0x7d, 0x5e, 0x80, 
  0x27, 0x4f, 0xb0, 0x74, 0xc4, 0x04, 0x49, 0x69, 0x89, 0xef, 0xe4, 0x7d, 
  0x2c, 0x9f, 0xae, 0x1e, 0x24, 0xce, 0xd6, 0x5d, 0x45, 0xd3, 0x16, 0x2a, 
  0x18, 0xbe, 0xa0, 0xae, 0xa6, 0xab, 0xc5, 0x52, 0x65, 0x87, 0xdf, 0x75, 
  0x1c, 0xe0, 0x5f, 0x24, 0x1d, 0xfc, 0xb3, 0xc2, 0xc1, 0x97, 0x22, 0x1b, 
  0x0e, 0xe3, 0x72, 0x92, 0xa6, 0x8d, 0x16, 0x48, 0xf0, 0x8b, 0x0e, 0x2f, 
  0x8f, 0x4e, 0x4e, 0xbc, 0xa9, 0xe4, 0x9e, 0xe5, 0x70, 0x53, 0x60, 0x54, 
  0x0a, 0xc7, 0xb4, 0x68, 0x59, 0xd8, 0x94, 0xd4, 0x68, 0x21, 0xcd, 0x66, 
  0x39, 0xd1, 0xe9, 0x4b, 0xd8, 0x97, 0xd8, 0x2a, 0x85, 0x29, 0x85, 0xc2, 
  0x54, 0x42, 0x4f, 0x14, 0x13, 0xb1, 0x80, 0xd4, 0x14, 0x6e, 0x63, 0x43, 
  0x19, 0xac, 0x16, 0x20, 0x1e, 0x12, 0x39, 0xc5, 0x20, 0x10, 0xf5, 0xfe, 
  0x54, 0xad, 0x97, 0xc9, 0xf3, 0xc3, 0x9e, 0x8a, 0x07, 0xba, 0x48, 0x93, 
  0x98, 0xa6, 0xd2, 0xa4, 0x1d, 0xe5, 0xb2, 0x2c, 0xbe, 0x82, 0x87, 0x95, 
  0xd5, 0x94, 0x25, 0x9b, 0x0a, 0xdd, 0x33, 0x3b, 0xa4, 0x6b, 0x5e, 0xe4, 
  0x66, 0xd6, 0xe2, 0xe8, 0xfe, 0x7a, 0x74, 0xd0, 0x64, 0x43, 0x6b, 0xba, 
  0xd2, 0x17, 0xe5, 0xaf, 0x28, 0xbd, 0xcb, 0x2a, 0xaf, 0x4a, 0x92, 0xcc, 
  0x43, 0xc1, 0x0d, 0x37, 0x7d, 0xf7, 0xfd, 0x27, 0x52, 0x9b, 0xe9, 0x36, 
  0x4c, 0xc1, 0xa0, 0xbe, 0x2f, 0xf9, 0x8d, 0x86, 0xd4, 0xb6, 0x49, 0x5c, 
  0xe1, 0x01, 0x4e, 0x93, 0x59, 0x4c, 0x3a, 0xa5, 0xca, 0x0a, 0xc2, 0x9a, 
  0x74, 0x3a, 0xb8, 0x19, 0x57, 0xe5, 0x2a, 0x9e, 0xb7, 0xee, 0xbf, 0x25, 
  0x89, 0x5b, 0x15, 0x69, 0x8b, 0x74, 0x76, 0xa2, 0x55, 0xc6, 0xbf, 0x88, 
  0xa0, 0xc2, 0xc3, 0x48, 0xb1, 0xb4, 0xac, 0x46, 0x15, 0x29, 0xeb, 0x22, 
  0x72, 0x4d, 0x34, 0xf9, 0xb2, 0x5e, 0x1b, 0x44, 0xd1, 0xda, 0x1b, 0x36, 
  0x18, 0x16, 0x9f, 0xd8, 0x09, 0x07, 0x55, 0x68, 0xfa, 0x6b, 0x8b, 0x4c, 
  0xf4, 0x96, 0xb2, 0xff, 0xed, 0x72, 0x45, 0x5c, 0x98, 0x58, 0x83, 0x89, 
  0x3e, 0x26, 0x0d, 0x61, 0x5a, 0x26, 0x01, 0x35, 0x5b, 0xa0, 0xab, 0x61, 
  0x67, 0x64, 0x02, 0x11, 0x11, 0xc2, 0x7f, 0x5e, 0x00, 0x1a, 0x4e, 0xd2, 
  0xe5, 0x0d, 0x33, 0x8f, 0x67, 0xf3, 0xb4, 0x04, 0x3b, 0xd7, 0x0f, 0x5a, 
  0x42, 0xd0, 0xe5, 0xe5, 0xa9, 0x29, 0x69, 0x60, 0x80, 0xb8, 0x86, 0xec, 
  0x6d, 0x25, 0x08, 0xbd, 0xea, 0xc5, 0x54, 0xd0, 0xb5, 0x7c, 0x23, 0x5c, 
  0x20, 0xe8, 0x0a, 0xba, 0xaf, 0xbd, 0x1f, 0x2d, 0x56, 0xfc, 0xd1, 0xd8, 
  0xdf, 0x59, 0x77, 0xf1, 0x3c, 0x6d, 0x5d, 0xef, 0xf2, 0xf4, 0x28, 0xba, 
  0xe0, 0x8b, 0x65, 0xb5, 0x64, 0x83, 0x01, 0x5b, 0x60, 0xe5, 0x73, 0x69, 
  0x56, 0x4d, 0x91, 0x11, 0x36, 0xb8, 0xc5, 0xd5, 0xe9, 0x60, 0x3f, 0x0d, 
  0x6d, 0x4a, 0x39, 0xa9, 0xb0, 0x65, 0x39, 0x87, 0x5d, 0x69, 0x9a, 0x4f, 
  0xca, 0x5d, 0x52, 0x6a, 0xcb, 0x5d, 0xeb, 0xa7, 0x66, 0x30, 0xfa, 0xc5, 
  0x7b, 0xf3, 0xa0, 0x0a, 0xe5, 0xa8, 0x15, 0xbc, 0xb2, 0x42, 0x77, 0xe1, 
  0xae, 0xe4, 0x0b, 0x22, 0xe2, 0xb2, 0x6c, 0x49, 0x38, 0xa6, 0x42, 0x5d, 
  0xa8, 0xda, 0x11, 0xf1, 0x75, 0x68, 0xcf, 0x3a, 0x85, 0x43, 0x17, 0x51, 
  0x8c, 0xf8, 0x1d, 0xd7, 0x52, 0x3c, 0xbf, 0xce, 0x0b, 0xe2, 0x6a, 0x8b, 
  0xd2, 0xd9, 0x80, 0x9d, 0xfa, 0x63, 0x52, 0x7c, 0x91, 0x54, 0xab, 0x22, 
  0xeb, 0x92, 0x0d, 0x56, 0x59, 0xd0, 0x25, 0x69, 0x09, 0x93, 0xd5, 0x42, 
  0xac, 0xb8, 0x1b, 0xd6, 0x26, 0x6e, 0x99, 0x58, 0x02, 0xf9, 0xb5, 0x04, 
  0x8b, 0x25, 0x9e, 0xbb, 0xca, 0xbc, 0x35, 0x10, 0x0a, 0x37, 0xd4, 0x69, 
  0x67, 0x0e, 0x6b, 0xc9, 0x48, 0xfc, 0x28, 0x54, 0x26, 0x52, 0xb7, 0x8b, 
  0xd1, 0xc6, 0xcb, 0xec, 0x3d, 0x1b, 0x95, 0xc4, 0x44, 0xc5, 0x38, 0x2d, 
  0xc3, 0x56, 0x0f, 0x74, 0x52, 0xd4, 0xc4, 0x93, 0x5f, 0xb3, 0xd6, 0x9e, 
  0xf2, 0x9d, 0xb7, 0x9b, 0xcf, 0x66, 0xf5, 0x9d, 0x82, 0x59, 0x6c, 0xc8, 
  0xed, 0x31, 0x93, 0x7f, 0x26, 0x0c, 0xb8, 0x75, 0x7e, 0x5e, 0xc5, 0xef, 
  0xd2, 0xc5, 0x6a, 0x81, 0x7e, 0xf9, 0x9c, 0xe8, 0x63, 0xc2, 0x85, 0x98, 
  0x93, 0xc5, 0x7c, 0x92, 0xcd, 0xde, 0xb8, 0xe9, 0xfc, 0x78, 0xad, 0x43, 
  0x97, 0x8f, 0xed, 0x21, 0x74, 0xbe, 0x47, 0xca, 0x63, 0x21, 0xb5, 0xcc, 
  0xd3, 0x05, 0x9b, 0x39, 0xda, 0x1b, 0xe7, 0xed, 0x87, 0xd1, 0xf2, 0x26, 
  0x2e, 0xe9, 0xc6, 0xc0, 0x9d, 0x6e, 0x9a, 0xf8, 0x0d, 0x0b, 0xe0, 0xfa, 
  0x4c, 0x32, 0xed, 0x14, 0x8f, 0x43, 0x46, 0x9d, 0x43, 0xe0, 0x87, 0x78, 
  0x40, 0x2b, 0x2b, 0x7e, 0x01, 0xdc, 0xb1, 0x10, 0x6c, 0x86, 0x8b, 0xf8, 
  0x1d, 0x16, 0xa5, 0xb3, 0x85, 0xd1, 0xaf, 0x74, 0xac, 0xc6, 0x49, 0x53, 
  0xda, 0xa8, 0x0b, 0x58, 0xd1, 0x33, 0x88, 0x0e, 0xac, 0x5e, 0x34, 0x37, 
  0xc8, 0xec, 0x4f, 0x58, 0x61, 0x15, 0xd4, 0xf1, 0x30, 0x6f, 0xce, 0x7d, 
  0x4c, 0x57, 0x83, 0x5d, 0x7d, 0x6c, 0x9c, 0xe3, 0xa9, 0xce, 0x3b, 0xb5, 
  0x0f, 0x22, 0xe6, 0x59, 0x05, 0x37, 0x1e, 0x9f, 0x12, 0xd2, 0x85, 0x78, 
  0x29, 0x89, 0xcf, 0x14, 0xb1, 0x8a, 0xd0, 0x20, 0x69, 0x69, 0xa4, 0xb9, 
  0xbc, 0x70, 0xc2, 0x58, 0x33, 0xa1, 0xb6, 0x03, 0x49, 0x1a, 0x12, 0x74, 
  0x1c, 0x48, 0xb1, 0x1d, 0x52, 0x37, 0x6f, 0xe1, 0x7d, 0xc2, 0xcd, 0x40, 
  0x9b, 0xaa, 0xb5, 0xe7, 0x74, 0x48, 0x69, 0xc9, 0x6c, 0x21, 0x2d, 0x0d, 
  0x88, 0x09, 0x6b, 0xbb, 0xa4, 0x8b, 0x4a, 0x54, 0x3a, 0x37, 0x2d, 0xda, 
  0xe8, 0xdb, 0x2c, 0xbf, 0xcf, 0x06, 0xfc, 0x29, 0x96, 0xa6, 0xdb, 0xf4, 
  0xc8, 0x53, 0xab, 0x12, 0xd3, 0x16, 0xe4, 0xc9, 0x40, 0x60, 0xd6, 0xaf, 
  0x1d, 0xa7, 0xef, 0x20, 0x54, 0x13, 0xf9, 0x9d, 0x46, 0xa7, 0x8d, 0xa8, 
  0xb4, 0xcf, 0x03, 0xe3, 0x5d, 0xe1, 0xcb, 0x7c, 0x83, 0xf6, 0x01, 0x05, 
  0x52, 0xdc, 0x9b, 0x62, 0x72, 0x9b, 0xc6, 0xe5, 0xcd, 0x20, 0xea, 0x0d, 
  0x7b, 0x03, 0x67, 0xd4, 0xd7, 0x65, 0xb1, 0x91, 0x75, 0xcf, 0x02, 0x96, 
  0x47, 0xc8, 0x6f, 0x1b, 0x94, 0x0c, 0x35, 0xce, 0xea, 0x40, 0x99, 0xc6, 
  0x48, 0xd8, 0xec, 0xc3, 0x42, 0xad, 0x36, 0x58, 0x96, 0x54, 0xb5, 0xb5, 
  0x96, 0x8e, 0x24, 0x34, 0x7d, 0x7f, 0x93, 0xb3, 0xad, 0x1b, 0xce, 0x4b, 
  0xa3, 0x14, 0x1a, 0x41, 0xce, 0xed, 0x88, 0xed, 0x12, 0xfe, 0x24, 0x96, 
  0xfd, 0xbb, 0xf9, 0xa0, 0x63, 0x84, 0xd1, 0x64, 0x9e, 0xc4, 0xc5, 0x7c, 
  0x6d, 0x2a, 0xeb, 0xf0, 0x4e, 0xe6, 0xc7, 0x96, 0xe7, 0x98, 0xc8, 0xb8, 
  0x68, 0x19, 0x82, 0xf8, 0x29, 0x12, 0x0a, 0x49, 0x1f, 0x5b, 0x27, 0xd3, 
  0x41, 0x34, 0x66, 0x41, 0x95, 0x79, 0x92, 0x8a, 0x6b, 0xe0, 0x28, 0xd1, 
  0x5d, 0x5a, 0xa6, 0x63, 0xec, 0x40, 0x92, 0x4c, 0x9b, 0x2d, 0x8c, 0xe3, 
  0xc9, 0xad, 0x48, 0x63, 0xe8, 0x65, 0x0c, 0x59, 0xf7, 0x06, 0xae, 0xc6, 
  0x92, 0x5f, 0x5b, 0xb3, 0x45, 0xe0, 0x86, 0x4e, 0x71, 0x99, 0x56, 0xab, 
  0x4e, 0xf9, 0xb0, 0x7d, 0xfa, 0x55, 0x4b, 0xb7, 0xf3, 0x6f, 0x0c, 0x40, 
  0xb6, 0x8e, 0x59, 0x40, 0x93, 0x6a, 0xe9, 0x50, 0xb8, 0x33, 0x21, 0xbb, 
  0xbf, 0x81, 0x21, 0x1c, 0x81, 0x21, 0x90, 0x80, 0x97, 0xad, 0x48, 0x07, 
  0x21, 0x86, 0x4d, 0x0c, 0x9d, 0x08, 0xa9, 0xc9, 0x0e, 0x8e, 0xf4, 0x91, 
  0xdd, 0x0b, 0x73, 0xd5, 0xfa, 0x03, 0x69, 0xe4, 0xe8, 0x5d, 0xf6, 0x55, 
  0x07, 0x11, 0x5f, 0xa7, 0xac, 0xaa, 0x49, 0xeb, 0x22, 0xf7, 0x84, 0x9f, 
  0xd8, 0xfa, 0x26, 0xef, 0x62, 0x0e, 0x6d, 0xc8, 0x56, 0x8b, 0x71, 0xdb, 
  0x9e, 0x4b, 0x97, 0xd8, 0x78, 0xcd, 0xe6, 0x04, 0x55, 0x65, 0x03, 0xad, 
  0xf3, 0x36, 0x5d, 0x2e, 0x13, 0xd6, 0xae, 0x57, 0x59, 0x15, 0x98, 0x85, 
  0x9a, 0x5b, 0x93, 0x5c, 0xa7, 0x59, 0x16, 0xba, 0xdf, 0xf2, 0x15, 0xe9, 
  0x3e, 0x32, 0xfe, 0x71, 0x32, 0x63, 0xe6, 0x0d, 0xe3, 0x27, 0x2f, 0x39, 
  0xa6, 0xd3, 0xdc, 0xdc, 0x19, 0x9c, 0xc5, 0xde, 0xd8, 0x35, 0x85, 0x3b, 
  0xcf, 0x78, 0xd9, 0xc9, 0x4c, 0x36, 0x0a, 0x2a, 0x92, 0xf8, 0x46, 0xca, 
  0x41, 0x97, 0x1e, 0x5c, 0x2d, 0xed, 0xc6, 0x32, 0x8f, 0xce, 0xe5, 0xc9, 
  0xff, 0x3a, 0xd6, 0x09, 0xb1, 0x43, 0x27, 0xf4, 0xe8, 0xac, 0x3b, 0xfc, 
  0x29, 0xad, 0xd3, 0xc7, 0xaa, 0x22, 0x9d, 0xe7, 0x23, 0xda, 0xd2, 0x1e, 
  0xae, 0x41, 0xe6, 0x7a, 0xce, 0xf3, 0xb2, 0xaa, 0x72, 0xe2, 0x14, 0xec, 
  0xef, 0x9c, 0xaf, 0xc5, 0xab, 0x4c, 0x54, 0xd9, 0x3c, 0xe1, 0x24, 0x75, 
  0x25, 0xbb, 0x37, 0x7c, 0xeb, 0xe6, 0xe6, 0x91, 0x87, 0xa3, 0x46, 0xb7, 
  0x75, 0xc4, 0xd6, 0x3a, 0x56, 0x06, 0x78, 0x5c, 0x65, 0xb4, 0x79, 0x8b, 
  0x57, 0xd5, 0x72, 0x55, 0xed, 0xc2, 0x48, 0xa0, 0x3e, 0xad, 0x2a, 0x37, 
  0x9b, 0x36, 0x36, 0xae, 0x8b, 0x7b, 0x74, 0xa8, 0xdb, 0x0f, 0x5e, 0x79, 
  0xef, 0xbb, 0xf1, 0xbc, 0x44, 0x02, 0xae, 0x43, 0xea, 0x48, 0xcb, 0xa0, 
  0xf2, 0x9d, 0xce, 0x05, 0xba, 0x07, 0x9d, 0x81, 0xbf, 0x92, 0x24, 0x87, 
  0xbe, 0xbd, 0x6f, 0x21, 0xb7, 0x1b, 0x7a, 0xd0, 0x69, 0x9a, 0x42, 0x97, 
  0xd2, 0x01, 0x9e, 0x27, 0x51, 0x81, 0xc4, 0xc0, 0xb8, 0xa0, 0x23, 0x9e, 
  0xd3, 0x5a, 0x13, 0x23, 0xa1, 0x4b, 0xa6, 0xca, 0xe9, 0xef, 0x9b, 0x94, 
  0x66, 0x51, 0x4c, 0x6e, 0xd6, 0xed, 0x0b, 0x2a, 0x23, 0x1e, 0x52, 0x77, 
  0x17, 0x4c, 0x8a, 0xf9, 0x4c, 0xfd, 0x6e, 0x74, 0xee, 0x68, 0xfe, 0x55, 
  0x74, 0xfa, 0x92, 0x17, 0xf1, 0xe8, 0x82, 0x7e, 0xd2, 0x60, 0x85, 0xb4, 
  0x98, 0xa9, 0x21, 0x8c, 0x83, 0xd5, 0xe6, 0xe8, 0xd5, 0xb7, 0x97, 0x4d, 
  0xe1, 0xf8, 0xec, 0x72, 0xf7, 0xd1, 0x93, 0xbd, 0x9d, 0x7f, 0x5e, 0x6d, 
  0x16, 0xc7, 0x2b, 0x3b, 0xb3, 0x36, 0xa8, 0xcd, 0x18, 0xe9, 0x44, 0xc6, 
  0x48, 0xc7, 0x2a, 0x98, 0xc4, 0x94, 0xcd, 0x2b, 0xac, 0xf8, 0x3f, 0x7b, 
  0xc0, 0x86, 0x7c, 0x99, 0x88, 0xcc, 0x17, 0xda, 0xa2, 0xf0, 0x92, 0x98, 
  0x71, 0xcf, 0xcf, 0x2e, 0xaf, 0x22, 0x73, 0x29, 0xb4, 0xed, 0x69, 0xce, 
  0xe2, 0x63, 0x21, 0x3b, 0x78, 0xeb, 0x3e, 0x5e, 0x0b, 0x95, 0xb1, 0x91, 
  0x23, 0x59, 0xac, 0x38, 0x72, 0x03, 0x46, 0xab, 0xa6, 0xe4, 0x1f, 0x4b, 
  0x70, 0x0b, 0x8b, 0x79, 0x44, 0xa5, 0x73, 0x73, 0x56, 0x7f, 0x7d, 0xf5, 
  0xea, 0x14, 0x37, 0xab, 0x0a, 0xfe, 0x4e, 0xb2, 0xef, 0x70, 0x72, 0xad, 
  0xc6, 0x0b, 0xe6, 0x16, 0x74, 0x49, 0x54, 0x38, 0xff, 0xaf, 0xf3, 0x4a, 
  0x49, 0x1c, 0xaa, 0x3d, 0x66, 0x52, 0x8a, 0xe5, 0x03, 0x8c, 0x6d, 0xde, 
  0xb1, 0xfd, 0x0d, 0x2b, 0x5c, 0xc6, 0x0e, 0x36, 0xb8, 0x3d, 0x38, 0x36, 
  0x84, 0xc9, 0x09, 0x52, 0x81, 0xc4, 0x22, 0x74, 0x48, 0x59, 0x59, 0x72, 
  0x2f, 0xf6, 0x5d, 0xa2, 0x4f, 0x68, 0x91, 0xb3, 0x9d, 0x51, 0xdd, 0xbc, 
  0x4d, 0x23, 0x48, 0xde, 0x2d, 0x45, 0x88, 0x85, 0xcd, 0xa5, 0xd1, 0x42, 
  0x8f, 0xe8, 0x7a, 0x28, 0x3e, 0xbd, 0xa9, 0x99, 0x73, 0x84, 0xb0, 0x63, 
  0x58, 0x9b, 0xbd, 0x5f, 0x6a, 0xc9, 0x26, 0xff, 0x8e, 0x75, 0x70, 0x0e, 
  0x80, 0x40, 0x12, 0x5f, 0xa9, 0x89, 0x18, 0xea, 0x2f, 0x5d, 0xf5, 0xa4, 
  0x12, 0xac, 0x97, 0xf0, 0x92, 0xce, 0x37, 0xd8, 0x12, 0x76, 0xdf, 0x0d, 
  0x49, 0x07, 0x1d, 0xf2, 0xd2, 0x0f, 0xa9, 0x4b, 0x1d, 0xd1, 0x88, 0x8e, 
  0xc0, 0x62, 0xc9, 0xc2, 0x16, 0xb5, 0x3f, 0x7c, 0x39, 0x72, 0x8c, 0xe2, 
  0x01, 0x51, 0x1c, 0xd4, 0x5c, 0x37, 0xd4, 0x89, 0x02, 0xac, 0xee, 0x7d, 
  0xe5, 0xb9, 0x8d, 0x16, 0xc4, 0x22, 0xef, 0x36, 0x2e, 0x5a, 0xa6, 0x7c, 
  0x9a, 0xa3, 0x60, 0x83, 0x82, 0x0b, 0x67, 0x91, 0x14, 0xd7, 0x2d, 0x6d, 
  0x94, 0x14, 0xa3, 0x84, 0x75, 0x57, 0x33, 0x24, 0xc7, 0xce, 0x0b, 0xcf, 
  0x6b, 0xf1, 0xfb, 0xa1, 0x78, 0x02, 0x78, 0x89, 0x57, 0xe5, 0xa0, 0xd3, 
  0xd8, 0xd6, 0x1f, 0x4e, 0x23, 0x75, 0xbc, 0x64, 0x69, 0x32, 0xa7, 0x63, 
  0xc4, 0x57, 0xdb, 0x7c, 0xfe, 0x7c, 0x4e, 0xf7, 0xec, 0xba, 0xcf, 0x42, 
  0x10, 0x0c, 0xf7, 0xd7, 0x49, 0xc6, 0x72, 0x51, 0xd2, 0xf6, 0xad, 0x70, 
  0x20, 0x96, 0xbb, 0x28, 0x6e, 0x56, 0xd9, 0xad, 0xbb, 0x76, 0x62, 0xfb, 
  0x7c, 0x4e, 0xb2, 0x59, 0xe9, 0x26, 0x7d, 0xdb, 0xdc, 0xcd, 0x7e, 0x30, 
  0x80, 0xdf, 0x87, 0xbd, 0x77, 0xf1, 0x11, 0xc8, 0x9d, 0x15, 0x07, 0x0b, 
  0xb9, 0x85, 0x73, 0xdc, 0x53, 0x1d, 0x1f, 0x5f, 0x0c, 0xbc, 0xff, 0xaf, 
  0x25, 0xa7, 0x04, 0x8e, 0x88, 0x38, 0x10, 0x56, 0xcc, 0x5a, 0xee, 0x1a, 
  0x15, 0xef, 0x05, 0xf1, 0xb9, 0x96, 0xbc, 0x36, 0x6b, 0x6b, 0x24, 0xed, 
  0x57, 0x59, 0x66, 0x4d, 0x33, 0x3d, 0x18, 0x6d, 0x35, 0x90, 0xe9, 0x53, 
  0x54, 0x38, 0x1f, 0x59, 0x00, 0x13, 0x4c, 0x3c, 0xe7, 0xb6, 0xe0, 0x5b, 
  0x08, 0x4e, 0x49, 0x53, 0x5e, 0x7b, 0x65, 0x41, 0x21, 0x72, 0xdb, 0xd5, 
  0x5c, 0xd5, 0x46, 0x3c, 0xa3, 0xe8, 0x3c, 0x97, 0xc8, 0x1f, 0x8c, 0xaa, 
  0x29, 0x56, 0x40, 0x03, 0x09, 0x56, 0x60, 0x1a, 0xf5, 0x67, 0x79, 0x3e, 
  0x8e, 0x8b, 0xbe, 0x6e, 0x39, 0x7c, 0xa3, 0xe3, 0x44, 0x9c, 0xb0, 0xbc, 
  0xc4, 0x6d, 0xf7, 0x23, 0x4f, 0xf6, 0x0b, 0x79, 0xab, 0xed, 0x8f, 0xba, 
  0xca, 0x85, 0x34, 0xf0, 0xd4, 0x92, 0xae, 0x62, 0x12, 0x04, 0xd8, 0xf3, 
  0x51, 0xac, 0x07, 0xb2, 0x89, 0xb2, 0x13, 0xe6, 0x3c, 0xe5, 0x33, 0xd4, 
  0x21, 0xb8, 0x48, 0x2f, 0x43, 0x79, 0x71, 0x93, 0xf2, 0xea, 0x79, 0xbf, 
  0x0a, 0x75, 0x38, 0x74, 0x30, 0x0e, 0xe2, 0x6d, 0x58, 0xba, 0xff, 0x05, 
  0x95, 0x37, 0x87, 0x3b, 0x2b, 0x88, 0x71, 0x72, 0x74, 0x7d, 0x6f, 0x3c, 
  0x47, 0x9c, 0xd2, 0x72, 0x7d, 0x49, 0x5c, 0x06, 0xf7, 0x1c, 0xde, 0xb1, 
  0x7e, 0x24, 0x0f, 0xde, 0x50, 0x66, 0xaa, 0xc5, 0x96, 0xa6, 0xb1, 0x04, 
  0x1a, 0x61, 0x25, 0xdc, 0x24, 0xff, 0x65, 0x15, 0xfe, 0xdf, 0x37, 0x1f, 
  0xdd, 0x97, 0x87, 0x26, 0xa4, 0xe1, 0x14, 0x4c, 0x0b, 0xa5, 0xbb, 0x21, 
  0x32, 0xe1, 0x55, 0xe9, 0x22, 0x9d, 0x93, 0xc2, 0xa6, 0x31, 0x5a, 0x71, 
  0xd9, 0x49, 0x62, 0xba, 0x68, 0x1c, 0x78, 0x33, 0xa0, 0x35, 0xe1, 0x10, 
  0xd4, 0xeb, 0x1b, 0x71, 0x4b, 0xac, 0xbc, 0x5b, 0x50, 0xa7, 0xdd, 0x41, 
  0x42, 0x11, 0x5b, 0x93, 0x8b, 0x44, 0xcf, 0xdd, 0x3b, 0xe7, 0x33, 0xe3, 
  0x11, 0xb9, 0xeb, 0xbf, 0x8c, 0x6e, 0x93, 0x25, 0x1d, 0xbf, 0x96, 0xfc, 
  0x9d, 0x96, 0x4e, 0xdd, 0xc5, 0x91, 0xaf, 0x94, 0xac, 0x63, 0x25, 0x66, 
  0xa7, 0x5e, 0x4b, 0x68, 0xec, 0x86, 0xc8, 0x94, 0xe5, 0xd0, 0x5f, 0x9b, 
  0x1a, 0x3a, 0x6a, 0xc3, 0xa8, 0x4d, 0x52, 0x65, 0xbf, 0xd6, 0x2c, 0x84, 
  0x26, 0x66, 0xe2, 0x89, 0xfa, 0x8f, 0xef, 0x3c, 0x0c, 0xed, 0x1b, 0x76, 
  0xfb, 0x38, 0x63, 0x39, 0xad, 0x14, 0x39, 0xe9, 0x85, 0x9a, 0xe4, 0xeb, 
  0xce, 0x09, 0xa3, 0xf1, 0x96, 0x78, 0x54, 0x7f, 0x4e, 0x6e, 0x10, 0xd6, 
  0xf9, 0x84, 0x59, 0x62, 0x2f, 0x59, 0x22, 0xb8, 0x87, 0x77, 0x96, 0x39, 
  0x58, 0x4b, 0xdb, 0xe2, 0x49, 0x40, 0xfa, 0xc9, 0x61, 0x9c, 0x63, 0xd5, 
  0x9e, 0xb7, 0x9e, 0xc5, 0x6d, 0xd6, 0xcb, 0xe1, 0xf9, 0x81, 0x14, 0xab, 
  0x6b, 0x9a, 0xb5, 0x58, 0xb3, 0xf7, 0xce, 0xba, 0x6b, 0x25, 0x63, 0xab, 
  0x07, 0x5d, 0x8d, 0x2b, 0x0d, 0xaa, 0x72, 0x0e, 0x0c, 0x8e, 0x89, 0x6a, 
  0xae, 0x83, 0xc4, 0x2f, 0xe3, 0x4e, 0x61, 0x69, 0xce, 0xc6, 0x1b, 0x98, 
  0xe7, 0xbc, 0xc7, 0x62, 0xa3, 0x93, 0x42, 0x9d, 0x18, 0x1a, 0xc5, 0x83, 
  0x7d, 0x77, 0x11, 0xc1, 0x1a, 0x81, 0x3e, 0xf2, 0x81, 0x1d, 0xed, 0x59, 
  0xf0, 0xb5, 0xf4, 0x7f, 0x81, 0x6f, 0x43, 0x85, 0xf6, 0x61, 0xb2, 0x2c, 
  0xaa, 0xce, 0x20, 0xbf, 0xab, 0x50, 0x67, 0x34, 0x11, 0x9f, 0xfb, 0x66, 
  0x39, 0x50, 0xcf, 0xc7, 0xf1, 0xf9, 0xc5, 0x55, 0xd4, 0x61, 0xc3, 0x3e, 
  0xe5, 0xcf, 0x55, 0xb0, 0x2a, 0x85, 0x1d, 0x68, 0x4c, 0x10, 0xe9, 0x54, 
  0x77, 0x09, 0xfc, 0x94, 0x2e, 0x14, 0x73, 0x04, 0xab, 0x5f, 0x97, 0x32, 
  0x25, 0x9b, 0x4b, 0x77, 0x53, 0x3c, 0x27, 0x41, 0xbe, 0x54, 0xf2, 0x77, 
  0xc1, 0x9f, 0x3e, 0x06, 0x82, 0xc7, 0xd1, 0xa1, 0x5a, 0x67, 0x3a, 0x12, 
  0x55, 0xe6, 0x85, 0x23, 0x9d, 0x9f, 0xd1, 0xb3, 0x30, 0xe5, 0x28, 0x11, 
  0xb9, 0x05, 0x6f, 0xb6, 0x60, 0xf1, 0x83, 0xdc, 0x05, 0xbf, 0x15, 0x15, 
  0xe9, 0xf5, 0x0d, 0xf7, 0x4f, 0x83, 0x19, 0x45, 0x7e, 0xf2, 0xda, 0x0b, 
  0x1b, 0x01, 0x1b, 0x2d, 0x10, 0x45, 0x27, 0x59, 0x89, 0x98, 0x54, 0x6f, 
  0x25, 0xc8, 0xa9, 0x19, 0xa2, 0xe3, 0x39, 0x56, 0xc1, 0x42, 0xbe, 0x07, 
  0x88, 0x5a, 0x68, 0x07, 0xdf, 0x21, 0xd6, 0x89, 0x63, 0x3f, 0x11, 0xf0, 
  0xce, 0xc2, 0x74, 0x89, 0xb1, 0x27, 0x38, 0xca, 0x12, 0x1f, 0x4f, 0xe7, 
  0x4d, 0x95, 0x55, 0xba, 0x95, 0xaa, 0x75, 0xcb, 0x86, 0xc5, 0xc7, 0x77, 
  0x2c, 0xe2, 0x97, 0xea, 0x43, 0x99, 0xe9, 0xf2, 0xd3, 0x54, 0x5e, 0x93, 
  0xf9, 0xe9, 0x8e, 0x35, 0x25, 0x1a, 0xa2, 0xe5, 0xc0, 0x25, 0xf7, 0xc9, 
  0x3f, 0x49, 0xb6, 0xe2, 0x4e, 0xf8, 0x50, 0x7f, 0x82, 0x34, 0xd8, 0xf2, 
  0x28, 0x78, 0xaa, 0x2d, 0xef, 0xfe, 0x05, 0xaa, 0xbd, 0xfc, 0x96, 0xe7, 
  0x3a, 0x6c, 0x05, 0x19, 0xb2, 0x96, 0xeb, 0x89, 0x95, 0xf9, 0x83, 0x51, 
  0x6b, 0x48, 0xae, 0x66, 0xa5, 0x6e, 0x7b, 0x5e, 0x1c, 0xc1, 0x1a, 0xc5, 
  0x36, 0x49, 0x56, 0x7d, 0x81, 0x18, 0x81, 0x50, 0x65, 0xa3, 0x85, 0xf3, 
  0xc3, 0xcb, 0x6f, 0x37, 0x50, 0xa7, 0xa3, 0x47, 0x98, 0x84, 0x2a, 0xba, 
  0xde, 0x3a, 0xb5, 0x06, 0x6e, 0xfb, 0x37, 0x71, 0xf9, 0x74, 0x6f, 0x51, 
  0x23, 0x92, 0x42, 0x9c, 0x0a, 0x4d, 0xf1, 0xe3, 0x3b, 0x78, 0x09, 0x70, 
  0xd1, 0x5b, 0xca, 0x43, 0x10, 0xa8, 0x51, 0x37, 0x01, 0x20, 0x4c, 0x64, 
  0xab, 0xcb, 0x69, 0xee, 0xa7, 0x22, 0xa1, 0x3e, 0xba, 0xb8, 0xd8, 0xc1, 
  0x50, 0x26, 0x90, 0x00, 0x93, 0x2e, 0xe9, 0xc3, 0x75, 0xca, 0xb7, 0x59, 
  0xac, 0xf6, 0x03, 0x1e, 0x9a, 0x78, 0xde, 0xe8, 0x5d, 0xbe, 0xd2, 0x23, 
  0x09, 0x1e, 0x2b, 0xbb, 0xc4, 0x74, 0x6e, 0xc6, 0x5a, 0x99, 0xa8, 0x6c, 
  0x4e, 0xdd, 0x8f, 0xa1, 0xe1, 0xc4, 0x53, 0x2f, 0x4e, 0xc1, 0x86, 0xd2, 
  0x75, 0x17, 0x68, 0x18, 0x76, 0x84, 0xc4, 0x0b, 0xaf, 0x28, 0x87, 0x01, 
  0x38, 0x32, 0xd1, 0xdf, 0x75, 0xa8, 0x2b, 0x4d, 0x17, 0x4e, 0xb0, 0x24, 
  0xf9, 0x3d, 0x6f, 0xad, 0x3f, 0xfa, 0x38, 0xfb, 0x34, 0xa5, 0x96, 0x04, 
  0x14, 0x04, 0xdf, 0xb4, 0xd6, 0xd9, 0x5b, 0xc5, 0xf2, 0xcc, 0x42, 0x46, 
  0x6a, 0x16, 0x4b, 0xe7, 0x55, 0x15, 0x01, 0xaa, 0xcd, 0x02, 0x69, 0xda, 
  0x65, 0x3a, 0x15, 0x43, 0xa9, 0xc8, 0x00, 0x51, 0x4f, 0x17, 0xac, 0xe7, 
  0xe2, 0x1c, 0xd8, 0x6c, 0xcc, 0x5a, 0x3d, 0x82, 0x77, 0x3a, 0x1c, 0xa2, 
  0x45, 0xf2, 0xab, 0x9b, 0x08, 0x1d, 0x01, 0x27, 0xb4, 0xa2, 0x45, 0xc2, 
  0x37, 0x26, 0x11, 0xef, 0x9b, 0x8b, 0xd3, 0xf7, 0x5a, 0xab, 0x7a, 0x17, 
  0xfa, 0xf4, 0x79, 0x7c, 0x9d, 0xf4, 0x10, 0x64, 0xc3, 0x9e, 0x18, 0x95, 
  0x42, 0x36, 0x85, 0x64, 0x47, 0x2e, 0x28, 0x3b, 0x88, 0x69, 0x16, 0x21, 
  0x44, 0x8c, 0xd8, 0x49, 0x65, 0x96, 0x83, 0x8e, 0x08, 0x34, 0x1f, 0xe6, 
  0x4c, 0x74, 0x38, 0x8f, 0xaf, 0x35, 0x62, 0x40, 0x22, 0x9b, 0x6d, 0xdf, 
  0xcc, 0x66, 0xdc, 0xa9, 0x21, 0xd6, 0x62, 0xd8, 0xd6, 0x9a, 0xf0, 0xa1, 
  0x42, 0x65, 0xef, 0x4f, 0x6c, 0x23, 0xee, 0xd9, 0x59, 0xd4, 0xd5, 0x68, 
  0x87, 0x0b, 0xf0, 0x03, 0x90, 0x32, 0x40, 0xc8, 0x75, 0xbb, 0xb2, 0xf9, 
  0x9f, 0x9c, 0x5f, 0x20, 0xc8, 0x7e, 0xf2, 0x36, 0xe6, 0x4c, 0x2c, 0xec, 
  0x22, 0xce, 0x48, 0x88, 0xe3, 0xa9, 0x0e, 0xea, 0xa9, 0x9e, 0x2b, 0x71, 
  0x0f, 0xe8, 0x90, 0x3a, 0x03, 0xcb, 0x31, 0x74, 0xdd, 0x48, 0x5a, 0x41, 
  0x4e, 0x3c, 0x92, 0x50, 0x30, 0x35, 0x07, 0x4c, 0xe1, 0x2b, 0xc2, 0x82, 
  0xc6, 0x59, 0xeb, 0x76, 0x4c, 0x91, 0x8a, 0xa2, 0x73, 0xfc, 0xed, 0x2c, 
  0xd1, 0x49, 0x76, 0x97, 0x16, 0x79, 0xc6, 0xd1, 0x01, 0x4d, 0x02, 0xbb, 
  0x38, 0xb9, 0x3c, 0x8a, 0xce, 0x2e, 0xa3, 0xb3, 0xd7, 0xa7, 0x3f, 0x30, 
  0xa1, 0x21, 0x0a, 0x87, 0xae, 0x9f, 0xeb, 0x44, 0xb6, 0x39, 0x78, 0x95, 
  0x63, 0x41, 0x8a, 0xb6, 0x94, 0xca, 0x52, 0xfe, 0x20, 0x08, 0x71, 0x14, 
  0x33, 0x82, 0x90, 0xeb, 0xf0, 0xde, 0xe6, 0xe2, 0xa3, 0x1a, 0x5a, 0x5c, 
  0x21, 0x89, 0xcb, 0x34, 0x29, 0xd4, 0xef, 0x0e, 0x0b, 0xe4, 0xc4, 0xc2, 
  0xe7, 0x35, 0x5b, 0x30, 0x24, 0x73, 0x38, 0x75, 0x9b, 0x71, 0xdc, 0xf1, 
  0x1d, 0x77, 0x5e, 0xac, 0xb2, 0x6e, 0x17, 0xc5, 0x6f, 0x77, 0x23, 0x0d, 
  0x93, 0xeb, 0xe9, 0x10, 0x9a, 0x60, 0xe7, 0x5d, 0x84, 0xf3, 0x7c, 0x59, 
  0xcf, 0xb1, 0x58, 0xc6, 0x6c, 0x7c, 0x55, 0xdb, 0x13, 0x44, 0x86, 0xac, 
  0x2a, 0xf2, 0x25, 0xf1, 0xcf, 0xaf, 0xe8, 0x9b, 0xe6, 0x40, 0x12, 0x10, 
  0xe1, 0x8b, 0x38, 0x59, 0xf0, 0xa2, 0xe6, 0x93, 0x5b, 0xf3, 0x69, 0xc9, 
  0xef, 0xde, 0xa4, 0xce, 0x3a, 0x49, 0x32, 0xed, 0x0a, 0xbc, 0x27, 0x3e, 
  0x48, 0x97, 0x49, 0x92, 0x5d, 0x73, 0x2a, 0x0f, 0xab, 0x14, 0x1c, 0xba, 
  0x13, 0xe6, 0x34, 0xd1, 0xa1, 0x66, 0x25, 0x45, 0x19, 0x44, 0x07, 0x47, 
  0x18, 0x4a, 0x1b, 0x32, 0xd1, 0xa6, 0x15, 0x62, 0x78, 0xcc, 0xd7, 0x04, 
  0xbb, 0x0e, 0x9e, 0xf1, 0xbf, 0x1c, 0xfb, 0x4e, 0x0a, 0xcb, 0x8f, 0x4f, 
  0x4d, 0x03, 0xfa, 0x69, 0xd3, 0xa2, 0xb4, 0xe3, 0xda, 0xea, 0x97, 0x73, 
  0xd0, 0x5a, 0x57, 0x74, 0x65, 0x3d, 0x3e, 0xd1, 0xfc, 0xe2, 0xb4, 0xb6, 
  0x68, 0xde, 0x65, 0xb7, 0x4a, 0x23, 0xcd, 0x65, 0x9d, 0xc0, 0xa4, 0x09, 
  0xcb, 0x9b, 0x84, 0x06, 0x9e, 0x1f, 0xbf, 0x72, 0x5e, 0x6e, 0x73, 0x2d, 
  0xcb, 0x4c, 0x89, 0x5c, 0x78, 0x2a, 0xc3, 0xb6, 0xf0, 0xcc, 0x39, 0xb3, 
  0x38, 0xfd, 0x36, 0xe4, 0x30, 0x2d, 0x28, 0xfa, 0xdb, 0x8a, 0xd3, 0x0b, 
  0xa7, 0x58, 0xf1, 0xbc, 0x2b, 0x73, 0x85, 0xe8, 0x7a, 0xc1, 0xb2, 0xfa, 
  0xa8, 0x66, 0xcd, 0xe7, 0xa0, 0x49, 0x3f, 0x71, 0x33, 0x6c, 0x2d, 0x8b, 
  0xf4, 0xae, 0xbd, 0x0e, 0xb7, 0xc9, 0x1a, 0xb7, 0x5c, 0xf0, 0x44, 0xed, 
  0x65, 0xda, 0x63, 0xfe, 0x99, 0xb1, 0x02, 0xf9, 0xbb, 0xdf, 0x2c, 0xf2, 
  0x63, 0x38, 0x89, 0x85, 0x1c, 0x8e, 0x0e, 0xc3, 0xd1, 0xfc, 0x4a, 0x64, 
  0x40, 0xef, 0xd0, 0x80, 0xdd, 0xe1, 0x4a, 0x8c, 0xa9, 0x8b, 0x69, 0x95, 
  0xc4, 0x12, 0xb6, 0xfe, 0x20, 0xe4, 0x79, 0xb1, 0x9a, 0xb7, 0xbd, 0x01, 
  0xc8, 0xe2, 0xa3, 0x81, 0x86, 0xdd, 0x94, 0xd2, 0x42, 0xf0, 0xc9, 0x76, 
  0xb9, 0x63, 0xc4, 0xd2, 0xd6, 0x80, 0x02, 0xd2, 0xd9, 0xea, 0x14, 0xc2, 
  0x38, 0xae, 0xfc, 0x3a, 0x4b, 0x7f, 0x4e, 0x4a, 0x67, 0x98, 0x6a, 0x30, 
  0x59, 0xd1, 0xb7, 0x60, 0x8e, 0x6d, 0xda, 0xc8, 0x8f, 0xe8, 0x6e, 0x7b, 
  0x7b, 0x74, 0xf8, 0xf6, 0xcb, 0x37, 0xaf, 0x5f, 0x9c, 0x1e, 0xf7, 0x25, 
  0x40, 0x5e, 0xc2, 0x04, 0xe8, 0xd6, 0x71, 0x79, 0x38, 0x42, 0x26, 0xf0, 
  0x8b, 0x36, 0xed, 0xf4, 0xcc, 0x6f, 0x62, 0x66, 0xf3, 0xf8, 0x0d, 0xb1, 
  0x19, 0x36, 0x61, 0xf6, 0x28, 0x65, 0xd3, 0xb9, 0x0b, 0x63, 0xea, 0x36, 
  0xa6, 0x59, 0xcc, 0x9c, 0xca, 0xb2, 0x36, 0xe0, 0x0e, 0xc1, 0x99, 0x4f, 
  0x20, 0x71, 0x0a, 0xba, 0x6d, 0x59, 0x99, 0xb4, 0x9c, 0x28, 0x9f, 0x59, 
  0x59, 0xbb, 0xc5, 0xd9, 0x3b, 0xd0, 0xdc, 0x51, 0x4e, 0x88, 0x76, 0xa3, 
  0x73, 0xfe, 0x7e, 0xb1, 0x53, 0x47, 0x7d, 0x6e, 0x89, 0xa8, 0x6b, 0xa8, 
  0x83, 0x9e, 0x14, 0x55, 0xbf, 0xa9, 0x57, 0x27, 0x29, 0xfc, 0x22, 0x69, 
  0xe0, 0x84, 0xf1, 0xbe, 0xd1, 0x58, 0xe8, 0x6c, 0x94, 0xbc, 0x4b, 0x60, 
  0xe2, 0xef, 0x4c, 0x28, 0x3b, 0x82, 0x91, 0xa3, 0x8a, 0xbe, 0x23, 0xed, 
  0x18, 0xbc, 0xd7, 0x5e, 0xb7, 0x57, 0x38, 0x97, 0x93, 0xa5, 0x0a, 0x08, 
  0x48, 0x2c, 0x12, 0x5c, 0xb7, 0xb3, 0x00, 0x48, 0x60, 0x3b, 0xbc, 0xfa, 
  0xfa, 0xb7, 0x13, 0x2c, 0x69, 0x55, 0xb0, 0xbb, 0x8d, 0x33, 0xe7, 0xe7, 
  0xfe, 0xef, 0x3f, 0x7d, 0x7e, 0x59, 0x37, 0x1d, 0xc1, 0xf0, 0x48, 0xe1, 
  0xf8, 0xb4, 0xcc, 0x76, 0xf5, 0xe3, 0x33, 0x70, 0xcc, 0xcc, 0xb7, 0x8d, 
  0x53, 0x77, 0xc3, 0x61, 0xf7, 0xf4, 0x78, 0x9b, 0xb6, 0xc5, 0x71, 0x99, 
  0x4c, 0x43, 0xed, 0x66, 0xf2, 0xb6, 0x48, 0x6e, 0xe2, 0xf2, 0x26, 0x5a, 
  0x55, 0x29, 0xdb, 0x2c, 0x20, 0x8b, 0xcc, 0xcd, 0xef, 0xd9, 0xf2, 0xe6, 
  0x49, 0x20, 0xaa, 0x85, 0xed, 0xd8, 0x42, 0x9a, 0xc8, 0xcc, 0x32, 0x4a, 
  0xe0, 0x98, 0x64, 0x89, 0xb4, 0x29, 0x8c, 0x30, 0x0a, 0x41, 0xed, 0x3e, 
  0xa5, 0x41, 0x73, 0xa6, 0x08, 0xeb, 0x3e, 0xc9, 0x8c, 0xe6, 0x9f, 0x12, 
  0x39, 0xcd, 0xd5, 0x36, 0xd2, 0xa5, 0x55, 0x3b, 0x8e, 0x99, 0x9a, 0x65, 
  0x58, 0xff, 0x06, 0xf5, 0x2b, 0xff, 0x2a, 0x25, 0x89, 0x58, 0xf6, 0xb7, 
  0xcd, 0xc7, 0x8c, 0x73, 0xfd, 0x66, 0x14, 0x37, 0xa3, 0x5b, 0x9f, 0x23, 
  0xa4, 0xba, 0x35, 0x98, 0x97, 0x1c, 0x3b, 0x55, 0x72, 0x42, 0x11, 0xcf, 
  0x7c, 0x3b, 0xcb, 0x35, 0x58, 0x83, 0x23, 0x76, 0x68, 0x51, 0x77, 0x22, 
  0x24, 0x79, 0xd7, 0xb3, 0x9f, 0x9d, 0xc4, 0x53, 0xe4, 0xb0, 0x84, 0x68, 
  0x86, 0x33, 0x07, 0x29, 0xe7, 0x25, 0x37, 0x23, 0x2e, 0x29, 0x60, 0x48, 
  0x60, 0x4a, 0xf0, 0x31, 0x57, 0x6d, 0xf1, 0x50, 0xed, 0x57, 0x02, 0x5d, 
  0x40, 0xaf, 0x27, 0xd5, 0x44, 0x76, 0xcf, 0xb4, 0xd5, 0x69, 0x12, 0xcf, 
  0x4d, 0x01, 0x9a, 0x01, 0xe9, 0xa0, 0x65, 0x8a, 0x85, 0x49, 0x85, 0x47, 
  0x71, 0x92, 0x99, 0x1d, 0x78, 0x12, 0x97, 0x89, 0x1a, 0x1c, 0xe3, 0x30, 
  0x1c, 0x00, 0x4d, 0x94, 0xed, 0xa8, 0x81, 0x69, 0x32, 0x4f, 0x45, 0x4b, 
  0xb6, 0x50, 0x5d, 0xc8, 0x07, 0x12, 0xdf, 0xcb, 0xfc, 0x58, 0x22, 0x00, 
  0xdc, 0xb7, 0x2d, 0xfd, 0x43, 0xbc, 0xb9, 0x9c, 0x4c, 0x1e, 0x6d, 0x6b, 
  0x60, 0x64, 0x3e, 0x43, 0x04, 0x9f, 0x48, 0x6a, 0x82, 0xce, 0x30, 0xc6, 
  0xa0, 0xd6, 0x1d, 0x96, 0x52, 0xa6, 0xc0, 0x1d, 0xb5, 0xba, 0x43, 0x91, 
  0xc3, 0x56, 0xaa, 0x61, 0x5d, 0x88, 0x5a, 0xdc, 0x81, 0xb2, 0x37, 0x55, 
  0x9b, 0x32, 0xc5, 0x76, 0x41, 0x87, 0x72, 0x56, 0xdb, 0x4f, 0xf5, 0xdd, 
  0xfd, 0x8a, 0xe1, 0x1e, 0xd2, 0x15, 0xba, 0x5d, 0x15, 0x35, 0xdb, 0xf2, 
  0xac, 0x5a, 0x3e, 0x10, 0x69, 0x23, 0x86, 0x3a, 0x68, 0xa8, 0x9a, 0xb2, 
  0x42, 0xd7, 0xe7, 0xae, 0x8f, 0xed, 0x93, 0x80, 0xa2, 0x58, 0x6f, 0x45, 
  0xcc, 0xaf, 0x39, 0x02, 0xcd, 0xf3, 0x16, 0x5b, 0x37, 0xcf, 0x16, 0x19, 
  0xdf, 0xce, 0xad, 0xaf, 0x11, 0x20, 0xf8, 0xbd, 0xa2, 0xa5, 0x89, 0x8b, 
  0x69, 0x8b, 0xad, 0xb1, 0x7e, 0xc2, 0x52, 0xdf, 0xcc, 0x81, 0x7f, 0x20, 
  0xd9, 0x96, 0x26, 0x33, 0x8a, 0x94, 0xd1, 0xd4, 0xf4, 0x93, 0x41, 0xa7, 
  0xd8, 0x80, 0x45, 0x32, 0x37, 0x69, 0x60, 0xe4, 0xd3, 0x30, 0xa0, 0x45, 
  0x2a, 0x11, 0x1b, 0xe0, 0x95, 0x2d, 0x86, 0x90, 0x33, 0xb4, 0x45, 0x2b, 
  0xe5, 0xe1, 0x8f, 0x3b, 0xff, 0xa9, 0x2d, 0x23, 0x11, 0xba, 0xdb, 0xa8, 
  0xca, 0x3e, 0x19, 0x36, 0x4c, 0xca, 0xc1, 0x32, 0x4b, 0x28, 0x87, 0xf8, 
  0xc8, 0xc7, 0x2a, 0x00, 0x03, 0x75, 0x66, 0xd8, 0x0a, 0x36, 0x9d, 0xbb, 
  0xb4, 0x16, 0x5b, 0x75, 0x31, 0x70, 0x06, 0x0e, 0x42, 0x97, 0x30, 0x94, 
  0x75, 0x04, 0x9b, 0x8a, 0x11, 0x83, 0x77, 0xc7, 0x25, 0x06, 0xf8, 0x80, 
  0xc3, 0xd2, 0x0d, 0x1e, 0xa1, 0x9e, 0xa6, 0xf8, 0xb4, 0x0c, 0xd8, 0x7e, 
  0x85, 0xf7, 0x47, 0x7b, 0xff, 0xb1, 0x15, 0xa6, 0x5b, 0xac, 0x1b, 0x50, 
  0x21, 0x7a, 0x85, 0x84, 0x47, 0x48, 0x9e, 0x30, 0x37, 0x07, 0xe1, 0xe8, 
  0x51, 0x49, 0x5c, 0x90, 0x19, 0x8b, 0xba, 0x3b, 0x9a, 0xb1, 0xd9, 0x97, 
  0xa7, 0xbb, 0x57, 0xa7, 0x97, 0xa3, 0xff, 0x2b, 0x66, 0xf9, 0x92, 0x6f, 
  0x1c, 0x0e, 0x97, 0x92, 0x8c, 0x61, 0x8d, 0xa6, 0x78, 0xd8, 0xfb, 0x3c, 
  0x67, 0x03, 0x07, 0x8e, 0x93, 0x0b, 0xd0, 0x0a, 0x62, 0xb0, 0xd0, 0x5a, 
  0x6b, 0x20, 0xc2, 0x6a, 0x83, 0xa0, 0x2d, 0x0b, 0xcc, 0x12, 0x5c, 0x81, 
  0x66, 0x28, 0xd6, 0x55, 0x3b, 0x44, 0x48, 0x92, 0xd3, 0x42, 0xb9, 0x41, 
  0x02, 0xcc, 0xe0, 0x72, 0xee, 0x8e, 0x57, 0x6a, 0xb2, 0x6e, 0x04, 0x7a, 
  0xc4, 0x45, 0xb5, 0x8b, 0x28, 0x25, 0xf1, 0x9e, 0xc7, 0x13, 0xce, 0x4f, 
  0x15, 0xee, 0x41, 0x6d, 0x5e, 0xbc, 0x3c, 0xda, 0xff, 0xec, 0xd3, 0x3f, 
  0x1a, 0x72, 0x41, 0xe7, 0x25, 0x58, 0x6a, 0x04, 0x9f, 0x46, 0xa2, 0x06, 
  0xae, 0xeb, 0x92, 0xaf, 0x45, 0xa4, 0x48, 0x22, 0x2b, 0xaf, 0x43, 0x10, 
  0xee, 0xeb, 0xf8, 0xfa, 0x82, 0xd1, 0x23, 0x59, 0x74, 0xe3, 0xc4, 0x52, 
  0x85, 0x07, 0x38, 0x26, 0xb3, 0xf4, 0x5d, 0x90, 0xe9, 0xd9, 0x15, 0x0c, 
  0x6e, 0x21, 0x4a, 0x59, 0xf4, 0x45, 0xc4, 0xb8, 0x52, 0xe8, 0xf3, 0xaf, 
  0x2c, 0xd6, 0x5d, 0xab, 0x19, 0x4f, 0xfb, 0x41, 0x37, 0x5d, 0x76, 0xf0, 
  0x58, 0xfb, 0xd3, 0xee, 0x5c, 0xe0, 0x8c, 0x46, 0x1b, 0xab, 0x19, 0x33, 
  0xd2, 0x30, 0xa0, 0x46, 0x0b, 0xcf, 0xcc, 0x12, 0xe0, 0x5d, 0x95, 0x1e, 
  0xbb, 0xe4, 0x0b, 0x5c, 0x6e, 0xcf, 0x94, 0xc9, 0xa8, 0xe7, 0xf9, 0x8b, 
  0x96, 0xeb, 0xe6, 0x96, 0xad, 0xcf, 0xd2, 0x27, 0x22, 0xad, 0xab, 0x2a, 
  0x36, 0xcc, 0x19, 0x71, 0x4e, 0x23, 0x14, 0x2a, 0x48, 0xa3, 0x6e, 0x72, 
  0x19, 0x05, 0x2f, 0x21, 0xca, 0x52, 0x8f, 0xd1, 0x33, 0xd7, 0x2a, 0x22, 
  0x13, 0x48, 0xd4, 0x9e, 0x23, 0x5f, 0xc7, 0x2d, 0x4c, 0x87, 0x47, 0xc1, 
  0x85, 0x0f, 0x49, 0x64, 0x08, 0x5b, 0x0b, 0xfc, 0xbb, 0xc1, 0x42, 0xb5, 
  0xae, 0xe5, 0xe3, 0x77, 0x31, 0x27, 0x44, 0x0c, 0x1c, 0x98, 0x07, 0x14, 
  0x14, 0xe7, 0x51, 0x37, 0x35, 0x5a, 0xc8, 0x5b, 0xee, 0xb7, 0xae, 0x88, 
  0x5d, 0xa2, 0x08, 0x7b, 0xa7, 0x1f, 0x19, 0x5f, 0xc6, 0x1e, 0x58, 0x32, 
  0x32, 0x93, 0xaa, 0x0c, 0xa7, 0x65, 0xf4, 0x93, 0x43, 0xb5, 0x4b, 0x34, 
  0xb7, 0x8b, 0x46, 0xa6, 0xb5, 0xa4, 0x55, 0x84, 0xf0, 0x3e, 0xed, 0xd4, 
  0x9e, 0x87, 0x2f, 0xdd, 0x48, 0x9f, 0x7f, 0x51, 0x7b, 0xff, 0xfe, 0x7e, 
  0xb4, 0x58, 0xdb, 0x77, 0x65, 0x0d, 0x04, 0xca, 0x87, 0x22, 0xb9, 0x08, 
  0x2d, 0x9e, 0x65, 0xbf, 0x74, 0xb4, 0xe6, 0x63, 0xb5, 0xe4, 0x8a, 0x9d, 
  0x8a, 0xf9, 0xb3, 0x2b, 0x8f, 0x77, 0xa0, 0x8e, 0xe0, 0xa1, 0x5b, 0x87, 
  0x3a, 0x05, 0x4a, 0x40, 0x53, 0xff, 0x2e, 0x81, 0x86, 0xd2, 0x99, 0x82, 
  0x79, 0x9d, 0x27, 0xb2, 0x6d, 0xe3, 0x9c, 0xa8, 0xd5, 0xa8, 0x8e, 0xdd, 
  0x17, 0x55, 0xb1, 0x9a, 0x54, 0x6d, 0xb1, 0xdd, 0x50, 0x92, 0x24, 0xaf, 
  0xc7, 0xf9, 0x1d, 0xef, 0x79, 0xd7, 0x8f, 0x94, 0x6d, 0x5c, 0x71, 0x98, 
  0xa3, 0x2a, 0x6d, 0xd4, 0xf6, 0x86, 0x2c, 0x68, 0x25, 0x3e, 0x1c, 0xae, 
  0x81, 0x4b, 0xbd, 0x8d, 0xfa, 0xc8, 0xaa, 0xed, 0x6b, 0x28, 0xab, 0x04, 
  0xe2, 0x34, 0x05, 0x50, 0x8d, 0xd2, 0xa9, 0xf2, 0x8d, 0x3b, 0xd3, 0xbb, 
  0x4f, 0xc6, 0xcf, 0xbf, 0x00, 0xcc, 0x13, 0x92, 0xf6, 0x24, 0x57, 0x97, 
  0xc9, 0x72, 0x97, 0xff, 0xec, 0x71, 0x2c, 0x5b, 0xd7, 0xc6, 0xb0, 0xb9, 
  0x71, 0xb6, 0x2a, 0xa0, 0xaa, 0x27, 0x42, 0x9d, 0x25, 0x16, 0xc5, 0xb2, 
  0x08, 0xf5, 0x64, 0xbd, 0x3a, 0x7c, 0xfd, 0xe6, 0xf0, 0xf4, 0x41, 0x0f, 
  0x5d, 0x68, 0x9f, 0x77, 0x98, 0x49, 0xd0, 0x6a, 0x82, 0xab, 0xe3, 0x9a, 
  0xae, 0x8e, 0xeb, 0x79, 0x3e, 0xce, 0x67, 0xb3, 0x07, 0x9a, 0x92, 0xbb, 
  0x10, 0x40, 0x61, 0x42, 0xd0, 0x3d, 0xf6, 0x43, 0xf0, 0x7b, 0x63, 0x71, 
  0xd9, 0x02, 0x4d, 0x60, 0xd4, 0xe5, 0xc6, 0xf2, 0x59, 0x31, 0x81, 0x4f, 
  0x75, 0xdd, 0x80, 0xba, 0x02, 0xb8, 0x55, 0x87, 0xc8, 0x69, 0x16, 0x2a, 
  0x1f, 0xca, 0x58, 0x46, 0x7f, 0xff, 0xc7, 0x8f, 0x3f, 0xb9, 0xe0, 0x22, 
  0xb5, 0x77, 0xd3, 0xf7, 0x0b, 0x75, 0x74, 0xb5, 0xac, 0x50, 0xf4, 0x12, 
  0xb1, 0xc7, 0x4a, 0xb2, 0xab, 0x45, 0xea, 0x04, 0x50, 0x4b, 0xdd, 0xb8, 
  0x98, 0x94, 0xae, 0x87, 0xa6, 0xc6, 0x53, 0x24, 0xf0, 0xfd, 0xaa, 0xae, 
  0x33, 0x4f, 0xae, 0xe9, 0x5f, 0x9e, 0xbe, 0xe3, 0x3a, 0x63, 0x8d, 0x72, 
  0x5a, 0x5b, 0x30, 0x65, 0x5b, 0x9b, 0xd7, 0xa8, 0xc5, 0xe0, 0xa2, 0x52, 
  0xb6, 0xf2, 0xe6, 0xe2, 0xc4, 0x49, 0xcb, 0xc1, 0xb6, 0x7c, 0xc5, 0xdb, 
  0xd2, 0xe2, 0x75, 0xce, 0x2f, 0x38, 0xa8, 0x89, 0x14, 0x1e, 0x70, 0x8f, 
  0xe3, 0x15, 0x70, 0x23, 0x3a, 0x33, 0x45, 0x4b, 0x65, 0x65, 0x94, 0x01, 
  0x1f, 0x37, 0x57, 0x34, 0xc2, 0xd6, 0xaa, 0xbc, 0x89, 0x48, 0x11, 0x77, 
  0xba, 0xd1, 0xbe, 0x3a, 0xf6, 0x51, 0xe1, 0x21, 0xda, 0x0b, 0x4f, 0x09, 
  0x37, 0xba, 0x7d, 0xd7, 0xb1, 0xa9, 0xc8, 0x2d, 0xbd, 0x4f, 0xd9, 0x67, 
  0x6c, 0xd0, 0x0b, 0xd0, 0xa0, 0x71, 0x19, 0x69, 0xf8, 0xaa, 0x30, 0x40, 
  0xf5, 0x8c, 0x75, 0x04, 0xf9, 0xea, 0xda, 0x9d, 0xca, 0x84, 0xe2, 0xa8, 
  0xff, 0xe7, 0xbe, 0x0b, 0xf4, 0xdd, 0x90, 0x7b, 0xe9, 0xb3, 0x0c, 0x1a, 
  0x01, 0x4d, 0xc3, 0x93, 0x81, 0x1f, 0xb7, 0xeb, 0xbf, 0x45, 0x47, 0x32, 
  0xc7, 0x71, 0xe2, 0x06, 0xd5, 0x31, 0x8c, 0xaf, 0x8f, 0x0f, 0x5f, 0xd8, 
  0xd4, 0xbb, 0x06, 0xd1, 0x71, 0x16, 0x39, 0x75, 0x8d, 0xd1, 0xfd, 0xae, 
  0x65, 0xcf, 0x88, 0xb6, 0x6e, 0xd0, 0x41, 0x78, 0x48, 0x6f, 0xe0, 0x77, 
  0x9c, 0x2f, 0x5b, 0xf9, 0x26, 0xf1, 0x35, 0xfb, 0xc1, 0xe7, 0xcb, 0xe0, 
  0xd9, 0xc0, 0x47, 0xf9, 0x4c, 0x7e, 0x6e, 0x90, 0x03, 0x8f, 0x11, 0xe1, 
  0xae, 0x8f, 0x86, 0x4e, 0x7c, 0xef, 0x39, 0x20, 0x1e, 0x46, 0x67, 0xfb, 
  0xba, 0x05, 0xdc, 0xc2, 0x3c, 0x98, 0x0d, 0xc8, 0x21, 0x52, 0x9d, 0xa4, 
  0x0b, 0x31, 0x0d, 0x68, 0xe8, 0xbc, 0xba, 0x9b, 0x35, 0x24, 0xbf, 0x4b, 
  0x7d, 0x56, 0x47, 0xa1, 0x86, 0xbd, 0xc6, 0xd3, 0x29, 0x67, 0x28, 0xd2, 
  0x2d, 0x4f, 0xf7, 0x8f, 0x0d, 0x8b, 0x1f, 0x63, 0x41, 0xb3, 0x23, 0x86, 
  0x90, 0x2f, 0x98, 0x4c, 0xa3, 0x5a, 0x03, 0x6c, 0x50, 0x1c, 0x78, 0x56, 
  0x7f, 0x24, 0xb2, 0xcf, 0x34, 0xc6, 0x8e, 0x63, 0xb9, 0x42, 0xba, 0x29, 
  0x6e, 0x7c, 0x84, 0x0c, 0xf1, 0x5b, 0x6c, 0x4b, 0x81, 0xcb, 0xd2, 0xdc, 
  0xbc, 0x3e, 0xdc, 0x7c, 0xd5, 0x4e, 0x7d, 0x6e, 0x10, 0xbe, 0xeb, 0x9a, 
  0x7a, 0x76, 0x56, 0x9a, 0x58, 0x7d, 0xac, 0xc0, 0x30, 0x6a, 0x5d, 0xfe, 
  0x82, 0xb8, 0x02, 0xb7, 0xa9, 0x20, 0x81, 0xb2, 0xff, 0xaf, 0xac, 0x56, 
  0x60, 0xb3, 0x71, 0xa6, 0x77, 0x1b, 0xd6, 0xc7, 0xa2, 0x5c, 0x5a, 0x5a, 
  0xf9, 0x08, 0xfb, 0xa1, 0xab, 0xc8, 0x9c, 0xaa, 0x48, 0x96, 0xf3, 0x78, 
  0xe2, 0xc7, 0xd3, 0x98, 0x54, 0xd9, 0xc1, 0x13, 0x10, 0xa8, 0xc9, 0xa9, 
  0x94, 0x90, 0xa1, 0x97, 0x49, 0x31, 0x4b, 0x38, 0x55, 0x42, 0x12, 0x37, 
  0xef, 0x35, 0x21, 0x98, 0x01, 0x5c, 0x10, 0xa3, 0xd3, 0xa4, 0x87, 0x0b, 
  0x74, 0xa8, 0x68, 0x18, 0x6e, 0x15, 0x74, 0x09, 0x71, 0x34, 0x2c, 0x62, 
  0x1a, 0xfd, 0x10, 0xe3, 0x6c, 0x69, 0xe5, 0x30, 0xf8, 0x3b, 0x78, 0x43, 
  0x09, 0xf9, 0xe2, 0x08, 0x06, 0x5b, 0xdb, 0x49, 0x3e, 0x37, 0x4e, 0xa7, 
  0x66, 0x9a, 0x2e, 0x8a, 0xd2, 0x2e, 0x45, 0xe4, 0xa3, 0x53, 0x14, 0x17, 
  0xb5, 0x8c, 0x98, 0xe0, 0x8e, 0xf5, 0x2e, 0xbd, 0x36, 0x36, 0x9c, 0xc4, 
  0x47, 0xd4, 0x62, 0x12, 0x3a, 0x33, 0x1d, 0xca, 0xee, 0xeb, 0xd7, 0x27, 
  0x42, 0x88, 0x6a, 0x1d, 0x30, 0x54, 0x0f, 0x8f, 0x88, 0xb3, 0xdf, 0x41, 
  0x10, 0x74, 0x0a, 0x76, 0x75, 0xff, 0x76, 0x39, 0x19, 0xf6, 0x2e, 0xf1, 
  0x2f, 0xd9, 0x89, 0xf2, 0x87, 0x3d, 0xa5, 0x11, 0xa6, 0xd9, 0x64, 0xbe, 
  0x9a, 0x26, 0xdd, 0x87, 0xfc, 0x44, 0xbe, 0x74, 0x79, 0x3a, 0xc6, 0x1a, 
  0x4c, 0x3e, 0x17, 0xfb, 0xd6, 0xa8, 0x2b, 0x26, 0x3f, 0x7c, 0x3c, 0xd2, 
  0x4e, 0xf8, 0x20, 0xd2, 0x8a, 0x2a, 0x5c, 0xad, 0x48, 0xc4, 0x43, 0x3e, 
  0x84, 0x03, 0x66, 0x9c, 0x49, 0x3b, 0x59, 0x10, 0x26, 0x6b, 0x67, 0xe3, 
  0x43, 0x93, 0xe6, 0xff, 0x88, 0x33, 0x49, 0x10, 0x19, 0x8d, 0x7e, 0x45, 
  0x6b, 0x99, 0x9b, 0x2e, 0x86, 0x1f, 0x1a, 0x06, 0x40, 0xa6, 0x33, 0x3e, 
  0x26, 0xcf, 0xba, 0x72, 0xaf, 0xcf, 0xe9, 0x4b, 0x4d, 0x40, 0x0a, 0x72, 
  0xa5, 0x55, 0x44, 0x0c, 0x33, 0x9e, 0x5d, 0x3b, 0xa3, 0x0d, 0x82, 0x6a, 
  0x92, 0x55, 0x86, 0x0d, 0x8c, 0xee, 0x64, 0xb9, 0x4e, 0xce, 0xb1, 0xd7, 
  0x05, 0x60, 0x43, 0x38, 0x77, 0xec, 0x26, 0x6f, 0x79, 0x01, 0xf8, 0xc9, 
  0x51, 0x74, 0x98, 0x99, 0x20, 0xa8, 0xa1, 0x4e, 0xec, 0x1d, 0xc2, 0x06, 
  0xb4, 0x84, 0x4f, 0x95, 0x3e, 0x83, 0xb9, 0x25, 0xd5, 0xcd, 0xde, 0xd3, 
  0xfd, 0x10, 0x5f, 0x22, 0xd3, 0x44, 0x66, 0x40, 0xa4, 0xfe, 0x66, 0x36, 
  0xf1, 0x13, 0xbd, 0x95, 0xba, 0xa8, 0x74, 0xf7, 0x25, 0xff, 0x8f, 0x81, 
  0x97, 0xa3, 0x97, 0x0c, 0x59, 0xda, 0x22, 0x56, 0x64, 0xfc, 0xfe, 0x4e, 
  0x29, 0xb2, 0x33, 0x37, 0xbc, 0x74, 0x21, 0xe4, 0xc2, 0x2b, 0x24, 0x9f, 
  0x13, 0xb7, 0xb1, 0xa8, 0x57, 0x98, 0x94, 0x38, 0x03, 0x9b, 0x27, 0x8e, 
  0xf5, 0x56, 0xbb, 0x82, 0x25, 0xd5, 0xd8, 0x91, 0x0d, 0xc3, 0xe2, 0x06, 
  0x68, 0x12, 0x4e, 0xfc, 0x6a, 0x01, 0x33, 0xb1, 0x7a, 0xcb, 0x06, 0x24, 
  0xda, 0x48, 0x9e, 0x88, 0x2a, 0x47, 0xd8, 0x0d, 0x4d, 0x64, 0x2e, 0xbd, 
  0xda, 0x51, 0xa6, 0x3f, 0xb7, 0x72, 0xe4, 0x19, 0x4f, 0x94, 0x17, 0x74, 
  0x91, 0x4f, 0xc5, 0x61, 0x81, 0x38, 0x26, 0x06, 0x66, 0xe0, 0xb9, 0xff, 
  0xfa, 0x07, 0xa4, 0xde, 0xcb, 0xf0, 0xaf, 0xb4, 0x5d, 0x7f, 0x5d, 0x65, 
  0xb7, 0x43, 0x05, 0x1f, 0xd3, 0x60, 0xb7, 0x72, 0x83, 0x45, 0x49, 0xe2, 
  0x9e, 0x34, 0xae, 0x0e, 0x5c, 0x0d, 0x8a, 0x6e, 0x07, 0xda, 0x56, 0xdc, 
  0x99, 0xae, 0x2a, 0xcb, 0xd5, 0x2d, 0xd2, 0x22, 0x52, 0x89, 0x46, 0x3b, 
  0x89, 0x39, 0xc4, 0xbd, 0x9d, 0x7c, 0xd7, 0x33, 0x7c, 0x34, 0xeb, 0xa8, 
  0x96, 0x3f, 0x07, 0xf0, 0x20, 0xba, 0xc7, 0x6e, 0x0c, 0x9e, 0x8a, 0xc5, 
  0x86, 0xa6, 0x3d, 0x68, 0xc6, 0x97, 0x9d, 0xe4, 0x27, 0xb2, 0x99, 0x22, 
  0x4b, 0xee, 0x3d, 0xea, 0x9a, 0x40, 0xe3, 0x71, 0x76, 0x15, 0x4b, 0xa8, 
  0x11, 0x69, 0x96, 0xec, 0xa3, 0x6d, 0x0a, 0xf8, 0x05, 0x5d, 0xf1, 0x00, 
  0x8d, 0x71, 0x11, 0xa8, 0x7e, 0xc8, 0xcd, 0xf1, 0x49, 0x04, 0x56, 0x5b, 
  0x27, 0x5d, 0xf3, 0xf5, 0x3a, 0x99, 0x33, 0x04, 0x1f, 0xd1, 0xdc, 0x7d, 
  0x56, 0x37, 0x2d, 0x3e, 0xf9, 0x70, 0x0b, 0xf5, 0xaf, 0x10, 0x01, 0x7c, 
  0x8b, 0x7b, 0x46, 0x70, 0x2c, 0x3b, 0x51, 0x78, 0x42, 0x65, 0x31, 0x79, 
  0xc7, 0xf9, 0x85, 0x69, 0x85, 0x08, 0x72, 0x08, 0x3f, 0xe6, 0x44, 0x5d, 
  0x0a, 0x53, 0x6d, 0xee, 0xa0, 0xb5, 0xdc, 0x13, 0xe8, 0x9c, 0xc0, 0x5d, 
  0x08, 0xaf, 0x67, 0x10, 0x02, 0x7c, 0xc9, 0x1b, 0xd1, 0x56, 0xf2, 0x14, 
  0x33, 0x4e, 0x08, 0x90, 0xcd, 0xf9, 0x03, 0x05, 0x9a, 0x68, 0xc6, 0xf3, 
  0x6c, 0x84, 0x56, 0x50, 0x27, 0x82, 0xa5, 0x67, 0x12, 0xe9, 0x4d, 0x13, 
  0xc3, 0xed, 0x74, 0x96, 0x01, 0xb9, 0x32, 0xd5, 0x07, 0xbf, 0xc9, 0xd1, 
  0x68, 0x81, 0x03, 0x22, 0x1d, 0xc6, 0x30, 0xa8, 0x72, 0x13, 0x6a, 0x8d, 
  0x57, 0xe2, 0x84, 0x8d, 0xab, 0x1b, 0x6a, 0x23, 0x18, 0x6c, 0x18, 0xc5, 
  0x19, 0xac, 0x12, 0xb4, 0xb4, 0xa8, 0xc3, 0xc5, 0xa8, 0x30, 0x54, 0xb5, 
  0xed, 0x32, 0xb2, 0xf8, 0x60, 0xff, 0x67, 0x9b, 0x89, 0x80, 0x0f, 0x75, 
  0xe8, 0x44, 0xe0, 0x2b, 0x8e, 0x93, 0xa4, 0x55, 0x78, 0xbd, 0xde, 0x16, 
  0xe3, 0xc7, 0xd1, 0xb3, 0x39, 0x91, 0xe2, 0xfc, 0xf3, 0x4e, 0xe3, 0xbb, 
  0x64, 0xc5, 0x44, 0xb7, 0x49, 0x31, 0x66, 0x30, 0xef, 0xc7, 0xcd, 0x54, 
  0x17, 0x8d, 0xde, 0xe8, 0x14, 0x4d, 0xd0, 0xac, 0x8b, 0x51, 0xc2, 0x05, 
  0x2b, 0xa0, 0x3e, 0x01, 0x9a, 0x9f, 0xaa, 0x04, 0x7d, 0x64, 0xb9, 0xb4, 
  0x82, 0x21, 0xfa, 0x65, 0x3c, 0x4b, 0xfa, 0x03, 0x58, 0x72, 0x67, 0xe9, 
  0x54, 0x90, 0xb1, 0xfb, 0xcc, 0xbf, 0xfb, 0x1a, 0x2e, 0xd4, 0x1f, 0x45, 
  0x97, 0xd2, 0x98, 0x82, 0x7a, 0xb5, 0x72, 0x73, 0x74, 0x18, 0x9a, 0xd6, 
  0x49, 0xcb, 0xc7, 0xb2, 0xb7, 0xd7, 0x44, 0x58, 0xbb, 0x70, 0x8d, 0xbd, 
  0x47, 0xa5, 0xec, 0xdc, 0xa0, 0xf0, 0x4c, 0xb1, 0x4e, 0x99, 0x02, 0x5d, 
  0xdf, 0xa5, 0x36, 0x33, 0x4e, 0x52, 0xc1, 0x3a, 0x7b, 0x74, 0xcf, 0xf6, 
  0xd5, 0xf1, 0x2a, 0x9d, 0x57, 0x9d, 0xe7, 0xc2, 0x2f, 0xb1, 0xc5, 0x1e, 
  0x8e, 0x3c, 0xfe, 0x19, 0x8f, 0x99, 0xd8, 0xc5, 0x1a, 0x97, 0x66, 0xdb, 
  0x87, 0xc3, 0x3e, 0xa8, 0xa1, 0x13, 0xd9, 0x24, 0x94, 0x4e, 0xf5, 0xb6, 
  0xc2, 0x45, 0xb2, 0x58, 0x44, 0x63, 0x8d, 0x04, 0x7e, 0xed, 0x58, 0xaa, 
  0x6f, 0x04, 0x34, 0x63, 0x96, 0x5e, 0x47, 0xcf, 0xf4, 0x67, 0x57, 0x9c, 
  0xa1, 0xc3, 0xd0, 0x51, 0x37, 0xb1, 0x3e, 0xea, 0x4c, 0xbb, 0x72, 0x45, 
  0x21, 0x90, 0xb6, 0xb8, 0xc6, 0x3d, 0xdf, 0x15, 0x70, 0xae, 0x51, 0x1b, 
  0xbe, 0x1b, 0x2d, 0x65, 0x21, 0x56, 0x66, 0xa0, 0x67, 0xfb, 0x0e, 0xba, 
  0x33, 0x1c, 0x14, 0x2f, 0xdc, 0x3a, 0x31, 0xeb, 0x9c, 0x61, 0xba, 0x98, 
  0x98, 0x92, 0x64, 0x5d, 0xa4, 0xe2, 0xc2, 0x6c, 0x4b, 0x07, 0x03, 0xca, 
  0x25, 0x13, 0xdc, 0xdb, 0xea, 0x82, 0x8d, 0x27, 0xd5, 0x2a, 0x9e, 0xbf, 
  0x67, 0x0c, 0xb4, 0xf9, 0x67, 0x4b, 0x65, 0x30, 0x1a, 0x08, 0x9e, 0xa4, 
  0x28, 0x47, 0x40, 0x57, 0x23, 0x2c, 0x6c, 0xdd, 0xf1, 0x5c, 0x35, 0x50, 
  0x74, 0x17, 0x42, 0x54, 0x5f, 0x50, 0xeb, 0x40, 0x78, 0x4b, 0xd2, 0x8a, 
  0xb7, 0xd2, 0x2e, 0xd4, 0xef, 0x6b, 0xd6, 0x3d, 0x9a, 0x3b, 0x07, 0xff, 
  0x2f, 0xb9, 0xba, 0xc1, 0x40, 0x23, 0x41, 0xf5, 0xc9, 0x96, 0xf3, 0xc7, 
  0xc2, 0x12, 0xf5, 0xa2, 0xd4, 0xca, 0x08, 0x00, 0xaf, 0x2e, 0x43, 0x5c, 
  0x72, 0xe4, 0x7f, 0x4c, 0xda, 0x69, 0x7d, 0xab, 0x45, 0xa6, 0xf6, 0x6c, 
  0x1b, 0x39, 0xf6, 0x05, 0xdb, 0xd9, 0xff, 0xa8, 0x1f, 0x4d, 0x6e, 0x62, 
  0x8e, 0xba, 0x35, 0x47, 0x76, 0x47, 0xbe, 0xb4, 0x6a, 0x35, 0x78, 0xcd, 
  0x59, 0xea, 0x15, 0x56, 0x07, 0xc1, 0x64, 0x7c, 0x92, 0x58, 0x5e, 0xdc, 
  0xda, 0x40, 0x8a, 0x26, 0x08, 0x9a, 0xf1, 0xa2, 0x3f, 0xec, 0xd7, 0x43, 
  0xba, 0x35, 0x87, 0xa1, 0xbd, 0x80, 0x82, 0x2f, 0xea, 0x73, 0xa9, 0x5b, 
  0xf0, 0x3f, 0xde, 0xa0, 0x89, 0x5b, 0x4c, 0xd2, 0x70, 0x72, 0x6f, 0xa7, 
  0x81, 0xad, 0xca, 0x43, 0xe2, 0xd1, 0xf4, 0x3b, 0xad, 0xfa, 0xb0, 0x55, 
  0x30, 0x26, 0x86, 0x82, 0x45, 0xda, 0x19, 0x62, 0x51, 0x2c, 0xbc, 0x0a, 
  0x87, 0xc3, 0x76, 0x0a, 0x99, 0xc3, 0xea, 0x00, 0x6d, 0x09, 0x8e, 0xca, 
  0x9a, 0x2d, 0xe6, 0x4b, 0x36, 0x27, 0x28, 0x88, 0xbc, 0x99, 0xcd, 0x98, 
  0x23, 0xb4, 0x0e, 0x1c, 0xc9, 0x3e, 0x4a, 0x47, 0x97, 0x39, 0xe2, 0x42, 
  0x02, 0xb5, 0xc7, 0x5b, 0xde, 0xc1, 0x56, 0x5a, 0x1a, 0x10, 0x2f, 0xdf, 
  0xf3, 0xa8, 0xa7, 0xfa, 0x0e, 0x42, 0xda, 0x6e, 0xe2, 0x77, 0xef, 0x46, 
  0x65, 0x22, 0x60, 0x7a, 0xbd, 0x7f, 0xd9, 0x60, 0x3e, 0x04, 0x96, 0xd9, 
  0x10, 0x99, 0xff, 0xcf, 0x50, 0x54, 0xe0, 0xf3, 0x07, 0xf6, 0x79, 0x61, 
  0x18, 0x6b, 0xae, 0xcc, 0x0a, 0xbf, 0x57, 0xcf, 0x96, 0x6f, 0xab, 0x24, 
  0x76, 0xef, 0xa5, 0x41, 0x6e, 0xac, 0x70, 0x4e, 0xc4, 0x80, 0x8b, 0xd9, 
  0x0c, 0x22, 0x6d, 0x2c, 0xd0, 0x6a, 0x2d, 0x95, 0x64, 0x99, 0x2e, 0x25, 
  0x65, 0x92, 0xcd, 0x36, 0x53, 0x51, 0xd7, 0xd5, 0xd4, 0xe5, 0x86, 0x22, 
  0x9b, 0x03, 0x07, 0x0e, 0x0a, 0xb5, 0xb4, 0xdc, 0xa4, 0xc8, 0x11, 0x1e, 
  0x53, 0x2b, 0xf7, 0xe9, 0xb4, 0xba, 0xe9, 0x0c, 0x6a, 0x14, 0xf9, 0x1d, 
  0xcb, 0x10, 0x01, 0x89, 0x38, 0x2e, 0x57, 0x85, 0xc8, 0xac, 0x80, 0x09, 
  0xda, 0x15, 0x11, 0x62, 0xa0, 0xa2, 0x49, 0xeb, 0x0e, 0x2d, 0x57, 0x33, 
  0x76, 0x5c, 0xf2, 0xf1, 0x53, 0xab, 0x2a, 0x29, 0xbc, 0xf8, 0x0d, 0x54, 
  0xd6, 0xbf, 0xed, 0x8b, 0x76, 0xdc, 0xff, 0xa6, 0xdf, 0x99, 0xfa, 0x05, 
  0xb0, 0x21, 0xa5, 0x46, 0xb5, 0x40, 0xd2, 0x89, 0xba, 0x4d, 0xe7, 0x39, 
  0xba, 0xa7, 0x1b, 0x78, 0x81, 0x5b, 0xfd, 0x55, 0x5f, 0xdd, 0x8a, 0x69, 
  0xd5, 0xc2, 0x6f, 0xbf, 0x8e, 0x05, 0xd1, 0x48, 0x7c, 0x90, 0xfd, 0x6b, 
  0xeb, 0xf2, 0xab, 0xbe, 0x79, 0x38, 0x41, 0xf8, 0xd7, 0xa9, 0x3e, 0x38, 
  0xea, 0x76, 0x22, 0x96, 0x4f, 0xa3, 0x83, 0xbd, 0xbd, 0x6f, 0x06, 0xd1, 
  0xa3, 0x05, 0x56, 0x7e, 0xff, 0xab, 0x07, 0x6f, 0xf4, 0x7b, 0x80, 0xf8, 
  0x56, 0x45, 0x3e, 0x5d, 0x4d, 0xd4, 0x30, 0xed, 0x72, 0x54, 0x7f, 0x33, 
  0xb5, 0x7c, 0xce, 0xe9, 0x28, 0x69, 0x59, 0x0d, 0x59, 0xff, 0xdb, 0x1c, 
  0x30, 0xc4, 0x8f, 0x04, 0x58, 0xb7, 0x3e, 0x08, 0x71, 0x60, 0xd1, 0x3a, 
  0xe2, 0x20, 0x6a, 0xc7, 0xac, 0x4e, 0x24, 0xa8, 0x88, 0x59, 0x1d, 0xfa, 
  0x88, 0xee, 0xd2, 0xe4, 0x9e, 0xb3, 0x38, 0xd5, 0xd8, 0x2d, 0x88, 0xc6, 
  0x9e, 0xaa, 0x9b, 0xc3, 0xd6, 0x5c, 0xb2, 0x05, 0xa9, 0x30, 0xc4, 0x11, 
  0x86, 0x70, 0x34, 0xd5, 0x5d, 0xbe, 0xac, 0xa3, 0xcb, 0xb0, 0x36, 0x85, 
  0xfb, 0xac, 0x51, 0xe4, 0x60, 0x92, 0x84, 0x99, 0xcb, 0x3e, 0x8c, 0x92, 
  0x07, 0xe4, 0x42, 0x9b, 0xf8, 0x30, 0xc4, 0xed, 0x68, 0x33, 0x78, 0x67, 
  0x84, 0x01, 0x11, 0x65, 0x6c, 0x88, 0x68, 0x6e, 0x63, 0xf0, 0xda, 0xc0, 
  0x5e, 0x9f, 0x5e, 0xba, 0x2c, 0x4f, 0xe5, 0xcc, 0x48, 0xc9, 0x6e, 0x12, 
  0x12, 0xea, 0x44, 0xe0, 0x0d, 0xb3, 0x6a, 0x08, 0x02, 0x6a, 0x36, 0xb7, 
  0xc0, 0x04, 0x61, 0xdd, 0xa9, 0x4f, 0x00, 0x6b, 0x3b, 0x46, 0xb8, 0xb3, 
  0x3f, 0x89, 0x88, 0x30, 0xcd, 0xf5, 0x8c, 0xab, 0xf9, 0x0b, 0x21, 0x1a, 
  0x36, 0x73, 0x68, 0xa2, 0xed, 0xc8, 0xb8, 0x72, 0xbd, 0x18, 0xe7, 0xa4, 
  0xbe, 0x31, 0x07, 0xbe, 0x2d, 0x7f, 0x45, 0xc3, 0x83, 0x9b, 0x5a, 0x40, 
  0x8e, 0x61, 0x76, 0x54, 0xa7, 0xa5, 0x48, 0x43, 0x73, 0x4d, 0xbe, 0xf0, 
  0x10, 0xf7, 0x02, 0x3a, 0x57, 0x7a, 0x90, 0x95, 0xae, 0x32, 0x0b, 0x70, 
  0xcb, 0xf0, 0xa5, 0xb6, 0x84, 0xdf, 0x24, 0xae, 0xc3, 0xec, 0xba, 0xb4, 
  0xac, 0xed, 0x94, 0xb8, 0xcf, 0xa4, 0x03, 0x0d, 0xde, 0xa5, 0xbf, 0xab, 
  0xd1, 0x04, 0x22, 0x80, 0x4b, 0x9c, 0xda, 0x91, 0x95, 0xf1, 0xe1, 0x84, 
  0xec, 0x4f, 0xec, 0xf2, 0x0e, 0xd7, 0xaa, 0xe8, 0xb8, 0x3f, 0x6e, 0x24, 
  0x82, 0x42, 0x65, 0x2b, 0xb6, 0x41, 0xc0, 0x08, 0x3c, 0xda, 0xe0, 0x44, 
  0x72, 0x38, 0x37, 0xe2, 0xc2, 0x4a, 0xe1, 0xca, 0x3b, 0x19, 0xf8, 0xe4, 
  0x4a, 0xc3, 0x33, 0xe9, 0xc0, 0x29, 0xb5, 0x75, 0xe0, 0x65, 0x28, 0x1d, 
  0x6b, 0x20, 0xd5, 0x89, 0x8d, 0x0e, 0xd4, 0x41, 0x43, 0x13, 0x6b, 0x05, 
  0xd0, 0x88, 0x07, 0xd2, 0x07, 0xaf, 0x83, 0x40, 0x11, 0x3e, 0x81, 0x5a, 
  0x26, 0x13, 0xba, 0x00, 0x44, 0xa1, 0xf2, 0xf9, 0xd7, 0x1b, 0xf2, 0xbf, 
  0x6e, 0x50, 0xb2, 0xac, 0xcc, 0xc5, 0xf2, 0x42, 0xef, 0x81, 0x38, 0x81, 
  0x1f, 0xea, 0xad, 0x06, 0xd8, 0xa4, 0x2e, 0x10, 0x38, 0xda, 0x34, 0x69, 
  0x80, 0x73, 0x4b, 0x90, 0x6d, 0x06, 0xc3, 0xe7, 0x24, 0xd1, 0xf5, 0x44, 
  0x9c, 0xd2, 0x7f, 0x39, 0xbc, 0x81, 0x8d, 0x5e, 0x00, 0x4f, 0x74, 0xc3, 
  0xaa, 0x58, 0x61, 0x69, 0x68, 0xda, 0x8a, 0xc2, 0x46, 0x02, 0x21, 0xa7, 
  0x80, 0xf1, 0xde, 0x8e, 0x7e, 0xbd, 0xc3, 0x60, 0xb4, 0xe7, 0x10, 0x06, 
  0x6a, 0x12, 0x47, 0x63, 0x74, 0x0f, 0x1e, 0x8d, 0x53, 0x5c, 0xf5, 0xb5, 
  0xa3, 0x34, 0x88, 0xc4, 0x45, 0x2d, 0xc3, 0xe0, 0x0e, 0x5a, 0x46, 0x54, 
  0xb9, 0x6f, 0x5d, 0xd8, 0xca, 0x7f, 0xf9, 0x18, 0x18, 0xde, 0x80, 0xb9, 
  0xec, 0x54, 0x19, 0xe0, 0xd7, 0xb7, 0x22, 0x22, 0x2a, 0xc9, 0x29, 0xf1, 
  0x7b, 0x98, 0x3b, 0x53, 0xc7, 0x9a, 0x89, 0x53, 0x13, 0xed, 0xfd, 0x9d, 
  0xd7, 0x96, 0x05, 0xd8, 0x5e, 0xc1, 0x51, 0xe9, 0xe3, 0x02, 0x26, 0x2b, 
  0x8d, 0xf9, 0x46, 0xd3, 0xd6, 0xac, 0x39, 0xd2, 0x98, 0xb5, 0xc5, 0x5d, 
  0x63, 0x00, 0x1a, 0x2a, 0x74, 0xa9, 0xb5, 0x14, 0x70, 0xf3, 0x61, 0x3d, 
  0x4d, 0xb2, 0xce, 0x66, 0x4d, 0xb9, 0x4b, 0x63, 0x89, 0x19, 0x27, 0x92, 
  0x6b, 0x01, 0x40, 0xbd, 0xd3, 0xb2, 0x0c, 0xac, 0xe9, 0xc4, 0xa5, 0xa6, 
  0x02, 0x8a, 0x0f, 0xfc, 0xcb, 0x0e, 0x60, 0xf2, 0x7a, 0x1f, 0xbf, 0x26, 
  0xec, 0xdb, 0xc3, 0x24, 0xc3, 0x50, 0xb7, 0xb8, 0x32, 0xd2, 0x9f, 0x49, 
  0x4c, 0x85, 0xd8, 0xf2, 0x21, 0x62, 0x2a, 0x1e, 0xdf, 0x36, 0xe1, 0x6d, 
  0x47, 0x15, 0x25, 0xc3, 0x96, 0xcc, 0x5b, 0xae, 0xc7, 0xfb, 0x4c, 0x40, 
  0xf0, 0xc2, 0x72, 0x50, 0x9e, 0xbf, 0xd0, 0xec, 0xe6, 0x5c, 0x61, 0xaa, 
  0x30, 0xf0, 0x83, 0x16, 0x27, 0xb9, 0x8b, 0xe7, 0x2b, 0x9d, 0xb7, 0x47, 
  0xd7, 0xb7, 0x64, 0x7b, 0xc1, 0xb4, 0xd2, 0x32, 0x36, 0x9b, 0x72, 0xff, 
  0x15, 0x13, 0x1a, 0x5c, 0x30, 0x79, 0x07, 0x65, 0x81, 0x2e, 0xba, 0x4f, 
  0x1f, 0x75, 0x42, 0xa3, 0x3e, 0xad, 0xe1, 0xbf, 0x62, 0xb2, 0x6a, 0x02, 
  0x51, 0xb3, 0x2d, 0xc0, 0x64, 0x39, 0x61, 0x0c, 0x95, 0x28, 0x37, 0x4c, 
  0x57, 0x92, 0x31, 0x38, 0x66, 0x09, 0x88, 0xeb, 0x72, 0x33, 0x37, 0x60, 
  0xe3, 0x01, 0x5c, 0x9c, 0xe5, 0xdd, 0x96, 0x66, 0xf5, 0xf7, 0xa6, 0xb3, 
  0xb0, 0x12, 0x84, 0x5f, 0x00, 0xa4, 0x38, 0xaf, 0x96, 0x9d, 0xe1, 0x2c, 
  0xcd, 0xf5, 0x54, 0x01, 0x1c, 0x4a, 0x80, 0xcf, 0x69, 0x66, 0xb4, 0x35, 
  0x0e, 0xa4, 0x47, 0x50, 0x55, 0xa3, 0x05, 0x16, 0x2f, 0xe0, 0x1c, 0xb9, 
  0xaa, 0xa1, 0x81, 0x38, 0xd2, 0x59, 0xec, 0x7a, 0xa0, 0xe4, 0xf7, 0x42, 
  0x47, 0x8b, 0x69, 0x10, 0x47, 0xe4, 0x01, 0xf4, 0x68, 0x60, 0xc9, 0xb6, 
  0xb3, 0x4b, 0x0a, 0x97, 0xad, 0x1d, 0xe2, 0x45, 0x7b, 0x3d, 0x47, 0x30, 
  0x15, 0xd5, 0xdb, 0x9b, 0x76, 0xe7, 0x12, 0x91, 0x7a, 0xc2, 0x1e, 0xa3, 
  0xbf, 0xe6, 0x63, 0x75, 0x30, 0x30, 0xb7, 0x66, 0x56, 0xc6, 0xef, 0xde, 
  0x70, 0x62, 0x76, 0x34, 0x5d, 0x89, 0x0e, 0xdc, 0x66, 0x7b, 0x5a, 0xd4, 
  0x08, 0xd5, 0x18, 0x21, 0xee, 0x44, 0xd7, 0x40, 0xa0, 0x10, 0xeb, 0xbb, 
  0xad, 0xa6, 0xc9, 0x86, 0x00, 0x05, 0x69, 0xde, 0x42, 0x2b, 0x38, 0xd7, 
  0x79, 0xfe, 0xa8, 0x99, 0xe0, 0xcb, 0x24, 0x44, 0x4d, 0xf0, 0x69, 0x43, 
  0xe5, 0x6e, 0x99, 0x8d, 0x05, 0xa4, 0xfb, 0xb7, 0x06, 0xa1, 0x7e, 0x85, 
  0x6d, 0xce, 0x56, 0x2d, 0x5f, 0xc6, 0x2b, 0x7c, 0x38, 0x8a, 0x5e, 0x88, 
  0xdf, 0x4a, 0xe4, 0x9d, 0x95, 0xc6, 0x99, 0x08, 0x5a, 0x90, 0x6f, 0x25, 
  0xdb, 0x65, 0xc8, 0x9e, 0xaa, 0x98, 0xb4, 0x1a, 0xb9, 0x75, 0xb1, 0x17, 
  0xe5, 0x44, 0x81, 0x4f, 0x46, 0x78, 0xd2, 0xd9, 0xcb, 0x14, 0x1e, 0xa4, 
  0xe8, 0x33, 0x6a, 0xc2, 0x62, 0x73, 0x0e, 0x15, 0xef, 0xe4, 0x3c, 0xa7, 
  0x4d, 0xed, 0x82, 0x10, 0x72, 0x65, 0x1c, 0xd6, 0xcb, 0x16, 0x4c, 0x95, 
  0xe4, 0xd2, 0xa9, 0xe7, 0x1d, 0xb4, 0xc4, 0x08, 0x0a, 0x7c, 0xb5, 0xaf, 
  0xb2, 0xf4, 0xdd, 0xa8, 0x8e, 0x14, 0xcb, 0x16, 0x83, 0xce, 0x64, 0x03, 
  0xac, 0x9f, 0xe6, 0xcd, 0x20, 0xee, 0xb9, 0x09, 0xdd, 0x04, 0x39, 0x02, 
  0x53, 0xdb, 0x7e, 0xbc, 0xd3, 0xae, 0x17, 0x43, 0x7d, 0x6e, 0xef, 0xd7, 
  0x6a, 0x92, 0x9a, 0x8c, 0x17, 0x56, 0x8b, 0xd9, 0x88, 0x2a, 0xcf, 0xcc, 
  0x09, 0xa8, 0xdd, 0x6c, 0x28, 0xb3, 0x0c, 0x47, 0xbc, 0x49, 0x2c, 0x86, 
  0xc9, 0x12, 0x56, 0x2a, 0x41, 0xc8, 0x59, 0x72, 0xda, 0x6c, 0x2b, 0x1d, 
  0x57, 0x81, 0x70, 0xb6, 0x89, 0x37, 0x06, 0x31, 0x22, 0x6c, 0x7a, 0xcc, 
  0x0b, 0x09, 0x2b, 0x89, 0xae, 0x8b, 0x9c, 0xf8, 0x0d, 0x5b, 0x9d, 0x78, 
  0x9a, 0x3b, 0x5d, 0x75, 0x9a, 0xc2, 0xc4, 0x4c, 0x97, 0x97, 0xd9, 0xfb, 
  0xfa, 0xec, 0xd5, 0x71, 0x2f, 0xcc, 0xb4, 0x06, 0xae, 0x6d, 0x5b, 0x3c, 
  0xe0, 0x0d, 0xf6, 0x5b, 0xda, 0xa2, 0xf2, 0x43, 0x2e, 0x3f, 0x97, 0x32, 
  0x64, 0x33, 0xef, 0x2e, 0xcc, 0xd1, 0x30, 0x18, 0x25, 0xce, 0xf3, 0x4d, 
  0x17, 0x91, 0xca, 0x63, 0x25, 0x31, 0xfc, 0x65, 0xeb, 0xee, 0x57, 0xda, 
  0x82, 0xb8, 0xd9, 0x4a, 0x4d, 0xc3, 0xb6, 0x3b, 0x20, 0x20, 0x53, 0x26, 
  0x5b, 0x43, 0x2c, 0xab, 0xd1, 0x34, 0x5f, 0x70, 0xd5, 0xc0, 0x09, 0x4b, 
  0xce, 0x62, 0x3c, 0xc7, 0x96, 0x83, 0xf0, 0xfa, 0x8b, 0x35, 0x87, 0x0d, 
  0xf6, 0x1d, 0x05, 0x76, 0xe5, 0x3d, 0x6f, 0xb5, 0xcc, 0xae, 0xe8, 0xab, 
  0xa3, 0x79, 0x21, 0x69, 0x7a, 0x02, 0xad, 0x46, 0x1e, 0xc7, 0xab, 0x25, 
  0x9b, 0x91, 0x3c, 0x5d, 0xfd, 0x7a, 0x72, 0x84, 0x2c, 0x5c, 0xab, 0xea, 
  0x8a, 0xab, 0x97, 0xb6, 0x21, 0x78, 0x4c, 0x63, 0xe8, 0xa3, 0xaf, 0x2e, 
  0x2f, 0x87, 0xaf, 0xed, 0xd9, 0xa8, 0x75, 0x38, 0x3a, 0x9c, 0x37, 0x8d, 
  0x37, 0xb4, 0x7a, 0x09, 0x9b, 0x43, 0x5c, 0x75, 0xe5, 0xf1, 0x3a, 0x7a, 
  0x95, 0x4e, 0x8a, 0xbc, 0xcc, 0x67, 0x55, 0x87, 0x8e, 0x5a, 0x2f, 0xe3, 
  0x45, 0xda, 0x30, 0xc7, 0xa9, 0xc5, 0x00, 0x35, 0xd5, 0xac, 0x7d, 0xab, 
  0x69, 0x46, 0x37, 0xf9, 0x82, 0x88, 0xb5, 0x65, 0xdb, 0x58, 0x24, 0x6c, 
  0x58, 0x80, 0x02, 0xa8, 0xce, 0x0b, 0x1c, 0xd0, 0x6f, 0xd4, 0x53, 0xf2, 
  0x49, 0x53, 0x56, 0x1c, 0xb7, 0x90, 0x9a, 0xb5, 0xda, 0x15, 0x18, 0xbc, 
  0x43, 0xc0, 0xb8, 0xd6, 0x38, 0xc0, 0x2c, 0x17, 0x08, 0xd2, 0x0f, 0x28, 
  0x1c, 0x48, 0x83, 0xe5, 0xc2, 0x40, 0x48, 0x89, 0x0c, 0xc1, 0x1d, 0xd8, 
  0xcf, 0x72, 0x72, 0x7c, 0xf5, 0x32, 0x9a, 0x16, 0x31, 0x2d, 0x02, 0xfe, 
  0x6d, 0xa1, 0x9c, 0x17, 0xc9, 0xcf, 0xf1, 0xed, 0xb0, 0x5c, 0xf2, 0x66, 
  0x0d, 0x99, 0x83, 0x0d, 0xf7, 0x1e, 0x73, 0xb1, 0xdb, 0x0f, 0x28, 0xe8, 
  0xf2, 0xef, 0x72, 0x2e, 0xd1, 0x6e, 0x1e, 0x9e, 0x9f, 0x04, 0x9e, 0xa5, 
  0x4d, 0x8e, 0x25, 0x76, 0x25, 0xb5, 0xb2, 0x3b, 0x3f, 0xd4, 0xb1, 0x64, 
  0x34, 0xd3, 0xbe, 0x3d, 0xb9, 0xa2, 0xdf, 0x7f, 0x10, 0xd0, 0xed, 0x35, 
  0x5f, 0x80, 0xf9, 0x70, 0xbc, 0xe2, 0xef, 0x1a, 0x8d, 0xbc, 0x90, 0x13, 
  0x26, 0x91, 0x1f, 0xf2, 0x84, 0x26, 0x9b, 0x84, 0xb1, 0x57, 0x80, 0x53, 
  0x49, 0xe2, 0x05, 0x12, 0x2a, 0x3b, 0x81, 0xad, 0x14, 0x8e, 0xcc, 0x63, 
  0xd5, 0x97, 0x83, 0xf0, 0x6e, 0x82, 0xcd, 0x6a, 0x63, 0xc6, 0x1d, 0xba, 
  0x4d, 0xa6, 0xd6, 0x99, 0xf4, 0x25, 0xfb, 0x2c, 0x46, 0x0a, 0xc9, 0x20, 
  0x96, 0xe4, 0x7b, 0x88, 0xa7, 0x5d, 0x71, 0x75, 0x0e, 0xbd, 0x41, 0x9b, 
  0xf1, 0xd0, 0xca, 0x99, 0x20, 0xdc, 0x4a, 0x18, 0xab, 0x80, 0x6f, 0xb7, 
  0x2e, 0x20, 0x9c, 0x40, 0x43, 0x5f, 0xd6, 0x6c, 0x36, 0x6b, 0x20, 0x2e, 
  0x0a, 0x92, 0x60, 0x51, 0x64, 0x34, 0x48, 0xff, 0xeb, 0x06, 0x16, 0xc6, 
  0x08, 0x3c, 0xba, 0x18, 0x8d, 0xcb, 0xad, 0xea, 0xaf, 0xa0, 0x68, 0x69, 
  0xfe, 0x17, 0x4e, 0x7f, 0xab, 0x17, 0x41, 0x2c, 0x6c, 0x41, 0x3c, 0x46, 
  0xaf, 0xaf, 0x4e, 0x5f, 0x75, 0x70, 0x41, 0x51, 0x3b, 0xf0, 0xed, 0x83, 
  0x0a, 0xe3, 0xbf, 0xc2, 0x0d, 0xe9, 0xb1, 0x93, 0x93, 0x4b, 0xf0, 0x42, 
  0x35, 0x1f, 0x8e, 0x7c, 0x71, 0x47, 0x81, 0xb2, 0x26, 0x76, 0x48, 0x22, 
  0x48, 0xb1, 0x6e, 0xe7, 0x8a, 0x2b, 0x1a, 0x5e, 0xc4, 0xc2, 0x76, 0x51, 
  0xa2, 0xde, 0x0d, 0x83, 0xa2, 0x58, 0x59, 0xf6, 0xc9, 0x1c, 0xa8, 0x56, 
  0xcb, 0x24, 0xe7, 0xcb, 0xb8, 0x63, 0x0c, 0x7c, 0x49, 0xb3, 0x6c, 0x10, 
  0x58, 0xb2, 0xc7, 0xb1, 0x02, 0x58, 0x29, 0x93, 0x66, 0xf2, 0x92, 0x62, 
  0xa6, 0x5d, 0x49, 0x59, 0xb7, 0x00, 0xc4, 0x9f, 0xf9, 0x14, 0xd1, 0xba, 
  0xac, 0x42, 0x3a, 0x51, 0x5e, 0xc0, 0xec, 0xe4, 0x23, 0x86, 0x5b, 0xfe, 
  0x0a, 0x06, 0x62, 0x62, 0xcb, 0x1e, 0x8f, 0x75, 0x8d, 0x88, 0xd3, 0x9b, 
  0x5c, 0x82, 0xbe, 0x64, 0x5b, 0xe0, 0xcb, 0x0a, 0xb2, 0xfa, 0x5a, 0xb8, 
  0xcd, 0xab, 0x31, 0x5b, 0x3e, 0x2d, 0xfe, 0xd3, 0x02, 0xbf, 0x00, 0xe6, 
  0xd4, 0xd8, 0x27, 0x63, 0xdf, 0xdd, 0x2e, 0x7d, 0x12, 0x0a, 0xb5, 0x16, 
  0x97, 0xc0, 0x7d, 0xfe, 0x76, 0xfc, 0x98, 0x03, 0x5e, 0x1c, 0x2b, 0x66, 
  0xe7, 0xbd, 0x46, 0x04, 0x76, 0x33, 0xda, 0xa6, 0x36, 0xde, 0x64, 0xbb, 
  0xbc, 0x6c, 0xff, 0x49, 0xee, 0x9a, 0x13, 0x77, 0x55, 0x8e, 0xf3, 0x00, 
  0xa0, 0x9d, 0x63, 0xa4, 0xbc, 0xa7, 0xf2, 0x5c, 0xad, 0x00, 0xad, 0x94, 
  0x4a, 0x51, 0xc8, 0xda, 0x8e, 0xe4, 0x0e, 0xf1, 0x68, 0xfe, 0xfd, 0x1f, 
  0x2c, 0xad, 0xff, 0xf8, 0x13, 0xa4, 0x58, 0x84, 0x21, 0x3a, 0x17, 0xa0, 
  0x11, 0x42, 0x39, 0xe8, 0x68, 0x01, 0x21, 0xbe, 0x70, 0xa2, 0xb1, 0xfb, 
  0x58, 0xe7, 0xac, 0x31, 0x3f, 0xec, 0xf9, 0x10, 0xa7, 0x94, 0xea, 0x3b, 
  0x9d, 0xb3, 0x30, 0xc7, 0x3a, 0xb0, 0x21, 0x02, 0x14, 0x11, 0xa7, 0xba, 
  0x69, 0x3c, 0xf0, 0x74, 0x23, 0x30, 0x99, 0x66, 0x64, 0x1b, 0x30, 0x97, 
  0xe1, 0x23, 0xb3, 0x87, 0x55, 0xc0, 0xdf, 0xb4, 0x14, 0xfc, 0x48, 0xac, 
  0x83, 0x69, 0xd6, 0x8e, 0x1c, 0x15, 0x42, 0x51, 0xbf, 0xe9, 0xdf, 0x19, 
  0xcc, 0x8b, 0x74, 0xe3, 0x7f, 0x8c, 0xd8, 0xa6, 0x06, 0x79, 0x75, 0x98, 
  0x47, 0x3d, 0x1e, 0xfc, 0xdb, 0x8f, 0xf6, 0x59, 0xc2, 0x68, 0xf9, 0x51, 
  0xf3, 0x02, 0x8b, 0x60, 0x54, 0x60, 0x73, 0x28, 0x37, 0x04, 0xaa, 0xd6, 
  0xbb, 0xe3, 0x5e, 0x06, 0x2c, 0x21, 0xff, 0x63, 0xc4, 0xff, 0xfe, 0xb8, 
  0x3f, 0xfc, 0xe4, 0x27, 0xd7, 0xeb, 0x47, 0xfb, 0x6f, 0x3f, 0x3a, 0xe8, 
  0x75, 0xa5, 0x81, 0x41, 0x08, 0x53, 0x64, 0x0e, 0x4f, 0x90, 0xb1, 0xe2, 
  0x41, 0x48, 0x84, 0x35, 0xfd, 0x65, 0xce, 0xd2, 0xe6, 0xe5, 0xea, 0x12, 
  0x16, 0x38, 0xfb, 0xa8, 0x33, 0x48, 0x3c, 0x54, 0xdf, 0x7d, 0x62, 0xbd, 
  0xb7, 0xf2, 0x30, 0xc1, 0x69, 0xce, 0x79, 0xc7, 0xae, 0xd4, 0xeb, 0x4f, 
  0xb0, 0xbf, 0x65, 0xba, 0x26, 0x4d, 0x42, 0xf4, 0xd2, 0x80, 0xca, 0xcf, 
  0x10, 0x66, 0xce, 0x75, 0x8f, 0x10, 0x4a, 0xfd, 0x20, 0x8d, 0xc3, 0x1c, 
  0x2e, 0x0d, 0x07, 0x38, 0xe5, 0x0a, 0xfc, 0x90, 0x74, 0x97, 0x4f, 0x12, 
  0xfc, 0x27, 0xb8, 0x17, 0x88, 0x11, 0x9d, 0x65, 0x73, 0x1f, 0x82, 0x20, 
  0xf9, 0xab, 0x1a, 0xd1, 0xa0, 0x75, 0xa8, 0x3b, 0xb2, 0x34, 0xf5, 0x8c, 
  0x0f, 0x3c, 0x4a, 0x17, 0x63, 0x31, 0xb1, 0xd5, 0x62, 0x36, 0x1b, 0xed, 
  0xfc, 0x76, 0x5b, 0x33, 0x5c, 0xd2, 0x52, 0xd1, 0x6d, 0xf5, 0x6e, 0x5d, 
  0xad, 0xb2, 0x2c, 0x99, 0x77, 0xa5, 0x47, 0xd1, 0x71, 0x84, 0x69, 0x0b, 
  0x8f, 0x85, 0x23, 0x6f, 0x04, 0x97, 0x8a, 0x8f, 0xae, 0x25, 0x70, 0x65, 
  0x43, 0x7b, 0x1b, 0x57, 0xa2, 0x94, 0x30, 0xf5, 0x0e, 0x1b, 0xe9, 0x97, 
  0x5a, 0x2b, 0x00, 0xb9, 0xdd, 0x11, 0xe3, 0x22, 0xdd, 0x7a, 0xf6, 0xb3, 
  0x48, 0x80, 0xf3, 0x2e, 0x4c, 0x26, 0x55, 0x2e, 0xc5, 0xe6, 0x6b, 0x44, 
  0x33, 0x77, 0x60, 0xff, 0x3b, 0xcb, 0x58, 0x69, 0xf9, 0xb9, 0xda, 0x29, 
  0xbb, 0xc8, 0x8b, 0x3c, 0x16, 0x03, 0x35, 0x02, 0x14, 0xcd, 0x21, 0xd5, 
  0x95, 0xa2, 0x25, 0x03, 0x39, 0x3a, 0x7b, 0xfd, 0xfa, 0xf8, 0xe8, 0xaa, 
  0x5e, 0x13, 0x1c, 0xf7, 0x4b, 0x91, 0x3c, 0x60, 0xce, 0x97, 0x97, 0x35, 
  0x7a, 0x53, 0x0d, 0xfa, 0x6a, 0xc0, 0xf2, 0xf0, 0x84, 0xa0, 0x16, 0xe8, 
  0x4e, 0xb4, 0x5f, 0x2d, 0xdd, 0x84, 0xeb, 0xea, 0x40, 0x46, 0x8d, 0xd9, 
  0x4b, 0xdb, 0xb1, 0x74, 0xf9, 0xaf, 0x68, 0x1c, 0x97, 0xf1, 0x4b, 0x8f, 
  0x01, 0xf9, 0x9c, 0xef, 0x06, 0xa8, 0x05, 0xcf, 0x34, 0xfc, 0xbe, 0x3b, 
  0x3c, 0x31, 0xba, 0x10, 0x49, 0xc8, 0x80, 0xa9, 0xc4, 0x63, 0x45, 0xe7, 
  0x78, 0x97, 0x1d, 0x97, 0x5c, 0xfa, 0x21, 0x2a, 0xf2, 0xb9, 0xa2, 0x9e, 
  0x6c, 0x28, 0x6a, 0x67, 0xfa, 0x20, 0x75, 0xa9, 0x7a, 0x91, 0x4a, 0x1f, 
  0x12, 0x55, 0x00, 0x93, 0x8f, 0xe2, 0x0a, 0x35, 0xb3, 0x0f, 0x18, 0x17, 
  0xd8, 0xb9, 0x8c, 0x7d, 0x45, 0x00, 0xd6, 0x1d, 0x18, 0xfb, 0x61, 0xc4, 
  0xe0, 0x2b, 0x4b, 0xc0, 0x03, 0xf2, 0xd2, 0xf0, 0xe3, 0xad, 0x84, 0x1a, 
  0x46, 0x2f, 0xaa, 0x97, 0xe5, 0x6b, 0xec, 0xe0, 0x64, 0xce, 0xf0, 0x3b, 
  0x7d, 0x2b, 0xaf, 0xd1, 0xf2, 0xb0, 0xa1, 0xdc, 0x86, 0xcb, 0x51, 0x80, 
  0xd5, 0x23, 0xe7, 0x4c, 0x59, 0x89, 0x93, 0x00, 0x04, 0x45, 0x5c, 0xde, 
  0x86, 0x9d, 0x74, 0x61, 0x56, 0xd1, 0x3e, 0x2e, 0x5d, 0x2b, 0xd6, 0x48, 
  0x7d, 0x34, 0xa3, 0x8d, 0x7b, 0xd1, 0x0c, 0xe7, 0x6c, 0x5d, 0x24, 0x2e, 
  0xd3, 0xa1, 0x75, 0xc1, 0xc8, 0xd7, 0x23, 0xae, 0xc8, 0xc4, 0x49, 0x10, 
  0x12, 0x35, 0x6b, 0x91, 0x4c, 0xea, 0xe7, 0xb1, 0x97, 0x69, 0x0d, 0x4e, 
  0xce, 0xbb, 0x5b, 0xb0, 0x91, 0x87, 0xc8, 0xb6, 0xb8, 0xed, 0xb7, 0xdf, 
  0x64, 0xe9, 0x3b, 0xb8, 0x3e, 0xdb, 0x71, 0xd9, 0xe7, 0xf6, 0xda, 0xe6, 
  0x51, 0xf5, 0xf6, 0x9f, 0x1c, 0x8c, 0xf6, 0x3f, 0xfd, 0x8c, 0xa5, 0xc1, 
  0xfd, 0x5e, 0x38, 0x36, 0x29, 0xbf, 0xc5, 0xf9, 0x21, 0x1d, 0xc7, 0xca, 
  0x9f, 0xae, 0xad, 0x0e, 0xfb, 0x55, 0xd4, 0x71, 0x7f, 0x84, 0x7d, 0x2e, 
  0xd6, 0xa3, 0xc0, 0x0e, 0x55, 0xeb, 0xd5, 0x8c, 0x62, 0x4d, 0x15, 0x5d, 
  0xcf, 0x04, 0x90, 0xbd, 0xa4, 0x6e, 0x9d, 0x96, 0x50, 0x31, 0x18, 0xd0, 
  0x1d, 0x17, 0xbb, 0x46, 0xcc, 0x6d, 0x99, 0x4e, 0x6e, 0xbb, 0xfb, 0x17, 
  0x2f, 0x13, 0xfa, 0xe8, 0x97, 0x16, 0x0c, 0xed, 0x7a, 0xfb, 0x85, 0x66, 
  0xee, 0x3c, 0x6b, 0x15, 0xfa, 0x93, 0x0c, 0xd2, 0x17, 0x6d, 0xe8, 0x69, 
  0x1c, 0x25, 0x71, 0x92, 0x3b, 0xb8, 0x95, 0x80, 0x25, 0xfc, 0xad, 0xe6, 
  0x55, 0x8f, 0xcb, 0x20, 0x7c, 0xd0, 0x87, 0x2b, 0xe6, 0x59, 0x2d, 0xaf, 
  0x04, 0x55, 0x6a, 0x3a, 0x92, 0xca, 0xff, 0x7f, 0x36, 0x87, 0xee, 0x8e, 
  0x98, 0xed, 0x99, 0x9d, 0xdb, 0x39, 0xb3, 0x20, 0xc6, 0xc5, 0x53, 0x0b, 
  0x6b, 0x9e, 0xb6, 0x4b, 0x3b, 0xc4, 0x61, 0x7c, 0x69, 0x30, 0xc2, 0xff, 
  0x26, 0xa6, 0x85, 0xf8, 0x46, 0x8e, 0x73, 0xe5, 0xfe, 0x37, 0x30, 0x2c, 
  0x86, 0xc6, 0x45, 0xba, 0x52, 0x5c, 0x8c, 0xd3, 0x0a, 0xca, 0x42, 0x10, 
  0x73, 0x12, 0xb0, 0x6c, 0x7a, 0xbc, 0x33, 0x89, 0x26, 0xc8, 0x81, 0xe7, 
  0xa7, 0xff, 0xfb, 0x0d, 0x17, 0x13, 0xb4, 0x26, 0xf2, 0x7a, 0xc4, 0xc5, 
  0xa8, 0x1d, 0x79, 0xa8, 0x01, 0xec, 0x16, 0xba, 0x62, 0x76, 0x35, 0xc1, 
  0x6d, 0x94, 0x56, 0x3c, 0x8c, 0x59, 0xbb, 0x4a, 0x00, 0x75, 0x50, 0xeb, 
  0x51, 0xaa, 0x3b, 0x5a, 0x49, 0x56, 0x11, 0x91, 0x27, 0xbf, 0x8b, 0xa2, 
  0xff, 0xc6, 0x52, 0x6c, 0x0a, 0x71, 0xb5, 0xb7, 0xe8, 0xa0, 0x7e, 0x79, 
  0xfc, 0xf2, 0xec, 0xe2, 0xb8, 0xee, 0x5b, 0x64, 0x4f, 0x41, 0x0c, 0xec, 
  0xba, 0xce, 0xe0, 0x8a, 0x2b, 0x8b, 0xc2, 0xb4, 0x21, 0xc0, 0x33, 0x15, 
  0xc9, 0xc3, 0x91, 0x56, 0xd1, 0x04, 0xae, 0xf4, 0x6a, 0xc2, 0xe8, 0x6a, 
  0xb3, 0x55, 0x53, 0x04, 0xb1, 0x9e, 0xea, 0x10, 0x20, 0x8b, 0xa0, 0x1a, 
  0x11, 0x57, 0x7d, 0xe4, 0x90, 0xcf, 0x91, 0x65, 0xd1, 0x76, 0x6a, 0x03, 
  0x92, 0x53, 0x1b, 0x2f, 0x10, 0xde, 0xc6, 0x68, 0x49, 0x36, 0x22, 0x09, 
  0x1f, 0x62, 0x7c, 0x57, 0x85, 0xd7, 0x6f, 0x2b, 0xe3, 0x3a, 0x4c, 0xec, 
  0x56, 0x50, 0x38, 0x6e, 0x16, 0xde, 0x06, 0x06, 0xb5, 0xa5, 0x58, 0x32, 
  0x1d, 0x8c, 0x3b, 0x48, 0xa9, 0xb5, 0xce, 0xe5, 0x04, 0x6a, 0x5c, 0x60, 
  0x58, 0x15, 0xb2, 0x33, 0x60, 0x39, 0x1e, 0xa3, 0x72, 0xee, 0xbf, 0x0e, 
  0x51, 0x50, 0xc3, 0x58, 0x7d, 0x10, 0x4c, 0x36, 0xa8, 0x98, 0x2a, 0x95, 
  0x31, 0x02, 0x3c, 0xd9, 0x10, 0x31, 0xae, 0x23, 0x83, 0xc4, 0x19, 0xc4, 
  0xc6, 0x49, 0x98, 0x76, 0x41, 0x0c, 0x41, 0x51, 0x62, 0x51, 0xf2, 0xc3, 
  0xa7, 0xa8, 0x77, 0x06, 0xc5, 0x84, 0x58, 0xb3, 0x1b, 0xd0, 0x65, 0x43, 
  0x70, 0xd9, 0x87, 0x35, 0x0e, 0x87, 0x9f, 0xdb, 0x82, 0x95, 0x2d, 0x76, 
  0xb1, 0x26, 0xd7, 0xb4, 0x1a, 0xf8, 0xf1, 0xf9, 0xa6, 0xac, 0xba, 0x1d, 
  0x92, 0x62, 0x88, 0x49, 0x27, 0x08, 0x14, 0x65, 0x97, 0x7e, 0x64, 0x80, 
  0xc6, 0xdb, 0xb8, 0x19, 0x81, 0xf6, 0x55, 0x70, 0x24, 0x4e, 0xcb, 0xd5, 
  0x2d, 0x1a, 0xef, 0x8e, 0xa1, 0xa7, 0xa0, 0xc5, 0xfd, 0xd1, 0x3e, 0x32, 
  0xdc, 0x5c, 0x80, 0xda, 0x28, 0xba, 0xe0, 0xe6, 0x10, 0xcc, 0xde, 0x26, 
  0x80, 0x30, 0x47, 0xd2, 0x6b, 0xc2, 0x44, 0x53, 0xec, 0x6a, 0x6f, 0x91, 
  0xc5, 0xde, 0xf0, 0xf1, 0x93, 0x27, 0x35, 0x7d, 0x38, 0xe4, 0xc5, 0x9f, 
  0xec, 0xed, 0x49, 0x4c, 0x42, 0xf3, 0x35, 0xfa, 0x62, 0xf8, 0x04, 0x2f, 
  0xd6, 0x5f, 0x53, 0x49, 0x71, 0xe3, 0x7b, 0x43, 0xfe, 0xa6, 0xa3, 0x3b, 
  0xdc, 0x2f, 0x1b, 0xdf, 0x7a, 0xb2, 0xe1, 0x2d, 0x09, 0x20, 0xc5, 0x5a, 
  0x69, 0x2d, 0x4d, 0x79, 0xb2, 0x7d, 0x38, 0x6b, 0x87, 0xec, 0x3e, 0x6e, 
  0x7b, 0x8c, 0xf6, 0x86, 0x7b, 0x83, 0xe1, 0x7e, 0xbd, 0x0b, 0xf3, 0x5c, 
  0x69, 0x58, 0xbb, 0x48, 0xf1, 0xe2, 0xf0, 0xe5, 0x9e, 0x37, 0x76, 0xc1, 
  0xd2, 0xc9, 0xf6, 0x1f, 0x76, 0xb6, 0xbf, 0xde, 0xe9, 0x5a, 0xb6, 0x3f, 
  0xee, 0xed, 0x0d, 0x3e, 0xe5, 0x9f, 0x4f, 0x9e, 0x6c, 0x6c, 0xc1, 0x8f, 
  0xe1, 0x91, 0xad, 0x49, 0x6d, 0x9a, 0xd4, 0x4e, 0x47, 0xeb, 0xfb, 0xd4, 
  0xea, 0xfe, 0x93, 0x27, 0x03, 0xee, 0xe5, 0x93, 0x0f, 0x6a, 0x9d, 0x66, 
  0x78, 0x9f, 0x47, 0x0e, 0xc2, 0x21, 0x91, 0x46, 0x40, 0x48, 0xeb, 0x76, 
  0x51, 0xe2, 0x20, 0xfc, 0x03, 0xf4, 0xd7, 0x98, 0x23, 0xfd, 0x19, 0x3d, 
  0x97, 0x5a, 0xb8, 0x1e, 0x3a, 0x38, 0x28, 0xa7, 0x57, 0x97, 0x8a, 0xd9, 
  0xba, 0xb2, 0x56, 0xc7, 0xcd, 0x56, 0x13, 0x64, 0xca, 0x05, 0x5a, 0x7a, 
  0x90, 0xe0, 0x20, 0xd9, 0xde, 0x2a, 0x8c, 0xc5, 0xf7, 0xb1, 0xd5, 0xd5, 
  0x84, 0x7e, 0xeb, 0x4e, 0x8b, 0x5d, 0x86, 0xa4, 0xef, 0x05, 0x45, 0x46, 
  0x34, 0x19, 0x31, 0xf5, 0x59, 0xab, 0xe2, 0x5f, 0x9e, 0x22, 0x14, 0x4e, 
  0x6c, 0xf3, 0x06, 0x9d, 0x12, 0xe8, 0x9e, 0x01, 0x1e, 0x88, 0x02, 0x93, 
  0x0f, 0x2c, 0xc8, 0xc9, 0x14, 0x04, 0xc3, 0x8d, 0x92, 0xea, 0xbd, 0x2e, 
  0x73, 0xd5, 0x8d, 0x9d, 0x8f, 0xae, 0x70, 0x00, 0x0b, 0x66, 0xd1, 0x02, 
  0xdd, 0xfe, 0xb6, 0x4e, 0xcc, 0xf5, 0x5a, 0xae, 0x89, 0x57, 0xbe, 0x8b, 
  0xfa, 0x08, 0xc3, 0x71, 0x77, 0x6d, 0x59, 0xe5, 0xcb, 0x3e, 0x2d, 0xb1, 
  0x21, 0x40, 0xb3, 0x87, 0x5d, 0xee, 0x36, 0xbe, 0x30, 0xec, 0xc6, 0x90, 
  0xb3, 0x4e, 0x6d, 0x2f, 0x38, 0x3f, 0x65, 0xca, 0x85, 0x9b, 0xbd, 0xb0, 
  0x37, 0x4d, 0x96, 0x08, 0x71, 0xb1, 0x50, 0x47, 0xd2, 0xb9, 0x2f, 0x5e, 
  0x1e, 0xd5, 0xaa, 0xb0, 0x8e, 0xfe, 0xdd, 0x92, 0xa1, 0x67, 0x9e, 0x17, 
  0xde, 0xda, 0xd2, 0x51, 0x0b, 0xbc, 0x89, 0xb0, 0xe2, 0xf3, 0x50, 0xad, 
  0x2a, 0x7d, 0xb0, 0x21, 0x52, 0x4f, 0xb5, 0x29, 0xc7, 0xa8, 0x7b, 0x04, 
  0x23, 0xab, 0xe2, 0xc5, 0xb2, 0xc3, 0xbc, 0x22, 0x72, 0x90, 0x06, 0x00, 
  0xb5, 0xf0, 0x51, 0x60, 0xaf, 0xbf, 0xa3, 0x8b, 0x59, 0x6b, 0xcd, 0x78, 
  0x8c, 0x3a, 0x31, 0xfc, 0x78, 0xb8, 0x2d, 0x90, 0x4a, 0x47, 0x46, 0xab, 
  0xeb, 0xfb, 0x9f, 0x57, 0xb1, 0x25, 0xb0, 0x67, 0xda, 0x0e, 0x27, 0x30, 
  0x97, 0x16, 0x87, 0xec, 0xb3, 0x06, 0x1e, 0x2c, 0x6d, 0x49, 0x4b, 0x2b, 
  0x18, 0x75, 0xcd, 0x9b, 0x4d, 0x80, 0xeb, 0x38, 0xbb, 0x99, 0xe3, 0x7c, 
  0x5e, 0x48, 0x15, 0x69, 0x0e, 0x38, 0x85, 0xa9, 0xe1, 0x1a, 0x1a, 0x96, 
  0x8a, 0xda, 0x85, 0xc0, 0x9c, 0xb6, 0x9c, 0xa5, 0x25, 0x7b, 0xa8, 0xd9, 
  0x24, 0xf2, 0xca, 0x2b, 0xcf, 0x8b, 0xd5, 0x87, 0x7b, 0xff, 0xfe, 0x09, 
  0x2b, 0x42, 0xbd, 0xf9, 0xe1, 0x25, 0x4f, 0x8f, 0xc6, 0x3c, 0xec, 0x1a, 
  0xa0, 0xa4, 0x40, 0xfb, 0x78, 0x92, 0x21, 0xa7, 0x1a, 0xa8, 0xa2, 0x2f, 
  0x61, 0x30, 0x3c, 0x5b, 0x29, 0x88, 0xad, 0x93, 0x69, 0x57, 0x51, 0x4c, 
  0x05, 0xdc, 0xef, 0xd7, 0x0c, 0xbb, 0xf6, 0xc3, 0x08, 0x25, 0xac, 0xb2, 
  0x22, 0x71, 0x67, 0x43, 0xd5, 0x98, 0x0b, 0x8b, 0xe8, 0x64, 0xf1, 0x5e, 
  0x6a, 0xc4, 0x6b, 0x05, 0x72, 0x7e, 0xa5, 0xb3, 0x70, 0xcc, 0x26, 0xaf, 
  0x48, 0x18, 0x26, 0x08, 0xb9, 0x0c, 0x69, 0x57, 0x12, 0x6c, 0xc9, 0x85, 
  0x37, 0xfb, 0x03, 0x2b, 0xfd, 0xbc, 0x21, 0x55, 0xb2, 0x5d, 0x01, 0xbd, 
  0x26, 0x4e, 0x72, 0xd4, 0x5d, 0xc6, 0xd5, 0xe8, 0xd2, 0xac, 0xea, 0xaa, 
  0x7a, 0xa1, 0x18, 0x26, 0x0e, 0xc4, 0xe1, 0x06, 0xe8, 0x26, 0xe0, 0x5e, 
  0xd3, 0x64, 0x02, 0x12, 0xb5, 0x40, 0xd3, 0xb6, 0x88, 0xc8, 0xf0, 0xc7, 
  0x63, 0x86, 0x4d, 0x4e, 0x7f, 0x4b, 0x30, 0xe1, 0x8a, 0x88, 0xae, 0x4a, 
  0xe6, 0x59, 0x52, 0x0d, 0xb5, 0xe9, 0x67, 0x67, 0xe7, 0x57, 0xcf, 0xef, 
  0xe2, 0x56, 0x5a, 0xed, 0x39, 0x57, 0x86, 0xcd, 0x2d, 0xb3, 0xcf, 0x85, 
  0xbb, 0xc8, 0xcb, 0xde, 0xc9, 0xc7, 0x91, 0x69, 0xc2, 0xec, 0xdb, 0x38, 
  0x06, 0xfa, 0x32, 0x5d, 0x66, 0x2d, 0x43, 0xcb, 0xd5, 0xd5, 0x0f, 0xe7, 
  0xc7, 0xcf, 0x9f, 0x31, 0x32, 0xff, 0xe7, 0x52, 0x1c, 0x03, 0x4c, 0x4e, 
  0x81, 0xfa, 0x39, 0xfe, 0xaa, 0x7d, 0x12, 0xbf, 0x7f, 0x71, 0x72, 0x79, 
  0x7e, 0x7a, 0x76, 0xf4, 0xfc, 0xd9, 0xf7, 0x06, 0x83, 0x10, 0xbc, 0xeb, 
  0x3e, 0x73, 0xa1, 0xac, 0xed, 0x98, 0xcd, 0xe3, 0xef, 0xde, 0x1e, 0xbf, 
  0xfe, 0xf6, 0xf9, 0xb3, 0xbb, 0xb8, 0x18, 0xf0, 0x94, 0xb5, 0x2c, 0x47, 
  0xd6, 0x19, 0x8e, 0x14, 0xac, 0xda, 0x15, 0x03, 0xba, 0x00, 0xdd, 0xed, 
  0x01, 0xad, 0x41, 0xc2, 0xfb, 0x5c, 0x08, 0xa4, 0xe9, 0xb7, 0xbe, 0xd4, 
  0x6c, 0xc8, 0x6e, 0x85, 0xce, 0x5b, 0xc1, 0xa7, 0x60, 0xe9, 0x6f, 0x2e, 
  0x4e, 0x8d, 0xb6, 0x0b, 0x8d, 0x28, 0x0d, 0xac, 0xeb, 0x06, 0xb5, 0xf2, 
  0x80, 0x91, 0x8d, 0x1a, 0x18, 0x84, 0xf5, 0xad, 0x0c, 0xf8, 0x4a, 0xe8, 
  0xa5, 0x6e, 0xed, 0x1f, 0x75, 0xc4, 0xb5, 0xfa, 0xa0, 0x4b, 0x24, 0x48, 
  0x4a, 0x44, 0x00, 0x4d, 0x8c, 0xa8, 0x95, 0x3d, 0xea, 0xbb, 0x01, 0xb2, 
  0x4e, 0x47, 0xa1, 0x7a, 0x1f, 0x6a, 0xa7, 0x29, 0x09, 0x7c, 0xa9, 0x13, 
  0xb9, 0xdc, 0x61, 0xd6, 0x18, 0x95, 0xf9, 0x21, 0x6d, 0x7a, 0x5d, 0x1e, 
  0x06, 0xc1, 0x3b, 0x2c, 0x82, 0xc8, 0x04, 0x4e, 0xcd, 0xbc, 0x75, 0x63, 
  0x2b, 0x54, 0x62, 0xdd, 0x9c, 0xa6, 0x63, 0x2c, 0xa1, 0x71, 0x5b, 0x3a, 
  0x15, 0x0e, 0x69, 0x71, 0x57, 0xa6, 0xa9, 0xb5, 0x20, 0x9d, 0xa9, 0x71, 
  0x36, 0xa7, 0xd3, 0xe0, 0xbd, 0x98, 0xa7, 0x10, 0x7f, 0xb5, 0x68, 0x53, 
  0x45, 0x1b, 0x3e, 0x99, 0x75, 0xd5, 0x94, 0xf4, 0xc5, 0x8b, 0xd9, 0x5f, 
  0x01, 0x0f, 0x15, 0x97, 0x38, 0x08, 0xc1, 0x8d, 0xcf, 0xdf, 0x5c, 0x6d, 
  0x28, 0x5f, 0xdc, 0x7d, 0x86, 0x83, 0x54, 0xea, 0x3a, 0xf7, 0xeb, 0x0d, 
  0x7b, 0xd1, 0x76, 0xac, 0x66, 0x35, 0x18, 0x06, 0x76, 0x9c, 0x79, 0x11, 
  0x09, 0x9e, 0x9b, 0xe1, 0xa6, 0xe2, 0x00, 0x39, 0xa3, 0xd5, 0xd3, 0x97, 
  0x62, 0x19, 0x10, 0x57, 0xf3, 0x67, 0x03, 0x2b, 0xf9, 0x53, 0x35, 0xb2, 
  0xcf, 0x42, 0x06, 0xd5, 0x25, 0x40, 0x34, 0xc5, 0xaa, 0x78, 0x13, 0x90, 
  0x40, 0x98, 0xba, 0xf6, 0x99, 0x62, 0x99, 0x20, 0x83, 0xd6, 0x60, 0xfe, 
  0x7c, 0x06, 0x29, 0x84, 0xc4, 0xe1, 0x55, 0x87, 0xbd, 0x41, 0x61, 0x2a, 
  0xd8, 0x67, 0xe9, 0xa8, 0x35, 0x34, 0xb8, 0x8d, 0xa2, 0x63, 0x7e, 0x60, 
  0x78, 0x15, 0xfd, 0x57, 0x47, 0x51, 0xa3, 0x65, 0x9c, 0x16, 0x81, 0x3a, 
  0x71, 0xaf, 0x39, 0xb0, 0xba, 0xfd, 0x92, 0xe6, 0x9c, 0x2b, 0x4a, 0xe5, 
  0xa8, 0xb3, 0x8e, 0xbc, 0xe0, 0x41, 0x39, 0xd7, 0x77, 0xcf, 0xc0, 0x0d, 
  0x7b, 0xae, 0x2a, 0xe9, 0x95, 0xcb, 0xde, 0x1e, 0x20, 0x80, 0xac, 0x15, 
  0x70, 0x0a, 0xc3, 0x99, 0x1e, 0x44, 0x9e, 0xb6, 0xf6, 0xbe, 0xa8, 0x97, 
  0x26, 0x86, 0x0b, 0x4f, 0x37, 0xbd, 0xa3, 0xb8, 0x53, 0xdd, 0x08, 0x87, 
  0x1c, 0xeb, 0x1a, 0xd6, 0x62, 0x59, 0xad, 0xf9, 0x1a, 0xdf, 0xc0, 0xc2, 
  0x95, 0xd9, 0x80, 0xa1, 0x38, 0x38, 0xf8, 0x6e, 0x90, 0x4a, 0xf0, 0x49, 
  0xe0, 0x6f, 0xfc, 0x9d, 0x07, 0xb6, 0x3f, 0xe0, 0x7f, 0x0f, 0xfe, 0xd1, 
  0x83, 0x86, 0xe2, 0xf1, 0x82, 0x94, 0x8d, 0xb6, 0xce, 0x2b, 0x37, 0x6c, 
  0xde, 0xe1, 0x0e, 0x67, 0x30, 0x07, 0x6d, 0x6f, 0xe8, 0x16, 0xbd, 0xf6, 
  0xd2, 0xc5, 0xf5, 0x8f, 0xfb, 0x43, 0x52, 0xf2, 0xf6, 0x7e, 0x1a, 0x2d, 
  0x79, 0x99, 0xd9, 0x4d, 0x42, 0x7d, 0xb2, 0xb3, 0x64, 0x99, 0x4e, 0x58, 
  0x2d, 0x5a, 0xb4, 0x6a, 0x94, 0x67, 0x69, 0x0c, 0xdc, 0x22, 0x19, 0xd4, 
  0x6e, 0x20, 0xc1, 0x70, 0xad, 0xa4, 0x0d, 0x7c, 0xde, 0x82, 0x73, 0x62, 
  0x84, 0x6b, 0x47, 0xf2, 0x24, 0x17, 0xcb, 0xc3, 0x41, 0x82, 0xf6, 0x44, 
  0x6d, 0x4a, 0x7e, 0xe3, 0x14, 0x02, 0x7c, 0xb3, 0x5b, 0x09, 0x0b, 0x87, 
  0xe1, 0x67, 0x60, 0xd9, 0x74, 0x08, 0x14, 0x4f, 0x04, 0x49, 0x9f, 0xcb, 
  0x15, 0x06, 0xc1, 0x7b, 0x1d, 0x95, 0x9d, 0x5c, 0x09, 0x12, 0x73, 0xe4, 
  0xe2, 0xe0, 0x82, 0x27, 0x30, 0x17, 0xe0, 0xa2, 0xc6, 0x96, 0x11, 0xce, 
  0x74, 0xda, 0xe1, 0x13, 0x45, 0xd9, 0x1d, 0x0d, 0xe2, 0x4a, 0xc4, 0x0f, 
  0xa1, 0x22, 0xd0, 0xaf, 0x2c, 0x8b, 0x6c, 0x86, 0xa1, 0xd1, 0x55, 0xb7, 
  0x12, 0xce, 0xff, 0x6f, 0xed, 0x7d, 0x0a, 0x83, 0xc5, 0x30, 0x5b, 0xb2, 
  0xba, 0x2e, 0x95, 0x40, 0xb0, 0xcf, 0x13, 0xea, 0xa2, 0x34, 0x4d, 0xb1, 
  0xe9, 0xc7, 0x49, 0xde, 0x89, 0xdc, 0x00, 0xab, 0x3b, 0x74, 0xf3, 0x1b, 
  0xf6, 0xc2, 0xf2, 0x18, 0x0e, 0x2f, 0x8f, 0x4e, 0x4e, 0x6a, 0x3e, 0x7b, 
  0x5e, 0xca, 0x56, 0x5a, 0x5a, 0xe5, 0xf2, 0x96, 0x4b, 0x46, 0x0c, 0x04, 
  0x82, 0x96, 0x85, 0xc8, 0xc0, 0x46, 0x81, 0x70, 0x71, 0x8e, 0xaa, 0x92, 
  0x7a, 0x63, 0xad, 0x15, 0x83, 0xa7, 0x82, 0x99, 0xf2, 0x2a, 0x63, 0x29, 
  0x82, 0x83, 0xd0, 0x6e, 0x56, 0xc4, 0x89, 0xcb, 0x5f, 0x3b, 0x3f, 0xe1, 
  0x01, 0x5a, 0x73, 0xa5, 0x86, 0x9f, 0xf1, 0xbf, 0xae, 0x86, 0xd6, 0x46, 
  0xbc, 0x0f, 0xa9, 0x3a, 0x0c, 0xaa, 0xf2, 0x15, 0x92, 0x43, 0x98, 0x4b, 
  0xc4, 0xc4, 0x74, 0x82, 0x19, 0x2a, 0x2e, 0xb2, 0x40, 0xec, 0x06, 0x91, 
  0xfb, 0x1c, 0x16, 0x67, 0x90, 0xbc, 0x3e, 0x20, 0xbd, 0xab, 0x4a, 0x7b, 
  0xaa, 0x58, 0x14, 0x2c, 0x09, 0xfa, 0xee, 0xd9, 0x01, 0xec, 0x0b, 0x62, 
  0x05, 0xc5, 0x7f, 0xca, 0xae, 0x6a, 0x3f, 0xa9, 0xa6, 0x33, 0x4a, 0xf1, 
  0xde, 0x0e, 0x10, 0xb0, 0x1a, 0x12, 0x32, 0x84, 0x06, 0x05, 0x65, 0x90, 
  0x6a, 0xd4, 0xf5, 0x30, 0x15, 0xb1, 0x30, 0xb5, 0x22, 0x54, 0xe5, 0xc1, 
  0x46, 0x70, 0x1b, 0x96, 0x87, 0xef, 0xde, 0x55, 0x86, 0x8f, 0xcc, 0x8f, 
  0xcd, 0x66, 0xad, 0xa6, 0xa5, 0xcf, 0x1b, 0xb9, 0x7e, 0xbb, 0xdc, 0x95, 
  0x37, 0x16, 0x05, 0xf2, 0xcb, 0x09, 0x22, 0xcc, 0x1e, 0x09, 0x10, 0xa2, 
  0xa3, 0x73, 0x09, 0x78, 0xc0, 0x3a, 0xb4, 0x83, 0x8c, 0x2d, 0x8e, 0x93, 
  0x66, 0xc4, 0xea, 0x65, 0xb0, 0x9f, 0xe1, 0x86, 0x6e, 0x4e, 0x52, 0xa3, 
  0x0d, 0xfe, 0xb0, 0x2d, 0xfd, 0xf5, 0xaa, 0x20, 0xf1, 0xd0, 0xba, 0xea, 
  0x6a, 0x5e, 0xd6, 0xa0, 0x41, 0x2c, 0xf6, 0x6d, 0xd4, 0x2c, 0xf5, 0xaa, 
  0x75, 0x66, 0x50, 0xf1, 0x75, 0x83, 0x66, 0xed, 0xdc, 0xe3, 0x01, 0xa8, 
  0x33, 0x8b, 0xce, 0x30, 0xfe, 0x77, 0xba, 0x36, 0x6b, 0x7a, 0x98, 0x11, 
  0x2b, 0x02, 0x87, 0x1c, 0x62, 0x66, 0x1d, 0x59, 0x56, 0x3c, 0x43, 0xd1, 
  0x55, 0xde, 0x01, 0x13, 0x5d, 0xe4, 0x73, 0x05, 0x21, 0xc7, 0x02, 0x02, 
  0xe8, 0xa4, 0x34, 0x83, 0xc1, 0x20, 0x3c, 0x1f, 0x5c, 0xd2, 0xa2, 0x0b, 
  0x13, 0x7c, 0x78, 0xd6, 0xc6, 0xf5, 0x1c, 0xde, 0xed, 0x22, 0x78, 0x72, 
  0x9c, 0xb7, 0x4e, 0xb9, 0xe6, 0x38, 0x49, 0x06, 0x9f, 0xf2, 0x12, 0x89, 
  0xe3, 0xd7, 0xe7, 0x77, 0xab, 0x78, 0x7e, 0x1b, 0xf3, 0x4e, 0x8f, 0xa2, 
  0x57, 0x58, 0xbf, 0x96, 0xcb, 0x08, 0x26, 0x19, 0x61, 0x30, 0xe3, 0xd5, 
  0xf5, 0x35, 0x6a, 0x7b, 0x9c, 0xa2, 0xa4, 0x6b, 0xa9, 0x48, 0x67, 0x72, 
  0xf2, 0xfa, 0x9f, 0xf7, 0x21, 0x72, 0x36, 0xed, 0x22, 0x52, 0xfd, 0x00, 
  0x77, 0x92, 0x82, 0x5b, 0x0f, 0xa2, 0xfe, 0x33, 0x7d, 0x56, 0xbe, 0x25, 
  0x65, 0x2b, 0xa1, 0x21, 0x38, 0xf4, 0xeb, 0x4e, 0x20, 0xde, 0x32, 0xba, 
  0x49, 0x89, 0xf1, 0x72, 0x52, 0x6c, 0xbd, 0xa6, 0x8f, 0x43, 0x0d, 0x32, 
  0x14, 0xbc, 0x0d, 0xe0, 0x6b, 0xfd, 0x3f, 0x58, 0xa7, 0xf1, 0xd4, 0x55, 
  0xb7, 0xe6, 0x6b, 0x19, 0x8a, 0x64, 0x3a, 0xf5, 0xfd, 0x77, 0x83, 0xd6, 
  0x58, 0x98, 0xf9, 0x2c, 0xaa, 0x93, 0x52, 0x22, 0x48, 0x90, 0x2e, 0xab, 
  0xbd, 0xb3, 0x2e, 0x99, 0x5c, 0x6e, 0x83, 0x1a, 0x1c, 0xaa, 0xbf, 0xe4, 
  0x94, 0xb0, 0xd4, 0xf6, 0xc3, 0x20, 0x0e, 0xed, 0x39, 0xcc, 0x36, 0x60, 
  0x46, 0x0b, 0x68, 0x2f, 0xd4, 0xd8, 0x7a, 0x82, 0x67, 0x59, 0x21, 0x16, 
  0x5d, 0x53, 0x03, 0x59, 0xba, 0xe8, 0x08, 0x0d, 0x4d, 0x32, 0x44, 0x3a, 
  0x69, 0xda, 0xd7, 0xc0, 0xf9, 0x15, 0x55, 0xbe, 0x37, 0xa1, 0x95, 0x95, 
  0x1f, 0x13, 0xa5, 0x5a, 0x8c, 0x83, 0x25, 0xab, 0x5f, 0xbf, 0xa8, 0x90, 
  0x52, 0x6c, 0x40, 0xf7, 0xdf, 0xee, 0xba, 0xa0, 0xe1, 0x76, 0x5a, 0x83, 
  0x00, 0x5a, 0xd6, 0x6a, 0x91, 0x8e, 0x05, 0xd9, 0x17, 0x1c, 0xd0, 0x50, 
  0xa5, 0x22, 0x33, 0x9a, 0x6f, 0x88, 0x33, 0x4e, 0x61, 0xaa, 0x28, 0x3b, 
  0x81, 0x65, 0xcc, 0xd7, 0x25, 0xe8, 0x4c, 0x1e, 0x7d, 0x36, 0x11, 0x41, 
  0xb2, 0x51, 0x44, 0xaf, 0x19, 0x8d, 0xe1, 0x8c, 0xf5, 0x2c, 0x43, 0x21, 
  0x17, 0xe7, 0x51, 0x21, 0x40, 0xff, 0x6b, 0x8d, 0xa4, 0x86, 0xd3, 0x89, 
  0x93, 0x3e, 0xd9, 0xfe, 0xd2, 0x51, 0xfd, 0x0c, 0x9e, 0xee, 0x77, 0xc9, 
  0x64, 0x55, 0x6d, 0x2c, 0xe8, 0x67, 0xab, 0x2b, 0x63, 0x8c, 0xb6, 0x71, 
  0x3e, 0x4a, 0x39, 0x0f, 0xbd, 0x73, 0x0b, 0x20, 0x7c, 0xda, 0xdb, 0x11, 
  0x09, 0xae, 0x03, 0xed, 0x2f, 0x88, 0x32, 0x64, 0xf2, 0xb7, 0x51, 0x1b, 
  0x98, 0x05, 0x1f, 0x00, 0x8d, 0xe5, 0xee, 0xea, 0x9f, 0xf6, 0xbe, 0x10, 
  0xdd, 0xb8, 0xd1, 0xf7, 0x4b, 0xf1, 0x2a, 0xf9, 0xae, 0x99, 0x25, 0xb7, 
  0xea, 0x7c, 0x72, 0x3c, 0x85, 0x39, 0xa0, 0xca, 0xae, 0xbe, 0x73, 0x8e, 
  0xc8, 0x0e, 0x48, 0xe2, 0x9e, 0x48, 0x02, 0xf6, 0x5f, 0x8e, 0xc9, 0x26, 
  0x71, 0x1f, 0x9b, 0xdf, 0xbc, 0x4f, 0x5e, 0x24, 0x33, 0xe1, 0x16, 0xa6, 
  0x82, 0x9b, 0x91, 0x4f, 0xa2, 0x12, 0x62, 0x49, 0x66, 0x04, 0x1c, 0x3f, 
  0xf0, 0xfa, 0x56, 0x2d, 0x53, 0x90, 0x06, 0x56, 0x78, 0x9b, 0x8d, 0x56, 
  0xad, 0x44, 0x77, 0x62, 0x31, 0xd6, 0x38, 0x67, 0xe1, 0x19, 0xed, 0x10, 
  0x0a, 0x57, 0xd7, 0x52, 0x0d, 0xcb, 0xc8, 0xe3, 0x5f, 0xa4, 0xef, 0xcc, 
  0x36, 0x5f, 0xbf, 0x54, 0x36, 0x96, 0xf2, 0xd5, 0x6a, 0xb2, 0xb5, 0x62, 
  0xc7, 0xde, 0x3a, 0x48, 0x6a, 0x43, 0x4f, 0xbe, 0xeb, 0x0d, 0xa2, 0x6e, 
  0x54, 0x59, 0xc5, 0xf1, 0x52, 0x20, 0x0e, 0xf5, 0xb5, 0x4f, 0x56, 0xac, 
  0x12, 0x88, 0x15, 0x08, 0xb9, 0x0c, 0x7a, 0x5b, 0xb6, 0x80, 0x89, 0x7a, 
  0x5f, 0x98, 0x5a, 0xd2, 0x8b, 0x2c, 0x88, 0xc7, 0x95, 0xbb, 0x80, 0x4c, 
  0xe7, 0x60, 0xc2, 0x22, 0x5d, 0x9d, 0xae, 0x12, 0x31, 0x52, 0xc9, 0x03, 
  0x4c, 0x15, 0x91, 0xc4, 0xbd, 0x2f, 0x86, 0xbd, 0x6e, 0x72, 0xf6, 0x31, 
  0xdb, 0x5c, 0xd6, 0x87, 0xef, 0x14, 0xb5, 0x26, 0x98, 0xda, 0x24, 0x3b, 
  0xd0, 0x70, 0xaf, 0x99, 0x5f, 0x70, 0x35, 0x26, 0x9e, 0x58, 0xad, 0xb4, 
  0xce, 0x02, 0xbf, 0x86, 0xe4, 0x7e, 0xe6, 0x6e, 0x58, 0x7f, 0xd9, 0x2c, 
  0x1d, 0x3c, 0x73, 0xd4, 0x16, 0xce, 0x5e, 0x5a, 0x0d, 0xa4, 0x54, 0x8c, 
  0x55, 0x6f, 0xe3, 0xc0, 0xbf, 0x79, 0x7e, 0x3f, 0x8a, 0x0e, 0xe7, 0x61, 
  0x44, 0x39, 0x22, 0x7c, 0x36, 0x1a, 0x53, 0x61, 0xf5, 0xf8, 0xf8, 0xef, 
  0xf6, 0xf8, 0x5b, 0x5e, 0xc0, 0x7f, 0xd8, 0x02, 0x5a, 0xa9, 0x3d, 0xbb, 
  0xe4, 0x3e, 0x6e, 0xe7, 0x94, 0x47, 0x52, 0x68, 0x46, 0x16, 0x0b, 0xb1, 
  0x3b, 0xd2, 0xe2, 0xc7, 0x23, 0x27, 0x70, 0xfb, 0x56, 0x92, 0xfb, 0x61, 
  0x8b, 0xf3, 0x64, 0x01, 0x62, 0xe8, 0x5f, 0x48, 0xf2, 0x20, 0x92, 0xe7, 
  0x24, 0x27, 0x4e, 0x4c, 0x09, 0xc1, 0x0a, 0xfe, 0x62, 0xda, 0x49, 0x33, 
  0x0b, 0x85, 0x18, 0x8e, 0x60, 0xe1, 0xe9, 0x73, 0xd5, 0x83, 0x50, 0x06, 
  0x1f, 0xbb, 0x70, 0x3c, 0x4d, 0xf3, 0xb1, 0x2a, 0x02, 0x5a, 0xcd, 0xa2, 
  0xfb, 0xc6, 0x44, 0xb2, 0x7a, 0x58, 0x0c, 0x7b, 0xa0, 0xb2, 0x13, 0x73, 
  0xa5, 0x30, 0x3d, 0x83, 0xce, 0xc7, 0xc7, 0xd1, 0x86, 0x0a, 0x95, 0xa4, 
  0x00, 0xb3, 0xd3, 0x5a, 0x04, 0xc0, 0x56, 0x59, 0xb1, 0x76, 0x92, 0xaf, 
  0x73, 0x69, 0xd6, 0xb7, 0xd2, 0x1c, 0xf4, 0xf0, 0xda, 0x74, 0x01, 0xba, 
  0xbd, 0x95, 0xbc, 0x34, 0xbe, 0x63, 0x65, 0xce, 0x90, 0x54, 0x61, 0x06, 
  0x66, 0xdd, 0x5d, 0x52, 0x1b, 0x20, 0x0f, 0x8f, 0xba, 0x32, 0x8b, 0xa2, 
  0x96, 0x77, 0x55, 0x85, 0x59, 0x96, 0x57, 0x68, 0xd0, 0x1e, 0x7c, 0xaa, 
  0x8f, 0x4c, 0xb8, 0x7c, 0x3e, 0x7d, 0xb8, 0x05, 0xc3, 0xa5, 0x91, 0x54, 
  0x0f, 0xe7, 0xbd, 0x78, 0xda, 0xc6, 0x67, 0x37, 0x95, 0xbe, 0xaa, 0x96, 
  0x6f, 0x81, 0x4b, 0xe1, 0x0e, 0x1b, 0xb1, 0x9f, 0xa4, 0xe0, 0x4c, 0x00, 
  0xc1, 0xab, 0xf0, 0xb3, 0xc9, 0x57, 0x0c, 0xa3, 0x93, 0x3d, 0x3c, 0x02, 
  0x27, 0xff, 0x17, 0x1a, 0xde, 0x23, 0x70, 0x0e, 0xdb, 0x97, 0x3b, 0x5a, 
  0xae, 0xa1, 0xc3, 0x9c, 0xfb, 0xb6, 0xca, 0xab, 0x78, 0xee, 0x2f, 0x0f, 
  0xfc, 0xc5, 0x5f, 0xa0, 0xd0, 0x8d, 0xa2, 0x37, 0x0c, 0x9c, 0xa5, 0xff, 
  0xe1, 0x01, 0xe0, 0x0e, 0xf6, 0x46, 0x75, 0x1e, 0x8b, 0x15, 0xf0, 0xd8, 
  0x04, 0x16, 0x1b, 0xb5, 0xe9, 0x47, 0x6e, 0x06, 0xe3, 0xca, 0x0b, 0x7a, 
  0x27, 0xb5, 0x2b, 0x95, 0x18, 0x50, 0x3e, 0x7c, 0xb8, 0x85, 0xf9, 0xaa, 
  0x93, 0xcc, 0x30, 0x57, 0x3e, 0xf4, 0x2c, 0xe9, 0xad, 0x96, 0x0f, 0xb7, 
  0x21, 0xe1, 0xf5, 0x58, 0x84, 0xda, 0x2a, 0xa4, 0x7c, 0x75, 0xe5, 0xb7, 
  0xe0, 0xa0, 0xef, 0xdf, 0x0a, 0x01, 0x2a, 0x59, 0x91, 0x02, 0x3d, 0x57, 
  0x24, 0x3a, 0x20, 0x63, 0xf2, 0x1c, 0xe6, 0x77, 0x6d, 0x61, 0xb3, 0xf1, 
  0x1f, 0x6f, 0xbb, 0xbb, 0x14, 0xbb, 0xa7, 0x63, 0xa1, 0xd2, 0xbf, 0xd6, 
  0x80, 0x5d, 0xfb, 0xdd, 0x68, 0x4d, 0x51, 0xa7, 0xd7, 0x4b, 0x22, 0x8e, 
  0xa3, 0x6d, 0x01, 0xe9, 0x20, 0xf5, 0x79, 0x47, 0x93, 0xd3, 0x3a, 0x42, 
  0x33, 0x1b, 0xff, 0x3d, 0x34, 0x57, 0xae, 0xd5, 0xa3, 0x2e, 0xb9, 0xf7, 
  0xef, 0x5d, 0x9b, 0x7e, 0x25, 0xc3, 0x82, 0x56, 0xe2, 0x9f, 0x5c, 0x0a, 
  0x71, 0xf6, 0xf9, 0x78, 0xd1, 0x87, 0x5b, 0xc0, 0x55, 0x21, 0xb2, 0x2f, 
  0x02, 0x33, 0x49, 0x83, 0xf3, 0xe5, 0x59, 0x55, 0x68, 0x7d, 0xb8, 0x05, 
  0xc4, 0xcc, 0x22, 0x58, 0x74, 0xe8, 0x81, 0x19, 0x83, 0x00, 0xd4, 0x07, 
  0x43, 0xc8, 0x14, 0xc5, 0x44, 0x72, 0xe9, 0xe1, 0xba, 0x95, 0x5b, 0x96, 
  0xd9, 0xaa, 0x8b, 0x99, 0xed, 0x10, 0x4e, 0x3a, 0xd6, 0x21, 0x90, 0x4d, 
  0x4c, 0x2a, 0x15, 0xe5, 0xfd, 0x8e, 0x68, 0x78, 0xd3, 0x5e, 0x61, 0xf1, 
  0x7e, 0xcb, 0xdd, 0x32, 0x4c, 0x20, 0xd9, 0xaf, 0x20, 0x3e, 0x10, 0xc1, 
  0x8d, 0xbf, 0x6c, 0xb7, 0x60, 0x64, 0xb0, 0xc1, 0x0b, 0xb8, 0xfb, 0xfb, 
  0x2f, 0x0f, 0x53, 0x44, 0x5a, 0xb4, 0x2a, 0x97, 0x39, 0x9b, 0xe2, 0xde, 
  0x3f, 0x0b, 0xb0, 0xc8, 0x20, 0x08, 0x8d, 0x91, 0x56, 0xa5, 0x10, 0x2a, 
  0x5d, 0x08, 0x93, 0xd5, 0xfb, 0xf8, 0x5e, 0x5c, 0x59, 0xb2, 0x57, 0xc9, 
  0x80, 0xe2, 0x5b, 0x2d, 0xbc, 0x8f, 0x9f, 0x93, 0xb7, 0x16, 0xde, 0x65, 
  0x1c, 0x03, 0xdc, 0xde, 0x87, 0x13, 0x4b, 0x20, 0x9f, 0xdc, 0x3a, 0x49, 
  0xf1, 0x9e, 0xf3, 0x6e, 0x6d, 0x75, 0x50, 0x01, 0xfa, 0x52, 0x37, 0x57, 
  0xed, 0x62, 0xe9, 0xec, 0xea, 0x03, 0xfa, 0x92, 0xb6, 0x36, 0xf5, 0x64, 
  0xf5, 0x20, 0x6a, 0xb3, 0xb2, 0xbe, 0x10, 0xa2, 0x2e, 0xbd, 0x89, 0x71, 
  0xfc, 0x43, 0x67, 0xb5, 0xf1, 0xde, 0x46, 0x9f, 0x96, 0x39, 0xf5, 0xef, 
  0x98, 0x5d, 0x28, 0x54, 0xc3, 0xac, 0xb1, 0xa9, 0x54, 0x14, 0x00, 0x55, 
  0xfd, 0x26, 0x72, 0xcf, 0x31, 0x5b, 0x00, 0x83, 0xc0, 0x3d, 0x05, 0x5d, 
  0x45, 0xd7, 0x1d, 0x3a, 0x76, 0xd4, 0x02, 0xbc, 0x10, 0x60, 0x56, 0xcb, 
  0x0d, 0xb5, 0x1b, 0x27, 0x40, 0xf1, 0xea, 0x1e, 0x84, 0xdb, 0x5d, 0x2c, 
  0xb9, 0x8d, 0xc2, 0x7c, 0x9b, 0xff, 0xa6, 0x41, 0x48, 0x6b, 0xad, 0x11, 
  0x28, 0xc8, 0xe7, 0x5b, 0x8e, 0x2e, 0xd1, 0x11, 0xd4, 0x4a, 0xfc, 0xf9, 
  0xac, 0x04, 0x07, 0x3a, 0xf6, 0xbe, 0x4d, 0xb7, 0x52, 0x34, 0x86, 0xbe, 
  0x55, 0x88, 0x63, 0x9b, 0x54, 0x42, 0x73, 0x3e, 0xbc, 0x8f, 0x03, 0xc0, 
  0x33, 0xf1, 0xc9, 0xce, 0xaf, 0x17, 0xa1, 0xf8, 0xce, 0xcc, 0xdb, 0xd1, 
  0x33, 0xfc, 0x40, 0x4a, 0xec, 0x53, 0x56, 0xcb, 0x7f, 0xfa, 0xbc, 0x23, 
  0xa6, 0xc0, 0xab, 0xa4, 0x3e, 0xef, 0xcf, 0x85, 0x5a, 0x59, 0x7a, 0xde, 
  0x58, 0x92, 0x1f, 0x82, 0x20, 0xd4, 0x46, 0x08, 0xee, 0x14, 0xcc, 0x98, 
  0xb5, 0xeb, 0xb2, 0x5c, 0x71, 0x4e, 0x29, 0xed, 0x28, 0x5e, 0xde, 0xdf, 
  0xfb, 0x6c, 0xef, 0xc1, 0x18, 0x7e, 0x2b, 0x0f, 0xcc, 0xe5, 0xc4, 0xdf, 
  0x29, 0x50, 0x6c, 0x2d, 0x3e, 0x67, 0xb3, 0x86, 0x6d, 0x66, 0xbf, 0x92, 
  0xa3, 0x7a, 0x34, 0x67, 0x4f, 0xc3, 0x3c, 0x2c, 0x9c, 0xa6, 0xef, 0xc2, 
  0x7d, 0x5a, 0xb5, 0x2b, 0x9a, 0x68, 0x44, 0xa5, 0xab, 0x5b, 0x86, 0xa6, 
  0x82, 0x2a, 0x83, 0xa4, 0x8b, 0xe3, 0xa3, 0x36, 0x5a, 0x6a, 0x0f, 0x49, 
  0x50, 0xae, 0xc2, 0x71, 0x07, 0x80, 0x7d, 0x60, 0x9e, 0x8c, 0x43, 0xa1, 
  0x57, 0x4f, 0x3d, 0x5f, 0xb5, 0x5a, 0xd6, 0x82, 0x63, 0x46, 0x50, 0xd5, 
  0x7c, 0x73, 0x3a, 0xa6, 0x84, 0xc5, 0xf0, 0x95, 0xc1, 0x61, 0xce, 0xa8, 
  0xa1, 0x2d, 0xf9, 0x06, 0xf4, 0x9e, 0x16, 0x9f, 0xe0, 0xa7, 0x3b, 0x3d, 
  0x7a, 0xb0, 0xae, 0xca, 0x49, 0xa3, 0x87, 0xd9, 0xb0, 0x61, 0x17, 0xb5, 
  0xbf, 0xea, 0xfd, 0xe8, 0x9a, 0xd1, 0x31, 0xb0, 0x86, 0x6a, 0x22, 0x92, 
  0x0b, 0x2e, 0xad, 0xa3, 0xb5, 0xe0, 0x44, 0x32, 0xc6, 0x61, 0x27, 0x14, 
  0x2f, 0xe2, 0x38, 0x2c, 0x13, 0xd5, 0x92, 0x38, 0x35, 0xcf, 0x42, 0x96, 
  0x9b, 0x75, 0xf7, 0xa9, 0x15, 0xfa, 0xea, 0x60, 0xc0, 0xcd, 0xec, 0xdd, 
  0xdf, 0x1c, 0xf3, 0xec, 0x7b, 0x84, 0xfe, 0x0a, 0x3b, 0x7f, 0xa6, 0x22, 
  0xd6, 0xa6, 0x22, 0xc9, 0x97, 0x2e, 0x96, 0xc4, 0xd5, 0xa4, 0x73, 0x25, 
  0x0d, 0x03, 0x27, 0x62, 0x57, 0x1a, 0x52, 0xc3, 0x6b, 0x86, 0x25, 0x12, 
  0xc4, 0x48, 0xcb, 0x9a, 0x30, 0xfb, 0xe1, 0x86, 0x22, 0x8d, 0xee, 0xca, 
  0x71, 0xc5, 0xe7, 0x14, 0xee, 0xa8, 0x56, 0x6d, 0xce, 0xe1, 0x12, 0x7f, 
  0x75, 0x7c, 0xb5, 0xd1, 0x87, 0x89, 0x7e, 0xd9, 0x49, 0xe7, 0x68, 0x44, 
  0x73, 0x76, 0x10, 0x72, 0x63, 0x80, 0x64, 0x1d, 0x42, 0x26, 0x17, 0x71, 
  0x89, 0xb3, 0xb8, 0xbb, 0xcc, 0x99, 0x64, 0x9c, 0x75, 0x2c, 0x11, 0xc7, 
  0x97, 0x07, 0x49, 0x67, 0xbc, 0x4c, 0x3a, 0xea, 0x76, 0xb6, 0xd7, 0xe9, 
  0xc9, 0xe5, 0x95, 0x2c, 0x22, 0x6a, 0xca, 0x89, 0xe4, 0xcd, 0xc9, 0xb5, 
  0xa5, 0xcf, 0x9a, 0xfd, 0xcd, 0x48, 0x63, 0xcd, 0xb1, 0xbd, 0x7c, 0x97, 
  0x29, 0xee, 0x21, 0xff, 0xfb, 0x79, 0x87, 0x43, 0x20, 0xf6, 0xf7, 0x2f, 
  0x7b, 0x73, 0x19, 0xea, 0x41, 0xd1, 0x18, 0xe5, 0x6d, 0x00, 0x31, 0xaa, 
  0x54, 0xb0, 0x6c, 0xd7, 0x8d, 0x15, 0xed, 0x76, 0xba, 0x2a, 0x84, 0x4f, 
  0x45, 0x41, 0x97, 0xfc, 0x78, 0x9a, 0x4f, 0x07, 0x7a, 0xa6, 0xac, 0x9b, 
  0xb6, 0x59, 0x91, 0xb7, 0x4b, 0x53, 0xab, 0x64, 0x4c, 0x41, 0x23, 0xb5, 
  0x44, 0x7d, 0x4b, 0xb2, 0xec, 0xb8, 0xd5, 0x75, 0x9c, 0xb6, 0x18, 0xfb, 
  0x56, 0x39, 0x86, 0x39, 0xa5, 0x84, 0x2f, 0xaf, 0x1f, 0xce, 0xdb, 0x12, 
  0x87, 0x5b, 0x19, 0x44, 0x4f, 0xaa, 0xd1, 0x7f, 0xe5, 0x6a, 0xec, 0xb4, 
  0xef, 0x9a, 0x58, 0xe1, 0x2f, 0x79, 0xd9, 0x4c, 0xe7, 0xd4, 0x62, 0xdb, 
  0xb6, 0xb1, 0xa9, 0x14, 0x50, 0x00, 0x7e, 0x65, 0x47, 0xe9, 0x5e, 0x62, 
  0x4b, 0x34, 0xb7, 0x62, 0xdd, 0xc0, 0x54, 0xfc, 0x4f, 0x81, 0x28, 0xfe, 
  0xe0, 0xa8, 0x46, 0xd6, 0xb3, 0xbb, 0x1e, 0x80, 0xd0, 0xcd, 0x46, 0xc2, 
  0x09, 0x60, 0x3c, 0xf1, 0xfa, 0xa0, 0x6d, 0xfe, 0x71, 0xf4, 0x14, 0x19, 
  0x9c, 0x3e, 0xd0, 0x47, 0x03, 0xe2, 0x31, 0xf4, 0x4d, 0x41, 0xaa, 0x4f, 
  0x5a, 0x35, 0x15, 0x1c, 0xc5, 0xd4, 0x89, 0xc5, 0xef, 0xf7, 0x0f, 0xd8, 
  0xc0, 0x94, 0xf3, 0x7c, 0x98, 0xff, 0x77, 0x08, 0x0a, 0xc9, 0x6f, 0x58, 
  0xdc, 0xe5, 0x67, 0x8e, 0x7a, 0xa6, 0xb7, 0x87, 0x38, 0x2f, 0xcf, 0xb8, 
  0xb6, 0x20, 0x73, 0xa4, 0x42, 0x4a, 0x69, 0x6d, 0xe0, 0xd9, 0x17, 0x9e, 
  0x3f, 0xa3, 0x16, 0xb9, 0xea, 0xf2, 0x56, 0x42, 0x94, 0x4b, 0x50, 0x6b, 
  0x7d, 0xb5, 0x16, 0xc7, 0x45, 0xbc, 0xa2, 0x6d, 0x87, 0x45, 0x0b, 0x61, 
  0x91, 0x50, 0x7a, 0x99, 0xbe, 0x1d, 0x44, 0x9a, 0x13, 0x69, 0xed, 0xb5, 
  0xec, 0xa1, 0x41, 0xeb, 0x96, 0x9b, 0x29, 0xc6, 0xb4, 0x74, 0x91, 0xb8, 
  0xc4, 0xc1, 0x70, 0x1a, 0x1d, 0x17, 0xec, 0x58, 0x2c, 0xb0, 0x25, 0x5c, 
  0x30, 0xc4, 0x23, 0xf1, 0x86, 0x78, 0x19, 0x80, 0x52, 0xca, 0x42, 0x2b, 
  0xea, 0xa1, 0x89, 0xe3, 0xb1, 0x95, 0x00, 0x0b, 0x68, 0x23, 0xe4, 0x6a, 
  0x87, 0xb5, 0x48, 0xd5, 0x3e, 0x04, 0x9f, 0x97, 0x2e, 0x8e, 0xa9, 0xa1, 
  0xdd, 0x45, 0xe5, 0x7d, 0x6c, 0xa9, 0xc6, 0xe4, 0x0a, 0x0f, 0xff, 0x1d, 
  0x52, 0x14, 0xf9, 0xd5, 0xaf, 0x5e, 0xbf, 0xc1, 0xd8, 0xb6, 0xf7, 0x3b, 
  0x10, 0x2f, 0xa1, 0x09, 0xbc, 0xa5, 0x5e, 0xf0, 0xc4, 0xa3, 0x1d, 0x64, 
  0xe6, 0x46, 0x8a, 0x36, 0x0e, 0x67, 0xf7, 0x83, 0xeb, 0xa0, 0x97, 0x52, 
  0x1b, 0x90, 0x05, 0xaa, 0x7f, 0xd5, 0x5e, 0x47, 0x2b, 0xbe, 0x8b, 0xcc, 
  0xda, 0xed, 0xe1, 0x8e, 0x98, 0xb1, 0x38, 0x02, 0xaa, 0x19, 0x1c, 0x59, 
  0x05, 0x77, 0x2b, 0x2e, 0x40, 0x5f, 0xdd, 0xcf, 0x39, 0xc2, 0xf3, 0xf9, 
  0x34, 0x20, 0x85, 0xce, 0x72, 0x75, 0xdc, 0xff, 0xae, 0x18, 0x33, 0x94, 
  0xc7, 0x3a, 0xeb, 0xbb, 0x6b, 0xce, 0x55, 0x85, 0x6a, 0x61, 0xce, 0xde, 
  0x87, 0x94, 0xe6, 0x85, 0x77, 0xd7, 0xe8, 0x6f, 0x17, 0x14, 0xf2, 0xbf, 
  0x14, 0xea, 0x17, 0x39, 0x0f, 0x65, 0xf4, 0x8c, 0xf4, 0x84, 0x56, 0x78, 
  0x48, 0x02, 0x0f, 0x9b, 0xa2, 0xfd, 0x9a, 0x26, 0x21, 0x8a, 0x97, 0xcf, 
  0x95, 0xc8, 0xb3, 0xa1, 0xc3, 0x7a, 0xea, 0xf0, 0x73, 0x32, 0x1e, 0x92, 
  0xdc, 0x55, 0x35, 0x58, 0xf2, 0x6e, 0x70, 0x96, 0xce, 0x54, 0x52, 0x4b, 
  0xae, 0x55, 0x30, 0x60, 0x31, 0xc1, 0x83, 0x58, 0x5d, 0xbf, 0xe1, 0x68, 
  0xca, 0x76, 0x85, 0x39, 0xe2, 0x80, 0xa4, 0x7b, 0x4e, 0x57, 0x8b, 0xde, 
  0x6f, 0xb7, 0xbe, 0x7b, 0x5c, 0xf4, 0xb2, 0xaa, 0x96, 0xfb, 0xa3, 0xbd, 
  0x6e, 0x8e, 0xf5, 0x52, 0x0a, 0x64, 0x98, 0x43, 0x21, 0x25, 0xd5, 0x2b, 
  0x01, 0x86, 0xbe, 0x52, 0x69, 0xa9, 0x6e, 0x95, 0xce, 0xc0, 0xab, 0xbd, 
  0x50, 0x20, 0x34, 0x78, 0x99, 0x32, 0x2c, 0xfa, 0xbb, 0x44, 0xf1, 0x5a, 
  0x5a, 0x97, 0xa7, 0x1b, 0x42, 0xb7, 0x82, 0xb1, 0xee, 0x33, 0xc7, 0x9d, 
  0x97, 0x77, 0xfb, 0x1b, 0x52, 0xab, 0x1b, 0x43, 0x65, 0xc9, 0xee, 0xea, 
  0xf2, 0xd4, 0xf9, 0xe1, 0xf7, 0x45, 0x92, 0xcb, 0x36, 0x60, 0x34, 0x3a, 
  0x61, 0x38, 0x36, 0xeb, 0xf1, 0xd5, 0xe9, 0xa5, 0x83, 0x12, 0x70, 0x83, 
  0x38, 0xe0, 0xfb, 0xb4, 0x9c, 0xdf, 0x1d, 0x7c, 0xf8, 0x20, 0x2e, 0x83, 
  0x41, 0x1c, 0xfc, 0xd2, 0x41, 0x00, 0x2d, 0xad, 0x39, 0x88, 0x47, 0x3a, 
  0x88, 0x47, 0xff, 0xdc, 0x20, 0x1e, 0xfd, 0x5b, 0x06, 0xf1, 0x98, 0x23, 
  0x59, 0x96, 0x77, 0x8f, 0x3b, 0x48, 0xd5, 0x3c, 0xf5, 0x60, 0x39, 0x48, 
  0x4a, 0x12, 0x7c, 0x5c, 0xe7, 0x6e, 0x00, 0x06, 0x84, 0xc2, 0x96, 0xb4, 
  0x0b, 0x4e, 0xbb, 0x0a, 0xc4, 0x8c, 0x30, 0xa2, 0x83, 0x2e, 0x1d, 0xf4, 
  0xbd, 0xa6, 0x5f, 0x45, 0xee, 0xa6, 0xe9, 0xc8, 0xc5, 0x5a, 0xde, 0x7d, 
  0x3a, 0xd4, 0x7e, 0x77, 0xea, 0x67, 0x57, 0x40, 0x67, 0x6c, 0x80, 0x48, 
  0x26, 0xe1, 0x31, 0x25, 0x1d, 0x75, 0x6d, 0x71, 0x13, 0x9d, 0x9c, 0xdf, 
  0x3d, 0xb6, 0xa1, 0x26, 0x92, 0x89, 0xda, 0x82, 0xca, 0xfb, 0x2c, 0x88, 
  0x01, 0xfd, 0x54, 0x56, 0xe5, 0xd3, 0xf6, 0xaa, 0x58, 0x9f, 0x8c, 0x35, 
  0xd1, 0xb5, 0x24, 0x28, 0xe3, 0xeb, 0xb0, 0x6c, 0x1e, 0x58, 0x95, 0x0f, 
  0x5c, 0x96, 0x5f, 0x79, 0x55, 0x3e, 0xfd, 0x25, 0xab, 0xf2, 0x91, 0xa8, 
  0xd5, 0xc8, 0xa2, 0x1c, 0x8e, 0xe3, 0xa2, 0x23, 0x4e, 0xcd, 0x07, 0xdf, 
  0x5b, 0x38, 0x86, 0xcf, 0xbb, 0xac, 0xc5, 0xf1, 0xc0, 0xff, 0x1e, 0xb7, 
  0xd1, 0xa0, 0xe4, 0x51, 0x6a, 0xbc, 0xa9, 0x85, 0xda, 0x05, 0x48, 0xda, 
  0x68, 0xc5, 0xc6, 0x9f, 0xc9, 0xaf, 0x99, 0xbc, 0x08, 0x8b, 0x56, 0x30, 
  0x18, 0xea, 0x8a, 0xcb, 0xed, 0x5e, 0xda, 0xe3, 0xff, 0xdb, 0xc0, 0x57, 
  0xda, 0x41, 0x29, 0x18, 0x64, 0x3d, 0x0a, 0xf1, 0xf8, 0xf5, 0xb7, 0x27, 
  0x17, 0x67, 0xaf, 0x5f, 0x1d, 0xbf, 0x76, 0xf9, 0x28, 0xf0, 0xd4, 0x8a, 
  0xa9, 0xe6, 0x47, 0xb3, 0xae, 0x3c, 0xdd, 0xdd, 0xfd, 0xe9, 0x19, 0xdb, 
  0xe0, 0x3e, 0x57, 0x23, 0x5c, 0xfb, 0x8a, 0x34, 0xe3, 0x95, 0x4f, 0x2a, 
  0xb7, 0xb8, 0x52, 0xb1, 0xe6, 0x6c, 0x05, 0x96, 0xa0, 0xcb, 0xb7, 0xe7, 
  0x17, 0x67, 0xdf, 0xff, 0xf0, 0x6f, 0x6c, 0xff, 0xb2, 0x96, 0xdf, 0xfd, 
  0x6f, 0x6d, 0xfe, 0x65, 0x38, 0xfa, 0xaf, 0xce, 0xce, 0xbf, 0x3e, 0xbe, 
  0xf8, 0xb7, 0xb6, 0x2f, 0x4d, 0x3a, 0xeb, 0xc5, 0xe1, 0xe9, 0xe9, 0x3f, 
  0xd5, 0xbc, 0xb6, 0xef, 0xaa, 0x01, 0x99, 0xe9, 0x41, 0xc2, 0x75, 0xb5, 
  0xa5, 0xa1, 0x59, 0x40, 0xba, 0x11, 0xdb, 0xca, 0xba, 0x86, 0xf3, 0xfa, 
  0x4c, 0x47, 0x22, 0x86, 0xa2, 0xa1, 0x01, 0x13, 0x4c, 0xb5, 0x70, 0xd1, 
  0x4c, 0x2a, 0xa2, 0x7c, 0xde, 0x0a, 0xff, 0xf0, 0x5f, 0xda, 0x89, 0x46, 
  0x92, 0x36, 0x00, 0x03, 0x90, 0xf6, 0x7c, 0x9d, 0x07, 0xf6, 0x33, 0x92, 
  0xd5, 0xbb, 0x86, 0x03, 0x85, 0x98, 0x95, 0x33, 0x24, 0x0b, 0xb1, 0x77, 
  0xbd, 0x48, 0xcb, 0x5b, 0x22, 0xd9, 0xef, 0x4f, 0xae, 0xa2, 0xa3, 0xb3, 
  0x17, 0x9e, 0xe4, 0xaf, 0x60, 0xc2, 0x16, 0xcb, 0xab, 0x88, 0xa0, 0xe3, 
  0x55, 0xc6, 0xb0, 0xb5, 0xb3, 0xa0, 0xb4, 0x91, 0xa4, 0x1d, 0x73, 0xa4, 
  0x41, 0x69, 0x08, 0x3c, 0xa9, 0x63, 0x13, 0x93, 0xbc, 0x10, 0x90, 0x03, 
  0xa4, 0x55, 0xd4, 0x32, 0x94, 0x4b, 0xc3, 0x34, 0x58, 0x4b, 0x46, 0x22, 
  0x07, 0x2e, 0xa9, 0xf1, 0x82, 0x8e, 0xdf, 0xd4, 0xb7, 0x90, 0x49, 0xcc, 
  0x27, 0x47, 0xbd, 0x1f, 0x5a, 0x39, 0x36, 0xa9, 0x5e, 0xad, 0x67, 0x5f, 
  0x0b, 0xff, 0x29, 0x82, 0x8c, 0xd5, 0xe9, 0x70, 0x4c, 0xb4, 0x96, 0x71, 
  0xba, 0xaf, 0xb6, 0xed, 0xcc, 0x25, 0x39, 0x05, 0xc9, 0xab, 0xb0, 0x42, 
  0x30, 0xfc, 0xa9, 0xa2, 0xa1, 0x09, 0x5b, 0xeb, 0x2e, 0xb7, 0x11, 0x42, 
  0x7b, 0x4b, 0x88, 0x89, 0x35, 0xe3, 0xfa, 0x3a, 0xd0, 0x73, 0x23, 0xd1, 
  0xfd, 0x2c, 0x83, 0x49, 0x65, 0xa2, 0xf4, 0xe7, 0x40, 0x0e, 0x7f, 0xe4, 
  0xb3, 0xb3, 0x16, 0xf1, 0xdc, 0x10, 0xfb, 0x11, 0x1c, 0x26, 0x18, 0x09, 
  0xf7, 0x71, 0xa9, 0x40, 0xfd, 0x05, 0x4b, 0xa0, 0xfe, 0xcd, 0xc7, 0x41, 
  0x5e, 0x97, 0x24, 0x24, 0xb8, 0x06, 0xb4, 0x9e, 0xb4, 0x95, 0x29, 0x1a, 
  0x86, 0x59, 0x1d, 0xed, 0xfc, 0xb6, 0xf7, 0x75, 0xf4, 0x89, 0xfc, 0x38, 
  0x32, 0x2a, 0xd3, 0x2b, 0xc6, 0xa8, 0xc9, 0x97, 0xea, 0x13, 0x6a, 0x17, 
  0xd7, 0xfd, 0xa4, 0x03, 0x45, 0xd7, 0x61, 0x55, 0x95, 0x0d, 0xbf, 0xef, 
  0xa7, 0x8d, 0x1e, 0x5c, 0x17, 0x02, 0x6d, 0x1f, 0x96, 0x03, 0x54, 0xc1, 
  0x06, 0x9d, 0xdc, 0xb7, 0x34, 0x65, 0xee, 0xa1, 0xdd, 0xfc, 0x1f, 0x9b, 
  0x1b, 0x11, 0x80, 0xd5, 0xa1, 0x03, 0xf7, 0xe4, 0x67, 0x1e, 0xca, 0xe2, 
  0x3e, 0xe1, 0x08, 0x48, 0x07, 0x69, 0xb4, 0x9c, 0xeb, 0x54, 0x0d, 0x35, 
  0x0a, 0x8a, 0x98, 0xc4, 0x48, 0x77, 0x78, 0xa7, 0x26, 0x36, 0x15, 0x54, 
  0x95, 0xf3, 0x1d, 0x3c, 0xf1, 0x1d, 0xc4, 0x80, 0x79, 0xa2, 0x4b, 0x2e, 
  0x4b, 0x2d, 0xbe, 0x45, 0xdb, 0x96, 0x8f, 0x04, 0xc5, 0xdf, 0xbf, 0xba, 
  0xbf, 0xe7, 0x5e, 0xc5, 0xae, 0xee, 0xfa, 0xd4, 0x13, 0x4e, 0x74, 0x92, 
  0x4d, 0x8b, 0xa2, 0xe3, 0x54, 0xf0, 0xe1, 0x81, 0xb1, 0x54, 0x74, 0x55, 
  0x69, 0x41, 0x75, 0x57, 0x14, 0xa6, 0x99, 0x70, 0x39, 0x2b, 0x1f, 0x54, 
  0xd7, 0x94, 0x14, 0xf7, 0xf7, 0x1b, 0xab, 0x71, 0x7e, 0x78, 0x79, 0x69, 
  0x6b, 0x81, 0xdc, 0xdd, 0xfa, 0x34, 0xd5, 0x73, 0xbc, 0x6c, 0x05, 0xa3, 
  0x5b, 0x62, 0x13, 0x32, 0x5c, 0xa5, 0x8d, 0x86, 0x6f, 0x72, 0xff, 0xa0, 
  0xd1, 0xd5, 0x9b, 0xcb, 0xe3, 0x8b, 0x7f, 0xb5, 0x2b, 0x6d, 0xa3, 0xd9, 
  0xd5, 0xa3, 0xf6, 0xac, 0xbe, 0x95, 0xb6, 0x06, 0xff, 0xca, 0xac, 0xbe, 
  0xed, 0xe8, 0xea, 0xb1, 0xdf, 0x32, 0xe9, 0x2b, 0x3a, 0x38, 0xf8, 0x63, 
  0xe4, 0x0a, 0x73, 0x68, 0x5a, 0xb6, 0xeb, 0xcf, 0x77, 0xd8, 0xe8, 0x8a, 
  0xde, 0x1a, 0x22, 0xfa, 0xaf, 0xaa, 0x53, 0x60, 0xd0, 0xd5, 0x27, 0xae, 
  0x2b, 0xd2, 0x72, 0x39, 0x6e, 0x3c, 0xa9, 0xf4, 0xf4, 0xb4, 0x0e, 0x2e, 
  0xca, 0xae, 0xf0, 0x01, 0x3a, 0xe1, 0x25, 0x68, 0xe5, 0xc4, 0x39, 0x37, 
  0xb2, 0xf5, 0x1a, 0xf4, 0xf2, 0xa9, 0x9f, 0x90, 0x74, 0xc3, 0x39, 0x00, 
  0x72, 0x9a, 0x82, 0x8e, 0x1a, 0x60, 0x90, 0xdc, 0x57, 0x8b, 0x06, 0xdf, 
  0xd3, 0xd1, 0x1f, 0xfd, 0x74, 0xac, 0x55, 0xbe, 0xb3, 0xc6, 0x69, 0x16, 
  0x17, 0xeb, 0xa0, 0x2b, 0xab, 0xa1, 0x16, 0x6d, 0x08, 0x15, 0x51, 0xd0, 
  0x73, 0x8e, 0xa0, 0x91, 0x57, 0x7d, 0x17, 0x9f, 0x29, 0xb4, 0x01, 0x40, 
  0xaa, 0x22, 0xcd, 0xdc, 0x8b, 0x80, 0x61, 0xcb, 0x7e, 0xbe, 0x80, 0x67, 
  0x0a, 0xdc, 0x5e, 0xac, 0x26, 0xe9, 0xae, 0x72, 0x71, 0x01, 0xb7, 0xd9, 
  0x7f, 0xd2, 0x1e, 0xba, 0xd9, 0x67, 0x77, 0xf5, 0xd0, 0xe3, 0x12, 0x13, 
  0x86, 0xa6, 0xa0, 0x2d, 0x1d, 0x9b, 0x7e, 0x71, 0x7c, 0x75, 0x81, 0x10, 
  0x28, 0xcd, 0xf5, 0xdb, 0x71, 0xee, 0x8f, 0x19, 0x38, 0x59, 0x70, 0xd3, 
  0x04, 0xac, 0x41, 0x82, 0x4b, 0x15, 0x86, 0x43, 0xe2, 0x0a, 0x5c, 0xf5, 
  0x2b, 0x46, 0x1c, 0x4b, 0xf4, 0xda, 0x1b, 0x73, 0x75, 0xf0, 0x75, 0x47, 
  0x64, 0x7a, 0x93, 0x0b, 0x1c, 0x78, 0x2e, 0x20, 0x50, 0x81, 0xda, 0x34, 
  0x0a, 0xab, 0x18, 0x5e, 0xde, 0x42, 0xc1, 0x5f, 0x39, 0x06, 0x95, 0xa3, 
  0xde, 0xbb, 0x60, 0x4c, 0x60, 0x53, 0xe9, 0xec, 0xe1, 0xc0, 0xfb, 0x32, 
  0xa5, 0x7e, 0xa2, 0xf0, 0x71, 0x8d, 0x3f, 0x94, 0x59, 0xf8, 0xd2, 0x5f, 
  0x82, 0xfc, 0xda, 0xe5, 0x70, 0x96, 0x08, 0xc7, 0xbc, 0xf0, 0x03, 0xb1, 
  0x72, 0x19, 0x22, 0x7a, 0x38, 0x9f, 0x19, 0xba, 0xea, 0x1a, 0xa3, 0x44, 
  0x52, 0x0a, 0xb0, 0x75, 0xf4, 0x98, 0x51, 0xa2, 0x60, 0xca, 0x1b, 0xe7, 
  0x77, 0xae, 0x88, 0x94, 0x06, 0xda, 0xe2, 0xc9, 0x8e, 0xd2, 0xa6, 0x22, 
  0xcb, 0xa0, 0x96, 0xf6, 0x70, 0xc8, 0x1b, 0x65, 0x4a, 0x49, 0x30, 0x5f, 
  0xe1, 0x40, 0x82, 0xbe, 0xac, 0xab, 0x59, 0x67, 0x3c, 0xb2, 0x89, 0x72, 
  0xbb, 0x00, 0x4d, 0x5e, 0x01, 0x23, 0x3a, 0xb0, 0x11, 0xa4, 0x28, 0x54, 
  0xe4, 0xc9, 0x24, 0xe8, 0xe7, 0xb1, 0x2a, 0x69, 0x73, 0x75, 0x21, 0xf3, 
  0xb5, 0x81, 0xe4, 0x54, 0x2d, 0x3b, 0x43, 0x34, 0xc0, 0x39, 0xa0, 0x66, 
  0x27, 0x0c, 0xde, 0xfc, 0x24, 0x38, 0xe7, 0x36, 0xa8, 0xcb, 0xab, 0xb3, 
  0x0b, 0x3d, 0x25, 0xed, 0xcb, 0x8a, 0x57, 0x95, 0x1f, 0xd8, 0x04, 0x38, 
  0x3c, 0x10, 0xc5, 0x4c, 0x05, 0x7f, 0x0d, 0xca, 0xa8, 0x95, 0x3d, 0x38, 
  0xf8, 0xd4, 0xbb, 0x17, 0x75, 0x51, 0xbe, 0x8d, 0x8b, 0x34, 0x5f, 0x95, 
  0x08, 0x46, 0x07, 0xb0, 0x62, 0x91, 0x93, 0xaa, 0xb6, 0x08, 0xd4, 0xc0, 
  0x03, 0xe1, 0x13, 0x67, 0xc0, 0x8b, 0xa6, 0xc3, 0xbe, 0xe0, 0x12, 0x40, 
  0x44, 0x9a, 0xf2, 0x1b, 0x0c, 0x84, 0x6a, 0x10, 0xf4, 0xc6, 0x59, 0x3d, 
  0x3c, 0xd6, 0x82, 0xb0, 0x81, 0x33, 0x0f, 0x39, 0xa8, 0x1e, 0x9f, 0x51, 
  0xd3, 0x93, 0x8a, 0x2f, 0x90, 0x9f, 0x20, 0xee, 0xb4, 0xad, 0x76, 0xac, 
  0x25, 0x8a, 0x0b, 0x32, 0xd9, 0x4d, 0xe8, 0x42, 0x96, 0xb2, 0x87, 0xb9, 
  0x45, 0x41, 0x9a, 0x18, 0xeb, 0xc7, 0xfe, 0xa4, 0x9b, 0xc7, 0x49, 0x2a, 
  0xae, 0xeb, 0xde, 0x55, 0x21, 0xb5, 0xb3, 0xd5, 0x32, 0x62, 0xae, 0x32, 
  0xa9, 0x2d, 0x27, 0xd7, 0xa5, 0x17, 0x2d, 0x03, 0xae, 0x20, 0xa0, 0xbf, 
  0x3a, 0x75, 0x34, 0x8c, 0x4f, 0x1a, 0x0c, 0x05, 0x50, 0x9b, 0xed, 0xaa, 
  0x9e, 0x61, 0xd5, 0xd8, 0x10, 0xcc, 0x2b, 0x6c, 0x42, 0x5c, 0x67, 0xea, 
  0x6e, 0x6d, 0xc7, 0x9d, 0x1b, 0x0b, 0x12, 0x5b, 0x22, 0x6e, 0x4b, 0x33, 
  0xfc, 0xfb, 0xf1, 0xee, 0x77, 0x10, 0x9d, 0x24, 0xd7, 0x5d, 0x1c, 0x5f, 
  0x5e, 0xe9, 0x82, 0xf0, 0xaf, 0x2d, 0x46, 0xd8, 0xe1, 0x4d, 0xb4, 0x47, 
  0xcc, 0x24, 0x30, 0x03, 0x5b, 0x90, 0xf8, 0x93, 0x97, 0xf5, 0xf2, 0x74, 
  0x6e, 0x00, 0x07, 0xed, 0x0d, 0x81, 0x09, 0x8e, 0x51, 0xc3, 0xd0, 0x39, 
  0xff, 0xd6, 0x5a, 0xb4, 0x76, 0x19, 0x22, 0x0f, 0xae, 0x5c, 0x8a, 0x75, 
  0x28, 0x79, 0x57, 0x25, 0x99, 0x15, 0x49, 0x40, 0xda, 0x43, 0x91, 0x5e, 
  0x03, 0xdc, 0x06, 0x6b, 0x4b, 0x14, 0xd6, 0xe4, 0xfd, 0x2f, 0x8f, 0xa2, 
  0x27, 0x9f, 0x3c, 0x09, 0xc6, 0xf6, 0xc8, 0xf3, 0x48, 0x41, 0x59, 0x0b, 
  0x38, 0xbc, 0x7c, 0xd0, 0xd3, 0x6e, 0x7b, 0xa4, 0x9d, 0x4d, 0x5d, 0x55, 
  0x39, 0xb7, 0x38, 0x8f, 0x1e, 0x87, 0x5c, 0x16, 0x42, 0xba, 0x36, 0x71, 
  0x62, 0xfe, 0x1c, 0xfe, 0xd4, 0x45, 0x31, 0x5c, 0x33, 0x10, 0x75, 0x57, 
  0x71, 0xa1, 0x06, 0xc2, 0xd3, 0x23, 0xe1, 0x15, 0x01, 0x00, 0x65, 0x38, 
  0x34, 0xfe, 0x98, 0x33, 0x3b, 0xcb, 0x1b, 0xc1, 0x46, 0x6d, 0x5e, 0x5d, 
  0x8f, 0xbc, 0x44, 0xc1, 0x37, 0x92, 0x73, 0x64, 0xca, 0x56, 0xd5, 0x65, 
  0x0a, 0xd2, 0xf2, 0x56, 0x89, 0xac, 0x67, 0x5c, 0xb4, 0x93, 0x23, 0x38, 
  0x3c, 0x46, 0x5c, 0x91, 0x1d, 0x71, 0x67, 0x8f, 0x54, 0xa0, 0x38, 0x39, 
  0x3d, 0x0e, 0xa9, 0x4b, 0xb2, 0xd1, 0xc1, 0xd3, 0xbc, 0x7a, 0x40, 0x4c, 
  0xcb, 0x57, 0x51, 0x6b, 0x12, 0xd7, 0x39, 0x0a, 0xa1, 0xc1, 0x84, 0xf7, 
  0x67, 0xdf, 0xba, 0x30, 0x91, 0xd3, 0x17, 0x87, 0x10, 0xbf, 0xa0, 0xe8, 
  0xa4, 0x19, 0xd7, 0x44, 0xe0, 0x4f, 0xc6, 0xa8, 0x3f, 0xe2, 0x18, 0x4c, 
  0x6b, 0x09, 0x9e, 0xf8, 0x97, 0x4b, 0x9a, 0x19, 0xd7, 0x7d, 0x6c, 0x3c, 
  0xf2, 0x58, 0x8e, 0xf2, 0xa9, 0x16, 0xea, 0xe0, 0xf6, 0x71, 0xd7, 0xc9, 
  0x1a, 0xe3, 0x4d, 0x2b, 0xe2, 0x61, 0x6a, 0x9c, 0x3e, 0xe0, 0x5a, 0xd0, 
  0xc3, 0x45, 0x0a, 0xbc, 0x70, 0xb9, 0xe0, 0x19, 0x2e, 0x92, 0xa6, 0xb8, 
  0xed, 0x53, 0x69, 0x6c, 0x66, 0x8f, 0x75, 0xab, 0x58, 0xda, 0xb4, 0x6b, 
  0x5b, 0xce, 0xcd, 0xa1, 0x2e, 0x3e, 0x27, 0x63, 0x12, 0x13, 0x19, 0xc7, 
  0x93, 0x5b, 0x62, 0xc5, 0x19, 0xdf, 0x88, 0x73, 0x17, 0x1b, 0xc2, 0x29, 
  0x10, 0xd1, 0xa6, 0xda, 0xf4, 0xd8, 0x3e, 0x39, 0x1f, 0x2e, 0x41, 0xcb, 
  0xf7, 0xf2, 0x48, 0x11, 0x61, 0x94, 0x58, 0x8d, 0xca, 0x58, 0x10, 0x09, 
  0xc7, 0x8b, 0xce, 0x5d, 0x3a, 0x56, 0x68, 0x4b, 0x70, 0x78, 0x2e, 0x8a, 
  0xbd, 0x1c, 0xb4, 0xfd, 0xb8, 0xde, 0xb6, 0x13, 0x71, 0x5c, 0xc3, 0x1a, 
  0x7e, 0x2e, 0x4d, 0xa3, 0x28, 0x63, 0x1c, 0x75, 0xb4, 0x4d, 0x5c, 0xbf, 
  0xd6, 0xee, 0x27, 0xbe, 0xdd, 0x19, 0x70, 0x7e, 0x83, 0x41, 0x07, 0x68, 
  0x50, 0x74, 0xa9, 0x08, 0x16, 0xc5, 0x26, 0xcc, 0xf1, 0x49, 0x58, 0xb0, 
  0xa6, 0x2e, 0x4d, 0x3c, 0x96, 0x13, 0xf4, 0x65, 0x1c, 0x64, 0x9f, 0x73, 
  0x65, 0x19, 0xc4, 0x1d, 0xd3, 0xf2, 0x8b, 0xe8, 0x23, 0xe3, 0xe7, 0xaa, 
  0x3f, 0x31, 0x66, 0xd0, 0x01, 0x2d, 0x2f, 0xa1, 0xda, 0xda, 0x02, 0x3f, 
  0x6e, 0xad, 0xf8, 0xae, 0xe4, 0x10, 0x5d, 0xe5, 0xf0, 0x81, 0x66, 0xbe, 
  0x22, 0x6f, 0x39, 0x12, 0x90, 0xba, 0xb6, 0xc7, 0xac, 0x1c, 0x74, 0xa9, 
  0xc7, 0x37, 0x69, 0x55, 0xab, 0x0d, 0x2b, 0x41, 0xaf, 0x41, 0x47, 0x9f, 
  0xa9, 0x99, 0x46, 0x2e, 0xb6, 0xab, 0xe3, 0xd3, 0xd7, 0xc7, 0x57, 0x2e, 
  0x3f, 0xb6, 0x2d, 0xaf, 0x3c, 0x7e, 0xd2, 0x90, 0x74, 0x14, 0x99, 0xac, 
  0x19, 0xb4, 0xf1, 0xc9, 0xbe, 0x0b, 0x18, 0xb7, 0x1a, 0x03, 0x09, 0xaa, 
  0x44, 0x82, 0x7b, 0x25, 0xa4, 0x09, 0x20, 0x8a, 0x09, 0xc2, 0x3e, 0xf3, 
  0x87, 0xfc, 0xd6, 0xbf, 0x7a, 0xe0, 0x5e, 0x35, 0xc9, 0x27, 0x55, 0xad, 
  0x6a, 0x09, 0x8d, 0x21, 0x5b, 0x73, 0xea, 0xd9, 0x35, 0x20, 0x91, 0x60, 
  0xd7, 0x17, 0xeb, 0x59, 0x5a, 0x76, 0x44, 0x9e, 0x3a, 0x08, 0xe0, 0xac, 
  0xc9, 0x4d, 0x3f, 0x79, 0xe4, 0xb9, 0x69, 0xb1, 0x5e, 0x12, 0x37, 0x52, 
  0x90, 0x5f, 0x77, 0xee, 0xfc, 0xa3, 0x42, 0xb4, 0x47, 0xc2, 0x6f, 0x58, 
  0x72, 0x68, 0xbf, 0x15, 0xb7, 0xf1, 0xd0, 0x3f, 0xf9, 0x24, 0xb4, 0x86, 
  0x58, 0x79, 0x66, 0xad, 0x57, 0x0a, 0x99, 0xd3, 0x3f, 0xfa, 0xa9, 0x7b, 
  0x74, 0x85, 0x1a, 0x72, 0x9a, 0xf1, 0xbd, 0xf9, 0x05, 0x21, 0x90, 0xcb, 
  0x9b, 0x58, 0xd0, 0xbc, 0x52, 0x00, 0x5e, 0x72, 0xd5, 0xdf, 0xf0, 0x60, 
  0x79, 0xff, 0xc2, 0x27, 0xaa, 0x83, 0x89, 0x5c, 0xe7, 0xe5, 0x73, 0xc1, 
  0x25, 0x0b, 0x36, 0xc4, 0xbf, 0xf1, 0xa4, 0x6e, 0x2a, 0x5a, 0xd5, 0xa2, 
  0x54, 0xb1, 0x00, 0xe9, 0xf2, 0x26, 0x80, 0xb0, 0xff, 0x74, 0xaf, 0xbb, 
  0x8b, 0xa3, 0x43, 0xb4, 0x1f, 0x6d, 0x33, 0x92, 0xf3, 0x9f, 0xb5, 0xbe, 
  0x25, 0xb3, 0xf5, 0x3f, 0xfb, 0xe1, 0x7d, 0xba, 0xaf, 0x64, 0xc8, 0x4a, 
  0xee, 0x75, 0x96, 0xfe, 0xcc, 0x94, 0xe5, 0x4b, 0xe9, 0x92, 0x0a, 0xc0, 
  0x19, 0x38, 0xee, 0xe9, 0x03, 0x3d, 0xec, 0x77, 0xf1, 0x3c, 0x55, 0x46, 
  0xca, 0xd6, 0x36, 0xf7, 0xfd, 0x23, 0x25, 0x52, 0xa1, 0x79, 0x28, 0x95, 
  0xa8, 0x13, 0x9c, 0xbc, 0x9b, 0x24, 0x09, 0x47, 0x07, 0xdb, 0x93, 0xdf, 
  0x7f, 0x1f, 0xda, 0x5f, 0x3d, 0x6a, 0x5b, 0xac, 0xc5, 0xfc, 0x42, 0x9b, 
  0xab, 0x00, 0xa7, 0xd1, 0xd1, 0x5b, 0x55, 0x6d, 0xc0, 0xd0, 0x22, 0x99, 
  0x27, 0x9c, 0x6b, 0x2f, 0xf7, 0x84, 0x0f, 0xa1, 0xcd, 0x91, 0x46, 0x8b, 
  0x54, 0x0e, 0x29, 0x57, 0x08, 0x2d, 0x23, 0x4b, 0xda, 0x75, 0x16, 0x44, 
  0xbd, 0x26, 0xfa, 0x3c, 0x7c, 0x73, 0xf5, 0xf5, 0xd9, 0xc5, 0x65, 0xb4, 
  0xcb, 0x75, 0x3f, 0xae, 0x2e, 0x4e, 0xbe, 0x7c, 0x43, 0xd2, 0xbe, 0x33, 
  0x15, 0xbf, 0x88, 0x49, 0x0b, 0x98, 0x73, 0x20, 0x45, 0x92, 0x8d, 0x93, 
  0xe2, 0xda, 0xa0, 0xd6, 0xb8, 0x16, 0x00, 0xa0, 0x2f, 0xf2, 0x42, 0xf0, 
  0x69, 0x3c, 0x82, 0xac, 0x9a, 0xb3, 0xb7, 0x42, 0x9c, 0x85, 0x94, 0x1e, 
  0xc9, 0x0b, 0x84, 0x6a, 0x59, 0xb6, 0x9a, 0x6a, 0x8c, 0x0a, 0xdd, 0x7b, 
  0xf5, 0xf5, 0xe1, 0xeb, 0x6f, 0x2e, 0xcd, 0xcb, 0xf2, 0xdd, 0x77, 0xdf, 
  0x85, 0xde, 0x95, 0xa7, 0xbb, 0xbb, 0x40, 0x01, 0xb8, 0x89, 0xdf, 0xbd, 
  0x1b, 0x95, 0x44, 0x33, 0x01, 0x1a, 0xbd, 0x07, 0x80, 0x2a, 0x57, 0x44, 
  0xba, 0xf4, 0xf5, 0xee, 0x72, 0x35, 0x66, 0x14, 0xaa, 0xdd, 0x55, 0xa5, 
  0xc8, 0x8b, 0x78, 0x7b, 0x77, 0x6b, 0xeb, 0xf2, 0xf8, 0x38, 0x3a, 0x3c, 
  0xbd, 0x3c, 0x0b, 0xde, 0xdd, 0xde, 0xdf, 0x19, 0x44, 0xf7, 0xd7, 0x49, 
  0x85, 0x5f, 0xca, 0x2c, 0x2e, 0x66, 0x1c, 0x9f, 0xb2, 0x75, 0x7a, 0x78, 
  0xc5, 0xf2, 0xe8, 0xb7, 0xc7, 0x17, 0x97, 0x27, 0x67, 0xaf, 0x79, 0x03, 
  0x7f, 0x40, 0x79, 0x62, 0x54, 0x7c, 0x46, 0xc1, 0xd2, 0x2c, 0xb9, 0x2f, 
  0x35, 0x31, 0x84, 0xd3, 0x96, 0xfb, 0x56, 0x08, 0x58, 0x4a, 0xd6, 0xdc, 
  0x27, 0xc0, 0x68, 0xd1, 0x00, 0x80, 0x8a, 0xe5, 0x2e, 0x73, 0x10, 0x6e, 
  0x05, 0x1a, 0xb3, 0xe0, 0xb9, 0x24, 0x63, 0x09, 0x74, 0x19, 0x48, 0x5e, 
  0x20, 0x02, 0xa9, 0x83, 0xa4, 0xc6, 0xce, 0x25, 0xb8, 0x3c, 0x79, 0x75, 
  0x4e, 0x22, 0xcf, 0x9b, 0xcb, 0xc3, 0xaf, 0x8e, 0xf9, 0xd1, 0xaf, 0x92, 
  0xca, 0x6f, 0x0c, 0x74, 0x6d, 0x74, 0x42, 0x4b, 0x52, 0x4e, 0xe2, 0x25, 
  0x87, 0x44, 0x53, 0x37, 0x43, 0xe1, 0x70, 0x41, 0xdb, 0x61, 0x49, 0x25, 
  0x46, 0xee, 0xb2, 0xe7, 0x81, 0x98, 0x15, 0xb6, 0x7b, 0x71, 0x7c, 0xf8, 
  0xe2, 0xd5, 0xb1, 0x85, 0x47, 0xd5, 0xaa, 0xf0, 0x06, 0x60, 0x80, 0x5c, 
  0x67, 0x96, 0xb7, 0x81, 0xbe, 0xe1, 0xba, 0x09, 0xdd, 0xdd, 0xf9, 0x2d, 
  0xc3, 0xb3, 0xa3, 0x59, 0xba, 0x2b, 0xad, 0x5b, 0x7f, 0xb1, 0x5b, 0x12, 
  0x0b, 0x2e, 0x52, 0xce, 0x2c, 0x5a, 0x06, 0xf4, 0x94, 0xcf, 0xf6, 0xf6, 
  0xf6, 0x1e, 0x98, 0x07, 0xac, 0x72, 0x6a, 0x8f, 0xa0, 0xa9, 0x3c, 0xe5, 
  0xc7, 0x77, 0x7d, 0xfb, 0xe6, 0x72, 0x89, 0x83, 0xb1, 0xf3, 0x9f, 0x99, 
  0xc8, 0xed, 0xa4, 0xa4, 0x77, 0x0f, 0x7a, 0x92, 0xe7, 0x6e, 0x0f, 0x82, 
  0xe6, 0xae, 0x73, 0x66, 0x4d, 0x3e, 0x90, 0x47, 0xa2, 0x4c, 0x74, 0x21, 
  0xf4, 0xcb, 0xee, 0xb5, 0x90, 0x2f, 0xa9, 0x65, 0xf9, 0xc5, 0xad, 0x48, 
  0xb8, 0xf4, 0x53, 0x4e, 0x8f, 0x4f, 0xab, 0x00, 0xba, 0xc0, 0x96, 0x65, 
  0x9a, 0x42, 0x88, 0x21, 0xf1, 0xb0, 0xd9, 0x2e, 0x7f, 0x43, 0xad, 0xf2, 
  0x8f, 0x51, 0x5e, 0x5c, 0xef, 0x2e, 0x9e, 0xe2, 0xb6, 0xa6, 0x87, 0x5e, 
  0xa2, 0x4e, 0x19, 0x23, 0x67, 0xbb, 0x12, 0x65, 0xbc, 0x6d, 0x1c, 0x3e, 
  0xf9, 0x01, 0x73, 0xfe, 0x80, 0x35, 0x7e, 0x71, 0xf6, 0xdd, 0xeb, 0xd3, 
  0xb3, 0xc3, 0x17, 0xd1, 0xd5, 0x19, 0x49, 0x43, 0x2c, 0x98, 0x77, 0xec, 
  0x2b, 0xf2, 0xf8, 0x2b, 0x29, 0x60, 0x5a, 0xab, 0x4e, 0xd5, 0x1c, 0xc3, 
  0x50, 0xc0, 0xad, 0x91, 0xa2, 0x7a, 0x53, 0x2d, 0xde, 0x4f, 0xac, 0x1f, 
  0xd2, 0xc9, 0x40, 0x00, 0x92, 0x1b, 0x48, 0x99, 0x16, 0xe3, 0xa6, 0x05, 
  0x51, 0xea, 0x10, 0xcc, 0x6e, 0x6f, 0xb7, 0xc5, 0x43, 0xe8, 0x03, 0xdd, 
  0x04, 0xb0, 0xb3, 0xac, 0x43, 0xd7, 0x3b, 0x40, 0x3d, 0xad, 0x4c, 0x09, 
  0x5e, 0xcf, 0xd2, 0xff, 0x4e, 0x6b, 0x82, 0x67, 0x1b, 0xa7, 0x44, 0x6c, 
  0x26, 0x79, 0x87, 0x59, 0xd7, 0x37, 0x4e, 0x30, 0x01, 0xfd, 0xec, 0x90, 
  0x71, 0x6e, 0x17, 0x60, 0x5a, 0xd8, 0x90, 0xe1, 0x4a, 0xec, 0xe8, 0x8e, 
  0xfb, 0xb1, 0xfd, 0xf4, 0x5d, 0xf0, 0x37, 0x21, 0x8b, 0xd9, 0x75, 0xba, 
  0x96, 0x0c, 0xe0, 0xcd, 0xe5, 0xc9, 0xeb, 0xaf, 0x60, 0xe5, 0xff, 0xee, 
  0xec, 0xe2, 0xc5, 0x25, 0x35, 0xcb, 0x5c, 0x78, 0x0b, 0x62, 0x23, 0xaa, 
  0x25, 0xcb, 0xa8, 0xe4, 0x88, 0x72, 0xd7, 0xff, 0x05, 0x99, 0x13, 0xa1, 
  0xa9, 0x82, 0xae, 0x82, 0x61, 0xfa, 0xb5, 0x69, 0x56, 0x79, 0x0b, 0x48, 
  0x8e, 0x5f, 0x17, 0x70, 0xa6, 0xe9, 0x17, 0x5a, 0x00, 0x46, 0xeb, 0xcf, 
  0xc0, 0x9f, 0xbb, 0xcb, 0xa9, 0xc4, 0xbb, 0x7c, 0xbf, 0xef, 0x56, 0xf9, 
  0x2e, 0xc0, 0x83, 0xb7, 0x24, 0x8c, 0xd0, 0x80, 0x11, 0x6a, 0x2b, 0x12, 
  0x0d, 0x57, 0xd1, 0x6c, 0x1e, 0x5f, 0xa3, 0xc3, 0xe6, 0x72, 0xac, 0xa2, 
  0xa0, 0x33, 0xed, 0xfe, 0x43, 0xbb, 0x44, 0x80, 0xd4, 0x96, 0x0a, 0x8f, 
  0xd0, 0xbf, 0x79, 0x5a, 0x06, 0xf0, 0x62, 0x16, 0x95, 0x36, 0x86, 0x54, 
  0xb0, 0x06, 0x12, 0xa7, 0x29, 0x66, 0xc2, 0xad, 0x48, 0x82, 0x34, 0x03, 
  0x5b, 0x0c, 0x27, 0x8b, 0x64, 0xeb, 0xfb, 0x78, 0x2d, 0x81, 0x6c, 0x40, 
  0xc5, 0xe1, 0x20, 0x55, 0xe6, 0xad, 0xc0, 0x74, 0x74, 0x7a, 0x85, 0xfa, 
  0x68, 0x57, 0xa5, 0x65, 0xb0, 0x70, 0x6b, 0x5c, 0x5a, 0xc7, 0x62, 0x5a, 
  0xbb, 0x56, 0x5b, 0x09, 0x6f, 0xf3, 0x72, 0xbf, 0x7f, 0xa5, 0xdb, 0xb3, 
  0xb3, 0x3b, 0x7d, 0xbe, 0x16, 0x14, 0x84, 0x34, 0x7b, 0x78, 0xcd, 0x75, 
  0x10, 0x1f, 0xd4, 0x31, 0xa3, 0x18, 0xfc, 0x2e, 0xba, 0x24, 0x8a, 0xf2, 
  0x0b, 0x8e, 0x04, 0x92, 0x87, 0xd6, 0xdb, 0x25, 0xf5, 0xa8, 0x58, 0x69, 
  0xf0, 0xe9, 0xb2, 0x82, 0x01, 0x12, 0x01, 0x6c, 0xb5, 0x77, 0x69, 0x6c, 
  0xd9, 0x40, 0x82, 0xde, 0xf0, 0x96, 0x91, 0x0c, 0xde, 0x5a, 0xd1, 0x2d, 
  0x1e, 0xbd, 0xbc, 0x08, 0x10, 0x01, 0xec, 0x99, 0x78, 0xb7, 0x4b, 0x2e, 
  0xdf, 0x39, 0x49, 0x0b, 0xe2, 0x13, 0x9c, 0x66, 0x31, 0x11, 0x90, 0x1a, 
  0x04, 0x5b, 0x60, 0xec, 0x2c, 0xa9, 0xc6, 0x63, 0xc6, 0x10, 0x60, 0x1b, 
  0x8d, 0x54, 0x38, 0x46, 0x91, 0x37, 0xd3, 0x69, 0x97, 0x45, 0x7a, 0xc7, 
  0xb2, 0x50, 0x20, 0x1e, 0x93, 0x48, 0xc0, 0xfa, 0xda, 0x3b, 0x80, 0x92, 
  0x38, 0x6c, 0x0b, 0x6a, 0x4e, 0x82, 0x20, 0xd0, 0x2e, 0x46, 0xed, 0x30, 
  0x59, 0x42, 0xac, 0xb1, 0xd0, 0x97, 0xad, 0xf7, 0xcb, 0xd6, 0x16, 0x22, 
  0x14, 0xb8, 0x05, 0xe6, 0x95, 0x99, 0x3b, 0xb9, 0x0e, 0xe0, 0x5a, 0x9c, 
  0xbd, 0x52, 0x23, 0x70, 0xb1, 0xd6, 0xa4, 0x32, 0x50, 0x22, 0xaa, 0xa2, 
  0xca, 0xe5, 0xfb, 0xd9, 0x67, 0x2d, 0xbe, 0xf2, 0xce, 0x3d, 0xfd, 0x94, 
  0xbe, 0x0e, 0x2e, 0xf9, 0x39, 0xdb, 0x4e, 0x0d, 0xf5, 0xd3, 0xdf, 0xf4, 
  0x5f, 0xf9, 0x70, 0xeb, 0xa0, 0x5e, 0x88, 0x8b, 0xf7, 0xe0, 0x0e, 0x5d, 
  0xcd, 0xb9, 0x8e, 0x2d, 0x75, 0x70, 0xa7, 0x5b, 0x82, 0x77, 0xaa, 0xd5, 
  0xe7, 0x4a, 0xb1, 0xe9, 0x3f, 0x6d, 0x93, 0x9c, 0x07, 0x7c, 0x9b, 0xb6, 
  0x06, 0x1b, 0x30, 0x60, 0x2e, 0x78, 0xc8, 0x3c, 0x9b, 0xef, 0x93, 0xcb, 
  0x5c, 0x1b, 0xe6, 0x20, 0x68, 0x1d, 0x8c, 0xc3, 0xca, 0x68, 0xd6, 0xeb, 
  0x35, 0x50, 0x34, 0x87, 0xe3, 0x31, 0x7c, 0xb3, 0x79, 0x38, 0x6f, 0xfe, 
  0xa9, 0xe1, 0x84, 0xb5, 0x5e, 0xba, 0xc0, 0xac, 0x15, 0xe1, 0xbe, 0xc6, 
  0x3e, 0x00, 0xc8, 0x43, 0xb2, 0x48, 0x01, 0x77, 0x89, 0x66, 0xb4, 0x69, 
  0x2a, 0x06, 0x51, 0xc3, 0xc5, 0xe1, 0xeb, 0xaf, 0x8e, 0x41, 0x9f, 0xdf, 
  0x19, 0x5a, 0x1f, 0x52, 0x7f, 0x38, 0x7b, 0x40, 0xea, 0xc5, 0x94, 0xe2, 
  0x57, 0x4e, 0xf9, 0x8d, 0xe9, 0x6a, 0xc2, 0xc6, 0x87, 0x37, 0x0e, 0xb7, 
  0x03, 0x48, 0x25, 0x28, 0x09, 0x87, 0x50, 0x74, 0x35, 0x31, 0x6e, 0x45, 
  0x16, 0x32, 0x0e, 0x0a, 0x57, 0x8f, 0x35, 0x34, 0x9c, 0x72, 0x35, 0x5e, 
  0xc6, 0x1a, 0xa8, 0x1e, 0x87, 0x91, 0xcc, 0x56, 0x76, 0xa2, 0x36, 0x05, 
  0xbe, 0x39, 0xb5, 0xa4, 0x82, 0xb1, 0xf2, 0x02, 0xac, 0x7c, 0x14, 0xca, 
  0x47, 0x92, 0xcd, 0xbd, 0xef, 0x6a, 0x8d, 0x88, 0x5c, 0xa7, 0x0d, 0xb6, 
  0x96, 0xbe, 0x88, 0xb8, 0xf8, 0xcb, 0xa6, 0x35, 0x76, 0x8d, 0xd6, 0x6b, 
  0xba, 0xbc, 0xb7, 0x4d, 0x94, 0x86, 0xd9, 0xd4, 0x26, 0xa6, 0x84, 0x9d, 
  0x73, 0x50, 0xc1, 0x5a, 0x2f, 0x43, 0x57, 0xd8, 0xbc, 0x27, 0x7a, 0xb1, 
  0x8b, 0xfa, 0x00, 0xdd, 0x2e, 0x73, 0x09, 0x89, 0xea, 0x92, 0x32, 0xbe, 
  0x2b, 0x49, 0xed, 0x2a, 0x03, 0x2c, 0xd9, 0xc2, 0x9b, 0x3a, 0x93, 0xc8, 
  0x07, 0x2d, 0x8c, 0x52, 0x29, 0x75, 0xbb, 0x69, 0x89, 0x66, 0xed, 0xd9, 
  0xa8, 0x16, 0x10, 0x91, 0x38, 0x70, 0xce, 0x32, 0x1e, 0x89, 0x04, 0x5e, 
  0x10, 0x78, 0xa3, 0xc0, 0xc9, 0x0c, 0x72, 0xc6, 0x1e, 0x2e, 0x40, 0x9e, 
  0x31, 0x90, 0x10, 0x02, 0x92, 0x02, 0xb4, 0x7f, 0x62, 0x39, 0x5d, 0x22, 
  0xf6, 0xf0, 0x2a, 0x1a, 0x06, 0x7c, 0x43, 0xf3, 0x7b, 0x99, 0x69, 0x2c, 
  0xd6, 0x76, 0x03, 0x68, 0x1f, 0x68, 0xdf, 0x74, 0x83, 0x5a, 0x19, 0x81, 
  0x81, 0x84, 0x57, 0x08, 0xc5, 0xb4, 0xf8, 0x46, 0x47, 0x97, 0xd2, 0x0d, 
  0xf8, 0x50, 0x83, 0x4b, 0x7c, 0xd8, 0x50, 0x6a, 0xa5, 0x55, 0xeb, 0x45, 
  0xd3, 0x50, 0xa2, 0xd6, 0xaa, 0xb7, 0x75, 0xe1, 0xb2, 0xfb, 0xda, 0xab, 
  0x55, 0x9e, 0x3f, 0xdd, 0x8a, 0xfe, 0xd5, 0xc1, 0x3d, 0x30, 0x2c, 0x64, 
  0xb7, 0x00, 0x20, 0x3e, 0x69, 0xd6, 0x76, 0x0b, 0xd8, 0x3f, 0xb7, 0xda, 
  0x5e, 0x22, 0xb4, 0x24, 0x83, 0x88, 0xbb, 0x3b, 0x96, 0x96, 0x6c, 0x65, 
  0x3a, 0xe8, 0x9d, 0xf7, 0x5c, 0xd3, 0xbf, 0x2d, 0x8e, 0xcd, 0xa5, 0xdc, 
  0xb2, 0xf9, 0x00, 0x8c, 0x22, 0x9d, 0x59, 0xb4, 0x26, 0x82, 0xeb, 0xb6, 
  0x22, 0x0d, 0xbe, 0x44, 0xfe, 0x37, 0x13, 0x11, 0xb0, 0x73, 0xc0, 0xd6, 
  0xac, 0xf4, 0xb7, 0x64, 0x85, 0x42, 0x84, 0x3a, 0x41, 0x2d, 0x0c, 0x16, 
  0xa0, 0x7c, 0x16, 0x2f, 0xd7, 0x3c, 0x93, 0x18, 0x5f, 0x96, 0x87, 0x68, 
  0xf0, 0x71, 0x79, 0x03, 0x53, 0xa3, 0x43, 0xd9, 0x6d, 0x4d, 0xb7, 0x96, 
  0x6d, 0x4a, 0x9c, 0x59, 0xd8, 0x32, 0x18, 0x6a, 0x6d, 0x29, 0xea, 0x2b, 
  0x10, 0x48, 0x83, 0x1f, 0x7a, 0x0c, 0x98, 0x5b, 0x6c, 0x3e, 0x07, 0x2d, 
  0x34, 0xed, 0x06, 0xf5, 0x21, 0xc5, 0xd8, 0x95, 0xfa, 0x96, 0xb6, 0xe4, 
  0xea, 0x64, 0x71, 0x85, 0x51, 0x89, 0x90, 0x5d, 0xd4, 0x58, 0x40, 0x04, 
  0x06, 0x01, 0x8c, 0xde, 0x65, 0x1b, 0xc9, 0x3a, 0x4b, 0x1e, 0x11, 0x32, 
  0x71, 0x7d, 0x9d, 0x3a, 0x75, 0x3a, 0xbe, 0xe4, 0x2c, 0x26, 0x5c, 0x1f, 
  0xb0, 0x7e, 0x30, 0x3e, 0x5b, 0x2e, 0x3d, 0x62, 0x7e, 0x32, 0xbc, 0x01, 
  0x70, 0x17, 0xc5, 0x7b, 0x78, 0x79, 0xc5, 0xd1, 0xb9, 0x50, 0x58, 0x4d, 
  0x60, 0xf9, 0xf6, 0xf8, 0xe2, 0xcb, 0xb3, 0xcb, 0xe3, 0x68, 0x37, 0x7a, 
  0x71, 0xfc, 0xe5, 0x1b, 0x66, 0x1a, 0xbc, 0x5f, 0x22, 0xf2, 0x23, 0x9d, 
  0x54, 0xa0, 0xa4, 0x90, 0x4e, 0xee, 0x84, 0x39, 0x49, 0xe0, 0x18, 0x18, 
  0x5d, 0xf8, 0xc2, 0x48, 0xfc, 0xc4, 0x3c, 0x11, 0xd0, 0xf4, 0x34, 0x63, 
  0x20, 0x3f, 0x49, 0x3f, 0x36, 0x21, 0x2f, 0x63, 0x68, 0x86, 0xca, 0xea, 
  0x06, 0x5a, 0x39, 0xa6, 0xf2, 0xa9, 0x17, 0xe2, 0xee, 0x44, 0x23, 0xd0, 
  0x83, 0xe1, 0xc1, 0x3a, 0x1d, 0xc0, 0xaf, 0x10, 0x31, 0xd4, 0x36, 0x85, 
  0xee, 0x9a, 0xe7, 0x72, 0x6d, 0x01, 0xa1, 0x92, 0xdb, 0x06, 0x5a, 0x5d, 
  0x0a, 0x78, 0xe7, 0xa9, 0xa8, 0x63, 0x8a, 0x9b, 0x59, 0x0a, 0xb9, 0xc1, 
  0x67, 0xc0, 0x5d, 0xcc, 0x95, 0x1f, 0x83, 0x1d, 0x95, 0x89, 0xe4, 0x6b, 
  0xc9, 0xb5, 0xa9, 0x26, 0x12, 0x0f, 0xf1, 0x4a, 0x6b, 0xb6, 0xcd, 0x07, 
  0x82, 0x33, 0x2d, 0x45, 0xac, 0xbd, 0xc9, 0xef, 0xb7, 0x04, 0x65, 0x8c, 
  0xdb, 0xa0, 0x67, 0x56, 0xb1, 0x50, 0xd6, 0xce, 0xa8, 0x49, 0x38, 0x77, 
  0x9b, 0xd9, 0xc2, 0x95, 0xcc, 0x94, 0x53, 0x61, 0xe4, 0x26, 0xb6, 0x3c, 
  0x5e, 0xf8, 0x52, 0x83, 0x68, 0x6e, 0x60, 0xf9, 0x2a, 0x34, 0x83, 0x9e, 
  0x26, 0xf6, 0x00, 0x07, 0xf2, 0x56, 0x08, 0x42, 0x59, 0x87, 0xf3, 0xb6, 
  0x62, 0x20, 0xea, 0xa2, 0x69, 0xa6, 0x84, 0xf1, 0x52, 0xe4, 0xd7, 0xd8, 
  0x52, 0xad, 0x61, 0xdc, 0x40, 0x9a, 0xd7, 0x13, 0x28, 0xad, 0xe3, 0x5f, 
  0xae, 0x1b, 0x1e, 0x2a, 0xac, 0xc4, 0x23, 0xb7, 0x5e, 0x1c, 0x5f, 0x1d, 
  0x9e, 0x9c, 0x1e, 0xbf, 0x88, 0x4e, 0x5e, 0xbf, 0x3c, 0xbb, 0x78, 0x75, 
  0x78, 0xa5, 0x16, 0xba, 0x17, 0x2e, 0x76, 0xd5, 0x63, 0x24, 0x9a, 0xce, 
  0xe4, 0xe3, 0x5a, 0x41, 0xc3, 0xb4, 0x8d, 0xd7, 0x9a, 0xf9, 0xef, 0x60, 
  0x9a, 0x83, 0x45, 0xd8, 0x8a, 0xd4, 0xb2, 0xe7, 0x92, 0xe4, 0x71, 0x33, 
  0xef, 0x3a, 0x8b, 0xc9, 0xc8, 0xd6, 0xd3, 0xc2, 0xf3, 0x51, 0x22, 0xe7, 
  0xc1, 0xa6, 0x5c, 0xcd, 0x06, 0xb9, 0xa5, 0xd6, 0xbe, 0x22, 0x18, 0x13, 
  0xe5, 0xf0, 0x84, 0xf3, 0x7e, 0x10, 0x23, 0xbf, 0x54, 0xdc, 0xe0, 0xca, 
  0xe2, 0xee, 0x4b, 0x75, 0xdd, 0xfb, 0xfa, 0x4e, 0x20, 0x41, 0xd4, 0x9a, 
  0x08, 0xda, 0x74, 0xb1, 0xdd, 0xd8, 0x52, 0x8e, 0xc2, 0xf6, 0x7a, 0x69, 
  0xb8, 0xc1, 0x9c, 0x2e, 0xbb, 0xc5, 0x71, 0x27, 0x95, 0x1a, 0x9d, 0xc5, 
  0x87, 0x7d, 0x97, 0xb8, 0xc3, 0xce, 0xaf, 0x78, 0x1e, 0x6a, 0x66, 0x11, 
  0x05, 0x52, 0x09, 0x9b, 0xda, 0x76, 0xe5, 0x06, 0x48, 0x66, 0x19, 0x9e, 
  0x10, 0xc5, 0xf2, 0x7c, 0x78, 0x2d, 0x38, 0xc5, 0x8f, 0x7f, 0x66, 0x9e, 
  0xd1, 0x68, 0xdc, 0x8b, 0x97, 0x8f, 0x03, 0xe4, 0x55, 0x3d, 0x6e, 0xfe, 
  0xe0, 0x96, 0x46, 0x6a, 0x2f, 0xe8, 0x21, 0x06, 0x2c, 0x1f, 0x6a, 0xf7, 
  0x56, 0x8b, 0x82, 0x45, 0x23, 0xdb, 0x42, 0x11, 0x9b, 0x20, 0x0e, 0x70, 
  0x58, 0xa4, 0x44, 0x61, 0x66, 0x53, 0x9d, 0x07, 0x08, 0xbc, 0x32, 0x1b, 
  0x0c, 0x0b, 0xed, 0xde, 0x6c, 0xd2, 0xc0, 0x88, 0x6d, 0xc8, 0x12, 0x58, 
  0x90, 0x4b, 0xf7, 0x6c, 0x13, 0x54, 0x36, 0xf6, 0xe6, 0x6b, 0xac, 0xff, 
  0xb6, 0x61, 0xc2, 0x30, 0xcd, 0x6a, 0x83, 0x8a, 0xfd, 0xdd, 0xb6, 0xfa, 
  0xd4, 0x26, 0x15, 0xbe, 0x58, 0x37, 0xf3, 0x86, 0x8c, 0xde, 0xba, 0xc6, 
  0xe8, 0xa7, 0x5d, 0x23, 0x50, 0x36, 0x0e, 0x20, 0x79, 0xa2, 0x2a, 0x46, 
  0xa9, 0x8b, 0x61, 0xee, 0xe4, 0x54, 0xd5, 0x2d, 0x0d, 0xaf, 0x56, 0x56, 
  0x09, 0xb8, 0xdc, 0x30, 0x21, 0x69, 0xc2, 0x28, 0xb7, 0x6c, 0x7d, 0x50, 
  0x64, 0xe0, 0x20, 0xa2, 0x2b, 0x7a, 0x85, 0xaa, 0xa1, 0x82, 0x82, 0x04, 
  0xae, 0x97, 0x6d, 0x59, 0xb5, 0x0d, 0x7b, 0x69, 0xa2, 0xe2, 0x27, 0xd8, 
  0xbf, 0xe4, 0xaa, 0x81, 0xcb, 0xb3, 0x09, 0x34, 0x89, 0x4b, 0xb1, 0x60, 
  0xb0, 0xe6, 0x2b, 0x97, 0x06, 0x48, 0x00, 0x73, 0x75, 0x78, 0x12, 0xb8, 
  0x7d, 0x7c, 0x19, 0x8b, 0xa1, 0x24, 0xf1, 0xc6, 0x1c, 0x2e, 0x6f, 0x87, 
  0x02, 0x14, 0xed, 0x5b, 0x41, 0xe5, 0x1a, 0x76, 0x9c, 0x16, 0x73, 0x78, 
  0x6d, 0xd4, 0x75, 0x78, 0xce, 0x0f, 0xc4, 0x26, 0x63, 0xf7, 0x3c, 0x1c, 
  0x66, 0x6f, 0x79, 0x43, 0x7d, 0xf4, 0xa2, 0x6b, 0xd6, 0x52, 0xc6, 0x34, 
  0xf4, 0x16, 0x07, 0x9d, 0xca, 0xe3, 0xcf, 0x2f, 0xe2, 0x59, 0x9c, 0xcc, 
  0x3f, 0x3e, 0xd8, 0xbb, 0x8c, 0xaf, 0x57, 0xf3, 0xf8, 0xf7, 0x78, 0xf1, 
  0xf9, 0xa3, 0x47, 0x07, 0x7b, 0x7f, 0xfc, 0x6c, 0xaf, 0x17, 0xfd, 0xa5, 
  0x05, 0xf8, 0x12, 0xda, 0x45, 0x51, 0x30, 0x84, 0x19, 0x2f, 0xfa, 0x19, 
  0x4d, 0xae, 0x61, 0xce, 0xfd, 0x5a, 0xa0, 0xdf, 0x97, 0x32, 0x38, 0x3e, 
  0x44, 0xc2, 0x27, 0x05, 0x81, 0x99, 0x53, 0xe9, 0x89, 0xae, 0x3f, 0xda, 
  0x7f, 0x2a, 0xac, 0xec, 0x1a, 0x50, 0xff, 0xb1, 0x50, 0x6c, 0xf4, 0x2c, 
  0xcd, 0xe8, 0x0a, 0xfa, 0x3c, 0xaa, 0xe2, 0x6b, 0x47, 0xab, 0x68, 0xc1, 
  0xd5, 0x0e, 0x31, 0xf4, 0xe3, 0x59, 0x8a, 0x02, 0x09, 0xa3, 0x68, 0xfb, 
  0x4a, 0xa0, 0x50, 0x20, 0xf7, 0x2c, 0x93, 0x62, 0x2e, 0x59, 0x30, 0xf1, 
  0xc2, 0x9c, 0xdd, 0xfc, 0x3e, 0x7b, 0x32, 0x46, 0xcb, 0xb9, 0x2b, 0x56, 
  0x0c, 0xdd, 0x2b, 0xf5, 0x04, 0x37, 0x5f, 0x3a, 0xdd, 0x2b, 0x2d, 0xe5, 
  0xbe, 0x09, 0x41, 0x56, 0x68, 0xb1, 0x80, 0x89, 0xd9, 0xc3, 0xac, 0x84, 
  0x65, 0x80, 0x9b, 0x4d, 0x6d, 0xa6, 0x23, 0xfc, 0x0e, 0xd4, 0x6b, 0x2d, 
  0xe7, 0xd0, 0x5b, 0x4a, 0xd4, 0xa8, 0xc3, 0x41, 0xd5, 0xba, 0xda, 0xb5, 
  0x79, 0xc5, 0xde, 0xad, 0x19, 0x3d, 0x33, 0xf5, 0x76, 0xff, 0xf3, 0xe7, 
  0x20, 0x88, 0xfd, 0xcf, 0x7f, 0xef, 0x3e, 0x3b, 0xd0, 0xcf, 0x0e, 0x3e, 
  0xff, 0xfd, 0x68, 0x84, 0xf1, 0x31, 0x85, 0xf4, 0xed, 0xeb, 0xbe, 0xe6, 
  0x53, 0xc4, 0x7a, 0x84, 0xe5, 0x2f, 0x97, 0xc1, 0x2e, 0x7b, 0xdd, 0xb3, 
  0x9e, 0xc3, 0x55, 0x1e, 0x28, 0xbe, 0x45, 0xe5, 0x8b, 0xb7, 0x5a, 0xc0, 
  0x57, 0x05, 0x9b, 0x79, 0xc7, 0xa2, 0x3b, 0x8c, 0x22, 0xb4, 0x53, 0x06, 
  0x95, 0x5f, 0xff, 0xc0, 0x94, 0xfa, 0x87, 0x2d, 0xe4, 0xa5, 0xd2, 0x36, 
  0xf0, 0x76, 0x00, 0xeb, 0x3c, 0x32, 0xb2, 0x95, 0x12, 0x45, 0x82, 0xd7, 
  0xc2, 0x2d, 0xb3, 0xf3, 0x99, 0x2f, 0xc1, 0x00, 0xd4, 0xf3, 0xbf, 0xd4, 
  0xc4, 0x27, 0x1b, 0xbe, 0x65, 0x11, 0xa1, 0x12, 0x7f, 0x2c, 0xc0, 0x9d, 
  0xba, 0x59, 0x1f, 0x7f, 0xff, 0xbd, 0xca, 0x53, 0xf4, 0x8b, 0x8e, 0xfb, 
  0x86, 0x38, 0xd1, 0x94, 0x98, 0x1b, 0x23, 0x98, 0x52, 0xe3, 0x02, 0xd6, 
  0xaa, 0x37, 0xfe, 0x4c, 0xe7, 0x29, 0x8d, 0xd0, 0xc6, 0x4a, 0xcd, 0x08, 
  0x1e, 0x19, 0x96, 0xf4, 0x58, 0x98, 0x18, 0x28, 0x73, 0x1b, 0x96, 0x75, 
  0xef, 0xa7, 0x0a, 0x09, 0x9f, 0x77, 0x0e, 0x9b, 0x0e, 0xda, 0xa7, 0xc6, 
  0x4c, 0x01, 0xd6, 0x8d, 0x04, 0xc5, 0x8a, 0x90, 0xf3, 0xbc, 0x27, 0x0f, 
  0x5e, 0xa7, 0x3d, 0x0d, 0xe5, 0x95, 0x4f, 0x7a, 0x3e, 0x39, 0x46, 0x76, 
  0x03, 0x5b, 0xf6, 0x5c, 0x24, 0xa7, 0xf4, 0xe7, 0xe4, 0xf9, 0xfe, 0x5e, 
  0xf7, 0x13, 0xac, 0x16, 0xa1, 0xa2, 0xd8, 0x73, 0x6f, 0xfe, 0x7a, 0xe8, 
  0xf9, 0x74, 0x2a, 0x4f, 0x2b, 0x86, 0x39, 0x70, 0x67, 0x9f, 0xf7, 0xc6, 
  0x7c, 0xbf, 0xf2, 0xff, 0x6f, 0x18, 0x07, 0x5c, 0xea, 0xfa, 0x6c, 0xb9, 
  0x1a, 0x2f, 0xd2, 0xda, 0x80, 0x77, 0x79, 0x82, 0x9f, 0xc3, 0x98, 0x92, 
  0x38, 0xda, 0x40, 0xb0, 0x85, 0x88, 0x7e, 0xfd, 0x59, 0x9e, 0x8f, 0xe3, 
  0xa2, 0xaf, 0xe6, 0x3e, 0x1b, 0x67, 0x7f, 0xff, 0xe0, 0xd1, 0xe3, 0x4f, 
  0xfa, 0x23, 0x15, 0xd3, 0xc0, 0x20, 0xa0, 0xa1, 0xa5, 0xaa, 0xc9, 0x48, 
  0x13, 0xb1, 0x1c, 0xcf, 0xb0, 0xbe, 0x51, 0xa7, 0x51, 0x97, 0x79, 0x18, 
  0x77, 0xf7, 0x5c, 0x7a, 0xfb, 0x3d, 0xf7, 0xf3, 0x1c, 0x5d, 0xfc, 0x3e, 
  0x9d, 0x3e, 0x77, 0x33, 0xfc, 0x3d, 0xcf, 0xe5, 0xb9, 0x4e, 0x82, 0xf6, 
  0xd5, 0xe2, 0xb0, 0xca, 0x30, 0x3b, 0xff, 0x7d, 0x9b, 0x6b, 0x9b, 0xb8, 
  0x85, 0x49, 0xdf, 0x40, 0x45, 0x9c, 0x8a, 0xa1, 0x10, 0xc2, 0xaa, 0x8f, 
  0x10, 0xda, 0x7d, 0x37, 0xa4, 0x56, 0x86, 0xdc, 0xca, 0xd0, 0xb3, 0xeb, 
  0x68, 0xc1, 0xa1, 0x97, 0xbc, 0x11, 0x03, 0x8d, 0x4b, 0x9b, 0xc3, 0xca, 
  0xa1, 0x82, 0x40, 0x9e, 0x23, 0xea, 0xe8, 0xe8, 0xab, 0x93, 0xbe, 0xfa, 
  0x3b, 0x44, 0x6f, 0xd3, 0x42, 0x18, 0x75, 0x15, 0x13, 0xde, 0x4f, 0xbe, 
  0xa7, 0x34, 0xa3, 0x72, 0x2b, 0x28, 0xc9, 0x8a, 0x9d, 0x19, 0xe2, 0x28, 
  0xa2, 0xea, 0x9c, 0xdc, 0x39, 0xf3, 0x18, 0x68, 0xb7, 0x40, 0x0a, 0x0b, 
  0x9a, 0x01, 0x70, 0x02, 0x4c, 0xd7, 0xa2, 0x19, 0x7b, 0x9c, 0xb1, 0xe1, 
  0x4b, 0x55, 0xa1, 0x4a, 0x1f, 0x6c, 0xa4, 0x8f, 0xd2, 0x57, 0xc2, 0x4d, 
  0x8c, 0x41, 0xf4, 0xa0, 0x91, 0x7a, 0x2e, 0x11, 0xf2, 0x0e, 0x04, 0x48, 
  0x59, 0x75, 0x77, 0x35, 0x63, 0x88, 0x58, 0xc8, 0xdc, 0xf3, 0x99, 0x03, 
  0x71, 0xfe, 0x3c, 0x02, 0xce, 0xa7, 0xbc, 0xa5, 0xa1, 0x38, 0x6a, 0x00, 
  0x12, 0x63, 0x2d, 0x5e, 0x52, 0xed, 0xc0, 0x95, 0xf5, 0x08, 0x9c, 0x20, 
  0xbe, 0x82, 0x35, 0x72, 0x1a, 0x78, 0xa2, 0xb4, 0x9e, 0x62, 0x07, 0xe0, 
  0x16, 0xfa, 0x7f, 0xc2, 0x21, 0x78, 0xb6, 0x00, 0xba, 0x20, 0xfd, 0xfa, 
  0x79, 0x5f, 0x8c, 0x77, 0xb5, 0xa2, 0x63, 0xa3, 0x7a, 0xd9, 0x10, 0x21, 
  0xd0, 0x70, 0x3e, 0xf9, 0xcc, 0x25, 0xbe, 0x8b, 0x2c, 0x96, 0x66, 0x9a, 
  0xf1, 0x4e, 0xb2, 0xd4, 0x9c, 0x03, 0xd1, 0x58, 0xac, 0x54, 0x59, 0x68, 
  0xa0, 0x8d, 0x27, 0x1c, 0xf8, 0xc4, 0xb2, 0x63, 0x9f, 0x3d, 0x8c, 0x78, 
  0xaf, 0xef, 0x13, 0x3d, 0x73, 0xa8, 0x55, 0x6c, 0x2c, 0x48, 0xb4, 0x08, 
  0xd6, 0x60, 0x4b, 0xeb, 0x06, 0x78, 0x59, 0x3e, 0x9c, 0x58, 0x19, 0x88, 
  0x0e, 0x3e, 0x5c, 0x49, 0x72, 0xa0, 0x5a, 0x47, 0xe4, 0x25, 0x07, 0x55, 
  0x6a, 0xa7, 0xcf, 0x79, 0xb9, 0xf7, 0x47, 0xd7, 0xe9, 0x4c, 0x16, 0x83, 
  0x58, 0xe4, 0x75, 0xb2, 0x4b, 0x7f, 0x72, 0x71, 0xab, 0x03, 0x96, 0xc9, 
  0xf8, 0x97, 0x47, 0x70, 0x83, 0x85, 0x37, 0x7f, 0x70, 0x36, 0xdc, 0xb9, 
  0xe0, 0x5f, 0x52, 0x77, 0xe3, 0x9f, 0xcc, 0xc2, 0x65, 0x02, 0x99, 0x1b, 
  0x6e, 0x56, 0x67, 0x4d, 0x17, 0x80, 0xd4, 0xe4, 0x90, 0x4e, 0x4a, 0x1f, 
  0x23, 0xa0, 0xc5, 0x31, 0x7d, 0xa8, 0xe9, 0x76, 0xaa, 0xf6, 0x12, 0x0e, 
  0xa2, 0xc2, 0xbd, 0x9a, 0xdc, 0xef, 0x00, 0x6b, 0xc4, 0xd4, 0x5b, 0x86, 
  0x3c, 0xe0, 0x00, 0xeb, 0x30, 0x08, 0x5c, 0x76, 0x7f, 0x5b, 0x31, 0x33, 
  0x39, 0x40, 0x29, 0x2e, 0x10, 0x5b, 0x89, 0x6d, 0x4e, 0x9b, 0x3b, 0xe8, 
  0x00, 0xb3, 0x7d, 0x31, 0x6e, 0x76, 0x9a, 0xef, 0xa0, 0x4e, 0xd7, 0xbc, 
  0x84, 0xaa, 0xae, 0x88, 0xbd, 0x7e, 0xdd, 0x2d, 0xb1, 0x17, 0x5d, 0xf5, 
  0x19, 0xc2, 0x7b, 0x17, 0x9e, 0x0b, 0xe1, 0x6d, 0xc7, 0x74, 0x1c, 0x59, 
  0x54, 0x05, 0xd9, 0xce, 0x87, 0x72, 0x5f, 0xaa, 0x10, 0x34, 0x7c, 0x39, 
  0x8a, 0x4e, 0xe1, 0x2e, 0x2f, 0xe3, 0x35, 0xc8, 0xd9, 0xee, 0x54, 0xa3, 
  0x00, 0x22, 0x17, 0x91, 0xba, 0xb7, 0x24, 0xcf, 0x66, 0x14, 0x9d, 0x65, 
  0x46, 0x46, 0x40, 0x00, 0xf2, 0x7a, 0xa6, 0x48, 0x14, 0x2a, 0x81, 0x0c, 
  0x60, 0x7f, 0x76, 0xcf, 0xa1, 0xa8, 0x20, 0x9e, 0x92, 0x5a, 0x49, 0x8e, 
  0x48, 0x83, 0x46, 0x5c, 0x99, 0x28, 0x16, 0x39, 0x03, 0x56, 0xee, 0x08, 
  0x5f, 0xf2, 0x46, 0x12, 0x29, 0xca, 0x6c, 0xf5, 0x45, 0xe1, 0x32, 0xa1, 
  0xd6, 0x40, 0x59, 0x3c, 0x77, 0x26, 0x9d, 0x1e, 0x34, 0xc5, 0x79, 0xe2, 
  0xf4, 0x69, 0x45, 0xd8, 0x93, 0x78, 0x1d, 0xcb, 0x74, 0x14, 0x01, 0xc3, 
  0x27, 0x49, 0xf3, 0x20, 0x79, 0x5c, 0xf1, 0x1d, 0xfd, 0xc2, 0x97, 0xfc, 
  0xb8, 0xa0, 0x9d, 0xb6, 0xea, 0x78, 0x52, 0x0a, 0x3a, 0x17, 0xee, 0x21, 
  0x8a, 0xc9, 0xab, 0xd3, 0xa8, 0xa4, 0x47, 0x27, 0x89, 0xcb, 0x6c, 0xe1, 
  0x95, 0x35, 0x27, 0x38, 0xa6, 0xa8, 0xc6, 0x10, 0x91, 0x80, 0xf4, 0x29, 
  0xb9, 0xd9, 0x64, 0x6d, 0x39, 0x5c, 0x38, 0xe2, 0xc5, 0xa9, 0x1d, 0xd3, 
  0xe0, 0x09, 0x79, 0x75, 0x4b, 0xc2, 0x8b, 0xfa, 0xbc, 0x04, 0xfd, 0x41, 
  0xd4, 0xe7, 0xa1, 0xf2, 0x17, 0x7d, 0xac, 0x27, 0x3e, 0x0e, 0x96, 0xaf, 
  0x3f, 0xea, 0x38, 0x79, 0xfc, 0xcc, 0xf3, 0x2f, 0x6a, 0xab, 0x84, 0xcf, 
  0xad, 0xa9, 0xe7, 0x12, 0x74, 0xd4, 0x92, 0xb2, 0xed, 0xdd, 0xa0, 0xfd, 
  0xe7, 0x47, 0xd4, 0x8a, 0x60, 0xc5, 0xcb, 0x9e, 0x40, 0xa0, 0x76, 0x9f, 
  0xa5, 0x08, 0xc8, 0x6b, 0x35, 0xf4, 0xfe, 0x93, 0x7b, 0x65, 0xec, 0xc7, 
  0x79, 0xdb, 0x85, 0xa3, 0x09, 0x09, 0x18, 0xb7, 0xa5, 0xdd, 0x4c, 0x45, 
  0xd3, 0xa3, 0xc7, 0xd8, 0xae, 0x00, 0x3e, 0xb3, 0x3f, 0x8a, 0x2e, 0xf9, 
  0xdd, 0x46, 0x09, 0xbf, 0x34, 0x50, 0xd7, 0x7b, 0x58, 0xd0, 0x9e, 0xd9, 
  0x49, 0x9c, 0x12, 0x6f, 0xab, 0xdc, 0x36, 0x05, 0xd3, 0xd4, 0xb5, 0xc0, 
  0x1d, 0xf1, 0xab, 0x69, 0x7e, 0xcd, 0xec, 0x6a, 0x40, 0x37, 0x2b, 0xff, 
  0xec, 0x45, 0x78, 0xfc, 0x40, 0xfb, 0x95, 0x31, 0xe3, 0xb8, 0x88, 0xe8, 
  0x6e, 0x7f, 0x6b, 0x40, 0x40, 0xd4, 0xb1, 0x25, 0xd3, 0x7c, 0xa2, 0xcd, 
  0xbb, 0xd6, 0x65, 0x4f, 0xa8, 0x0b, 0xf7, 0x85, 0xef, 0x6e, 0xeb, 0xe2, 
  0xf8, 0xe5, 0xf1, 0xc5, 0x85, 0x38, 0x20, 0x0f, 0x6b, 0xb0, 0xa4, 0x48, 
  0xab, 0x95, 0x48, 0x5f, 0xab, 0x9d, 0x69, 0xfe, 0xff, 0x76, 0xed, 0x0f, 
  0x39, 0xa8, 0x0a, 0x5b, 0xb0, 0x15, 0x99, 0xd7, 0x4f, 0x00, 0x48, 0xc4, 
  0x60, 0x09, 0x6b, 0x17, 0xa2, 0x3f, 0x9c, 0x5d, 0x79, 0xce, 0x5c, 0x0f, 
  0xf6, 0xb0, 0xda, 0x5d, 0xb7, 0x15, 0xd9, 0xab, 0x85, 0x00, 0x2b, 0xbb, 
  0x92, 0x9c, 0xed, 0xb2, 0x90, 0x27, 0x88, 0xd8, 0x48, 0xd4, 0x97, 0x37, 
  0x77, 0xda, 0x32, 0x2e, 0xe6, 0x19, 0xd3, 0x0f, 0x4b, 0xf2, 0x05, 0xbb, 
  0xcf, 0xcb, 0x6a, 0xb5, 0x4c, 0xa7, 0xce, 0xf8, 0x48, 0x9f, 0x93, 0x38, 
  0x12, 0x09, 0x05, 0x96, 0x36, 0x62, 0x78, 0xb9, 0x4c, 0x35, 0x0e, 0x6d, 
  0x3f, 0x92, 0x71, 0xe4, 0x2d, 0x37, 0x08, 0xef, 0x93, 0x4a, 0x13, 0x86, 
  0xc8, 0xc8, 0x87, 0xbf, 0x75, 0x4c, 0x12, 0x18, 0xbd, 0x98, 0x92, 0xcd, 
  0x73, 0x1a, 0x52, 0x2d, 0x5b, 0x56, 0x16, 0x3e, 0xec, 0x45, 0xb0, 0xfd, 
  0x25, 0xf8, 0x95, 0x6f, 0xc6, 0xc2, 0x73, 0x34, 0xc4, 0x0e, 0xf9, 0x90, 
  0x14, 0x71, 0xb1, 0xd2, 0xac, 0x75, 0x85, 0x54, 0x27, 0xe3, 0x62, 0xb4, 
  0x1c, 0xe1, 0x71, 0x7c, 0x11, 0x1d, 0x7e, 0xc5, 0xd0, 0x06, 0xff, 0xda, 
  0xb6, 0xf2, 0x73, 0xca, 0xb1, 0x6c, 0x53, 0x35, 0xe9, 0x20, 0x31, 0x8b, 
  0xac, 0x24, 0x54, 0xd6, 0x76, 0x34, 0x55, 0x3c, 0xec, 0xe0, 0xda, 0xa9, 
  0xef, 0xdd, 0x56, 0xf4, 0xde, 0xdd, 0xfb, 0x90, 0xbd, 0x63, 0xdd, 0x33, 
  0xdc, 0x3d, 0x5c, 0xa5, 0x6a, 0x19, 0xb7, 0x3d, 0xd1, 0xd1, 0x97, 0x2d, 
  0xf5, 0x47, 0x76, 0xe7, 0x30, 0xea, 0xbf, 0xca, 0x7f, 0xa6, 0x0b, 0x2a, 
  0xde, 0x7d, 0x34, 0xda, 0x8b, 0xb6, 0xbf, 0x4b, 0xb3, 0x27, 0x9f, 0xfc, 
  0x29, 0x3a, 0xd9, 0xe9, 0xd7, 0x62, 0x79, 0x04, 0x09, 0x71, 0x1c, 0x67, 
  0xb7, 0x6e, 0xab, 0xce, 0x60, 0x47, 0x17, 0xe7, 0xbf, 0x81, 0x74, 0x3d, 
  0xc5, 0xde, 0x6f, 0x6c, 0x11, 0xc8, 0x02, 0x1a, 0x16, 0x14, 0x7d, 0xeb, 
  0x10, 0x63, 0x58, 0xd7, 0xa4, 0xa7, 0xa6, 0xbc, 0x74, 0x4f, 0x3e, 0x69, 
  0x35, 0xf1, 0xd8, 0xb5, 0xf1, 0x46, 0xda, 0xf8, 0x85, 0x4d, 0x1c, 0x8c, 
  0xf6, 0x0e, 0xa2, 0xed, 0xb3, 0xcb, 0xdd, 0x03, 0xd7, 0x42, 0xbb, 0x89, 
  0x03, 0x34, 0xc1, 0x0f, 0xd5, 0x5f, 0x7e, 0xcc, 0xfd, 0xff, 0x98, 0x64, 
  0x3f, 0x45, 0xdb, 0xdf, 0xef, 0xef, 0x53, 0x03, 0x7f, 0x8a, 0x0e, 0x4f, 
  0xbe, 0x8f, 0x1e, 0x8f, 0xa8, 0xb1, 0xd7, 0xf1, 0x9d, 0x36, 0xa7, 0xa0, 
  0x09, 0x97, 0x68, 0x84, 0xbe, 0x6f, 0xb5, 0xf1, 0x49, 0xa3, 0x8d, 0x53, 
  0xd2, 0x4f, 0xde, 0x11, 0x9f, 0xdb, 0x1b, 0x3d, 0x3a, 0x88, 0xd2, 0x4f, 
  0x3e, 0xfb, 0xd4, 0x1a, 0xd2, 0x36, 0xf0, 0x7d, 0xdd, 0x66, 0x26, 0x91, 
  0xff, 0x74, 0xfd, 0x1e, 0xbf, 0x23, 0x31, 0x1e, 0xac, 0x01, 0x90, 0x66, 
  0x37, 0xb1, 0xd4, 0x72, 0x1b, 0x0b, 0xa0, 0x30, 0xed, 0x94, 0xd8, 0x55, 
  0xd9, 0x40, 0x8e, 0x64, 0x8b, 0xf5, 0xd3, 0xd6, 0x70, 0x58, 0x47, 0xb2, 
  0x47, 0xff, 0x14, 0xbd, 0xba, 0x3c, 0x39, 0xa6, 0x19, 0xed, 0xd1, 0xd0, 
  0xfc, 0x1a, 0xca, 0x80, 0xf0, 0x15, 0x16, 0x97, 0x56, 0x95, 0x9a, 0xd1, 
  0x36, 0x42, 0xcc, 0x54, 0x10, 0x1d, 0x5d, 0x26, 0x25, 0xfa, 0xe5, 0xcc, 
  0xbd, 0xe1, 0xe1, 0x35, 0x8b, 0xb2, 0xca, 0xfe, 0xb9, 0xeb, 0x6f, 0xf2, 
  0x8c, 0x8e, 0x49, 0x91, 0x17, 0xbb, 0xfb, 0xa3, 0xbd, 0x7e, 0xed, 0x06, 
  0xfb, 0xe6, 0xc5, 0x71, 0xf4, 0x92, 0x2f, 0xbc, 0x57, 0x71, 0x46, 0xbc, 
  0x91, 0xb3, 0xf5, 0xca, 0x5b, 0xf6, 0x03, 0x8b, 0x57, 0x41, 0xde, 0x3f, 
  0x5d, 0x67, 0xef, 0x68, 0x1f, 0xff, 0x38, 0xda, 0xe7, 0x24, 0x12, 0xd6, 
  0xbe, 0x5e, 0xbe, 0xa2, 0xbf, 0xf7, 0x1f, 0xf7, 0x23, 0xfe, 0xaa, 0xae, 
  0x49, 0xda, 0x79, 0xdd, 0x3a, 0x3a, 0x3b, 0xfb, 0xe6, 0x44, 0x42, 0x02, 
  0x8e, 0xd4, 0xb8, 0xc7, 0x17, 0xbe, 0xd3, 0xce, 0x84, 0xab, 0x92, 0x16, 
  0xc1, 0x61, 0x76, 0x76, 0xb2, 0x68, 0x25, 0x6f, 0x93, 0x64, 0x09, 0x44, 
  0x97, 0x06, 0x47, 0xb0, 0xca, 0x10, 0x32, 0x32, 0x16, 0xf0, 0xd2, 0x69, 
  0xd2, 0x48, 0xb9, 0xaf, 0x4a, 0x67, 0x48, 0x1c, 0xaf, 0x5d, 0xe8, 0x7a, 
  0xec, 0x3c, 0x37, 0x56, 0xd1, 0x49, 0x9b, 0x32, 0x43, 0xa8, 0x14, 0x40, 
  0xa2, 0x17, 0x55, 0x07, 0xeb, 0x5f, 0x26, 0xd5, 0x50, 0x06, 0xfd, 0x54, 
  0x6d, 0x87, 0x7d, 0x57, 0xdf, 0x4d, 0x2d, 0x31, 0x4b, 0x05, 0x84, 0x83, 
  0x01, 0x73, 0xbd, 0xe4, 0x72, 0x1a, 0x5c, 0xfc, 0x59, 0x78, 0x32, 0xea, 
  0x04, 0x25, 0x88, 0x0c, 0x7d, 0x7d, 0xf8, 0xea, 0xf8, 0xf9, 0xb7, 0x87, 
  0xa7, 0x6f, 0x8e, 0x51, 0x27, 0xb8, 0x8c, 0xb6, 0x3d, 0x9a, 0x07, 0xc6, 
  0xb8, 0x48, 0x27, 0xf9, 0x9c, 0x9d, 0x1d, 0xfd, 0x3f, 0xf5, 0xc1, 0x99, 
  0x68, 0x00, 0x3d, 0x7e, 0x6b, 0x5f, 0x5e, 0x23, 0xba, 0xe0, 0xbf, 0x0e, 
  0xe4, 0xaf, 0x83, 0x3f, 0xf5, 0x76, 0x6a, 0x93, 0x6e, 0x69, 0x6b, 0x4c, 
  0x2f, 0xf7, 0x12, 0x99, 0xc4, 0x61, 0x4f, 0x18, 0x71, 0x4f, 0x56, 0xa5, 
  0x67, 0x9e, 0x02, 0xbb, 0xd3, 0xf8, 0xd9, 0xed, 0xf1, 0x3a, 0xd4, 0x05, 
  0x7b, 0xfc, 0xd2, 0x73, 0x98, 0x26, 0x7a, 0x3b, 0x03, 0xb1, 0x8f, 0xeb, 
  0xc2, 0xa3, 0x0d, 0x6b, 0x22, 0x79, 0xb7, 0xe4, 0x28, 0x96, 0xed, 0x9e, 
  0xfc, 0xf2, 0xfc, 0xc5, 0xe1, 0xd5, 0x31, 0xbf, 0x60, 0xdd, 0x47, 0x12, 
  0x7f, 0xe5, 0xe0, 0x50, 0x78, 0x3c, 0xdb, 0x3d, 0xf9, 0xf0, 0x39, 0x4f, 
  0xa8, 0xb7, 0x23, 0x16, 0x75, 0x78, 0x5b, 0x1b, 0xe3, 0xca, 0x01, 0xd3, 
  0xcf, 0x29, 0x05, 0x9a, 0x31, 0x06, 0x6f, 0x90, 0x46, 0x2e, 0x6c, 0xf7, 
  0xe4, 0xbb, 0x9e, 0xb3, 0x23, 0x6a, 0xf9, 0x14, 0x57, 0x6d, 0x2e, 0xee, 
  0x8a, 0xf9, 0x15, 0xf4, 0x62, 0xbf, 0x3f, 0x6a, 0x32, 0x17, 0xcb, 0x47, 
  0x80, 0xe8, 0xe2, 0x36, 0xbe, 0x14, 0x84, 0x3f, 0xb6, 0x75, 0xe4, 0xf9, 
  0xfe, 0xc1, 0xa3, 0x3f, 0x61, 0x3d, 0x9f, 0xf7, 0x76, 0xe9, 0x6e, 0xe8, 
  0xfd, 0x89, 0xbb, 0x4e, 0x2b, 0x87, 0x8c, 0xec, 0xf6, 0x83, 0x65, 0x7c, 
  0xa5, 0x28, 0x09, 0x9b, 0x40, 0x75, 0x68, 0xb6, 0x9d, 0xc8, 0xbc, 0xb0, 
  0xa0, 0xf7, 0x12, 0x24, 0x6a, 0x29, 0x21, 0xe6, 0x55, 0xc6, 0x7e, 0xa1, 
  0x90, 0x43, 0xe6, 0xa0, 0xba, 0xa4, 0xbb, 0xf0, 0xfe, 0x18, 0x28, 0xc2, 
  0x24, 0xe6, 0xa8, 0xc5, 0x5b, 0xb8, 0xcf, 0xc5, 0xda, 0xe2, 0x48, 0xcb, 
  0xd2, 0x54, 0x2d, 0xd9, 0xb3, 0x96, 0xda, 0x3a, 0x56, 0x1b, 0x83, 0x09, 
  0xc8, 0x90, 0x05, 0x88, 0xb5, 0xac, 0x21, 0x20, 0x69, 0x51, 0x65, 0xef, 
  0x7d, 0xb7, 0x3b, 0x3b, 0x1e, 0x73, 0x20, 0xbc, 0xe1, 0x64, 0x87, 0xda, 
  0xa1, 0x5b, 0x7a, 0x3b, 0x7e, 0x69, 0x90, 0xeb, 0xc3, 0x17, 0xa5, 0xac, 
  0x65, 0xe9, 0x6c, 0x19, 0xf0, 0x79, 0xe9, 0xb3, 0xf5, 0x7d, 0x6a, 0x84, 
  0xa3, 0x62, 0x1a, 0xa2, 0x5a, 0x8a, 0xce, 0x46, 0xac, 0x26, 0x4b, 0x8a, 
  0x07, 0x3d, 0xef, 0x1d, 0x2e, 0x11, 0x4c, 0x51, 0x35, 0x12, 0x9b, 0xe0, 
  0x68, 0x34, 0x72, 0x22, 0x38, 0xdc, 0x39, 0xea, 0x09, 0x01, 0x1e, 0x54, 
  0x0d, 0xa2, 0x80, 0xd6, 0x98, 0xf3, 0xec, 0x35, 0x59, 0x7c, 0x47, 0x03, 
  0x32, 0x56, 0x0e, 0x8a, 0xa1, 0x36, 0x13, 0x5e, 0xa9, 0xbe, 0x76, 0xdb, 
  0xdf, 0x1c, 0x33, 0x49, 0x9b, 0xf0, 0xc0, 0xd8, 0xc4, 0x06, 0x56, 0xc6, 
  0x48, 0xa5, 0x71, 0x7c, 0x2a, 0x77, 0x6b, 0xc1, 0x14, 0xcc, 0xe9, 0x35, 
  0xa0, 0x13, 0x09, 0xeb, 0x94, 0x45, 0xd3, 0xa1, 0x28, 0xa2, 0x3a, 0x33, 
  0xb9, 0xfc, 0x9e, 0xef, 0x22, 0xc9, 0x09, 0xe1, 0xa0, 0x84, 0x4c, 0x54, 
  0x56, 0xbb, 0x41, 0x04, 0xa8, 0x8f, 0x63, 0x07, 0xa5, 0x99, 0x69, 0xae, 
  0x35, 0x64, 0x4f, 0x44, 0x8f, 0xd4, 0x18, 0x67, 0x4d, 0xd2, 0x2a, 0x63, 
  0xc5, 0x87, 0x70, 0xb5, 0x93, 0x6d, 0xee, 0x5e, 0x7b, 0xe7, 0xa0, 0xa3, 
  0xa1, 0x24, 0x66, 0x59, 0x18, 0xb2, 0x31, 0x0f, 0x2d, 0xe3, 0xf5, 0x90, 
  0xd7, 0x76, 0x62, 0x2d, 0x3a, 0x97, 0x6d, 0x63, 0x69, 0xfc, 0xa5, 0x5c, 
  0xe7, 0x5c, 0xb4, 0xa0, 0x62, 0xe4, 0x74, 0x70, 0x5d, 0xca, 0xf6, 0xa2, 
  0xf8, 0x9e, 0x6e, 0x9e, 0x8c, 0x48, 0x50, 0xbc, 0x37, 0x62, 0x28, 0x38, 
  0x0d, 0xcc, 0x5d, 0x6e, 0x86, 0x56, 0x57, 0x29, 0x0e, 0x2a, 0x2b, 0x29, 
  0x0c, 0x5b, 0x3e, 0x63, 0xe5, 0xdc, 0xec, 0x4a, 0x29, 0xe0, 0xb7, 0x19, 
  0x32, 0x42, 0x05, 0x74, 0xd3, 0x18, 0x79, 0xe4, 0xc4, 0xa1, 0x2f, 0x95, 
  0x6c, 0x52, 0x84, 0xa7, 0xb1, 0xea, 0x2d, 0xde, 0x7d, 0x5b, 0x2d, 0x14, 
  0xec, 0x70, 0x9d, 0x0c, 0x82, 0x60, 0x5b, 0xa6, 0x2a, 0xae, 0x11, 0x96, 
  0x0d, 0x5d, 0x3a, 0x8e, 0x0b, 0x09, 0x2a, 0xd2, 0xeb, 0xeb, 0xa4, 0x08, 
  0x1c, 0x66, 0x7e, 0x6a, 0xdd, 0x34, 0x76, 0xca, 0xab, 0x92, 0x2c, 0x96, 
  0xd5, 0x7a, 0xd3, 0x6a, 0x5e, 0xb9, 0xba, 0x33, 0x6a, 0x08, 0xa8, 0xd1, 
  0xb2, 0x39, 0xc6, 0x1c, 0x6c, 0x90, 0xa5, 0x4e, 0xa0, 0xb8, 0x5d, 0xcd, 
  0x91, 0x89, 0xd4, 0x7e, 0xce, 0x2d, 0xf5, 0x99, 0x22, 0xb6, 0xe9, 0x48, 
  0x9f, 0xf5, 0x71, 0x10, 0x53, 0x36, 0x77, 0x2e, 0xf8, 0x26, 0xbe, 0x77, 
  0x21, 0x38, 0x82, 0xff, 0x3f, 0x8e, 0xbd, 0xa6, 0xb5, 0x15, 0xd5, 0x8c, 
  0x8e, 0x28, 0x6a, 0x9c, 0x29, 0x1b, 0xca, 0xef, 0x12, 0x9f, 0x57, 0xee, 
  0xed, 0x5e, 0x1e, 0x8e, 0x45, 0x0f, 0xbf, 0xe3, 0x25, 0x0d, 0x2f, 0xa3, 
  0x63, 0x57, 0x98, 0x64, 0x63, 0x55, 0x46, 0x51, 0xd0, 0xa4, 0x68, 0xef, 
  0x79, 0xc8, 0xe1, 0x65, 0x6c, 0xea, 0x3c, 0xb5, 0x16, 0x85, 0x46, 0x04, 
  0x04, 0x37, 0xd0, 0x4c, 0x78, 0x41, 0xd2, 0x4a, 0xa9, 0xaa, 0x74, 0xa1, 
  0x5b, 0xde, 0x09, 0x69, 0xb3, 0xec, 0xb9, 0x4d, 0xea, 0x01, 0xf2, 0x6a, 
  0x5c, 0x23, 0x02, 0xb6, 0x1b, 0x39, 0x47, 0xf2, 0xe1, 0x3c, 0xe6, 0x58, 
  0x8a, 0x5c, 0x7c, 0xd4, 0xd8, 0x33, 0x50, 0x35, 0x0c, 0x3c, 0x0d, 0x9e, 
  0xda, 0x3a, 0x7f, 0x2e, 0x66, 0x40, 0x88, 0x0d, 0x90, 0x29, 0xdc, 0x0c, 
  0x91, 0x09, 0x37, 0x32, 0x9c, 0x18, 0x73, 0x77, 0x1e, 0xf9, 0xce, 0x64, 
  0x8a, 0x71, 0xed, 0x90, 0xbe, 0xef, 0xcc, 0x9e, 0x5f, 0x9c, 0x7d, 0x75, 
  0x71, 0x7c, 0x79, 0x19, 0xbd, 0x3a, 0xbe, 0x12, 0x5d, 0xff, 0x2a, 0x04, 
  0xd3, 0x83, 0xf9, 0xdb, 0x50, 0xc4, 0x2c, 0x06, 0x22, 0x16, 0x57, 0x87, 
  0x00, 0x98, 0xe5, 0xec, 0xda, 0x81, 0x28, 0x07, 0x3d, 0x7e, 0xae, 0x51, 
  0x5d, 0x37, 0x30, 0x40, 0x23, 0xca, 0x06, 0x1e, 0x32, 0x67, 0xcf, 0xf5, 
  0x56, 0xbe, 0xa0, 0x84, 0xe0, 0x8d, 0xb1, 0x2e, 0x6f, 0xd5, 0xd5, 0x2a, 
  0x6c, 0x98, 0xde, 0xc7, 0xd1, 0x95, 0x15, 0x29, 0xfb, 0x38, 0xba, 0x30, 
  0x02, 0xf9, 0x38, 0xfa, 0x9e, 0xda, 0x9c, 0x72, 0x05, 0x39, 0x29, 0x3e, 
  0x72, 0x89, 0xa2, 0x23, 0x1e, 0x4a, 0x00, 0x08, 0xd8, 0xc1, 0x7f, 0x44, 
  0xe6, 0xc5, 0xe8, 0xe1, 0x32, 0x1e, 0xc8, 0x87, 0x93, 0xc2, 0x26, 0x1a, 
  0xe3, 0xe5, 0x7a, 0x3e, 0x42, 0xf1, 0xbb, 0x2a, 0x8a, 0x4e, 0x93, 0x59, 
  0x05, 0x81, 0x84, 0xbb, 0xa3, 0xe6, 0xf6, 0x18, 0xc1, 0x67, 0xff, 0x15, 
  0x7f, 0xb4, 0x17, 0x3d, 0xfa, 0xec, 0xd3, 0xbd, 0xcf, 0xe4, 0x57, 0xfb, 
  0xf7, 0xc9, 0xe3, 0x3d, 0x05, 0xc9, 0xa2, 0xbf, 0x1e, 0x3f, 0x7d, 0xbc, 
  0xff, 0x94, 0xd3, 0xa1, 0xf7, 0x9e, 0xee, 0xd1, 0xff, 0x3f, 0xd6, 0x4f, 
  0x38, 0x8f, 0xfc, 0xc9, 0xc1, 0x67, 0x7f, 0x44, 0x78, 0x06, 0xd3, 0xc7, 
  0x9c, 0x3a, 0x19, 0x56, 0xf9, 0xb0, 0xe0, 0x02, 0x0d, 0x10, 0x82, 0x3e, 
  0xae, 0x1b, 0xca, 0xd8, 0xdf, 0x3b, 0x61, 0xff, 0xde, 0x75, 0x12, 0xd4, 
  0xce, 0x54, 0xa3, 0x9f, 0x64, 0xe9, 0x85, 0xb0, 0x3a, 0x6e, 0x1a, 0xfa, 
  0xb6, 0x14, 0xac, 0x41, 0x0a, 0x63, 0xed, 0x1d, 0x12, 0x19, 0xe9, 0x6a, 
  0x0d, 0x72, 0x25, 0x7f, 0x69, 0xd7, 0x21, 0x40, 0xbd, 0xdb, 0x2a, 0x7d, 
  0x4f, 0xea, 0x07, 0x72, 0x75, 0x8b, 0xa0, 0xca, 0x4e, 0xa3, 0x68, 0xce, 
  0x2f, 0xed, 0x4f, 0x5c, 0x37, 0xfc, 0x96, 0x52, 0x43, 0xd4, 0xee, 0xcd, 
  0xaa, 0x07, 0x75, 0xf5, 0x55, 0x23, 0x9e, 0x2d, 0xbf, 0xfd, 0x7e, 0xa5, 
  0x82, 0x22, 0x3b, 0x2e, 0x81, 0x54, 0xea, 0xdb, 0x74, 0x4c, 0xb9, 0xd5, 
  0xdc, 0x9b, 0x65, 0xd8, 0xde, 0x87, 0x34, 0xe7, 0x67, 0x04, 0x0a, 0x76, 
  0x3b, 0x37, 0x0c, 0x36, 0x27, 0x95, 0x50, 0x2b, 0x57, 0x28, 0xa7, 0x96, 
  0x77, 0xef, 0x5e, 0x75, 0x24, 0x3b, 0x94, 0x37, 0x54, 0xfc, 0x2c, 0x91, 
  0x5b, 0x21, 0x92, 0xc2, 0x5d, 0x2e, 0x70, 0xd8, 0x78, 0xde, 0x28, 0xbb, 
  0xd5, 0x15, 0x53, 0x63, 0xd8, 0x9f, 0xf5, 0x82, 0x13, 0xe5, 0x8e, 0xdd, 
  0x83, 0x93, 0xf3, 0x01, 0xd7, 0x0e, 0x94, 0x7e, 0xdb, 0x05, 0x30, 0x77, 
  0x1d, 0x4a, 0xff, 0x1c, 0x62, 0x9a, 0x83, 0xda, 0x6b, 0xfe, 0x2e, 0x42, 
  0x71, 0x02, 0x03, 0x14, 0x9c, 0xe4, 0x2b, 0xc6, 0x6b, 0xdb, 0x31, 0x26, 
  0x36, 0xfc, 0xc8, 0x45, 0x12, 0xe1, 0x6a, 0xb3, 0x82, 0xb3, 0x42, 0xfb, 
  0x4c, 0x84, 0x61, 0x30, 0x99, 0x47, 0x32, 0xad, 0x44, 0x45, 0x32, 0x24, 
  0x75, 0xae, 0xc2, 0x45, 0x97, 0x2d, 0x5d, 0x1e, 0x41, 0xed, 0x8b, 0xdf, 
  0x6d, 0x6d, 0x5d, 0x9e, 0x1f, 0x1f, 0xbf, 0x88, 0x4e, 0x4f, 0x5e, 0x9d, 
  0x5c, 0x05, 0x22, 0xb9, 0xbb, 0x4b, 0x84, 0x45, 0xe6, 0x82, 0xd6, 0x78, 
  0xd3, 0x5a, 0x0e, 0x0f, 0x2a, 0xa3, 0x58, 0x8a, 0x7a, 0x9b, 0x13, 0x37, 
  0x15, 0xef, 0xdc, 0xbc, 0xf9, 0x1e, 0x94, 0x6f, 0xe4, 0x9f, 0x8e, 0xa2, 
  0x2f, 0x83, 0x60, 0xbd, 0xa8, 0x24, 0xf9, 0x66, 0xc2, 0xa5, 0x19, 0xe4, 
  0x9a, 0xf8, 0x41, 0x43, 0x07, 0xea, 0xc2, 0x93, 0xc2, 0x33, 0xb8, 0xb2, 
  0x0c, 0x1a, 0x6f, 0xd9, 0x18, 0x15, 0xaf, 0x6d, 0x22, 0x01, 0xb8, 0x49, 
  0xad, 0x0c, 0x09, 0x63, 0x75, 0x97, 0x2c, 0x1c, 0x2e, 0x52, 0xc9, 0x35, 
  0x89, 0x1b, 0xd8, 0x3a, 0xe6, 0xd9, 0x06, 0x27, 0x0f, 0x7b, 0x0c, 0xce, 
  0x87, 0x0b, 0xf2, 0xb4, 0xbe, 0xc2, 0x72, 0x07, 0x8f, 0xf6, 0x5c, 0x0c, 
  0xbb, 0x14, 0xc8, 0x50, 0x61, 0x9f, 0x3b, 0xdb, 0x8f, 0x48, 0x24, 0x59, 
  0xb1, 0x5c, 0x5f, 0xac, 0xb2, 0xd6, 0x85, 0xf7, 0x83, 0xbc, 0x4b, 0xf3, 
  0xff, 0x74, 0x0f, 0x17, 0xdc, 0x2c, 0x2e, 0x86, 0x24, 0x7c, 0xad, 0x87, 
  0x66, 0x57, 0x15, 0x8a, 0x00, 0x06, 0x70, 0x26, 0x91, 0x53, 0xc8, 0xdd, 
  0xf5, 0x05, 0x54, 0x42, 0x81, 0xd1, 0x27, 0x22, 0xe4, 0x70, 0x96, 0xcd, 
  0xf5, 0x08, 0xf0, 0xd4, 0x07, 0x11, 0xea, 0xb8, 0xb9, 0x98, 0x5c, 0x11, 
  0x77, 0xec, 0xe0, 0x51, 0x3b, 0xb6, 0x8d, 0x9e, 0x4d, 0x71, 0x9c, 0x3a, 
  0x38, 0x2b, 0x37, 0x9b, 0xf2, 0x3c, 0x75, 0x32, 0x6d, 0xf1, 0x7a, 0x11, 
  0xed, 0x7f, 0xc6, 0x13, 0xf9, 0xb0, 0x09, 0x31, 0xde, 0xb4, 0x05, 0x58, 
  0x89, 0xc6, 0x90, 0xfb, 0xed, 0x94, 0xe0, 0x79, 0x00, 0x84, 0xca, 0xf2, 
  0x5a, 0xa4, 0x26, 0x02, 0xc9, 0x58, 0x45, 0x51, 0x2f, 0x2f, 0x8c, 0x53, 
  0x70, 0xbb, 0x8a, 0x94, 0x64, 0xd5, 0xd1, 0xd5, 0xdc, 0xaa, 0x05, 0x50, 
  0x0b, 0x9f, 0x3b, 0x84, 0x75, 0x00, 0x06, 0x59, 0x36, 0xbd, 0x4f, 0xa7, 
  0x90, 0xac, 0xcd, 0x0e, 0x00, 0x02, 0x14, 0xea, 0x93, 0x00, 0x5e, 0x78, 
  0xd5, 0xe0, 0x8e, 0x73, 0x23, 0x53, 0x19, 0x06, 0x35, 0x93, 0x60, 0x5f, 
  0xd8, 0x86, 0x08, 0xc1, 0x58, 0xea, 0x75, 0xb7, 0x00, 0x73, 0xe7, 0x9e, 
  0xf4, 0x82, 0xfd, 0x28, 0xf2, 0xaa, 0x9a, 0x9b, 0x65, 0xe1, 0x95, 0x23, 
  0xec, 0xfa, 0x94, 0x39, 0x6b, 0x33, 0x98, 0xf5, 0xfe, 0x1e, 0x89, 0xb0, 
  0xf3, 0xbc, 0x59, 0x27, 0xa3, 0xad, 0x96, 0x62, 0x56, 0x43, 0x2c, 0xce, 
  0xfe, 0xde, 0x37, 0x9b, 0x17, 0x9d, 0x23, 0x7e, 0x1f, 0x7e, 0xf9, 0xe0, 
  0xf1, 0x03, 0x7b, 0x76, 0x56, 0x74, 0x40, 0xd5, 0x3b, 0x3c, 0xad, 0xf6, 
  0xae, 0x11, 0xe1, 0x27, 0xd7, 0x31, 0x8a, 0x18, 0x3e, 0x30, 0x7a, 0xcb, 
  0x21, 0x68, 0x0c, 0xe5, 0x95, 0x46, 0x0a, 0xcb, 0x97, 0x25, 0xdb, 0xc8, 
  0x96, 0x80, 0x14, 0xf0, 0x8a, 0x6c, 0x50, 0xa0, 0x37, 0xa9, 0xbf, 0x2d, 
  0x9c, 0x73, 0x50, 0x67, 0x12, 0x46, 0x3c, 0x45, 0x72, 0x0d, 0x37, 0x2f, 
  0x78, 0x30, 0x2b, 0xfe, 0x34, 0xb8, 0xa1, 0x9e, 0x57, 0xe2, 0xcd, 0x1c, 
  0xd3, 0x22, 0xe4, 0x04, 0xc6, 0x3b, 0x89, 0x4d, 0x68, 0xd5, 0xe2, 0xb2, 
  0x8d, 0x8b, 0x81, 0x2d, 0xb4, 0x13, 0x4e, 0xc3, 0x02, 0x37, 0x90, 0xe3, 
  0x15, 0xd6, 0xdb, 0x90, 0xe2, 0x02, 0x23, 0xa4, 0x6a, 0x09, 0x9d, 0x38, 
  0x66, 0x2f, 0xe5, 0xa5, 0x89, 0xc8, 0xc4, 0x47, 0x80, 0x06, 0x06, 0x4a, 
  0xb4, 0x68, 0xc9, 0x75, 0xc5, 0x1c, 0xbf, 0xb4, 0x34, 0x3e, 0xc1, 0x00, 
  0x63, 0xcb, 0xff, 0xd1, 0xd9, 0xeb, 0x97, 0x27, 0x5f, 0xb9, 0x0c, 0x66, 
  0x61, 0xe2, 0xab, 0x2a, 0x67, 0xcb, 0xa6, 0x98, 0x0d, 0x5d, 0x79, 0x0c, 
  0xe7, 0x8a, 0x55, 0x2c, 0x69, 0x0d, 0x08, 0x25, 0xf6, 0xf4, 0x36, 0xfc, 
  0x00, 0x0c, 0x24, 0x7b, 0xc4, 0xd6, 0x72, 0x81, 0x77, 0x2b, 0x77, 0xbc, 
  0xed, 0xa1, 0x91, 0x51, 0x2f, 0x79, 0x03, 0x71, 0x51, 0xad, 0x96, 0x2e, 
  0xae, 0x2d, 0xc0, 0xa2, 0x56, 0xe4, 0x18, 0xbe, 0x15, 0x48, 0x7a, 0xa1, 
  0x4d, 0x16, 0xd6, 0xa4, 0x35, 0xaa, 0x6b, 0xa6, 0x5d, 0xb9, 0x03, 0xd8, 
  0xb6, 0xc0, 0x81, 0xe5, 0xfe, 0x02, 0x68, 0x05, 0x8b, 0xcc, 0x73, 0xf6, 
  0x49, 0x07, 0x31, 0xdc, 0xe6, 0xcc, 0xe1, 0x2a, 0x19, 0x32, 0x51, 0x5c, 
  0x1a, 0xa9, 0x44, 0x0e, 0x6f, 0x09, 0xcc, 0x92, 0x14, 0x05, 0xfb, 0xc1, 
  0xd5, 0x4d, 0xd3, 0x80, 0x54, 0xef, 0x2c, 0x72, 0xf8, 0xc1, 0x3e, 0x68, 
  0x46, 0x06, 0x8b, 0xe0, 0xb6, 0x92, 0x23, 0x17, 0x4c, 0x11, 0x7f, 0xce, 
  0x3e, 0x9a, 0xa7, 0x8c, 0x0e, 0xb5, 0x90, 0xcc, 0x74, 0x8d, 0x68, 0x75, 
  0x49, 0x92, 0x69, 0x00, 0xe0, 0x64, 0xf1, 0x15, 0x62, 0xaf, 0xd3, 0xd2, 
  0xd5, 0x4a, 0x74, 0x62, 0x30, 0x66, 0x6b, 0x4b, 0xff, 0xa3, 0xbe, 0x95, 
  0xbb, 0xd6, 0x64, 0x00, 0x07, 0xff, 0x68, 0x0f, 0x55, 0x34, 0x8d, 0x4a, 
  0xca, 0xb3, 0xa3, 0xd6, 0xfc, 0xc2, 0x10, 0x38, 0x9b, 0x01, 0x3c, 0x7e, 
  0xfc, 0x02, 0x36, 0x0b, 0x5f, 0x91, 0xcd, 0x82, 0x9f, 0x04, 0x8b, 0x67, 
  0xc7, 0x58, 0xae, 0x54, 0xcd, 0x19, 0x82, 0x58, 0xa9, 0xfa, 0xd4, 0xd9, 
  0xed, 0x87, 0x4a, 0xd8, 0x02, 0xb5, 0x48, 0xe2, 0x0e, 0x9b, 0x87, 0xbf, 
  0xb3, 0x09, 0xf2, 0xdb, 0xf2, 0xc5, 0xa0, 0x56, 0xef, 0x9d, 0x67, 0x26, 
  0xd8, 0x8c, 0x34, 0xd4, 0xbf, 0x88, 0x75, 0x51, 0x9c, 0x7f, 0x3f, 0x58, 
  0xe7, 0xf6, 0x68, 0x63, 0xe9, 0x89, 0x9e, 0xe2, 0xe2, 0x5a, 0xd3, 0xfd, 
  0xd5, 0xad, 0x06, 0x35, 0xd1, 0xc1, 0x73, 0x3a, 0x2b, 0x25, 0x0b, 0x25, 
  0x2e, 0x90, 0x03, 0xe2, 0xd3, 0x4a, 0x12, 0xcd, 0x34, 0x2f, 0x47, 0xec, 
  0x93, 0x8e, 0x10, 0x03, 0x8e, 0xf3, 0x91, 0x0b, 0x96, 0x88, 0xfd, 0x55, 
  0x66, 0xb0, 0x7b, 0xde, 0x58, 0xab, 0x77, 0x59, 0xf0, 0x1a, 0x5b, 0xf4, 
  0xa0, 0x0b, 0x27, 0x6a, 0x46, 0x91, 0xae, 0x20, 0x4b, 0x30, 0x8e, 0x06, 
  0x12, 0x52, 0x92, 0xd2, 0x37, 0x21, 0xdf, 0x3f, 0xd7, 0x34, 0x5d, 0x3a, 
  0xcf, 0x9a, 0x36, 0xac, 0x38, 0x04, 0x9f, 0xed, 0xa9, 0x2d, 0xae, 0xd2, 
  0x08, 0xca, 0x32, 0x3a, 0xbc, 0x38, 0x06, 0x4a, 0x12, 0x12, 0x6b, 0x79, 
  0x84, 0x95, 0xee, 0x0f, 0x44, 0x6b, 0x5e, 0x05, 0x3d, 0x1f, 0xdc, 0xe1, 
  0x7d, 0xf0, 0x26, 0x13, 0x93, 0xc2, 0x14, 0xd2, 0x21, 0x73, 0xa1, 0x51, 
  0x4c, 0x72, 0x93, 0x9b, 0x98, 0x73, 0x36, 0xe0, 0x5a, 0x9c, 0x45, 0x9c, 
  0xe6, 0x2a, 0x24, 0x05, 0x90, 0x9c, 0xeb, 0x2c, 0x37, 0x8c, 0xa5, 0xf3, 
  0x16, 0x5b, 0x37, 0xe0, 0xc3, 0x30, 0x68, 0x06, 0xa7, 0xda, 0x47, 0xc7, 
  0xff, 0xcd, 0xe0, 0x43, 0xb4, 0xaf, 0x9a, 0x0f, 0xd4, 0x93, 0xd3, 0xa0, 
  0xdb, 0x80, 0xf4, 0x37, 0xdc, 0x33, 0x2c, 0x8b, 0x34, 0xc5, 0x82, 0xc4, 
  0x05, 0x7d, 0x8b, 0x29, 0x7b, 0x1a, 0x08, 0xbf, 0x92, 0x32, 0xc6, 0x61, 
  0xbf, 0x62, 0xa5, 0x66, 0xe1, 0x27, 0x2e, 0x35, 0x2d, 0x47, 0x15, 0x82, 
  0xa9, 0x9e, 0x55, 0xa6, 0x0a, 0x8e, 0x60, 0xa5, 0x11, 0x2f, 0x04, 0x02, 
  0xae, 0x46, 0x16, 0xdd, 0x86, 0xde, 0x8f, 0xdc, 0x6c, 0xfd, 0x18, 0xb6, 
  0x82, 0xb2, 0xed, 0xb4, 0xa5, 0x3d, 0xf5, 0xa0, 0xf2, 0x28, 0x46, 0xdc, 
  0x11, 0x58, 0x2a, 0x1c, 0xa8, 0xfc, 0x0b, 0x3e, 0x46, 0x28, 0x96, 0x81, 
  0xb2, 0x4c, 0xe2, 0xcc, 0x1f, 0x10, 0x85, 0x05, 0x0d, 0x07, 0x22, 0x5e, 
  0x3e, 0x70, 0xe8, 0x71, 0x28, 0x1a, 0x0f, 0xbf, 0xd9, 0x45, 0x35, 0x30, 
  0x7a, 0x90, 0xad, 0x39, 0x9c, 0x55, 0x6a, 0x07, 0xbe, 0x4c, 0x6a, 0xb8, 
  0xff, 0x2e, 0x7b, 0xa5, 0x37, 0xec, 0xd1, 0x5a, 0xf4, 0xe7, 0x73, 0xcf, 
  0xf0, 0xed, 0x31, 0xde, 0x55, 0xa4, 0x79, 0x79, 0x79, 0x49, 0x79, 0x17, 
  0xa3, 0xe4, 0xad, 0x6b, 0x51, 0xf7, 0x0c, 0x4f, 0xcd, 0x49, 0x29, 0x76, 
  0x46, 0x25, 0x73, 0x01, 0x91, 0x02, 0x77, 0x69, 0x69, 0x9e, 0x48, 0xa2, 
  0xed, 0x89, 0x86, 0x45, 0x48, 0x72, 0x6f, 0x52, 0x4d, 0x82, 0xa5, 0x4c, 
  0x26, 0x37, 0xb9, 0x04, 0x7a, 0xd2, 0xa2, 0x05, 0x99, 0x81, 0xbd, 0xe8, 
  0x7f, 0x94, 0x06, 0xbe, 0xf1, 0x69, 0x64, 0x4c, 0x08, 0x23, 0xba, 0x84, 
  0x0b, 0x46, 0xc8, 0x71, 0x04, 0x71, 0xfc, 0xfd, 0xd5, 0xc5, 0x61, 0xf4, 
  0xf5, 0xf1, 0xe1, 0x8b, 0xe3, 0x8b, 0xcb, 0xc6, 0xa5, 0xaf, 0x59, 0x73, 
  0x22, 0xa0, 0xb1, 0x49, 0x18, 0xa2, 0xb1, 0x25, 0x3f, 0x6b, 0x28, 0xb9, 
  0x71, 0x3d, 0x22, 0x1e, 0x3e, 0x48, 0x74, 0x3e, 0x58, 0x21, 0x12, 0xd7, 
  0x41, 0x25, 0x89, 0xe8, 0xcc, 0x6c, 0x5c, 0x1b, 0x5a, 0xf1, 0xcf, 0xd9, 
  0xcf, 0xc3, 0x24, 0x0e, 0x8f, 0xdb, 0xe1, 0x2f, 0x93, 0x69, 0x6e, 0x09, 
  0xc0, 0xf5, 0x9d, 0xfb, 0xda, 0x27, 0x01, 0x07, 0x6c, 0x4b, 0x2f, 0x19, 
  0xb5, 0x21, 0xf6, 0xbe, 0x1f, 0x52, 0xbf, 0x43, 0x5a, 0xfc, 0xe1, 0x22, 
  0x79, 0x1a, 0xad, 0x93, 0xb2, 0xd7, 0x30, 0x08, 0xd6, 0xbb, 0xdf, 0x12, 
  0x88, 0xda, 0xd6, 0x49, 0xfa, 0xba, 0xb3, 0x25, 0x3e, 0x5d, 0x73, 0x06, 
  0x8f, 0x6d, 0x6a, 0x10, 0xb8, 0x54, 0x03, 0x19, 0x59, 0x4f, 0x50, 0x2b, 
  0xe3, 0x02, 0xc3, 0x8d, 0x03, 0x35, 0x53, 0x03, 0x96, 0x30, 0x10, 0x9d, 
  0x02, 0x64, 0x9d, 0xb4, 0xd2, 0x4b, 0x1d, 0x96, 0x11, 0x83, 0x7c, 0xa2, 
  0x61, 0xe9, 0x43, 0xe1, 0xfd, 0x00, 0x6f, 0x88, 0x86, 0x8e, 0x97, 0x35, 
  0x67, 0xa9, 0x9a, 0x46, 0x15, 0x6d, 0x4e, 0x9b, 0xe3, 0x31, 0x38, 0x9a, 
  0xb7, 0x88, 0x73, 0xee, 0xd2, 0x50, 0xbd, 0xf4, 0x5d, 0x09, 0x53, 0x62, 
  0xa5, 0x1e, 0xd6, 0x4e, 0x0e, 0x84, 0x92, 0x8d, 0x37, 0x79, 0x35, 0x48, 
  0x4f, 0x09, 0x89, 0x19, 0x48, 0xd6, 0x08, 0x69, 0x76, 0xcf, 0x25, 0xd1, 
  0xd7, 0x79, 0x89, 0xbb, 0xa0, 0xfd, 0x38, 0x5f, 0xf2, 0x5d, 0xcb, 0x8f, 
  0x37, 0xd4, 0xd9, 0xe5, 0xd0, 0x66, 0x00, 0x02, 0x05, 0xf6, 0x75, 0x7e, 
  0x78, 0xf5, 0x35, 0x5c, 0xad, 0x20, 0xe1, 0x17, 0x39, 0xeb, 0x3b, 0xe6, 
  0x60, 0x6b, 0x67, 0x09, 0x39, 0x05, 0x4e, 0xe4, 0x5f, 0x03, 0x69, 0x71, 
  0x50, 0xf7, 0xec, 0xca, 0x83, 0x91, 0xb2, 0x48, 0x48, 0x8a, 0x4d, 0xd5, 
  0xf4, 0xe8, 0x51, 0x82, 0x5c, 0x3c, 0xb6, 0x4b, 0x01, 0x73, 0x01, 0x81, 
  0x7d, 0xc9, 0x8e, 0xee, 0xcb, 0x9c, 0x40, 0xf4, 0x2c, 0xcc, 0xb1, 0xc2, 
  0x13, 0x02, 0x24, 0xe1, 0x0b, 0xcb, 0x81, 0x1e, 0xd0, 0x9e, 0x76, 0x63, 
  0xa0, 0x04, 0x47, 0xfa, 0x8b, 0xc5, 0x7a, 0xd4, 0x06, 0x50, 0x88, 0xbe, 
  0x5c, 0x55, 0x75, 0xb6, 0xd2, 0x80, 0x69, 0x72, 0x92, 0x65, 0x91, 0xe7, 
  0x55, 0x1d, 0xe8, 0x08, 0xab, 0x23, 0x27, 0x5a, 0xc0, 0x6e, 0x64, 0x2c, 
  0xdc, 0x54, 0xa6, 0x72, 0x77, 0x28, 0x18, 0xc6, 0xe3, 0x32, 0x9f, 0xaf, 
  0xaa, 0x20, 0x24, 0xf8, 0x97, 0x8d, 0x39, 0x18, 0xf4, 0xf6, 0xc9, 0x28, 
  0x31, 0x82, 0xe2, 0x98, 0xd6, 0x22, 0x26, 0x4d, 0x9f, 0x8b, 0xb0, 0xb1, 
  0xe7, 0xb1, 0xc8, 0xb3, 0x3a, 0x36, 0x37, 0xa2, 0x8f, 0x77, 0xfc, 0x5e, 
  0xd3, 0x5d, 0x98, 0xdc, 0xb3, 0xb4, 0x6e, 0x12, 0xf1, 0x4b, 0x29, 0x93, 
  0x2b, 0x25, 0x6d, 0x1d, 0x5e, 0x04, 0x10, 0x07, 0x66, 0xce, 0x8a, 0xc5, 
  0x55, 0x03, 0xa4, 0x58, 0xbd, 0x08, 0xb1, 0xc0, 0x01, 0x35, 0x8f, 0xa1, 
  0x64, 0x19, 0x2b, 0x1a, 0x24, 0x5d, 0xb9, 0x65, 0x2e, 0x3f, 0x2d, 0xe9, 
  0xc3, 0xd5, 0x7e, 0xc7, 0x5e, 0x07, 0xa5, 0xdf, 0x05, 0xc5, 0x0d, 0x99, 
  0x25, 0x1a, 0xfe, 0x27, 0xe1, 0x63, 0xe6, 0x88, 0xb3, 0x21, 0xda, 0x8d, 
  0xc7, 0x7e, 0x3a, 0x96, 0x68, 0xac, 0xe6, 0x90, 0x2b, 0xde, 0xe5, 0x70, 
  0xe6, 0x4d, 0x6a, 0xb7, 0xeb, 0xc3, 0xe2, 0xe8, 0xb7, 0xa2, 0xa0, 0x0c, 
  0x8a, 0x0c, 0x5e, 0xef, 0x39, 0xa4, 0x25, 0xc3, 0x27, 0x75, 0x1f, 0xa7, 
  0x55, 0x78, 0xfd, 0x99, 0xd6, 0xed, 0xeb, 0x0c, 0x8f, 0xd7, 0xb5, 0x48, 
  0x0c, 0x9f, 0x77, 0x75, 0xcd, 0x61, 0xf6, 0x6a, 0x7e, 0x51, 0x30, 0x07, 
  0xd8, 0x7a, 0x6e, 0x52, 0xb0, 0x28, 0x5b, 0x73, 0xb3, 0x7d, 0xb1, 0xee, 
  0x0e, 0x5b, 0xd6, 0x56, 0x14, 0x7a, 0x13, 0x9d, 0xbf, 0x7f, 0xd4, 0x26, 
  0x8d, 0x91, 0xc3, 0x12, 0x52, 0x76, 0x79, 0x12, 0x66, 0xf4, 0x62, 0x55, 
  0x5c, 0xd4, 0xe9, 0x07, 0x75, 0x1d, 0xf6, 0xc7, 0xe9, 0x61, 0x59, 0xe4, 
  0xd7, 0xa3, 0x14, 0xbe, 0x79, 0xb0, 0x0f, 0xfd, 0x4b, 0xe2, 0x14, 0xfe, 
  0xca, 0xa2, 0x71, 0x13, 0x98, 0xa7, 0xb9, 0xee, 0x28, 0xc1, 0x04, 0xe4, 
  0x27, 0x4b, 0x76, 0x56, 0xbf, 0xaa, 0x88, 0x3f, 0x81, 0x83, 0xa5, 0x86, 
  0xb1, 0x2c, 0x09, 0xb4, 0x65, 0x55, 0xac, 0x26, 0x55, 0xcd, 0xdf, 0x94, 
  0x2b, 0x69, 0x05, 0x88, 0xf9, 0xba, 0xbc, 0x79, 0xa8, 0xc2, 0x6e, 0xc7, 
  0xb5, 0x6c, 0x02, 0x2b, 0x3c, 0x10, 0x74, 0xb1, 0x13, 0x9d, 0x30, 0xde, 
  0x9d, 0x16, 0xd2, 0x83, 0x28, 0x4e, 0xe3, 0x77, 0x04, 0x36, 0x3c, 0x77, 
  0xc9, 0xcc, 0x93, 0x10, 0x3c, 0x43, 0x22, 0xc3, 0x83, 0x2b, 0x46, 0xe5, 
  0x0d, 0xdc, 0xaf, 0x45, 0xa4, 0x80, 0x3b, 0xb8, 0xbd, 0xd9, 0x32, 0x07, 
  0x2a, 0x93, 0x10, 0xf0, 0x93, 0xf3, 0xa1, 0xaf, 0x25, 0x45, 0xfd, 0xed, 
  0xd2, 0x42, 0x1a, 0x2e, 0xa4, 0x43, 0x1c, 0x12, 0xdd, 0x62, 0xd2, 0x11, 
  0x93, 0x99, 0xcc, 0x69, 0xca, 0x4e, 0x0c, 0x92, 0x83, 0xb8, 0x70, 0x55, 
  0xba, 0xad, 0xb0, 0x92, 0x55, 0xd6, 0x6a, 0xdc, 0x9a, 0xed, 0x2b, 0xe0, 
  0x5c, 0x60, 0x21, 0x5a, 0x44, 0xf4, 0xc2, 0x4c, 0x87, 0x60, 0x27, 0x58, 
  0x30, 0x16, 0xe0, 0x6d, 0x93, 0x4e, 0xce, 0x5d, 0x17, 0x34, 0x04, 0x9e, 
  0x71, 0x7f, 0x9e, 0xec, 0xf5, 0x03, 0xc8, 0xa4, 0x6d, 0x09, 0xbe, 0xce, 
  0x21, 0xe4, 0xb3, 0x95, 0x0c, 0x13, 0x14, 0x25, 0x9d, 0x03, 0xba, 0x76, 
  0x3a, 0x86, 0x42, 0x4d, 0xfc, 0xd2, 0xc1, 0xec, 0x3f, 0x39, 0x18, 0xed, 
  0x7f, 0xfa, 0xd9, 0x68, 0x6f, 0xb4, 0xbf, 0xc7, 0x9c, 0x85, 0x87, 0x12, 
  0x0c, 0x4e, 0xd6, 0xa5, 0xa3, 0xab, 0xda, 0x7b, 0xed, 0x3e, 0x5f, 0x1f, 
  0x5f, 0x7d, 0x77, 0x76, 0xf1, 0x4d, 0x74, 0xf2, 0xfa, 0xea, 0xf8, 0xe2, 
  0xe5, 0xe1, 0xd1, 0x87, 0xc2, 0xe7, 0x85, 0xd6, 0xd9, 0xa0, 0xd4, 0x4d, 
  0x80, 0x25, 0x45, 0x63, 0xf9, 0xff, 0xd4, 0x7c, 0xe5, 0x17, 0x2b, 0xa9, 
  0x6e, 0xf6, 0x9e, 0xee, 0x3f, 0x08, 0xbf, 0xc6, 0xe6, 0xaf, 0xf6, 0x8b, 
  0x36, 0x8d, 0x7d, 0x9e, 0xc6, 0xe6, 0xd7, 0x1d, 0x50, 0xd2, 0xa5, 0x44, 
  0x10, 0xb9, 0xe8, 0x53, 0x70, 0x74, 0x06, 0x00, 0x15, 0x24, 0x64, 0xe5, 
  0xe1, 0x63, 0xa9, 0x30, 0x2a, 0xa9, 0x8c, 0x0a, 0xb1, 0x31, 0xd5, 0xfa, 
  0xda, 0xc2, 0x60, 0x39, 0xfa, 0x76, 0x95, 0xce, 0x2b, 0xb5, 0x13, 0x48, 
  0xa5, 0xce, 0x29, 0x64, 0x97, 0xce, 0xb2, 0x6f, 0xa8, 0x4a, 0x20, 0xa5, 
  0xf0, 0xa6, 0x2e, 0x42, 0xdf, 0x65, 0x7c, 0xd7, 0xf2, 0x1c, 0x30, 0x56, 
  0x08, 0xe8, 0x74, 0xf3, 0xcc, 0x5b, 0x41, 0xa2, 0x0d, 0x84, 0xad, 0xd2, 
  0xa2, 0x76, 0x31, 0xb1, 0x9a, 0xcd, 0xef, 0x48, 0x07, 0x02, 0xfa, 0x0f, 
  0x46, 0x23, 0x5d, 0x41, 0x52, 0x20, 0x06, 0x5e, 0xe6, 0x59, 0x1d, 0x35, 
  0xd5, 0x4a, 0xb2, 0x22, 0x6a, 0x5d, 0x04, 0x1b, 0x43, 0x95, 0xe4, 0xd6, 
  0xcb, 0x1a, 0x7c, 0x52, 0x24, 0xb0, 0xa5, 0xe1, 0xeb, 0x22, 0x43, 0x22, 
  0x06, 0x71, 0x5a, 0xc4, 0xf7, 0x8c, 0xe8, 0x2c, 0x79, 0x82, 0x3e, 0x5a, 
  0x2f, 0xc0, 0xcc, 0x65, 0x89, 0xc0, 0xaf, 0x79, 0x74, 0x7e, 0xfc, 0x6a, 
  0x68, 0x85, 0x4e, 0xe8, 0x77, 0xb1, 0xb2, 0xb8, 0xc2, 0xe2, 0xb1, 0x40, 
  0x62, 0x67, 0x16, 0x32, 0x02, 0x2e, 0xa8, 0x21, 0x2e, 0xe1, 0x04, 0xf8, 
  0x98, 0x88, 0xc2, 0x2d, 0xdc, 0x95, 0x8f, 0x9f, 0x45, 0x16, 0x4a, 0x26, 
  0x57, 0x13, 0x24, 0x8b, 0xf7, 0x53, 0xc3, 0x72, 0xa3, 0x6d, 0x17, 0x8a, 
  0xca, 0xfd, 0x21, 0xde, 0x12, 0xee, 0x70, 0xe7, 0x01, 0xcf, 0x2d, 0xcb, 
  0xf5, 0xfc, 0x9b, 0xa3, 0xcb, 0x8f, 0xf6, 0x0f, 0x74, 0x38, 0x3b, 0x26, 
  0xee, 0x32, 0x77, 0x6a, 0x26, 0x40, 0x83, 0x41, 0x87, 0x63, 0xb4, 0x74, 
  0x56, 0x1c, 0x69, 0x6c, 0xc6, 0xb6, 0x4b, 0xc9, 0xd8, 0xa9, 0xe5, 0x64, 
  0x20, 0xbe, 0x69, 0xed, 0x64, 0x27, 0x57, 0x16, 0x84, 0x4d, 0xfd, 0x2c, 
  0xc7, 0x40, 0x35, 0xa6, 0x23, 0x58, 0xb9, 0x80, 0xb6, 0x38, 0xb3, 0x8f, 
  0xa4, 0x65, 0x6d, 0x0d, 0xf9, 0xba, 0x3e, 0x6a, 0xa3, 0xb9, 0xe7, 0xbc, 
  0xde, 0xfe, 0x5b, 0x46, 0x7b, 0xd5, 0x6b, 0xdc, 0xf0, 0x50, 0x7c, 0x37, 
  0x38, 0x00, 0x1a, 0xa3, 0x3d, 0x35, 0x88, 0xdf, 0xcc, 0xc3, 0x90, 0xf2, 
  0xd3, 0x67, 0xb4, 0x51, 0x74, 0xb2, 0x24, 0x47, 0x9e, 0xd9, 0x80, 0x14, 
  0xb2, 0x75, 0x8f, 0xbc, 0x28, 0x18, 0xf8, 0x75, 0x29, 0xd1, 0x92, 0xaf, 
  0x47, 0xd1, 0xd7, 0x49, 0xc6, 0x49, 0xca, 0x1c, 0x57, 0x66, 0x59, 0x2f, 
  0x88, 0x7e, 0x63, 0x64, 0x73, 0x7a, 0x9b, 0x9a, 0x4a, 0x62, 0x05, 0x0b, 
  0x23, 0xee, 0x56, 0x8a, 0xea, 0x66, 0x50, 0xdb, 0x31, 0xc7, 0xa0, 0xe1, 
  0xee, 0x51, 0xfb, 0x23, 0x2a, 0xd9, 0x70, 0x85, 0x2d, 0x34, 0xb0, 0x5d, 
  0x87, 0xfc, 0xa2, 0xef, 0xb5, 0x39, 0x3d, 0xe6, 0xf0, 0xbf, 0xa8, 0xb9, 
  0x94, 0xdf, 0x42, 0x70, 0x4e, 0x2c, 0xaa, 0x84, 0x67, 0x2a, 0xd3, 0xe2, 
  0x86, 0x75, 0xfa, 0x92, 0x2e, 0x98, 0x38, 0x9b, 0xac, 0x47, 0xd3, 0x84, 
  0x08, 0x88, 0x4e, 0xdb, 0x68, 0x75, 0xbb, 0x1b, 0x1c, 0x53, 0x66, 0xf2, 
  0x37, 0x92, 0x8f, 0x5d, 0xb7, 0xe8, 0x5a, 0x71, 0x92, 0x36, 0x50, 0x52, 
  0x5c, 0xc7, 0x91, 0x4e, 0x51, 0x7e, 0x29, 0xf6, 0xc7, 0x73, 0x23, 0xc4, 
  0xd0, 0x71, 0xe4, 0x70, 0xec, 0xb8, 0x85, 0xd1, 0x32, 0x59, 0x3c, 0x75, 
  0xb9, 0x9f, 0xc6, 0x1f, 0x84, 0x37, 0x78, 0x89, 0x39, 0xb0, 0x3e, 0x66, 
  0xc9, 0xf5, 0x5c, 0x45, 0x88, 0x50, 0x26, 0x77, 0x4d, 0x74, 0x24, 0x38, 
  0x88, 0x24, 0xaf, 0x15, 0x66, 0xb7, 0x60, 0x2e, 0x5b, 0xa0, 0x20, 0x94, 
  0xb1, 0x7a, 0x2d, 0x2b, 0xe5, 0x1b, 0x51, 0x94, 0x06, 0xc6, 0xfe, 0x86, 
  0xe0, 0xab, 0xb6, 0x0b, 0x0b, 0xb8, 0x51, 0xbf, 0x0a, 0x7d, 0x2b, 0x14, 
  0x42, 0x5b, 0x33, 0xb4, 0xd8, 0x5f, 0x78, 0xf5, 0xac, 0x82, 0x87, 0x9c, 
  0x15, 0xfa, 0xfa, 0xee, 0x11, 0x9b, 0x72, 0xaf, 0x4e, 0x2f, 0x07, 0x42, 
  0x0f, 0x52, 0xc3, 0x38, 0xc0, 0xc0, 0xf5, 0xe4, 0xc7, 0x86, 0x0d, 0x09, 
  0xd0, 0xb2, 0x6a, 0x6f, 0x85, 0x8c, 0x46, 0x38, 0x83, 0x77, 0x01, 0xf9, 
  0x30, 0x7f, 0x5b, 0x08, 0x0d, 0x98, 0xe5, 0xe1, 0x58, 0x2d, 0x55, 0x11, 
  0x81, 0x1c, 0xb2, 0x06, 0xca, 0xa2, 0x44, 0xc3, 0x47, 0x83, 0x68, 0x78, 
  0x00, 0xc0, 0x92, 0xfd, 0xfa, 0x42, 0xd2, 0xd0, 0x48, 0xf4, 0x9c, 0x00, 
  0x63, 0x7b, 0xcb, 0x55, 0xf1, 0x34, 0x96, 0xb0, 0xad, 0x64, 0x7d, 0x47, 
  0xef, 0xf3, 0x8f, 0x03, 0x9d, 0xd4, 0xdd, 0x3e, 0x62, 0x93, 0x59, 0x02, 
  0xbd, 0x4b, 0xe6, 0xeb, 0xb6, 0xa0, 0x70, 0xf0, 0xe0, 0xce, 0x22, 0x0b, 
  0xe0, 0x3e, 0x2d, 0x93, 0x30, 0x0a, 0x4a, 0xec, 0x7c, 0x7c, 0xb2, 0x69, 
  0xaf, 0x6c, 0x00, 0xb4, 0x8c, 0x6a, 0xc1, 0xcd, 0xa2, 0xbb, 0x03, 0x73, 
  0xa4, 0xf2, 0x37, 0xb6, 0x78, 0x62, 0x89, 0xf6, 0x8c, 0xa4, 0x95, 0x34, 
  0xc6, 0x01, 0x5d, 0x01, 0xe5, 0xd2, 0xc5, 0xcc, 0xe1, 0x88, 0xc4, 0x49, 
  0x6a, 0x9c, 0xc6, 0x95, 0x29, 0x97, 0x24, 0xe3, 0x18, 0x00, 0xdf, 0xac, 
  0x9d, 0x06, 0x51, 0x3c, 0x88, 0x71, 0xc6, 0x99, 0x26, 0x99, 0xb5, 0x5c, 
  0x2d, 0x14, 0x2e, 0x1c, 0x8c, 0x78, 0x80, 0xeb, 0xb6, 0x8a, 0x88, 0x13, 
  0xa7, 0x12, 0xd4, 0x36, 0x87, 0xf8, 0x0c, 0x91, 0x4a, 0x6d, 0x81, 0x7e, 
  0xa1, 0xd8, 0xc0, 0x23, 0x08, 0x66, 0xa0, 0x97, 0x9b, 0x54, 0x54, 0x74, 
  0x84, 0x60, 0x62, 0xc1, 0x88, 0x55, 0xf4, 0x23, 0x3a, 0x7d, 0x2b, 0x6e, 
  0xb4, 0xca, 0x11, 0xe3, 0xe9, 0x04, 0x06, 0xcd, 0x60, 0xba, 0x84, 0x9c, 
  0x19, 0xf5, 0x43, 0x26, 0x39, 0xfc, 0x9c, 0x17, 0xa1, 0xec, 0xfb, 0x55, 
  0x53, 0x0c, 0xcc, 0xfa, 0x12, 0xa8, 0xf9, 0x9f, 0xd6, 0x5b, 0x9a, 0x3a, 
  0x2f, 0xac, 0x7a, 0x53, 0x3f, 0x79, 0xc7, 0x42, 0x51, 0xdf, 0xfa, 0x95, 
  0xef, 0x25, 0x03, 0x1b, 0xeb, 0x7b, 0x7e, 0xf2, 0x5a, 0x6a, 0x04, 0xb9, 
  0xb3, 0x94, 0xb0, 0xac, 0x2d, 0xcf, 0x89, 0xe8, 0x2b, 0x06, 0x6c, 0x76, 
  0xca, 0x89, 0x49, 0x85, 0x09, 0x8e, 0x0f, 0x49, 0x6a, 0xdd, 0x5d, 0xac, 
  0x64, 0x04, 0x7d, 0xbe, 0x29, 0xcb, 0x72, 0xde, 0xaf, 0xd5, 0x52, 0x08, 
  0x76, 0xb4, 0x71, 0x25, 0x39, 0x63, 0xcd, 0xc4, 0x82, 0xdb, 0xb6, 0xb4, 
  0x18, 0x0f, 0xb7, 0x52, 0xe3, 0x94, 0x83, 0x46, 0x96, 0x5a, 0x68, 0x25, 
  0xfe, 0x28, 0x1a, 0xed, 0x52, 0x87, 0xe5, 0xae, 0xbd, 0xb8, 0xbc, 0x9d, 
  0x94, 0x74, 0x47, 0x72, 0x4a, 0xe6, 0x8f, 0xd0, 0xbb, 0x61, 0x54, 0xa2, 
  0x21, 0x4f, 0x7f, 0x8a, 0x86, 0x93, 0xb9, 0xcc, 0x10, 0x15, 0x72, 0x7e, 
  0x24, 0xba, 0xe1, 0x27, 0x7e, 0xda, 0xe2, 0x24, 0xb0, 0xcb, 0x37, 0xaf, 
  0x18, 0x14, 0x16, 0xc5, 0x37, 0xae, 0x2e, 0x0e, 0x5f, 0x5f, 0xbe, 0x14, 
  0x43, 0xe2, 0x55, 0x1e, 0x94, 0xf5, 0x50, 0x2b, 0xac, 0x2b, 0x56, 0x65, 
  0x40, 0x4f, 0x5c, 0x89, 0x20, 0x08, 0x45, 0xd6, 0x12, 0x1f, 0x83, 0xba, 
  0x0e, 0xb3, 0xa5, 0x05, 0x43, 0xc0, 0xb0, 0xe9, 0x44, 0x6d, 0x97, 0x3b, 
  0xee, 0x76, 0x2d, 0x43, 0xa0, 0x6d, 0x0f, 0x30, 0x26, 0x7a, 0x89, 0x7b, 
  0x88, 0xcf, 0xcc, 0x91, 0x0d, 0xc6, 0x3e, 0x15, 0x86, 0xbe, 0x11, 0xcf, 
  0xef, 0x88, 0x34, 0x8e, 0xa1, 0x62, 0xfc, 0x06, 0x00, 0xe3, 0xce, 0xf8, 
  0x24, 0x0c, 0x5d, 0xa1, 0xb8, 0x5c, 0xe3, 0xde, 0x57, 0xeb, 0x9b, 0xde, 
  0xfe, 0xc3, 0xfe, 0x4e, 0x77, 0xf3, 0x57, 0xbf, 0xb4, 0xf9, 0xee, 0xb1, 
  0x9b, 0x88, 0xef, 0xb3, 0x31, 0xb6, 0xff, 0x70, 0xb0, 0xf3, 0xe0, 0x8c, 
  0xc2, 0x44, 0x32, 0xdf, 0x27, 0xbd, 0xc1, 0x83, 0x8d, 0x9e, 0x5b, 0x35, 
  0x2c, 0xbd, 0x88, 0x5d, 0x3c, 0xc3, 0xcc, 0x43, 0x8c, 0xd5, 0x72, 0xee, 
  0x39, 0xda, 0xd1, 0x89, 0x7f, 0xde, 0x4d, 0xa1, 0x81, 0xf9, 0x28, 0xb1, 
  0xe3, 0xa1, 0xd9, 0x48, 0xff, 0x0e, 0x79, 0x1e, 0x27, 0xfb, 0x96, 0xf9, 
  0x08, 0x7d, 0x1f, 0x3c, 0xd0, 0xb7, 0x9f, 0x5d, 0xa0, 0xdd, 0xb2, 0xcf, 
  0x8f, 0x83, 0x86, 0x58, 0x1a, 0xdf, 0xe5, 0xca, 0xe4, 0xd2, 0x8f, 0xeb, 
  0xfb, 0xa1, 0xfe, 0xae, 0x4e, 0x5e, 0x1d, 0x33, 0xe0, 0xfd, 0x8b, 0x13, 
  0x46, 0x8f, 0xba, 0x54, 0xf8, 0x36, 0x53, 0x64, 0x1d, 0xa8, 0x65, 0x70, 
  0x55, 0xc4, 0xe2, 0x0c, 0x73, 0xb1, 0x39, 0xee, 0xfc, 0xbb, 0x9d, 0xe0, 
  0xae, 0xad, 0x08, 0xbb, 0x25, 0xa9, 0x9d, 0xcc, 0x86, 0xaf, 0xf2, 0x29, 
  0x94, 0xad, 0xa1, 0xc0, 0xd6, 0xd2, 0x5b, 0xf4, 0xe1, 0x9b, 0x6c, 0x51, 
  0xfb, 0x38, 0x4c, 0x85, 0x53, 0x3d, 0x7a, 0x6b, 0x13, 0x9a, 0xf1, 0xcf, 
  0x5c, 0x76, 0x9d, 0x71, 0x13, 0x24, 0x06, 0x46, 0x2d, 0xe1, 0xb5, 0x0c, 
  0x7b, 0x3b, 0xfb, 0xb4, 0x3e, 0xe9, 0x7c, 0x2d, 0x5e, 0xdb, 0xd8, 0xc7, 
  0xda, 0xf8, 0xbc, 0xb7, 0x6b, 0x54, 0xda, 0x75, 0x36, 0x22, 0xb1, 0x02, 
  0x6d, 0xd5, 0x90, 0x01, 0x59, 0x38, 0x4f, 0xee, 0x7d, 0xac, 0x88, 0xd6, 
  0x70, 0xc8, 0x97, 0x6b, 0x4c, 0xf2, 0xbe, 0xe6, 0x87, 0xee, 0x74, 0x46, 
  0xfd, 0x2c, 0xef, 0xd4, 0xf0, 0xbb, 0xa5, 0x87, 0x90, 0x00, 0xf5, 0x13, 
  0x85, 0xbb, 0x3e, 0x2b, 0x02, 0x06, 0xa6, 0xc3, 0x8e, 0xcd, 0x8b, 0xee, 
  0xb1, 0x02, 0x03, 0x90, 0xc3, 0xfa, 0x38, 0x3d, 0xbe, 0xe1, 0x16, 0xdf, 
  0x6d, 0x23, 0x36, 0x0c, 0x9b, 0x27, 0x81, 0xb8, 0x8e, 0x01, 0x20, 0x68, 
  0x5e, 0x50, 0xa2, 0xb9, 0x78, 0x96, 0x91, 0xdb, 0x1f, 0xf6, 0x81, 0xbc, 
  0x9b, 0x66, 0x1d, 0x93, 0x19, 0xfe, 0xf2, 0xd9, 0xb4, 0xfc, 0x54, 0x51, 
  0x6f, 0xc6, 0x69, 0xed, 0x6c, 0xf4, 0xef, 0xc9, 0x00, 0x04, 0xe9, 0x41, 
  0x68, 0x8b, 0x84, 0x7a, 0x66, 0x6b, 0xa6, 0x9c, 0x88, 0xa2, 0xe6, 0x02, 
  0x09, 0x9d, 0x75, 0x54, 0x6c, 0x5b, 0xcc, 0x47, 0x57, 0xcb, 0x29, 0x3c, 
  0xd8, 0x12, 0xbd, 0xb7, 0xe6, 0x7a, 0x7a, 0xc5, 0x34, 0x5e, 0x77, 0x0c, 
  0xde, 0x7d, 0xf7, 0xa1, 0x43, 0xf7, 0xf1, 0xdf, 0xb8, 0x4e, 0x35, 0x51, 
  0x92, 0x18, 0x0e, 0x7b, 0xb0, 0xa4, 0x40, 0x15, 0xd7, 0x0d, 0x06, 0x06, 
  0x15, 0xa4, 0x09, 0xb1, 0x2f, 0x59, 0xad, 0x04, 0x07, 0xb4, 0xce, 0x4f, 
  0x6c, 0x45, 0x93, 0x9b, 0x84, 0xae, 0x63, 0xc4, 0x06, 0x38, 0x23, 0x5b, 
  0x5c, 0xa0, 0x24, 0x44, 0x7d, 0x63, 0xd2, 0xca, 0xf6, 0x82, 0x83, 0x0f, 
  0x78, 0x43, 0x88, 0xc8, 0x5f, 0x9c, 0x1c, 0x5d, 0x19, 0x48, 0xd9, 0x8c, 
  0xef, 0xd0, 0x62, 0xfd, 0x61, 0xb8, 0xf7, 0x0f, 0x3e, 0x33, 0x7d, 0x7a, 
  0x93, 0x90, 0x2c, 0x96, 0x8d, 0x57, 0xd7, 0x4f, 0xff, 0x1a, 0x17, 0xd7, 
  0x41, 0x61, 0xac, 0x0d, 0xcf, 0x4f, 0x91, 0x7f, 0xf3, 0x94, 0xb8, 0xd2, 
  0xfe, 0x93, 0xfd, 0x47, 0x12, 0xdc, 0x9d, 0x72, 0x3d, 0x0e, 0x30, 0x85, 
  0xfe, 0xa2, 0x2f, 0x39, 0xf2, 0x08, 0x2b, 0x77, 0x89, 0xf1, 0xd9, 0xb4, 
  0x2f, 0x8a, 0x56, 0x1c, 0x3e, 0x3b, 0xd5, 0x67, 0x25, 0x51, 0xb7, 0x0f, 
  0x68, 0x06, 0x7a, 0x9c, 0xb3, 0xda, 0x56, 0xcb, 0xfe, 0xa8, 0x76, 0xac, 
  0xdf, 0x33, 0x57, 0xee, 0xc2, 0xc1, 0xfc, 0x1f, 0x09, 0x23, 0x56, 0x1e, 
  0x3a, 0x2e, 0x92, 0xf8, 0xd6, 0x81, 0x8e, 0x07, 0x09, 0xf4, 0x66, 0x26, 
  0xe7, 0xba, 0x64, 0xc0, 0x1d, 0xb4, 0xf4, 0x12, 0x2c, 0x75, 0xe4, 0x6c, 
  0xeb, 0x3b, 0x3c, 0xca, 0xf7, 0xf4, 0xcf, 0xf1, 0xdf, 0x4f, 0xa7, 0xe3, 
  0x0f, 0x78, 0x88, 0x0e, 0x9b, 0x20, 0x3c, 0x1d, 0xd6, 0x40, 0x94, 0x21, 
  0xed, 0x57, 0x4c, 0x6a, 0x28, 0xd9, 0x42, 0x54, 0xb0, 0x2d, 0xa5, 0x45, 
  0xc4, 0x4e, 0x2d, 0xc5, 0x23, 0xb5, 0x9c, 0x95, 0x9a, 0x09, 0x68, 0xdc, 
  0x5c, 0xad, 0xe3, 0xc5, 0xe1, 0x79, 0xa0, 0x31, 0x41, 0x23, 0xf1, 0xd6, 
  0x21, 0x7e, 0x8e, 0xa5, 0xe5, 0xb0, 0x9c, 0xd6, 0xc0, 0xcb, 0xb9, 0x15, 
  0x98, 0xe3, 0xf4, 0x2e, 0x96, 0x20, 0xe2, 0x5c, 0xef, 0x10, 0x18, 0x32, 
  0x00, 0x9e, 0x3c, 0x9f, 0xc6, 0x70, 0x15, 0xe9, 0xcd, 0x03, 0x21, 0x1c, 
  0x6d, 0xa5, 0x1a, 0x2f, 0x42, 0x7b, 0xf3, 0x2e, 0xd2, 0x40, 0x77, 0x8d, 
  0xe8, 0x97, 0xdf, 0xe5, 0x31, 0x4e, 0xe2, 0x5c, 0xdb, 0x04, 0x84, 0x29, 
  0xd3, 0xe0, 0xe3, 0xf2, 0x96, 0xf8, 0xa7, 0xb8, 0x38, 0xa9, 0xf7, 0x74, 
  0x92, 0x98, 0xfd, 0x74, 0x9a, 0x4a, 0xa8, 0x81, 0xaf, 0x15, 0x1d, 0x6e, 
  0x98, 0x5c, 0x3b, 0xac, 0xb6, 0xcc, 0xcb, 0x44, 0xa0, 0xc6, 0xa2, 0xab, 
  0xfb, 0x5c, 0x44, 0x4d, 0x97, 0x44, 0x2f, 0xb1, 0x7a, 0xe5, 0x2a, 0x15, 
  0xb4, 0x02, 0xab, 0x95, 0xfd, 0xda, 0x27, 0x79, 0xf4, 0x9c, 0x09, 0xe5, 
  0x85, 0xf3, 0x0c, 0x5d, 0xbe, 0xf8, 0x26, 0xe2, 0xf4, 0x63, 0xee, 0xe3, 
  0x88, 0x01, 0xcb, 0xd9, 0xc9, 0xbb, 0x80, 0x0a, 0xf1, 0xd5, 0x8a, 0xcf, 
  0xfb, 0xd1, 0x4d, 0xbc, 0x64, 0x49, 0x78, 0x7f, 0x8f, 0xf5, 0xee, 0xef, 
  0x2c, 0x91, 0x89, 0x0f, 0xaa, 0x95, 0xc5, 0x29, 0x7b, 0x81, 0x4a, 0x3e, 
  0x25, 0x55, 0x7a, 0xce, 0x92, 0x70, 0xdd, 0xda, 0x47, 0x57, 0x66, 0xb9, 
  0x4b, 0xe4, 0xb9, 0x8a, 0xe7, 0x25, 0x91, 0x46, 0x51, 0x4e, 0x6f, 0x77, 
  0x27, 0xf4, 0xcf, 0xa3, 0xbd, 0x5d, 0xa0, 0xdf, 0x55, 0x30, 0x8e, 0x31, 
  0x4d, 0x1e, 0x1c, 0x7c, 0xf2, 0xc9, 0x20, 0xea, 0xb9, 0x6a, 0x68, 0x4c, 
  0xbe, 0x2f, 0xc1, 0x66, 0x7a, 0xa1, 0x1c, 0x53, 0xcc, 0x26, 0xc3, 0x84, 
  0x78, 0x67, 0x5e, 0x80, 0xc8, 0xe8, 0x4f, 0xfe, 0x1f, 0xbf, 0xcc, 0x99, 
  0x0d, 0x86, 0xe8, 0x70, 0xa3, 0x77, 0x2b, 0x3c, 0x4f, 0x0e, 0xe4, 0xc2, 
  0x88, 0xeb, 0x9e, 0x76, 0xc3, 0xcc, 0x12, 0xec, 0x73, 0x58, 0x26, 0xf9, 
  0xd2, 0xbc, 0x68, 0x8b, 0xb5, 0xde, 0x34, 0xa0, 0xb4, 0xa8, 0x96, 0x9b, 
  0x78, 0x23, 0x61, 0x43, 0x9a, 0x39, 0x5e, 0xae, 0xc6, 0x43, 0x4d, 0xa1, 
  0x14, 0x35, 0x23, 0xa5, 0xf3, 0xbb, 0xe0, 0x72, 0xa1, 0x6a, 0xef, 0x6d, 
  0xf1, 0xe4, 0x2f, 0xa3, 0x9e, 0x52, 0x18, 0xff, 0x18, 0xc1, 0x09, 0x96, 
  0x4c, 0xb8, 0x02, 0x43, 0xfe, 0x5c, 0xff, 0xf8, 0xf3, 0x9f, 0xa9, 0xd9, 
  0x3f, 0x73, 0x2b, 0xcf, 0xff, 0x50, 0x56, 0x37, 0xc1, 0x33, 0x3d, 0x25, 
  0xfb, 0x13, 0xef, 0x02, 0x44, 0x58, 0x0f, 0x10, 0x22, 0x91, 0xea, 0xf3, 
  0xea, 0x54, 0xf9, 0xf2, 0x20, 0x98, 0x5f, 0x8a, 0x24, 0x2c, 0xb1, 0xb9, 
  0x39, 0xaf, 0xfa, 0x97, 0xec, 0x9e, 0x4b, 0x38, 0x77, 0x97, 0x68, 0x11, 
  0x10, 0x60, 0x3b, 0x26, 0x5d, 0x1c, 0xbf, 0xfe, 0xf6, 0xe4, 0xe2, 0xec, 
  0xf5, 0xab, 0xe3, 0xd7, 0x57, 0xd1, 0xb7, 0x87, 0x17, 0x27, 0x87, 0x5f, 
  0x9e, 0x6a, 0x8a, 0x30, 0x4f, 0x81, 0x83, 0x21, 0x44, 0xea, 0x6e, 0x00, 
  0x38, 0x06, 0x29, 0x1b, 0x9d, 0x78, 0xe5, 0x8d, 0x22, 0x37, 0x6f, 0x15, 
  0x10, 0x18, 0xe6, 0xd5, 0xb7, 0x00, 0xaa, 0x1f, 0xb0, 0x87, 0xcf, 0x7e, 
  0x15, 0xd0, 0xfb, 0xb7, 0x86, 0x60, 0xcf, 0x46, 0xcc, 0x75, 0x90, 0x82, 
  0xca, 0x51, 0x1b, 0x4c, 0xb9, 0xc6, 0xb3, 0x86, 0x0e, 0xbd, 0x53, 0x31, 
  0xdc, 0x47, 0xd1, 0x57, 0x92, 0xc5, 0xac, 0xf1, 0x43, 0xee, 0x55, 0xcd, 
  0xa8, 0x51, 0xa3, 0x8e, 0xfc, 0xe7, 0x7e, 0x39, 0x3c, 0x3d, 0xf5, 0x5d, 
  0x1e, 0x8a, 0x84, 0x3b, 0xf4, 0xc9, 0xc0, 0x56, 0x4a, 0x06, 0x85, 0x97, 
  0x05, 0x5d, 0x45, 0x92, 0x5f, 0x6e, 0xac, 0x94, 0xd5, 0x75, 0xee, 0x31, 
  0x8f, 0xb3, 0x75, 0x08, 0x6f, 0xcc, 0x9d, 0xd2, 0x26, 0x6d, 0x0b, 0x04, 
  0x01, 0xbb, 0x1d, 0xe9, 0x70, 0xa5, 0xe5, 0xed, 0x20, 0xea, 0xff, 0xa1, 
  0x2f, 0x59, 0x49, 0x09, 0xd0, 0x3f, 0xd1, 0x7a, 0xe9, 0x0b, 0x58, 0x45, 
  0xaf, 0xcf, 0xfc, 0x98, 0x4e, 0x10, 0x02, 0xcf, 0x24, 0x86, 0x88, 0xc7, 
  0xc2, 0x21, 0xcb, 0x24, 0x9a, 0xcc, 0x3b, 0x84, 0x57, 0x5b, 0x22, 0xb3, 
  0x31, 0x4c, 0x6b, 0xd9, 0xfb, 0x49, 0xcb, 0xc4, 0x41, 0xf2, 0x01, 0xf0, 
  0x95, 0x94, 0xb5, 0x78, 0x12, 0x80, 0xb9, 0x8a, 0x0d, 0x87, 0xd5, 0x5e, 
  0x88, 0x02, 0x5a, 0xb0, 0x4e, 0xd6, 0x95, 0xad, 0x43, 0xea, 0x8a, 0x5a, 
  0x95, 0xca, 0x42, 0x41, 0x50, 0xef, 0x76, 0x15, 0x4d, 0x59, 0xfc, 0x53, 
  0x1c, 0x32, 0x5d, 0xa4, 0x53, 0xc5, 0x06, 0xeb, 0x24, 0x88, 0x11, 0xdc, 
  0x1a, 0x17, 0x47, 0xc0, 0x51, 0xce, 0xd2, 0x77, 0x01, 0xec, 0xbc, 0x84, 
  0x57, 0x12, 0x1b, 0x29, 0x38, 0x6b, 0x29, 0x53, 0x29, 0x04, 0x21, 0x8b, 
  0x10, 0xcc, 0xe3, 0xeb, 0xdc, 0x84, 0xee, 0xd8, 0xf9, 0x5a, 0x25, 0x1b, 
  0x49, 0xa2, 0x51, 0x4c, 0xf6, 0x72, 0xe0, 0x3f, 0xce, 0xf8, 0x05, 0xaf, 
  0xac, 0x99, 0x9a, 0x39, 0x02, 0xa7, 0x0a, 0x50, 0xca, 0xcb, 0x20, 0x95, 
  0xd5, 0x07, 0x78, 0x33, 0x1b, 0x11, 0x7f, 0xa4, 0xa1, 0xf1, 0x00, 0xf3, 
  0xc8, 0x52, 0x5f, 0x11, 0x0b, 0x86, 0x61, 0xf1, 0x83, 0x68, 0x52, 0xc3, 
  0xfa, 0xd0, 0xa4, 0x59, 0x41, 0xe9, 0xe0, 0xcc, 0x39, 0xcb, 0xc6, 0x98, 
  0x50, 0x1c, 0x8d, 0xd3, 0xeb, 0xc8, 0x0c, 0x20, 0x11, 0x93, 0x02, 0x90, 
  0x99, 0xf2, 0x45, 0xc2, 0x5b, 0x05, 0xdc, 0x25, 0x48, 0xec, 0x37, 0x5c, 
  0x6d, 0xd1, 0x03, 0x05, 0xd9, 0x4c, 0x4a, 0x8e, 0x41, 0x77, 0x06, 0x34, 
  0xb1, 0xa1, 0xaf, 0x78, 0x19, 0x2d, 0x5e, 0x47, 0x31, 0x85, 0x35, 0x7a, 
  0x89, 0x8d, 0xb3, 0x40, 0x38, 0xcb, 0x90, 0x2b, 0x61, 0x99, 0xa7, 0x58, 
  0x06, 0x8b, 0xec, 0x64, 0x3e, 0x01, 0x93, 0x4a, 0x32, 0x9f, 0x45, 0xdb, 
  0x0e, 0x14, 0x18, 0x95, 0x3b, 0x05, 0x55, 0x91, 0x09, 0x5b, 0x02, 0xaf, 
  0x6b, 0xd0, 0xfd, 0xb6, 0x57, 0x8a, 0x7e, 0x33, 0x93, 0x0a, 0x91, 0x34, 
  0xbc, 0xed, 0x80, 0xe5, 0x64, 0x44, 0x21, 0xf2, 0x98, 0x28, 0x8d, 0xfa, 
  0xd7, 0x50, 0x3c, 0x95, 0x74, 0x50, 0xd5, 0x65, 0xb9, 0xe3, 0xbd, 0xd5, 
  0x22, 0x05, 0x30, 0xa9, 0x4a, 0x0a, 0x8a, 0x8a, 0xc7, 0xb4, 0x5d, 0x66, 
  0x82, 0x0a, 0x2d, 0x58, 0x91, 0xa5, 0x24, 0xcc, 0xe7, 0x01, 0x2a, 0xb0, 
  0xd8, 0x20, 0xe2, 0x96, 0xf0, 0xe1, 0x0a, 0x30, 0x1e, 0x6a, 0x70, 0x84, 
  0x20, 0x88, 0x06, 0x33, 0xd1, 0xb0, 0x5b, 0x16, 0xcf, 0x1a, 0x86, 0xb1, 
  0x80, 0x97, 0x99, 0x67, 0x35, 0x84, 0x72, 0x55, 0x58, 0xfa, 0x34, 0x5e, 
  0x88, 0xf0, 0xe8, 0xa9, 0x6f, 0xb1, 0x96, 0xc0, 0xac, 0xad, 0xad, 0xa3, 
  0x37, 0x97, 0x57, 0x67, 0xaf, 0xa2, 0xb3, 0x37, 0x57, 0xe7, 0x6f, 0xae, 
  0xf4, 0xd2, 0x1a, 0x4b, 0xe8, 0xaa, 0x28, 0x86, 0x22, 0x05, 0xd8, 0x6e, 
  0x2e, 0xd4, 0x5d, 0x8c, 0xc0, 0x84, 0x1c, 0x68, 0x60, 0x01, 0x00, 0x8b, 
  0x4b, 0x5b, 0x01, 0xbc, 0xa3, 0x80, 0x8c, 0x62, 0xcd, 0xef, 0x69, 0xcd, 
  0x91, 0x74, 0x08, 0x83, 0x8e, 0x65, 0xc1, 0x40, 0xd9, 0xe9, 0x2e, 0xf1, 
  0xb0, 0xae, 0x2b, 0x2f, 0x70, 0xec, 0xd6, 0x81, 0x6e, 0x7c, 0xa8, 0x89, 
  0x19, 0x74, 0xbc, 0xbd, 0x27, 0x8c, 0x7a, 0x43, 0xbc, 0xc7, 0xa4, 0x32, 
  0x33, 0xa6, 0x05, 0x1e, 0x22, 0xc4, 0xa4, 0x9e, 0x7d, 0x15, 0x26, 0x81, 
  0x55, 0x39, 0xcd, 0xf0, 0xc6, 0x05, 0x0d, 0x73, 0x7c, 0x34, 0x82, 0xa5, 
  0xc4, 0xf9, 0xce, 0x51, 0x49, 0x56, 0xea, 0xf0, 0x9e, 0x8d, 0xdf, 0xad, 
  0x0b, 0xf6, 0x3e, 0xea, 0x7f, 0x97, 0x84, 0x0d, 0x7e, 0xfc, 0x77, 0xce, 
  0x6d, 0x7b, 0x6b, 0x9f, 0xfc, 0x43, 0xba, 0xfc, 0x4b, 0xd6, 0x47, 0x8c, 
  0x51, 0xdd, 0xcb, 0xfa, 0xcd, 0xf1, 0xc5, 0x97, 0xc7, 0x17, 0x67, 0x97, 
  0x8f, 0x11, 0x6a, 0x62, 0x46, 0xae, 0x36, 0xb5, 0xdf, 0x26, 0xc5, 0x38, 
  0x29, 0xf2, 0xf2, 0xb1, 0x2b, 0xe6, 0xe0, 0x0b, 0x11, 0x43, 0x1f, 0xca, 
  0x2c, 0xd1, 0xc9, 0x9e, 0x24, 0x0a, 0x98, 0xdc, 0x12, 0xbb, 0x84, 0x9b, 
  0xa6, 0xe5, 0xc9, 0x34, 0x4b, 0x2c, 0xbb, 0x30, 0x35, 0xd1, 0x8a, 0x1b, 
  0x76, 0x20, 0x39, 0x8e, 0x54, 0x5f, 0xb2, 0xd9, 0x78, 0xe0, 0x22, 0x91, 
  0x6e, 0x8b, 0xf1, 0x90, 0x48, 0xfa, 0xd6, 0x6a, 0x59, 0x49, 0x3c, 0x38, 
  0xf1, 0x43, 0x09, 0x14, 0xf5, 0x66, 0x84, 0x5b, 0x26, 0x7f, 0xae, 0x3b, 
  0x60, 0x85, 0x26, 0x56, 0xb8, 0x03, 0x2c, 0xee, 0x8f, 0x39, 0xe8, 0x43, 
  0xb9, 0xfa, 0xd4, 0xcf, 0x63, 0x57, 0xb1, 0x46, 0x8c, 0x58, 0xfc, 0x91, 
  0x43, 0x2b, 0xd2, 0x72, 0x05, 0x88, 0x15, 0x9a, 0x91, 0x84, 0xbd, 0xbc, 
  0x9f, 0xea, 0x25, 0x01, 0xe8, 0xd8, 0x4c, 0x8c, 0xd8, 0xc2, 0xa3, 0x9b, 
  0xae, 0x0c, 0x2e, 0xb1, 0x83, 0x98, 0x75, 0x8d, 0xc8, 0x8d, 0xc6, 0xf3, 
  0x38, 0xbb, 0xc5, 0x6d, 0x85, 0xdb, 0x87, 0x75, 0x4a, 0x1b, 0x2a, 0x89, 
  0xd1, 0xe2, 0xb9, 0xd2, 0xf4, 0x78, 0xc8, 0x77, 0x73, 0xe6, 0x5e, 0x6b, 
  0xab, 0x73, 0xaa, 0xb6, 0x80, 0xc0, 0x47, 0x83, 0xe3, 0xc2, 0xf3, 0x67, 
  0x4b, 0x10, 0x6a, 0x90, 0xba, 0x08, 0x7b, 0xa8, 0xdc, 0x52, 0x64, 0xd4, 
  0xe2, 0x44, 0x24, 0xa9, 0x2c, 0x05, 0x8f, 0x12, 0xbe, 0x60, 0x78, 0xc6, 
  0xf0, 0x2f, 0x80, 0x0e, 0x90, 0x3d, 0x57, 0x3a, 0xd0, 0x7f, 0xe5, 0xc9, 
  0xc2, 0x9f, 0x00, 0xd7, 0xe7, 0x6b, 0x00, 0x84, 0x05, 0x22, 0x14, 0x5e, 
  0xf9, 0xc8, 0x47, 0x89, 0xc4, 0xf6, 0x9d, 0x0c, 0xc2, 0xcb, 0x9a, 0xce, 
  0x0b, 0x55, 0x0b, 0xed, 0xdf, 0xb8, 0x43, 0xf2, 0x7a, 0x97, 0x7e, 0x0f, 
  0xfe, 0x96, 0x69, 0x2d, 0x59, 0x0f, 0x8c, 0x62, 0xf1, 0x9a, 0xf5, 0x18, 
  0x49, 0x1b, 0xb8, 0xd6, 0xa3, 0x4e, 0x4a, 0x44, 0x32, 0x89, 0x63, 0x09, 
  0xf1, 0x7d, 0x7a, 0xb7, 0x56, 0x53, 0x30, 0x93, 0xa2, 0x86, 0x1d, 0x19, 
  0x86, 0x26, 0x4a, 0xf2, 0x3e, 0x4c, 0x7d, 0x12, 0xac, 0x0e, 0x05, 0xc5, 
  0x09, 0xad, 0xc3, 0xd7, 0x7c, 0x13, 0xe4, 0xc3, 0xf1, 0x0a, 0x2a, 0x97, 
  0x47, 0x99, 0xd2, 0x04, 0x36, 0xd2, 0xc4, 0x04, 0x56, 0x0a, 0xdf, 0xb3, 
  0xbf, 0x02, 0xc9, 0xc1, 0xe2, 0xc2, 0x40, 0xae, 0x58, 0x1d, 0x72, 0xc4, 
  0x01, 0x4d, 0x48, 0x00, 0x36, 0x02, 0x51, 0x35, 0xda, 0x56, 0x47, 0xa8, 
  0x9b, 0xec, 0x82, 0xc7, 0xb2, 0xe4, 0x3a, 0xaf, 0x52, 0xb5, 0x9d, 0xd7, 
  0xc3, 0x4d, 0x5d, 0xbd, 0x59, 0x62, 0x5a, 0x3c, 0xdf, 0x44, 0x51, 0x99, 
  0x2d, 0x8e, 0xd4, 0xa2, 0xd6, 0xef, 0x2a, 0xae, 0xb5, 0x22, 0x49, 0xf2, 
  0xf1, 0x5c, 0x70, 0xf3, 0x37, 0x5e, 0x12, 0x72, 0x8e, 0xaa, 0xab, 0xab, 
  0x1f, 0xce, 0x8f, 0x9f, 0xdb, 0x9b, 0x0f, 0xed, 0x99, 0x40, 0x47, 0x21, 
  0xae, 0x22, 0x51, 0xf8, 0x40, 0x8b, 0x1f, 0x16, 0xc6, 0x30, 0xac, 0xcc, 
  0xdf, 0x2b, 0xdd, 0x0c, 0xa3, 0xef, 0x5f, 0x9c, 0x5c, 0x9e, 0x9f, 0x9e, 
  0x1d, 0x3d, 0x7f, 0xf6, 0xbd, 0x31, 0xdb, 0xcf, 0x19, 0x2b, 0x45, 0x24, 
  0x30, 0xf7, 0x99, 0xcf, 0x6d, 0xd7, 0xf7, 0x5e, 0x1f, 0x7f, 0xf7, 0x96, 
  0x44, 0xfe, 0xe7, 0x0c, 0xb3, 0x3c, 0xb8, 0x8b, 0xe7, 0xfa, 0x12, 0xeb, 
  0x4d, 0x1d, 0x52, 0x5b, 0x90, 0x86, 0xd0, 0xb5, 0xb0, 0x28, 0x69, 0xe6, 
  0x31, 0x2f, 0xd7, 0x10, 0x82, 0x35, 0xb8, 0x2a, 0xa8, 0xd5, 0x12, 0xd7, 
  0x72, 0x0a, 0x3b, 0xca, 0x8a, 0xe5, 0xee, 0x62, 0xef, 0x57, 0x12, 0x64, 
  0xc7, 0x6e, 0xe6, 0xd0, 0x7b, 0x8b, 0x90, 0x4c, 0xfd, 0xc6, 0x07, 0x33, 
  0x2a, 0xa0, 0x69, 0xc1, 0x41, 0x0e, 0x06, 0x8b, 0xa3, 0x1d, 0x8b, 0x5f, 
  0x54, 0xb2, 0x96, 0x0c, 0x83, 0x26, 0x9b, 0xfa, 0x50, 0x62, 0xe3, 0x60, 
  0x2a, 0x9d, 0xb8, 0xb1, 0xc4, 0x93, 0x09, 0xfd, 0x60, 0xd4, 0x3e, 0xae, 
  0x90, 0x71, 0xce, 0x45, 0x42, 0x2f, 0xaf, 0x0e, 0x49, 0x37, 0x3a, 0x3a, 
  0x7b, 0xfd, 0xfa, 0xf8, 0xc8, 0x4c, 0xca, 0x56, 0x13, 0x0a, 0x29, 0xeb, 
  0x75, 0x34, 0xc0, 0x10, 0xbc, 0xbf, 0x76, 0xa2, 0x1d, 0x83, 0xab, 0x67, 
  0xb0, 0xb1, 0x91, 0x40, 0xb2, 0xe2, 0x58, 0xc4, 0x14, 0x4c, 0xcb, 0x78, 
  0x66, 0x07, 0x38, 0x57, 0xd2, 0x68, 0x60, 0xd8, 0xfb, 0xa2, 0xd5, 0xf3, 
  0x74, 0xec, 0x8d, 0xe0, 0x0d, 0x17, 0x23, 0x7b, 0xb0, 0x15, 0xab, 0x20, 
  0x3c, 0x42, 0x66, 0xde, 0xf6, 0x69, 0xa1, 0x65, 0x6e, 0xa5, 0xd3, 0x84, 
  0xf8, 0x61, 0x7e, 0x0e, 0x73, 0xf7, 0x9c, 0xf6, 0x09, 0x25, 0xc3, 0x24, 
  0x30, 0xf7, 0x69, 0x10, 0x95, 0xa8, 0xf0, 0x37, 0x40, 0x93, 0x54, 0x66, 
  0x8d, 0x12, 0x97, 0x92, 0x86, 0x93, 0x49, 0x99, 0x6a, 0x24, 0x16, 0x23, 
  0x96, 0x44, 0x67, 0xd6, 0x12, 0x2e, 0x54, 0x2a, 0xbc, 0xe6, 0xfc, 0x1d, 
  0x60, 0x0c, 0x4d, 0x59, 0x92, 0x82, 0x71, 0x2d, 0xec, 0xcc, 0x2e, 0x4f, 
  0x5e, 0x41, 0xab, 0x55, 0x2b, 0xde, 0x56, 0x37, 0x7a, 0x29, 0x12, 0x80, 
  0x85, 0x47, 0xdc, 0x5c, 0x5c, 0x00, 0xbc, 0xaf, 0x52, 0xec, 0x66, 0x53, 
  0x69, 0x34, 0x08, 0x6e, 0x54, 0xc7, 0x33, 0x31, 0xba, 0xd4, 0x18, 0x96, 
  0x07, 0x57, 0xd4, 0xad, 0xa6, 0x90, 0x6f, 0x91, 0x58, 0x6c, 0x8b, 0xd8, 
  0x0e, 0x4a, 0xf6, 0x1f, 0x64, 0x96, 0xa4, 0x21, 0x19, 0x17, 0x1c, 0xe3, 
  0x51, 0x28, 0x54, 0x0c, 0xb1, 0x3f, 0xb6, 0x14, 0xa3, 0x48, 0x37, 0x6a, 
  0xdf, 0xb1, 0x13, 0xcd, 0x60, 0xc4, 0x1c, 0x00, 0x87, 0x2e, 0x77, 0x40, 
  0x56, 0x62, 0x2e, 0x5f, 0x6b, 0x87, 0x2e, 0x3b, 0xd8, 0x36, 0x6b, 0x20, 
  0xc9, 0x26, 0x31, 0x72, 0x1b, 0xcc, 0x64, 0x1b, 0xe4, 0xc8, 0x95, 0x9a, 
  0x79, 0xe8, 0x1c, 0x90, 0xc2, 0xf0, 0x50, 0x04, 0xc6, 0xe7, 0xea, 0xd4, 
  0x1c, 0x7d, 0x24, 0x38, 0x2e, 0x51, 0xd1, 0x64, 0x82, 0x9d, 0x41, 0x14, 
  0xa7, 0x6b, 0xcd, 0x6e, 0x10, 0xbf, 0x52, 0xc2, 0xa7, 0xbb, 0x17, 0xae, 
  0x51, 0x80, 0x0c, 0x41, 0xf5, 0xbc, 0x3c, 0x7f, 0x1c, 0xfd, 0x91, 0x5e, 
  0x7b, 0x75, 0x78, 0x72, 0xca, 0x5e, 0xc8, 0x53, 0x3a, 0x83, 0x97, 0x66, 
  0x1d, 0x86, 0xab, 0x16, 0x5e, 0x54, 0x12, 0xb6, 0x69, 0x3d, 0x07, 0x0e, 
  0xae, 0xd5, 0x62, 0x1c, 0x41, 0x58, 0x6c, 0x52, 0x11, 0xde, 0xac, 0x18, 
  0x16, 0xc4, 0x11, 0x27, 0x2b, 0x0e, 0x4a, 0x64, 0x79, 0x19, 0x50, 0x51, 
  0x8c, 0xa1, 0x08, 0x23, 0x16, 0x78, 0x9e, 0xb8, 0x95, 0x81, 0x10, 0xcd, 
  0x35, 0x98, 0xef, 0x54, 0xb0, 0x15, 0xe4, 0x9d, 0xaf, 0xd4, 0x72, 0x24, 
  0x15, 0x62, 0xaa, 0xad, 0xce, 0xd2, 0xbd, 0xbb, 0xdc, 0xe7, 0xae, 0xdc, 
  0xa7, 0xd2, 0xad, 0x47, 0x87, 0x34, 0x33, 0x1d, 0x3f, 0x3f, 0x64, 0xe6, 
  0xa3, 0x35, 0xc6, 0xdf, 0x94, 0x9a, 0x63, 0xd4, 0x0c, 0xf4, 0x50, 0xf9, 
  0x4d, 0x4b, 0x0b, 0x88, 0xbe, 0x33, 0x30, 0x1c, 0x2f, 0xd1, 0xd2, 0x98, 
  0x5e, 0x07, 0x2c, 0x1b, 0xa3, 0x25, 0xab, 0x13, 0x38, 0x90, 0xf8, 0x76, 
  0x08, 0x28, 0xa4, 0x11, 0x0d, 0x22, 0xb8, 0xad, 0x78, 0xb5, 0xf1, 0x2c, 
  0xe3, 0x10, 0x05, 0xce, 0x64, 0x2e, 0xf6, 0x8e, 0x48, 0x26, 0xfd, 0x0b, 
  0x4d, 0x15, 0x2b, 0xc0, 0x5d, 0x0d, 0x10, 0x44, 0x08, 0x13, 0x4f, 0x35, 
  0x19, 0xb9, 0xd1, 0xab, 0x9d, 0x55, 0xc6, 0xff, 0xc2, 0xcc, 0x80, 0x06, 
  0x37, 0x94, 0x17, 0xb6, 0xaa, 0xb2, 0xfa, 0x63, 0xa9, 0x04, 0xf1, 0xe5, 
  0x8a, 0xad, 0x0f, 0x0e, 0xe9, 0x98, 0x47, 0xb1, 0xe0, 0x0a, 0x2e, 0x89, 
  0x14, 0x5d, 0x71, 0x8d, 0xf3, 0x51, 0x5b, 0xd1, 0xae, 0x4a, 0xeb, 0xa7, 
  0xf9, 0x3d, 0x97, 0x8c, 0x99, 0xcd, 0xd2, 0x09, 0x83, 0x02, 0xc3, 0x94, 
  0x22, 0xdf, 0x2f, 0x0c, 0x9d, 0x9a, 0xa6, 0x14, 0x2d, 0x57, 0xe3, 0x39, 
  0x09, 0x71, 0x16, 0x82, 0x12, 0xb6, 0x36, 0x1d, 0x9e, 0x7f, 0x7d, 0x6e, 
  0x4b, 0x6d, 0x87, 0x43, 0x82, 0x97, 0x35, 0x78, 0x09, 0x56, 0x00, 0x7a, 
  0x68, 0x14, 0x1d, 0xb3, 0x04, 0x28, 0x37, 0xba, 0xb2, 0x54, 0x5c, 0x5e, 
  0xf4, 0x1d, 0x75, 0x7b, 0xcd, 0x69, 0x89, 0x67, 0x05, 0xff, 0x85, 0xd6, 
  0xf4, 0x4b, 0x91, 0x54, 0xf1, 0xad, 0xeb, 0x95, 0xb7, 0x91, 0xa8, 0x4b, 
  0x03, 0x02, 0xac, 0x70, 0x10, 0xb1, 0x10, 0xf1, 0xf5, 0x2b, 0x72, 0x1a, 
  0xe8, 0xe9, 0xe8, 0xdb, 0xcb, 0x48, 0x1f, 0x97, 0x22, 0x19, 0x16, 0x4d, 
  0x0c, 0x0d, 0x44, 0x70, 0x7f, 0x17, 0x74, 0x36, 0xb8, 0x79, 0xa9, 0x2f, 
  0x9e, 0x5a, 0xe6, 0x24, 0x72, 0x67, 0xff, 0xb6, 0x42, 0xac, 0x54, 0x44, 
  0xe2, 0xd0, 0x75, 0xa8, 0x69, 0x2d, 0x50, 0x00, 0x48, 0xf3, 0x5e, 0x59, 
  0xb0, 0x60, 0xa8, 0xbd, 0x80, 0xda, 0x65, 0x9f, 0xc7, 0x8a, 0x56, 0xe4, 
  0x55, 0xf0, 0x19, 0xa0, 0xa6, 0x39, 0x75, 0x5d, 0x74, 0x0a, 0xd8, 0x37, 
  0xb5, 0xfc, 0x02, 0xe6, 0xc6, 0x58, 0x83, 0xff, 0xae, 0xf9, 0x51, 0x5b, 
  0x3a, 0x39, 0xb4, 0xb4, 0x0d, 0x51, 0x7c, 0xbe, 0xf6, 0x6e, 0x61, 0x0e, 
  0xc6, 0x1b, 0xfd, 0xc2, 0x49, 0xa3, 0xa9, 0xc6, 0xc4, 0x51, 0x11, 0x1d, 
  0x04, 0xfd, 0xcb, 0x66, 0x7c, 0x8e, 0xbc, 0x69, 0xcd, 0xaf, 0x90, 0x31, 
  0x07, 0x87, 0x49, 0x0f, 0x9c, 0x73, 0x0c, 0x0b, 0x07, 0x29, 0x24, 0xf9, 
  0xb3, 0x48, 0xd4, 0x8d, 0x9e, 0xab, 0x29, 0x4e, 0xee, 0xd6, 0x32, 0x69, 
  0x30, 0xa6, 0x00, 0x1a, 0xda, 0xbe, 0xe0, 0x0b, 0x20, 0x25, 0xbd, 0xf7, 
  0x2e, 0x9d, 0xae, 0xe2, 0xf9, 0x68, 0xeb, 0xff, 0x00, 0x78, 0xd8, 0xe6, 
  0xb5, 0x95, 0x6a, 0x01, 0x00, 
};
/* Decompress and send to stdout a gzip-compressed buffer */
void hugehelp(void)
{
  unsigned char buf[0x10000];
  int status,headerlen;
  z_stream z;

  /* Make sure no gzip options are set */
  if (hugehelpgz[3] & 0xfe)
    return;

  headerlen = 10;
  z.avail_in = sizeof(hugehelpgz) - headerlen;
  z.next_in = (unsigned char *)hugehelpgz + headerlen;
  z.zalloc = (alloc_func)Z_NULL;
  z.zfree = (free_func)Z_NULL;
  z.opaque = 0;
  z.next_in = NULL;
  z.avail_in = 0;

  if (inflateInit2(&z, -MAX_WBITS) != Z_OK)
    return;

  for (;;) {
    z.avail_out = (int)sizeof(buf);
    z.next_out = buf;
    status = inflate(&z, Z_SYNC_FLUSH);
    if (status == Z_OK || status == Z_STREAM_END) {
      fwrite(buf, sizeof(buf) - z.avail_out, 1, stdout);
      if (status == Z_STREAM_END)
         break;
    } else
      break;    /* Error */
  }
  inflateEnd(&z);
}
#endif /* HAVE_LIBZ */
