<?php
/*
 $Id: stats_show_per_month.php,v 1.8 2005/09/09 20:36:06 darcs Exp $
 ----------------------------------------------------------------------
 AlternC - Web Hosting System
 Copyright (C) 2002 by the AlternC Development Team.
 http://alternc.org/
 ----------------------------------------------------------------------
 Based on:
 Valentin Lacambre's web hosting softwares: http://altern.org/
 ----------------------------------------------------------------------
 LICENSE

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License (GPL)
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 To read the license please visit http://www.gnu.org/copyleft/gpl.html
 ----------------------------------------------------------------------
 Original Author of file:
 Purpose of file:
 ----------------------------------------------------------------------
*/
require_once("../class/config.php");

include("head.php");

// max 100 months, 12 by default
$count = ($_GET['count'] ? $_GET['count'] % 100: 12);
?>
<style>
.right { text-align: right; }
</style>
</head>
<body>
<h3><?php __("Bandwidth usage in the last $count months"); ?></h3>

<form method="GET">
Months: <input type="text" size="3" name="count" value="<?=$count?>">
<input type="submit" value="<?=_("Go")?>">
</form>
<?php

/*
 * find all the entries for a user
 */
$current_user = null;

$months = array();

$class = ($class== 'lst1' ? 'lst2' : 'lst1');
print "<table><tr class=\"$class\"><td class=\"right\">"._("User")."</td>";

// figure out YYYY-MM for the last N months
// XXX: bad, bad boy should be using PEAR Date
for ($i = ($count - 1); $i >= 0; $i--) {
  if ((date('m') - $i) < 1) { // we're switching a year (or more?)
    $y = round(date('Y') - ($i / 12));
    $m = date('m') - ($i % 12);
    while ($m < 0) {
      $m+=12;
    }
    if ($m == 0) $m = 12;
    $m = $y .'-'.$m;
  } else {
    $m = date('Y') .'-' . (sprintf("%02d", date('m') - $i));
  }
  $months[] = $m;
}

$db->query("SELECT DISTINCT date_format(day, '%Y-%m') AS `month` FROM stat_http
WHERE `day` < CONCAT( date_format( DATE_ADD( NOW( ) , INTERVAL 1 
MONTH ) , '%Y-%m' ) , '-01' )
AND `day` >= CONCAT( date_format( DATE_SUB( NOW( ) , INTERVAL " . (int) ($count - 1) .
" MONTH ) , '%Y-%m' ) , '-01' )
ORDER BY month ASC");

$months = array();
while ($db->next_record()) {
  $months[] = $db->f('month');
}

foreach ($months as $m) {
  print "<td>$m</td>";
}

// the stats in the last $count months for all accounts
$db->query("
SELECT SUM( s.size ) AS cnt, s.uid, date_format(
DAY , '%Y-%m' ) AS `month`, m.login
FROM `stat_http` s, membres m
WHERE `day` < CONCAT( date_format( DATE_ADD( NOW( ) , INTERVAL 1 
MONTH ) , '%Y-%m' ) , '-01' )
AND `day` >= CONCAT( date_format( DATE_SUB( NOW( ) , INTERVAL " . (int) ($count - 1) .
" MONTH ) , '%Y-%m' ) , '-01' ) 
AND m.uid = s.uid
GROUP BY `uid` , `month`
ORDER BY `login`
");

while ($db->next_record()) {
  if (($user = $db->f("uid")) !== $current_user) {
    # deal w/ $entries...
    if (!is_null($current_user)) { // not the first time we enter this block
      $class = ($class== 'lst1' ? 'lst2' : 'lst1');
      print "<tr class=\"$class\"><td class=\"right\"><acronym title=\"$current_user\">".$login."</acronym></td>\n";
      foreach ($months as $m) {
        print "<td>" . m_quota::display_val('bw_web', $entries[$m]) . "</td>\n";
        $monthly_size[$m] += $entries[$m];
      }
      print "</tr>\n";
    }
    $current_user = $user;
    $login = $db->f('login');
    $entries = array();
  }
  $entries[$db->f("month")] = $db->f("cnt");
}

print "</tr>\n";

print "<tr><td class=\"right\">"._("Total")."</td>";

foreach ($monthly_size as $m => $size) {
  print "<td>".m_quota::display_val('bw_web', $size)."</td>";
}

print "</table>";

?>
</body>
</html>
