<?php
/*
 $Id: cacti_users.php,v 1.1.1.1 2004/12/17 18:32:58 anonymous Exp $
 ----------------------------------------------------------------------
 AlternC - Web Hosting System
 Copyright (C) 2002 by the AlternC Development Team.
 http://alternc.org/
 ----------------------------------------------------------------------
 Based on:
 Valentin Lacambre's web hosting softwares: http://altern.org/
 ----------------------------------------------------------------------
 LICENSE

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License (GPL)
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 To read the license please visit http://www.gnu.org/copyleft/gpl.html
 ----------------------------------------------------------------------
 Original Author of file: Benjamin Sonntag
 Purpose of file: Manage list of allowed accounts for cacti stats.
 ----------------------------------------------------------------------
*/

require_once("../class/config.php");

if (!$admin->enabled) {
	__("This page is restricted to authorized staff");
	exit();
}

if ($delaccount) {
	// Delete an account
	if ($cacti->del_cacti_account($delaccount)) {
		$error=_("The requested account has been deleted. It is now denied.");
	}
}
if ($newlogin) {
	// Add an account
	if ($cacti->add_cacti_account($newlogin,$newpass)) { 
		$error=_("The requested account has been created. It is now allowed.");
		unset($newlogin); unset($newpass);
	}
}

include("head.php");
?>
</head>
<body>
<h3><?php __("Manage allowed accounts for cacti statistics"); ?></h3>
<?php
	if ($error) {
	  echo "<p class=\"error\">$error</p>";
	}

$c=$cacti->enum_cacti_account();

if (is_array($c)) {

?>
<p>
<?php __("Here is the list of the allowed accounts for cacti statistic gathering. You can configure the cacti package on a server and give him the login/pass that will grant him access to your server's statistics. "); ?>
</p>

<table border="0" cellpadding="4" cellspacing="0">
<tr><th><?php __("Action"); ?></th><th><?php __("Login"); ?></th><th><?php __("Password"); ?></th></tr>
<?php
$col=1;
for($i=0;$i<count($c);$i++) {
 $col=3-$col;
?>

<tr class="lst<?php echo $col; ?>">
<td><a href="cacti_users.php?delaccount=<?php echo urlencode($c[$i]["login"]); ?>"><?php __("Delete"); ?></a></td>
<td><?php echo $c[$i]["login"]; ?></td>
<td><?php echo $c[$i]["pass"]; ?></td>
</tr>
<?php
}
?>
</table>
    <?php } ?>
<p><?php __("If you want to allow a new server to access your cacti stats, give him an account."); ?></p>
<form method="post" action="cacti_users.php">
<table border="0" cellpadding="4" cellspacing="0">
<tr><th><label for="newlogin"><?php __("Login"); ?></label></th><th><label for="newpass"><?php __("Password"); ?></label></th></tr>
<tr>
	<td><input type="text" class="int" value="<?php echo urlencode($newlogin); ?>" id="newlogin" name="newlogin" maxlength="64" size="32" /> / </td>
	<td><input type="text" class="int" value="<?php echo urlencode($newpass); ?>" id="newpass" name="newpass" maxlength="64" size="32" /></td>
</tr>
<tr><td colspan="2">
	<input type="submit" value="<?php __("Add this account to the allowed list"); ?>" class="inb" />
</table>

</form>
</body>
</html>
