#!/usr/bin/php4 -q
<?php

/*
 $Id: cacti.php,v 1.2 2005/04/09 14:32:03 benjamin Exp $
 ----------------------------------------------------------------------
 AlternC - Web Hosting System
 Copyright (C) 2002 by the AlternC Development Team.
 http://alternc.org/
 ----------------------------------------------------------------------
 Based on:
 Valentin Lacambre's web hosting softwares: http://altern.org/
 ----------------------------------------------------------------------
 LICENSE

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License (GPL)
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 To read the license please visit http://www.gnu.org/copyleft/gpl.html
 ----------------------------------------------------------------------
 Original Author of file: Benjamin Sonntag
 Purpose of this file: this is a cacti-like statistic gathering prog.
 ----------------------------------------------------------------------
*/

include("/etc/alternc/cacti.conf.php");

// Debug output ? (launch the script with a "debug" paramete)
if (is_array($argv) && in_array("debug",$argv)) {
   $debug=1;
} else {
  $debug=0;
}


include("/var/alternc/bureau/class/local.php");

if (!$L_MYSQL_HOST) $L_MYSQL_HOST="localhost";

mysql_connect($L_MYSQL_HOST,$L_MYSQL_LOGIN,$L_MYSQL_PWD);
mysql_select_db($L_MYSQL_DATABASE);

// 1. Bandwith (input, in bytes)
// 2. Bandwith (output, in bytes)
$f=fopen("/proc/net/dev","rb");

if ($f) {
  $found=0;
  // skip 2 header lines.
  $s=fgets($f,1024);
  $s=fgets($f,1024);
  
  while ($s=fgets($f,1024)) {
    $s=trim($s);
    //    if ($debug) echo "1,2: found : $s ";
    if (preg_match("/^\s*([^:]*):\s*([0-9]+)\s*[0-9]+\s*[0-9]+\s*[0-9]+\s*[0-9]+\s*[0-9]+\s*[0-9]+\s*[0-9]+\s*([0-9]+)\s*[0-9]+\s*[0-9]+\s*[0-9]+\s*[0-9]+\s*[0-9]+\s*[0-9]+\s*[0-9]+\s*$/",$s,$match)) {
      if ($match[1]==$CACTI_NET_DEV) {
	$found=1;
	if ($debug) echo "1,2: found interface $CACTI_NET_DEV values are ".$match[2]." / ".$match[3]." \n";
	mysql_query("INSERT INTO cacti (stid,value) VALUES (1,'".$match[2]."');");
	mysql_query("INSERT INTO cacti (stid,value) VALUES (2,'".$match[3]."');");
      }
      if ($match[1]==$CACTI_NET_PRIVATE) {
	$found=1;
	if ($debug) echo "1,2,14,15: found interface $CACTI_NET_PRIVATE values are ".$match[2]." / ".$match[3]." \n";
	mysql_query("INSERT INTO cacti (stid,value) VALUES (14,'".$match[2]."');");
	mysql_query("INSERT INTO cacti (stid,value) VALUES (15,'".$match[3]."');");
      }
    } else {
      if ($debug) echo "1,2: don't match.\n";
    }
  }
  if (!$found && $debug) echo "1,2: Interface not found ! \n";
  
  fclose($f);
} else {
  if ($debug) echo "1,2: File /proc/net/dev not found or cannot be opened readonly !\n";
}

// 3. Apache requests (total), using apache status line.
// 12. Apache bandwith (total)
$f=fopen("http://$MYIP/server-status?auto","rb");
if ($f) {
  // The first and second line are what we need ;) 
  $s=trim(fgets($f,1024));
  if (preg_match("/^Total Accesses: ([0-9]+)$/",$s,$match)) {
    if ($debug) echo "3,12: Found total accesses : ".$match[1]."\n";
    mysql_query("INSERT INTO cacti (stid,value) VALUES (3,'".$match[1]."');");
  } else {
    if ($debug) echo "3,12: total accesses not found !\n";
  }
  $s=trim(fgets($f,1024));
  if (preg_match("/^Total kBytes: ([0-9]+)$/",$s,$match)) {
    if ($debug) echo "3,12: Found total kBytes : ".$match[1]."\n";
    mysql_query("INSERT INTO cacti (stid,value) VALUES (12,'".$match[1]."');");
  } else {
    if ($debug) echo "3,12: total kBytes not found !\n";
  }
} else {
  if ($debug) echo "3,12: server-status not found !\n";
}

// 4. Mysql Queries : 
$key=""; $val=0;
list($key,$val)=@mysql_fetch_array(mysql_query("SHOW STATUS LIKE 'Questions'"));
if ($key=="Questions") {
  if ($debug) echo "4: found $val queries\n";
  mysql_query("INSERT INTO cacti (stid,value) VALUES (4,'$val');");
} else {
  echo "4: query count for mysql not found\n";
}

// 9. Mysql Connection count : 
$r=mysql_query("SHOW PROCESSLIST;");
$ct=mysql_num_rows($r);
if ($ct) {
  if ($debug) echo "9: found $ct connections\n";
  mysql_query("INSERT INTO cacti (stid,value) VALUES (9,'$ct');");
} else {
  echo "9: connection count for mysql not found\n";
}

// 5. Used Memory (kB)
// 6. Used Cache (kB)
$f=fopen("/proc/meminfo","rb");

if ($f) {
  $memtotal=0; $memfree=0; $swaptotal=0; $swapfree=0;
  
  while ($s=fgets($f,1024)) {
    $s=trim($s);
    if (preg_match("/^\s*([^:]*):\s*([0-9]+)\skB$/",$s,$match)) {
      if ($match[1]=="MemTotal") {	$memtotal=doubleval($match[2]);      }
      if ($match[1]=="MemFree") {	$memfree=doubleval($match[2]);      }
      if ($match[1]=="SwapTotal") {	$swaptotal=doubleval($match[2]);      }
      if ($match[1]=="SwapFree") {	$swapfree=doubleval($match[2]);      }
    } else {
      if ($debug) echo "5,6: don't match.\n";
    }
  }
  if ($debug) echo "5,6: memtotal: $memtotal, memfree: $memfree, swaptotal: $swaptotal, swapfree: $swapfree \n";
  if ($memtotal && $memfree) {
    mysql_query("INSERT INTO cacti (stid,value) VALUES (5,'".doubleval($memtotal-$memfree)."');");
  }
  if ($swaptotal && $swapfree) {
    mysql_query("INSERT INTO cacti (stid,value) VALUES (6,'".doubleval($swaptotal-$swapfree)."');");
  }
  fclose($f);
} else {
  if ($debug) echo "5,6: File /proc/meminfo not found or cannot be opened readonly !\n";
}


// 7. Load average (1min)
// 8. Process count (from loadavg)
$f=fopen("/proc/loadavg","rb");

if ($f) {
  $s=trim(fgets($f,1024));
  if (preg_match("/^[0-9\.]+\s*([0-9\.]+)\s*[0-9\.]+\s*[0-9]+.([0-9]+)\s*[0-9]+$/",$s,$match)) {
    if ($debug) echo "7,8: Load Average 1 min : ".$match[1]." process count : ".$match[2]." \n";
    $load=doubleval($match[1])*100;
    mysql_query("INSERT INTO cacti (stid,value) VALUES (7,'".$load."');");
    mysql_query("INSERT INTO cacti (stid,value) VALUES (8,'".$match[2]."');");
  } else {
    if ($debug) echo "7,8: don't match.\n";
  }
  fclose($f);
} else {
  if ($debug) echo "7,8: File /proc/loadavg not found or cannot be opened readonly !\n";
}

// 10. Mailqueue
$mq=exec("find /var/spool/postfix/active /var/spool/postfix/deferred /var/spool/postfix/incoming -type f | wc -l");
$mq=doubleval(trim($mq));
if ($mq!==false) {
  if ($debug) echo "10: Mail queue has $mq items.\n";
  mysql_query("INSERT INTO cacti (stid,value) VALUES (10,'$mq');");
} else {
  if ($debug) echo "10: Cannot read mail queue size.\n";
}

// 11. Space used on root partition
// 13. Space used on data partition
$out=explode("\n",trim(shell_exec("df -mP")));
$root_size=0; $root_used=0; $data_size=0; $data_used=0;
for($i=1;$i<count($out);$i++) { // we skip the first line (explanation)
  if (preg_match("/([^\s]+)\s+([0-9]+)\s+([0-9]+)\s+[0-9]+\s+[0-9]+%\s+[^\s]+$/",$out[$i],$match)) {
    if ($match[1]==$CACTI_ROOT_PART) {
      $root_size=$match[2];
      $root_used=$match[3];
      if ($debug) echo "11,13: root used : $root_used size : $root_size \n";
    }
    if ($match[1]==$CACTI_DATA_PART) {
      $data_size=$match[2];
      $data_used=$match[3];
      if ($debug) echo "11,13: data used : $data_used size : $data_size \n";
    }
  } else {
        if ($debug) echo "11,13: line don't match : ".$out[$i]."\n";
  }
}
if ($root_size && $root_used) {
  mysql_query("INSERT INTO cacti (stid,value) VALUES (11,'".(doubleval($root_used*100)/doubleval($root_size))."');");
}
if ($data_size && $data_used) {
  mysql_query("INSERT INTO cacti (stid,value) VALUES (13,'".(doubleval($data_used*100)/doubleval($data_size))."');");
}


?>
