-- 
-- Structure de la table `cacti`
-- 

CREATE TABLE `cacti` (
  `ts` timestamp(14) NOT NULL,
  `stid` tinyint(3) unsigned NOT NULL default '0',
  `value` bigint(20) unsigned NOT NULL default '0',
  KEY `stid` (`stid`)
) TYPE=MyISAM COMMENT='Les statistiques du serveur (remplies pour cacti)';

-- --------------------------------------------------------

-- 
-- Structure de la table `cacti_account`
-- 

CREATE TABLE `cacti_account` (
  `login` varchar(64) NOT NULL default '',
  `pass` varchar(64) NOT NULL default '',
  PRIMARY KEY  (`login`)
) TYPE=MyISAM COMMENT='Allowed account for slave dns managment';

-- --------------------------------------------------------

-- 
-- Structure de la table `cacti_stid`
-- 

CREATE TABLE `cacti_stid` (
  `stid` tinyint(3) unsigned NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`stid`)
) TYPE=MyISAM COMMENT='Les noms des stats pour cacti (stid)';

INSERT IGNORE INTO `cacti_stid` VALUES (1, 'Bandwith (input, in bytes)'),
(2, 'Bandwith (output, in bytes)'), (3, 'Apache requests (total)'),
(4, 'Mysql queries (total)'), (5, 'Used memory (Mb)'),
(6, 'USed cache (Mb)'), (7, 'Load average (1min)'),
(8, 'Process count'), (9, 'Mysql connection count'),
(11, 'Space used on root partition'), (10, 'message queue count'),
(12, 'Apache bandwith (total)'), (13, 'Space used on data partition'),
(14, 'Bandwith private (input, in bytes)'), (15, 'Bandwith private (output, in bytes)') ;

