<?php
/*
 $Id: m_webalizer.php 83 2006-03-29 23:23:12Z benjamin $
 ----------------------------------------------------------------------
 AlternC - Web Hosting System
 Copyright (C) 2002 by the AlternC Development Team.
 http://alternc.org/
 ----------------------------------------------------------------------
 Based on:
 Valentin Lacambre's web hosting softwares: http://altern.org/
 ----------------------------------------------------------------------
 LICENSE

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License (GPL)
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 To read the license please visit http://www.gnu.org/copyleft/gpl.html
 ----------------------------------------------------------------------
 Original Author of file: Benjamin Sonntag
 Purpose of file: Gestion des statistiques web par Webalizer.
 ----------------------------------------------------------------------
*/
/**
* Classe de gestion des statistiques web webalizer / apache des hbergs
* 
* Cette classe permet de grer les statistiques web gnres par webalizer
* dans la langue de votre choix, ainsi que les fichiers logs bruts d'apache.<br />
* Copyleft {@link http://alternc.net/ AlternC Team}
* 
* @copyright    AlternC-Team 2002-11-01 http://alternc.net/
* 
*/
class m_webalizer {

  /** Emplacement des fichiers de conf webalizer
   * @access private 
   */
  var $CONFDIR="/var/cache/alternc-webalizer/";

  /** Emplacement du fichier patron pour recopie.
   * @access private 
   */
  var $TEMPLATEFILE="/etc/alternc/webalizer.template.conf";

  /** Nom des langues disponibles */
  var $langname=array(
		      "ca_ES"=>"Catalan",		"hr_HR"=>"Croatian",
		      "cs_CZ"=>"Czech",		      	"da_DK"=>"Danish",
		      "nl_NL"=>"Dutch",		      	"en_US"=>"English",
		      "et_EE"=>"Estonian",		"fi_FI"=>"Finnish",
		      "fr_FR"=>"French",		"de_DE"=>"German",
		      "el_GR"=>"Greek",		      	"hu_HU"=>"Hungarian",
		      "is_IS"=>"Icelandic",		"id_ID"=>"Indonesian",
		      "it_IT"=>"Italian",		"ja_JP.UTF-8"=>"Japanese",
		      "ko_KR.UTF-8"=>"Korean",		"lv_LV"=>"Latvian",
		      "ms_MY"=>"Malay",		      	"no_NO"=>"Norwegian",
		      "pl_PL"=>"Polish",		"pr_PR"=>"Portuguese",
		      "pt_BR"=>"Portuguese of Brazil",
		      "ro_RO"=>"Romanian",		"ru_RU"=>"Russian",
		      "sr_YU"=>"Serbian",		"zh_HK"=>"Simplified Chinese",
		      "sk_SK"=>"Slovak",		"sl_SI"=>"Slovene",
		      "es_ES"=>"Spanish",		"sv_SE"=>"Swedish",
		      "tr_TR"=>"Turkish",		"uk_UA"=>"Ukrainian",
		      );

  /* ----------------------------------------------------------------- */
  /**
   * Constructeur
   */
  function m_webalizer() {
  }

  /* ----------------------------------------------------------------- */
  /**
   * Nom du quota
   */
  function alternc_quota_names() {
    return "stats";
  } 

  /* ----------------------------------------------------------------- */
  /**
   * Nom des fonctions du module
   */
  function alternc_module_description() {
    return array("webalizer"=>_("The stats module allows any user to ask for statistics about his web site. Statistics are web pages generated daily based on the visits of the day before. Webalizer is the soft used to produce those stats. The statistics can be produced in many languages."));
  } 

  /* ----------------------------------------------------------------- */
  /**
   * Retourne un tableau contenant les jeux de statistiques d'un membre.
   *
   * @return array retourne un tableau index de tableaux associatif de la 
   *  forme : 
   *  $r[0-n]["id"] = numros du jeu
   *  $r[0-n]["hostname"]= domaine concern
   *  $r[0-n]["dir"]= Rpertoire destination (dans le dossier du membre)
   *  $r[0-n]["lang"]= Langue de production des statistiques
   */
  function get_list() {
    global $db,$err,$cuid;
    $err->log("webalizer","get_list");
    $r=array();
    $db->query("SELECT id, hostname, dir, lang FROM stats WHERE uid='$cuid' ORDER BY hostname;");
    if ($db->num_rows()) {
      while ($db->next_record()) {
	// On passe /var/alternc/html/u/user
	preg_match("/^\/var\/alternc\/html\/.\/[^\/]*\/(.*)/", $db->f("dir"),$match);
	$r[]=array(
		   "id"=>$db->f("id"),
		   "hostname"=>$db->f("hostname"),
		   "lang"=>$db->f("lang"),
		   "dir"=>$match[1]
		   );
      }
      return $r;
    } else {
      $err->raise("webalizer",1);
      return false;
    }
  }

  /* ----------------------------------------------------------------- */
  /**
   * Retourne un tableau contenant les dtails d'un jeu de statistiques
   *  d'un membre.
   *
   * @param integer $id Numro du jeu de stats dont on veut les infos.
   * @return array retourne un tableau associatif de la forme : 
   *  $r["id"] = numros du jeu
   *  $r["hostname"]= domaine concern
   *  $r["dir"]= Rpertoire destination (dans le dossier du membre)
   *  $r["lang"]= Langue de production des statistiques
   */
  function get_stats_details($id) {
    global $db,$err,$cuid;
    $err->log("webalizer","get_stats_details",$id);
    $r=array();
    $db->query("SELECT id, hostname, dir, lang FROM stats WHERE uid='$cuid' AND id='$id';");
    if ($db->num_rows()) {
      $db->next_record();
      // On passe /var/alternc/html/u/user
      preg_match("/^\/var\/alternc\/html\/.\/[^\/]*\/(.*)/", $db->f("dir"),$match);
      return array(
		   "id"=>$db->f("id"),
		   "hostname"=> $db->f("hostname"),
		   "lang"=>$db->f("lang"),
		   "dir"=>$match[1]
		   );
    } else {
      $err->raise("webalizer",2);
      return false;
    }
  }


  /* ----------------------------------------------------------------- */
  /** Retourne la liste des domaines / sous-domaines autoriss pour le membre.
   * 
   * @return array retourne un tableau index des domaines / sous-domaines utilisables.
   */
  function host_list() {
    global $db,$err,$cuid;
    $r=array();
    $db->query("SELECT domaine,sub FROM sub_domaines WHERE compte='$cuid' ORDER BY domaine,sub;");
    while ($db->next_record()) {
      if ($db->f("sub")) {
	$r[]=$db->f("sub").".".$db->f("domaine");
      } else {
	$r[]=$db->f("domaine");
      }
    }
    return $r;
  }

  /* ----------------------------------------------------------------- */
  /** 
   * Affiche des options select de la liste des noms de domaines autoriss pour
   * le membre. sous forme de champs d'options (select)
   */
  function select_host_list($current) {
    $r=$this->host_list();
    reset($r);
    while (list($key,$val)=each($r)) {
      if ($current==$val) $c=" selected=\"selected\""; else $c="";
      echo "<option$c>$val</option>";
    }
    return true;
  }

  /* ----------------------------------------------------------------- */
  /** 
   * Affiche des options select de la liste des langues autorises pour
   * le membre. sous forme de champs d'options (select)
   */
  function select_lang_list($current) {
    reset($this->langname);
    while (list($key,$val)=each($this->langname)) {
      if ($current==$key) $c=" selected=\"selected\""; else $c="";
      echo "<option value=\"$key\"$c>"._($val)."</option>";
    }
    return true;
  }

  /* ----------------------------------------------------------------- */
  /** 
   * Modifie un jeu de statistiques existant
   * @param integer $id est le numro du jeu de statistiques
   * @param string $dir est un chemin relatif  "/var/alternc/html/u/user"
   * @param string $stlang est la langue de production des statistiques (code  2 lettres)
   */
  function put_stats_details($id,$dir,$stlang) {
    global $db,$err,$bro,$mem,$cuid;
    $err->log("webalizer","put_stats_details",$id);
    $db->query("SELECT count(*) AS cnt FROM stats WHERE id='$id' and uid='$cuid';");
    $db->next_record();
    if (!$db->f("cnt")) {
      $err->raise("webalizer",2);
      return false;
    }
    $dir=$bro->convertabsolute($dir);
    if (substr($dir,0,1)=="/") {
      $dir=substr($dir,1);
    }
    // On a pur $dir des problmes eventuels ... On est en DESSOUS du dossier de l'utilisateur.
    if (!$this->langname[$stlang]) {
      $err->raise("webalizer",6);
      return false;
    }
    $lo=$mem->user["login"];
    $l=substr($lo,0,1);
    $db->query("UPDATE stats SET lang='$stlang', dir='/var/alternc/html/$l/$lo/$dir', uid='$cuid' WHERE id='$id';");
    $this->_createconf($id);
    return true;
  }

  /* ----------------------------------------------------------------- */
  /** 
   * Efface un jeu de statistiques existant.
   * @param integer $id est le numro du jeu de statistiques  supprimer
   * @return string le nom du domaine du jeu ainsi effac, ou FALSE si une erreur est survenue.
   */
  function delete_stats($id) {
    global $db,$err,$cuid;
    $err->log("webalizer","delete_stats",$id);
    $db->query("SELECT hostname FROM stats WHERE id='$id' and uid='$cuid';");
    if (!$db->num_rows()) {
      $err->raise("webalizer",2);
      return false;
    }
    $db->next_record();
    $this->_delconf($db->f("hostname"));
    $db->query("DELETE FROM stats WHERE id='$id'");
    return $name;
  }

  /* ----------------------------------------------------------------- */
  /** 
   * Cree un nouveau jeu de statistiques
   * @param string $dir est le chemin d'accs racine du compte ftp dans le compte du membre
   * @param string $lang est la langue choisie
   * @param string $hostname est le nom de domaine sur lequel on fait des stats
   * @return boolean TRUE si le jeu de stats a t cr avec succs, FALSE sinon.
   */
  function add_stats($hostname,$dir,$lang) {
    global $db,$err,$quota,$bro,$mem,$cuid;
    $err->log("webalizer","add_stats",$hostname);
    $dir=$bro->convertabsolute($dir);
    if (substr($dir,0,1)=="/") {
      $dir=substr($dir,1);
    }
    // On a pur $dir des problmes eventuels ... On est en DESSOUS du dossier de l'utilisateur.
    $r=$this->host_list();
    if (!in_array($hostname,$r) || $hostname=="") {
      $err->raise("webalizer",3);
      return false;
    }
    if (!$this->langname[$lang]) {
      $err->raise("webalizer",6);
      return false;
    }
    $lo=$mem->user[login];
    $l=substr($lo,0,1);
    // Le compte n'existe pas, on le cre.
    if ($quota->cancreate("stats")) {
      $db->query("INSERT INTO stats (hostname,lang,dir,uid) VALUES ('$hostname','$lang','/var/alternc/html/$l/$lo/$dir','$cuid')");
      $this->_createconf($db->lastid());
      return true;
    } else {
      $err->raise("webalizer",5);
      return false;
    }
  }

  function alternc_del_member() {
    global $db,$err,$cuid;
    $err->log("webalizer","del_member");
    $db->query("SELECT * FROM stats WHERE uid='$cuid';");
    $cnt=0;
    $t=array();
    while ($db->next_record()) {
      $cnt++;
      $t[]=$db->f("hostname");
    }
    $db->query("DELETE FROM stats WHERE uid='$cuid';");
    for($i=0;$i<cnt;$i++) {
      $this->_delconf($t[$i]);
    }
    return true;
  }

  /* ----------------------------------------------------------------- */
  /** 
   * Fonction appelle par m_dom lorsqu'un domaine est supprim.
   * @param string $dom est le domaine  supprimer.
   */
  function alternc_del_domain($dom) {
    global $db,$err,$cuid;
    $err->log("webalizer","del_dom",$dom);
    $db=new DB_System();
    $db->query("SELECT * FROM stats WHERE uid='$cuid' AND hostname like '%$dom'");
    $cnt=0;
    $t=array();
    while ($db->next_record()) {
      $cnt++;
      $t[]=$db->f("hostname");
    }
    // on dtruit les jeux de stats associs au prfixe correspondant :
    for($i=0;$i<cnt;$i++) {
      $db->query("DELETE FROM stats WHERE uid='$cuid' AND hostname='".$t[$i]."';");
      $this->_delconf($t[$i]);
    }
    return true;
  }

  /* ----------------------------------------------------------------- */
  /** 
   * Recalcule le quota complet de l'utilisateur courant, ou de l'utilisateur $id
   * @param integer $id Numro de l'utilisateur (facultatif)
   */
  function alternc_get_quota($name) {
    global $db,$err,$cuid;
    if ($name=="stats") {
      $err->log("stats","get_quota");
      $db->query("SELECT COUNT(*) AS cnt FROM stats WHERE uid='$cuid'");
      $db->next_record();
      return $db->f("cnt");
    } else return false;
  }

  /* ----------------------------------------------------------------- */
  /** Effacement du fichier de conf webalizer du domaine $hostname
   * @access private
   */
  function _delconf($hostname) {
    @unlink($this->CONFDIR."/".$hostname.".conf");
  }

  /* ----------------------------------------------------------------- */
  /** Cration du fichier de configuration Webalizer du domaine $id
   * @access private
   */
  function _createconf($id,$nochk=0) {
    global $db,$err,$cuid;
    $s=implode("",file($this->TEMPLATEFILE));
    if ($nochk) {
        $db->query("SELECT * FROM stats WHERE id='$id';");
    } else { 
        $db->query("SELECT * FROM stats WHERE id='$id' AND uid='$cuid';");
    }
    if (!$db->num_rows()) {
      $err->raise("webalizer",2);
      return false;
    }
    $db->next_record();
    $s=str_replace("%OUTPUTDIR%",$db->f("dir"),$s);
    $s=str_replace("%HOSTNAME%",$db->f("hostname"),$s);
    $f=fopen($this->CONFDIR."/".$db->f("hostname").".conf","wb");
    fputs($f,$s,strlen($s));
    fclose($f);
  }

} /* CLASSE m_webalizer */

?>
