#!/bin/sh

# AlternC Language file builder
# $id$
#
# This script build one "alternc.mo" file per language in /var/alternc/bureau/locales/
# Each alternc.mo file is build with msgfmt from a alternc.po file.
# Each alternc.po file is build from a serie of .po files located in 
# /var/alternc/bureau/locales/<lang>/LC_MESSAGES/*.po
# main.txt is included before all others .po to construct a complete alternc.po file.

#  - Advantages : 
#    * allow to add or remove standalone modules to an existing AlternC fluently
#    * only one textdomain is used in all the sources (no need to change it from module to module)
#  - Drawbacks : 
#    * AlternC now requires gettext package to work properly
#    * .mo file must be compiled at each upgrade/install

function dolangs {
    read A
    while [ "$A" ]
    do
	B="$A/LC_MESSAGES"
	rm -f "$B/procmail_builder.mo"
	msgfmt "$B/procmail_builder.po" -o "$B/procmail_builder.mo"
	read A
    done
}

# Apply the function to each language
find locales -type d -maxdepth 1 -mindepth 1 -name "*_*" | dolangs
exit 0