<?php
/*
 $Id: m_procmail.php,v 1.4 2005/04/01 16:50:11 benjamin Exp $
 ----------------------------------------------------------------------
 AlternC - Web Hosting System
 Copyright (C) 2002 by the AlternC Development Team.
 http://alternc.org/
 ----------------------------------------------------------------------
 Based on:
 Valentin Lacambre's web hosting softwares: http://altern.org/
 ----------------------------------------------------------------------
 LICENSE

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License (GPL)
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 To read the license please visit http://www.gnu.org/copyleft/gpl.html
 ----------------------------------------------------------------------
 Original Author of file: Benjamin Sonntag
 Purpose of file: Build a .procmailrc file for a user.
 	Manage ldap aliases with pipes to procmail for a user.
 ----------------------------------------------------------------------
*/

bindtextdomain("procmail_builder", "/var/alternc/bureau/locales");

// Every plugin MUST start with that require to be able to access other classes :

class m_procmail {

var $clsid="procmail";	/* Every plugin has a distinct CLSID, corresponding to his error messages class. */
var $uid=0;         /* Membre actuellement connect */
var $user;	    /* pop Login name */

/*
How it works : 
Normally, a pop mail entry is built as follow in the system db : 
	mail_domain (mail='friend@public.com'  alias='list of aliases+ friend_public.com' 
		uid=$cuid  pop=1 type=0 (standard mail ) ) 
	mail_users (pop courier account) : alias = friend@public.com && alias = friend_public.com
	mail_alias (postfix indirection) : mail = friend_public.com && alias = /var/alternc/mail...
with procmail_builder active, the entries are as follow : 
	mail_alias (postfix indirection) : mail = friend_public.com && alias = |/var/alternc/mail...
*/

/*****************************************************************************
m_procmail() Constructeur de la classe m_procmail
*****************************************************************************/
function m_procmail($user="") {
	$this->user=str_replace("@","_",$user);
}

/*****************************************************************************
get_status([$user]) retourne l'tat de drivation de la boite par procmail
de l'utilisateur $user (ou de l'utilisateur courant)
retourne 1 pour une boite drive, 0 pour une boite non drive, et false si
une erreur s'est produite
*****************************************************************************/
function get_status($user="") {
	global $db;
	if (!$user) $user=$this->user;

	//    $db->query("INSERT INTO mail_domain (mail,alias,uid,pop,type) VALUES ('".$login."@".$domain."','".$login."_".$domain."','$cuid',0,1);");
	//    $db->query("INSERT INTO mail_alias (mail,alias) VALUES ('".$login."_".$domain."','\"| $command\"');");

	$db->query("SELECT alias FROM mail_alias WHERE mail='".$login."';");
	if ($db->next_record()) {
		if (substr($db->f("alias"),1,1)=="|") {
			return 1;
		}
	}
	return 0;
}

/*****************************************************************************
disable([$user]) Dsactive procmail pour un utilisateur
Ne dtruit pas le jeu de rgles :)
Retourne True si tout s'est bien pass, false sinon.
*****************************************************************************/
function disable($user="") {
	global $er,$db;
	if (!$user) $user=$this->user;
	$u=substr($user,0,1);
	$db->query("UPDATE mail_alias SET alias='/var/alternc/mail/$u/$user/Maildir/' WHERE mail='$user';");
	return true;
}

/*****************************************************************************
enable([$user]) Active procmail pour un utilisateur
Construit le jeu de rgles par dfaut si besoin :)
Retourne True si tout s'est bien pass, false sinon.
*****************************************************************************/
function enable($user="") {
	global $er,$db;
	if (!$user) $user=$this->user;
	$u=substr($user,0,1);
	// 1. on vrifie qu'un .procmailrc existe, sinon on cre le .procmailrc par dfaut.
	if (!file_exists("/var/alternc/mail/$u/$user/.procmailrc")) {
		$f=fopen("/var/alternc/mail/$u/$user/.procmailrc","wb");
		fputs($f,str_replace("%%HOME%%","/var/alternc/mail/$u/$user",join("",file("/var/alternc/bureau/class/procmail_builder/procmailrc.default"))));
		fclose($f);
	}
	$db->query("UPDATE mail_alias SET alias='\"|/usr/bin/procmail -m /var/alternc/mail/$u/$user/.procmailrc\"' WHERE mail='$user';");
	return true;
}


/*****************************************************************************
readrules([$user]) Lit le fichier procmailrc d'un utilisateur et retourne
les rgles qu'il contient sous la forme d'un tableau ordonn de rgle.
Chaque rgle est un tableau associatif de la forme : 
$c[$i]["type"]=Type de la rgle (numro)
$c[$i]["name"]=Nom de la rgle (texte)
$c[$i]["count"]=Nombre de lignes dans la regle
$c[$i]["rule"][0-n]=Ligne de la rgle
peut retourner un tableau vide (pas de rgles) ou false si le fichier
.procmailrc n'existe pas ou est incorrectement formatt.
	(note : contient un automate de lecture de .procmailrc.)
*****************************************************************************/
function readrules($user="") {
	global $er;
	if (!$user) $user=$this->user;
	$u=substr($user,0,1);
	if (!file_exists("/var/alternc/mail/$u/$user/.procmailrc")) {
		$er->raise($this->clsid,6);
		return false;
	}
	$f=fopen("/var/alternc/mail/$u/$user/.procmailrc","rb");
	$state=0;	$rulenum=0;	$ligne=0;
	$res=array();
	while (!feof($f)) {
		$found=false; // found permet de savoir si on a trouv qqchose  chaque tour.
		$s=fgets($f,1024);
		$s=trim($s);
		if ($state==1 && !ereg("^# RuleEnd$",$s)) {
                        $res[$rulenum]["rule"][$res[$rulenum]["count"]++]=$s;
                        $found=true;
                }
                if ($state==1 && ereg("^# RuleEnd$",$s)) { // $
                        $state=0;
                        $rulenum++;
                        $found=true;
                }
		if ($state==0 && ereg("^# RuleType ([0-9][0-9]) -- (.*)?$",$s,$r)) {
			$state=1;
			$res[$rulenum]["type"]=$r[1];
			$res[$rulenum]["name"]=$r[2];
			$res[$rulenum]["count"]=0;
			$found=true;
		}
		if (!$found && $state!=0) {
			$er->raise($this->clsid,5,$ligne);
			return false;
		}
		$ligne++;
	}
	fclose($f);
	return $res;
}

/*****************************************************************************
writerules($rule,[$user]) Ecrit le fichier procmailrc d'un utilisateur en prenant
le tableau de rgle en paramtre. Remplit le .procmailrc avec le fichier
par dfaut, suivi des rgles dans l'ordre du tableau.
retourne false si le fichier .procmailrc n'existe pas dj.
retourne true si tout va bien.
*****************************************************************************/
function writerules($res,$user="") {
	global $er;
	if (!$user) $user=$this->user;
	$u=substr($user,0,1);
	if (!file_exists("/var/alternc/mail/$u/$user/.procmailrc")) {
		$er->raise($this->clsid,6);
		return false;
	}
	$f=fopen("/var/alternc/mail/$u/$user/.procmailrc","wb");
	fputs($f,str_replace("%%HOME%%","/var/alternc/mail/$u/$user",join("",file("/var/alternc/bureau/class/procmail_builder/procmailrc.default"))));
	for($i=0;$i<count($res);$i++) {
		$res[$i]["name"]=trim(str_replace("\r","",str_replace("\n","",$res[$i]["name"])));
		fputs($f,"# RuleType ".sprintf("%02d",$res[$i]["type"])." -- ".$res[$i]["name"]."\n");
		for($j=0;$j<$res[$i]["count"];$j++) {
			fputs($f,$res[$i]["rule"][$j]."\n");
		}
		fputs($f,"# RuleEnd\n\n");
	}
	fclose($f);
	return true;
}

/*****************************************************************************
addrule($rule,[$user]) Ajout la regle $rule au fichier procmailrc
d'un utilisateur retourne false si le fichier .procmailrc n'existe pas dj.
retourne true si tout va bien.
*****************************************************************************/
function addrule($rule,$user="") {
	global $er;
	if (!$user) $user=$this->user;
	$u=substr($user,0,1);
	if (!file_exists("/var/alternc/mail/$u/$user/.procmailrc")) {
		$er->raise($this->clsid,6);
		return false;
	}
	$f=fopen("/var/alternc/mail/$u/$user/.procmailrc","ab");
	$rule["name"]=trim(str_replace("\r","",str_replace("\n","",$rule["name"])));
	fputs($f,"# RuleType ".sprintf("%02d",$rule["type"])." -- ".$rule["name"]."\n");
	for($j=0;$j<$rule["count"];$j++) {
		fputs($f,$rule["rule"][$j]."\n");
	}
	fputs($f,"# RuleEnd\n\n");
	fclose($f);
	return true;
}

/*****************************************************************************
buildrule($crit,$crittext,$raction,$foldertogo,$emailto,$autoreplytxt,[$user]) 
Construit la rgle base sur les critres de formulaire passs en paramtre.
*****************************************************************************/
function buildrule($rulename,$crit,$crittext,$raction,$foldertogo,$emailto,$autoreplytxt,$user="") {
	global $er;
	if (!$user) $user=$this->user;
	$u=substr($user,0,1);
	$mail=$user;
	if ($c=strrpos($mail,"_")) {
		$mail=substr($mail,0,$c)."@".substr($mail,$c+1);
	}
	// Vrification de la monovalence de Spam, Forward et AutoReply
	if ($raction==2 || $raction==4 || $raction==5) {
		$r=$this->readrules($user);
		for($a=0;$a<count($r);$a++) {
			if ($r[$a]["type"]==$raction) {
				$er->raise($this->clsid,9);
				return false;
			}
		}
	}
	$r=array();
	$r["type"]=$raction;
	$r["name"]=str_replace("\n","",trim($rulename));
	if (!$r["name"]) $r["name"]="-";
	$r["count"]=0;
	switch ($raction) {
	case 2:
		$r["rule"][$r["count"]++]=":0 fw";
		break;
	case 4:
		$r["rule"][$r["count"]++]=":0 c";
		break;
	case 5:
		$r["rule"][$r["count"]++]=":0 Whc: /var/alternc/mail/$u/$user/$user.lock";
		break;
	default:
		$r["rule"][$r["count"]++]=":0";
		break;
	}

	for($j=0;$j<count($crit);$j++) {
		$tt=str_replace(array("\n","?",".","*","+"),
                                array("","\\?","\\.","\\*", "\\+"),
                	        $crittext[$j]);

		switch ($crit[$j]) {
		case 0:
			$s="* ^Subject.*$tt";
			break;
		case 1:
			$s="* ^From.*$tt";
			break;
		case 2:
			$s="* ^TO_$tt";
			break;
		case 3:
			$s="* ^List-Post: $tt";
			break;
		case 4:
			$s="* ^List-Id: $tt";
			break;
		case 5:
			$s="* ^X-Spam-Status: Yes";
			break;
		case 6:
			$s="* ^Delivered-To:.*$tt";
			break;
		}
	$r["rule"][$r["count"]++]=$s;
	} // for criteria.


	switch ($raction) {
	case 1:
		//$r["rule"][$r["count"]++]=str_replace(" ","\\ ",substr($foldertogo,5))."/";
		$r["rule"][$r["count"]++]=".".str_replace(array("\\\\"," "),array("\\","\\ "),addslashes(quotemeta(substr($foldertogo,6))))."/";
		break;
	case 2:
		$r["rule"][$r["count"]++]="| /usr/bin/spamc";
		break;
	case 3:
		$r["rule"][$r["count"]++]="/dev/null";
		break;
	case 4:
		if (checkmail($emailto)) {
			$er->raise($this->clsid,10);
			return false;
		}
		$r["rule"][$r["count"]++]='|$SENDMAIL -oi '.$emailto;
		break;
	case 5:
		$r["rule"][$r["count"]++]="* !^FROM_DAEMON";
		$r["rule"][$r["count"]++]="* !^X-Loop: $mail";
		$r["rule"][$r["count"]++]="| formail -rD 8192 /var/alternc/mail/$u/$user/$user.list";
		$r["rule"][$r["count"]++]="";
		$r["rule"][$r["count"]++]=":0 ehc";
		$r["rule"][$r["count"]++]="| (formail -rtI\"Precedence: junk\" -I\"From: <$mail>\" -A\"X-Loop: $mail\" ; cat /var/alternc/mail/$u/$user/$user.txt) | ".'$'."SENDMAIL -oi -t";
		$f=fopen("/var/alternc/mail/$u/$user/$user.txt","wb");
		fputs($f,$autoreplytxt);
		fclose($f);
		@unlink("/var/alternc/mail/$u/$user/$user.list");
		@unlink("/var/alternc/mail/$u/$user/$user.lock");
	}
	$r["rule"][$r["count"]++]="";
	return $r;
}

/*****************************************************************************
uprule($rules,$i) Remonte d'un cran la $i-me rgle du tableau de
rgle $rules retourne true si tout va bien. ($i>0)
*****************************************************************************/
function uprule($res,$i) {
	global $er;
	$i=intval($i);
	if (count($res)<$i || $i==0) {
		$er->raise($this->clsid,7);
		return false;
	}
	$t=$res[$i];
	$res[$i]=$res[$i-1];
	$res[$i-1]=$t;
	return $res;
}

/*****************************************************************************
downrule($rules,$i) Descend d'un cran la $i-me rgle du tableau de
rgle $rules retourne true si tout va bien.
*****************************************************************************/
function downrule($res,$i) {
	global $er;
	$i=intval($i);
	if ((count($res)-1)<$i) {
		$er->raise($this->clsid,7);
		return false;
	}
	$t=$res[$i];
	$res[$i]=$res[$i+1];
	$res[$i+1]=$t;
	return $res;
}

/*****************************************************************************
describe($rule) Retourne un text dans la langue courante dcrivant la rgle
$rule passe en paramtre.
*****************************************************************************/
function describe($rule) {
	$s="";

	// Lecture des conditions : 
	$cond=array();
	switch ($rule["type"]) {
	case 5: 
		$i=1;
		while ($rule["rule"][$i]!="* !^FROM_DAEMON" && $rule["rule"][$i]!="") {
			$cond[]=$rule["rule"][$i];
			$i++;
		}
		break;
	default:
		$i=1;
		while (substr($rule["rule"][$i],0,1)=="*") {
			$cond[]=$rule["rule"][$i];
			$i++;
		}
		break;
	}
	// On a cond, on le parse :)
	if (count($cond)) {
		$s.="<small>";
	}
	for($i=0;$i<count($cond);$i++) {
		if ($i) $s.=" et ";
		if (ereg("^\\* \\^Subject\\.\\*(.*)$",$cond[$i],$t)) {
			$s.=_("procmail_crit_0")."&nbsp;&nbsp;<code>".str_replace("\\","",$t[1])."</code>";
		}
		if (ereg("^\\* \\^From\\.\\*(.*)$",$cond[$i],$t)) {
			$s.=_("procmail_crit_1")."&nbsp;&nbsp;<code>".str_replace("\\","",$t[1])."</code>";
		}
		if (ereg("^\\* \\^TO_(.*)$",$cond[$i],$t)) {
			$s.=_("procmail_crit_2")."&nbsp;&nbsp;<code>".str_replace("\\","",$t[1])."</code>";
		}
		if (ereg("^\\* \\^List-Post: (.*)$",$cond[$i],$t)) {
			$s.=_("procmail_crit_3")."&nbsp;&nbsp;<code>".str_replace("\\","",$t[1])."</code>";
		}
		if (ereg("^\\* \\^List-Id: (.*)$",$cond[$i],$t)) {
			$s.=_("procmail_crit_4")."&nbsp;&nbsp;<code>".str_replace("\\","",$t[1])."</code>";
		}
		if (ereg("^\\* \\^X-Spam-Status: Yes$",$cond[$i])) {
			$s.=_("procmail_crit_5");
		}
		if (ereg("^\\* \\^Delivered-To:\\.\\*(.*)$",$cond[$i],$t)) {
			$s.=_("procmail_crit_6")."&nbsp;&nbsp;<code>".str_replace("\\","",$t[1])."</code>";
		}
		$s.="<br>\n";
	}
	if (count($cond)) {
		$s.="</small>";
	}
	$s.="--&gt; ";
	// Action :
	switch ($rule["type"]) {
	case 1: 
		$t=$rule["rule"][count($rule["rule"])-2];
		$s.=_("Move the message to this folder")." &nbsp; <code>INBOX".substr($t,0,strlen($t)-1)."</code>";
		break;
	case 2:
		$s.=_("Filter the message through SpamAssassin");
		break;
	case 3:
		$s.=_("Discard the message (for good !)");
		break;
	case 4:
		$t=$rule["rule"][count($rule["rule"])-2];
		$s.=_("Forward the mail to")." &nbsp; <code>".substr($t,15)."</code>";   
		break;
	case 5:
		$s.=_("Auto-reply");
		break;
	}
	return $s;
}


} // CLASS

/*

Procmail sample rules :

# PROCMAILRC HEADING
VERBOSE=no
MAILDIR=$HOME/Maildir/
DEFAULT=$HOME/Maildir/

# RULETYPE 1 Filtrage sur l'expditeur du mail
:0
* ^From.*www-data@sinerj.org
.Globenet.No-Log/

# RULETYPE 2 Filtrage sur le destinataire du mail
:0
* ^TO_frnog@frnog.org
.Listes.frnog/

# RULETYPE 3 Filtrage sur un List-Id
:0
* List-Id: <interne_lafil.org@lafil.org>
.Listes.interne_lafil/

# RULETYPE 4 Filtrage sur un List-Post
:0
* List-Post: <mailto:rv-sources@rezo.net>
.Listes.voltaire/

# RULETYPE 5 Filtrage sur l'expditeur ET le destinataire
:0
* ^From.*root@lautre.net
* To: root@lautre.net
.Lautre\ Net.logs/

# RULETYPE 6 Filtrage sur le sujet du mail
:0
* ^Subject.*creation du compte
.Lautre\ Net.create-delete/

# RULETYPE 7 Filtrage sur le sujet ET le destinataire du mail
:0
* ^Subject.*changement mail inscription
* ^TO_root@lautre.net
.Lautre\ Net.create-delete/

# RULETYPE 8 Filtrage sur le sujet ET l'expditeur du mail
:0
* ^Subject.*GROS
* ^From.*root@sinerj.org
.Globenet.No-Log/


# RULETYPE 9 Filtrage anti-spam
:0fw
| /usr/bin/spamc

:0
* ^X-Spam-Status: Yes
.zz\ spam/

*/

?>
